/*
 * Decompiled with CFR 0.152.
 */
package org.datasyslab.geospark.spatialOperator;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.datasyslab.geospark.rangeJudgement.RangeFilter;
import org.datasyslab.geospark.rangeJudgement.RangeFilterUsingIndex;
import org.datasyslab.geospark.spatialRDD.LineStringRDD;
import org.datasyslab.geospark.spatialRDD.PointRDD;
import org.datasyslab.geospark.spatialRDD.PolygonRDD;
import org.datasyslab.geospark.spatialRDD.RectangleRDD;
import org.datasyslab.geospark.utils.CRSTransformation;

public class RangeQuery
implements Serializable {
    public static JavaRDD<Point> SpatialRangeQuery(PointRDD spatialRDD, Envelope originalQueryWindow, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Envelope queryWindow = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryWindow = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            JavaRDD result = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new RangeFilterUsingIndex(queryWindow, considerBoundaryIntersection));
            return result.map((Function)new Function<Object, Point>(){

                public Point call(Object spatialObject) throws Exception {
                    return (Point)spatialObject;
                }
            });
        }
        JavaRDD result = spatialRDD.getRawSpatialRDD().filter((Function)new RangeFilter(queryWindow, considerBoundaryIntersection));
        return result.map((Function)new Function<Object, Point>(){

            public Point call(Object spatialObject) throws Exception {
                return (Point)spatialObject;
            }
        });
    }

    public static JavaRDD<Point> SpatialRangeQuery(PointRDD spatialRDD, Polygon originalQueryWindow, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Polygon queryWindow = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryWindow = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            JavaRDD result = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new RangeFilterUsingIndex(queryWindow, considerBoundaryIntersection));
            return result.map((Function)new Function<Object, Point>(){

                public Point call(Object spatialObject) throws Exception {
                    return (Point)spatialObject;
                }
            });
        }
        JavaRDD result = spatialRDD.getRawSpatialRDD().filter((Function)new RangeFilter(queryWindow, considerBoundaryIntersection));
        return result.map((Function)new Function<Object, Point>(){

            public Point call(Object spatialObject) throws Exception {
                return (Point)spatialObject;
            }
        });
    }

    public static JavaRDD<Polygon> SpatialRangeQuery(PolygonRDD spatialRDD, Envelope originalQueryWindow, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Envelope queryWindow = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryWindow = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            JavaRDD result = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new RangeFilterUsingIndex(queryWindow, considerBoundaryIntersection));
            return result.map((Function)new Function<Object, Polygon>(){

                public Polygon call(Object spatialObject) throws Exception {
                    return (Polygon)spatialObject;
                }
            });
        }
        JavaRDD result = spatialRDD.getRawSpatialRDD().filter((Function)new RangeFilter(queryWindow, considerBoundaryIntersection));
        return result.map((Function)new Function<Object, Polygon>(){

            public Polygon call(Object spatialObject) throws Exception {
                return (Polygon)spatialObject;
            }
        });
    }

    public static JavaRDD<Polygon> SpatialRangeQuery(PolygonRDD spatialRDD, Polygon originalQueryWindow, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Polygon queryWindow = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryWindow = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            JavaRDD result = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new RangeFilterUsingIndex(queryWindow, considerBoundaryIntersection));
            return result.map((Function)new Function<Object, Polygon>(){

                public Polygon call(Object spatialObject) throws Exception {
                    return (Polygon)spatialObject;
                }
            });
        }
        JavaRDD result = spatialRDD.getRawSpatialRDD().filter((Function)new RangeFilter(queryWindow, considerBoundaryIntersection));
        return result.map((Function)new Function<Object, Polygon>(){

            public Polygon call(Object spatialObject) throws Exception {
                return (Polygon)spatialObject;
            }
        });
    }

    public static JavaRDD<Polygon> SpatialRangeQuery(RectangleRDD spatialRDD, Envelope originalQueryWindow, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Envelope queryWindow = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryWindow = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            JavaRDD result = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new RangeFilterUsingIndex(queryWindow, considerBoundaryIntersection));
            return result.map((Function)new Function<Object, Polygon>(){

                public Polygon call(Object spatialObject) throws Exception {
                    return (Polygon)spatialObject;
                }
            });
        }
        JavaRDD result = spatialRDD.getRawSpatialRDD().filter((Function)new RangeFilter(queryWindow, considerBoundaryIntersection));
        return result.map((Function)new Function<Object, Polygon>(){

            public Polygon call(Object spatialObject) throws Exception {
                return (Polygon)spatialObject;
            }
        });
    }

    public static JavaRDD<LineString> SpatialRangeQuery(LineStringRDD spatialRDD, Envelope originalQueryWindow, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Envelope queryWindow = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryWindow = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            JavaRDD result = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new RangeFilterUsingIndex(queryWindow, considerBoundaryIntersection));
            return result.map((Function)new Function<Object, LineString>(){

                public LineString call(Object spatialObject) throws Exception {
                    return (LineString)spatialObject;
                }
            });
        }
        JavaRDD result = spatialRDD.getRawSpatialRDD().filter((Function)new RangeFilter(queryWindow, considerBoundaryIntersection));
        return result.map((Function)new Function<Object, LineString>(){

            public LineString call(Object spatialObject) throws Exception {
                return (LineString)spatialObject;
            }
        });
    }

    public static JavaRDD<LineString> SpatialRangeQuery(LineStringRDD spatialRDD, Polygon originalQueryWindow, boolean considerBoundaryIntersection, boolean useIndex) throws Exception {
        Polygon queryWindow = originalQueryWindow;
        if (spatialRDD.getCRStransformation()) {
            queryWindow = CRSTransformation.Transform(spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode(), originalQueryWindow);
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new Exception("[RangeQuery][SpatialRangeQuery] Index doesn't exist. Please build index on rawSpatialRDD.");
            }
            JavaRDD result = spatialRDD.indexedRawRDD.mapPartitions((FlatMapFunction)new RangeFilterUsingIndex(queryWindow, considerBoundaryIntersection));
            return result.map((Function)new Function<Object, LineString>(){

                public LineString call(Object spatialObject) throws Exception {
                    return (LineString)spatialObject;
                }
            });
        }
        JavaRDD result = spatialRDD.getRawSpatialRDD().filter((Function)new RangeFilter(queryWindow, considerBoundaryIntersection));
        return result.map((Function)new Function<Object, LineString>(){

            public LineString call(Object spatialObject) throws Exception {
                return (LineString)spatialObject;
            }
        });
    }
}

