/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.fixed;

import org.ejml.data.FixedMatrix3_64F;
import org.ejml.data.FixedMatrix3x3_64F;

public class FixedOps3 {
    public static void add(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b, FixedMatrix3x3_64F c) {
        c.a11 = a.a11 + b.a11;
        c.a12 = a.a12 + b.a12;
        c.a13 = a.a13 + b.a13;
        c.a21 = a.a21 + b.a21;
        c.a22 = a.a22 + b.a22;
        c.a23 = a.a23 + b.a23;
        c.a31 = a.a31 + b.a31;
        c.a32 = a.a32 + b.a32;
        c.a33 = a.a33 + b.a33;
    }

    public static void addEquals(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b) {
        a.a11 += b.a11;
        a.a12 += b.a12;
        a.a13 += b.a13;
        a.a21 += b.a21;
        a.a22 += b.a22;
        a.a23 += b.a23;
        a.a31 += b.a31;
        a.a32 += b.a32;
        a.a33 += b.a33;
    }

    public static void transpose(FixedMatrix3x3_64F m) {
        double tmp = m.a12;
        m.a12 = m.a21;
        m.a21 = tmp;
        tmp = m.a13;
        m.a13 = m.a31;
        m.a31 = tmp;
        tmp = m.a23;
        m.a23 = m.a32;
        m.a32 = tmp;
    }

    public static FixedMatrix3x3_64F transpose(FixedMatrix3x3_64F input, FixedMatrix3x3_64F output) {
        if (input == null) {
            input = new FixedMatrix3x3_64F();
        }
        output.a11 = input.a11;
        output.a12 = input.a21;
        output.a13 = input.a31;
        output.a21 = input.a12;
        output.a22 = input.a22;
        output.a23 = input.a32;
        output.a31 = input.a13;
        output.a32 = input.a23;
        output.a33 = input.a33;
        return output;
    }

    public static void mult(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b, FixedMatrix3x3_64F c) {
        c.a11 = a.a11 * b.a11 + a.a12 * b.a21 + a.a13 * b.a31;
        c.a12 = a.a11 * b.a12 + a.a12 * b.a22 + a.a13 * b.a32;
        c.a13 = a.a11 * b.a13 + a.a12 * b.a23 + a.a13 * b.a33;
        c.a21 = a.a21 * b.a11 + a.a22 * b.a21 + a.a23 * b.a31;
        c.a22 = a.a21 * b.a12 + a.a22 * b.a22 + a.a23 * b.a32;
        c.a23 = a.a21 * b.a13 + a.a22 * b.a23 + a.a23 * b.a33;
        c.a31 = a.a31 * b.a11 + a.a32 * b.a21 + a.a33 * b.a31;
        c.a32 = a.a31 * b.a12 + a.a32 * b.a22 + a.a33 * b.a32;
        c.a33 = a.a31 * b.a13 + a.a32 * b.a23 + a.a33 * b.a33;
    }

    public static void multTransA(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b, FixedMatrix3x3_64F c) {
        c.a11 = a.a11 * b.a11 + a.a21 * b.a21 + a.a31 * b.a31;
        c.a12 = a.a11 * b.a12 + a.a21 * b.a22 + a.a31 * b.a32;
        c.a13 = a.a11 * b.a13 + a.a21 * b.a23 + a.a31 * b.a33;
        c.a21 = a.a12 * b.a11 + a.a22 * b.a21 + a.a32 * b.a31;
        c.a22 = a.a12 * b.a12 + a.a22 * b.a22 + a.a32 * b.a32;
        c.a23 = a.a12 * b.a13 + a.a22 * b.a23 + a.a32 * b.a33;
        c.a31 = a.a13 * b.a11 + a.a23 * b.a21 + a.a33 * b.a31;
        c.a32 = a.a13 * b.a12 + a.a23 * b.a22 + a.a33 * b.a32;
        c.a33 = a.a13 * b.a13 + a.a23 * b.a23 + a.a33 * b.a33;
    }

    public static void multTransAB(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b, FixedMatrix3x3_64F c) {
        c.a11 = a.a11 * b.a11 + a.a21 * b.a12 + a.a31 * b.a13;
        c.a12 = a.a11 * b.a21 + a.a21 * b.a22 + a.a31 * b.a23;
        c.a13 = a.a11 * b.a31 + a.a21 * b.a32 + a.a31 * b.a33;
        c.a21 = a.a12 * b.a11 + a.a22 * b.a12 + a.a32 * b.a13;
        c.a22 = a.a12 * b.a21 + a.a22 * b.a22 + a.a32 * b.a23;
        c.a23 = a.a12 * b.a31 + a.a22 * b.a32 + a.a32 * b.a33;
        c.a31 = a.a13 * b.a11 + a.a23 * b.a12 + a.a33 * b.a13;
        c.a32 = a.a13 * b.a21 + a.a23 * b.a22 + a.a33 * b.a23;
        c.a33 = a.a13 * b.a31 + a.a23 * b.a32 + a.a33 * b.a33;
    }

    public static void multTransB(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b, FixedMatrix3x3_64F c) {
        c.a11 = a.a11 * b.a11 + a.a12 * b.a12 + a.a13 * b.a13;
        c.a12 = a.a11 * b.a21 + a.a12 * b.a22 + a.a13 * b.a23;
        c.a13 = a.a11 * b.a31 + a.a12 * b.a32 + a.a13 * b.a33;
        c.a21 = a.a21 * b.a11 + a.a22 * b.a12 + a.a23 * b.a13;
        c.a22 = a.a21 * b.a21 + a.a22 * b.a22 + a.a23 * b.a23;
        c.a23 = a.a21 * b.a31 + a.a22 * b.a32 + a.a23 * b.a33;
        c.a31 = a.a31 * b.a11 + a.a32 * b.a12 + a.a33 * b.a13;
        c.a32 = a.a31 * b.a21 + a.a32 * b.a22 + a.a33 * b.a23;
        c.a33 = a.a31 * b.a31 + a.a32 * b.a32 + a.a33 * b.a33;
    }

    public static void mult(FixedMatrix3x3_64F a, FixedMatrix3_64F b, FixedMatrix3_64F c) {
        c.a1 = a.a11 * b.a1 + a.a12 * b.a2 + a.a13 * b.a3;
        c.a2 = a.a21 * b.a1 + a.a22 * b.a2 + a.a23 * b.a3;
        c.a3 = a.a31 * b.a1 + a.a32 * b.a2 + a.a33 * b.a3;
    }

    public static void mult(FixedMatrix3_64F a, FixedMatrix3x3_64F b, FixedMatrix3_64F c) {
        c.a1 = a.a1 * b.a11 + a.a2 * b.a21 + a.a3 * b.a31;
        c.a2 = a.a1 * b.a12 + a.a2 * b.a22 + a.a3 * b.a32;
        c.a3 = a.a1 * b.a13 + a.a2 * b.a23 + a.a3 * b.a33;
    }

    public static double dot(FixedMatrix3_64F a, FixedMatrix3_64F b) {
        return a.a1 * b.a1 + a.a2 * b.a2 + a.a3 * b.a3;
    }

    public static void setIdentity(FixedMatrix3x3_64F a) {
        a.a11 = 1.0;
        a.a21 = 0.0;
        a.a31 = 0.0;
        a.a12 = 0.0;
        a.a22 = 1.0;
        a.a32 = 0.0;
        a.a13 = 0.0;
        a.a23 = 0.0;
        a.a33 = 1.0;
    }

    public static boolean invert(FixedMatrix3x3_64F a, FixedMatrix3x3_64F inv) {
        double scale = 1.0 / FixedOps3.elementMaxAbs(a);
        double a11 = a.a11 * scale;
        double a12 = a.a12 * scale;
        double a13 = a.a13 * scale;
        double a21 = a.a21 * scale;
        double a22 = a.a22 * scale;
        double a23 = a.a23 * scale;
        double a31 = a.a31 * scale;
        double a32 = a.a32 * scale;
        double a33 = a.a33 * scale;
        double m11 = a22 * a33 - a23 * a32;
        double m12 = -(a21 * a33 - a23 * a31);
        double m13 = a21 * a32 - a22 * a31;
        double m21 = -(a12 * a33 - a13 * a32);
        double m22 = a11 * a33 - a13 * a31;
        double m23 = -(a11 * a32 - a12 * a31);
        double m31 = a12 * a23 - a13 * a22;
        double m32 = -(a11 * a23 - a13 * a21);
        double m33 = a11 * a22 - a12 * a21;
        double det = (a11 * m11 + a12 * m12 + a13 * m13) / scale;
        inv.a11 = m11 / det;
        inv.a12 = m21 / det;
        inv.a13 = m31 / det;
        inv.a21 = m12 / det;
        inv.a22 = m22 / det;
        inv.a23 = m32 / det;
        inv.a31 = m13 / det;
        inv.a32 = m23 / det;
        inv.a33 = m33 / det;
        return !Double.isNaN(det) && !Double.isInfinite(det);
    }

    public static double det(FixedMatrix3x3_64F mat) {
        double a = mat.a11 * (mat.a22 * mat.a33 - mat.a23 * mat.a32);
        double b = mat.a12 * (mat.a21 * mat.a33 - mat.a23 * mat.a31);
        double c = mat.a13 * (mat.a21 * mat.a32 - mat.a31 * mat.a22);
        return a - b + c;
    }

    public static double trace(FixedMatrix3x3_64F a) {
        return a.a11 + a.a21 + a.a31;
    }

    public static void diag(FixedMatrix3x3_64F input, FixedMatrix3_64F out) {
        out.a1 = input.a11;
        out.a2 = input.a22;
        out.a3 = input.a33;
    }

    public static double elementMax(FixedMatrix3x3_64F a) {
        double max = a.a11;
        max = Math.max(max, a.a12);
        max = Math.max(max, a.a13);
        max = Math.max(max, a.a21);
        max = Math.max(max, a.a22);
        max = Math.max(max, a.a23);
        max = Math.max(max, a.a31);
        max = Math.max(max, a.a32);
        max = Math.max(max, a.a33);
        return max;
    }

    public static double elementMaxAbs(FixedMatrix3x3_64F a) {
        double max = a.a11;
        max = Math.max(max, Math.abs(a.a12));
        max = Math.max(max, Math.abs(a.a13));
        max = Math.max(max, Math.abs(a.a21));
        max = Math.max(max, Math.abs(a.a22));
        max = Math.max(max, Math.abs(a.a23));
        max = Math.max(max, Math.abs(a.a31));
        max = Math.max(max, Math.abs(a.a32));
        max = Math.max(max, Math.abs(a.a33));
        return max;
    }

    public static double elementMin(FixedMatrix3x3_64F a) {
        double min = a.a11;
        min = Math.min(min, a.a12);
        min = Math.min(min, a.a13);
        min = Math.min(min, a.a21);
        min = Math.min(min, a.a22);
        min = Math.min(min, a.a23);
        min = Math.min(min, a.a31);
        min = Math.min(min, a.a32);
        min = Math.min(min, a.a33);
        return min;
    }

    public static double elementMinAbs(FixedMatrix3x3_64F a) {
        double min = a.a11;
        min = Math.min(min, Math.abs(a.a12));
        min = Math.min(min, Math.abs(a.a13));
        min = Math.min(min, Math.abs(a.a21));
        min = Math.min(min, Math.abs(a.a22));
        min = Math.min(min, Math.abs(a.a23));
        min = Math.min(min, Math.abs(a.a31));
        min = Math.min(min, Math.abs(a.a32));
        min = Math.min(min, Math.abs(a.a33));
        return min;
    }

    public static void elementMult(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b) {
        a.a11 *= b.a11;
        a.a12 *= b.a12;
        a.a13 *= b.a13;
        a.a21 *= b.a21;
        a.a22 *= b.a22;
        a.a23 *= b.a23;
        a.a31 *= b.a31;
        a.a32 *= b.a32;
        a.a33 *= b.a33;
    }

    public static void elementMult(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b, FixedMatrix3x3_64F c) {
        c.a11 = a.a11 * b.a11;
        c.a12 = a.a12 * b.a12;
        c.a13 = a.a13 * b.a13;
        c.a21 = a.a21 * b.a21;
        c.a22 = a.a22 * b.a22;
        c.a23 = a.a23 * b.a23;
        c.a31 = a.a31 * b.a31;
        c.a32 = a.a32 * b.a32;
        c.a33 = a.a33 * b.a33;
    }

    public static void elementDiv(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b) {
        a.a11 /= b.a11;
        a.a12 /= b.a12;
        a.a13 /= b.a13;
        a.a21 /= b.a21;
        a.a22 /= b.a22;
        a.a23 /= b.a23;
        a.a31 /= b.a31;
        a.a32 /= b.a32;
        a.a33 /= b.a33;
    }

    public static void elementDiv(FixedMatrix3x3_64F a, FixedMatrix3x3_64F b, FixedMatrix3x3_64F c) {
        c.a11 = a.a11 / b.a11;
        c.a12 = a.a12 / b.a12;
        c.a13 = a.a13 / b.a13;
        c.a21 = a.a21 / b.a21;
        c.a22 = a.a22 / b.a22;
        c.a23 = a.a23 / b.a23;
        c.a31 = a.a31 / b.a31;
        c.a32 = a.a32 / b.a32;
        c.a33 = a.a33 / b.a33;
    }

    public static void scale(double alpha, FixedMatrix3x3_64F a) {
        a.a11 *= alpha;
        a.a12 *= alpha;
        a.a13 *= alpha;
        a.a21 *= alpha;
        a.a22 *= alpha;
        a.a23 *= alpha;
        a.a31 *= alpha;
        a.a32 *= alpha;
        a.a33 *= alpha;
    }

    public static void scale(double alpha, FixedMatrix3x3_64F a, FixedMatrix3x3_64F b) {
        b.a11 = a.a11 * alpha;
        b.a12 = a.a12 * alpha;
        b.a13 = a.a13 * alpha;
        b.a21 = a.a21 * alpha;
        b.a22 = a.a22 * alpha;
        b.a23 = a.a23 * alpha;
        b.a31 = a.a31 * alpha;
        b.a32 = a.a32 * alpha;
        b.a33 = a.a33 * alpha;
    }

    public static void divide(FixedMatrix3x3_64F a, double alpha) {
        a.a11 /= alpha;
        a.a12 /= alpha;
        a.a13 /= alpha;
        a.a21 /= alpha;
        a.a22 /= alpha;
        a.a23 /= alpha;
        a.a31 /= alpha;
        a.a32 /= alpha;
        a.a33 /= alpha;
    }

    public static void divide(FixedMatrix3x3_64F a, double alpha, FixedMatrix3x3_64F b) {
        b.a11 = a.a11 / alpha;
        b.a12 = a.a12 / alpha;
        b.a13 = a.a13 / alpha;
        b.a21 = a.a21 / alpha;
        b.a22 = a.a22 / alpha;
        b.a23 = a.a23 / alpha;
        b.a31 = a.a31 / alpha;
        b.a32 = a.a32 / alpha;
        b.a33 = a.a33 / alpha;
    }

    public static void changeSign(FixedMatrix3x3_64F a) {
        a.a11 = -a.a11;
        a.a12 = -a.a12;
        a.a13 = -a.a13;
        a.a21 = -a.a21;
        a.a22 = -a.a22;
        a.a23 = -a.a23;
        a.a31 = -a.a31;
        a.a32 = -a.a32;
        a.a33 = -a.a33;
    }

    public static void fill(FixedMatrix3x3_64F a, double v) {
        a.a11 = v;
        a.a12 = v;
        a.a13 = v;
        a.a21 = v;
        a.a22 = v;
        a.a23 = v;
        a.a31 = v;
        a.a32 = v;
        a.a33 = v;
    }
}

