/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.collection.SpatialIndexFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class SpatialIndexFeatureSource
implements SimpleFeatureSource {
    SpatialIndexFeatureCollection contents;
    private static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private static final Set<Class> supportedFilterTypes = new HashSet<Class>(Arrays.asList(BBOX.class, Contains.class, Crosses.class, DWithin.class, Equals.class, Intersects.class, Overlaps.class, Touches.class, Within.class));

    public SpatialIndexFeatureSource(SpatialIndexFeatureCollection original) {
        this.contents = original;
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
    }

    public DataStore getDataStore() {
        return null;
    }

    @Override
    public ReferencedEnvelope getBounds() throws IOException {
        return this.contents.getBounds();
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.getFeatures(query).getBounds();
    }

    @Override
    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.contents.getSchema();
    }

    @Override
    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.contents;
    }

    @Override
    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        Query query = new Query(this.getSchema().getName().getLocalPart(), filter);
        return this.getFeatures(query);
    }

    @Override
    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        Envelope bounds = this.getEnvelope(query.getFilter());
        return this.getFeatureCollection(query, bounds);
    }

    private SimpleFeatureCollection getFeatureCollection(Query query, Envelope bounds) throws IOException {
        SimpleFeatureType schema;
        SimpleFeatureType target;
        Object copy;
        int offset = ((Query)(query = DataUtilities.resolvePropertyNames((Query)query, this.getSchema()))).getStartIndex() != null ? ((Query)query).getStartIndex() : 0;
        if (offset > 0 & ((Query)query).getSortBy() == null) {
            if (!this.getQueryCapabilities().supportsSorting(((Query)query).getSortBy())) {
                throw new IllegalStateException("Feature source does not support this sorting so there is no way a stable paging (offset/limit) can be performed");
            }
            copy = new Query((Query)query);
            ((Query)copy).setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
            query = copy;
        }
        if (((Query)query).getFilter() != null && ((Query)query).getFilter().equals(Filter.EXCLUDE)) {
            return new EmptyFeatureCollection(this.getSchema());
        }
        if (((Query)query).getFilter() != null && ((Query)query).getFilter().equals(Filter.INCLUDE)) {
            copy = this.contents;
        }
        SimpleFeatureCollection collection = ((Query)query).getFilter() != null && ((Query)query).getFilter().equals(Filter.INCLUDE) ? this.contents : this.contents.subCollection(((Query)query).getFilter());
        if (((Query)query).getCoordinateSystemReproject() != null) {
            collection = new ReprojectingFeatureCollection(collection, ((Query)query).getCoordinateSystemReproject());
        }
        if (((Query)query).getSortBy() != null && ((Query)query).getSortBy().length != 0) {
            SimpleFeature[] array = collection.toArray(new SimpleFeature[collection.size()]);
            for (SortBy sortBy : ((Query)query).getSortBy()) {
                Comparator<SimpleFeature> comparator = DataUtilities.sortComparator(sortBy);
                Arrays.sort(array, comparator);
            }
            ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>(Arrays.asList(array));
            collection = new ListFeatureCollection(this.getSchema(), list);
        }
        if (offset > 0 || !((Query)query).isMaxFeaturesUnlimited()) {
            long max = Long.MAX_VALUE;
            if (!((Query)query).isMaxFeaturesUnlimited()) {
                max = ((Query)query).getMaxFeatures();
            }
            collection = new MaxSimpleFeatureCollection(collection, offset, max);
        }
        if (((Query)query).getPropertyNames() != Query.ALL_NAMES && !(target = SimpleFeatureTypeBuilder.retype(schema = (SimpleFeatureType)collection.getSchema(), ((Query)query).getPropertyNames())).equals(schema)) {
            collection = new ReTypingFeatureCollection(collection, target);
        }
        return collection;
    }

    Envelope getEnvelope(Filter filter) {
        BinarySpatialOperator gf;
        Envelope result = new Envelope();
        if (filter instanceof And) {
            Envelope bounds = new Envelope();
            for (Filter f : ((And)filter).getChildren()) {
                Envelope e = this.getEnvelope(f);
                if (e == null) {
                    return null;
                }
                bounds.expandToInclude(e);
            }
            result = bounds;
        } else if (filter instanceof BinarySpatialOperator && supportedFilterTypes.contains((gf = (BinarySpatialOperator)filter).getClass())) {
            Expression lg = gf.getExpression1();
            Expression rg = gf.getExpression2();
            if (lg instanceof Literal) {
                Geometry g = (Geometry)((Literal)lg).getValue();
                if (rg instanceof PropertyName) {
                    result = g.getEnvelopeInternal();
                }
            } else if (rg instanceof Literal) {
                Geometry g = (Geometry)((Literal)rg).getValue();
                if (lg instanceof PropertyName) {
                    result = g.getEnvelopeInternal();
                }
            }
        }
        return result;
    }

    private BBOX bboxFilter(Envelope bbox) {
        return ff.bbox(this.contents.getSchema().getGeometryDescriptor().getLocalName(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), null);
    }

    @Override
    public ResourceInfo getInfo() {
        return null;
    }

    @Override
    public Name getName() {
        return this.contents.getSchema().getName();
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilities(){

            @Override
            public boolean isOffsetSupported() {
                return true;
            }
        };
    }

    @Override
    public Set getSupportedHints() {
        HashSet hints = new HashSet();
        return hints;
    }
}

