/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.ExternalMark;
import org.geotools.styling.ExternalMarkImpl;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Mark;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleFactoryImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.Stroke;
import org.opengis.util.Cloneable;

public class MarkImpl
implements Mark,
Cloneable {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.styling");
    private final FilterFactory filterFactory;
    private FillImpl fill;
    private StrokeImpl stroke;
    private ExternalMarkImpl external;
    private Expression wellKnownName = null;

    public MarkImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()), null);
    }

    public MarkImpl(String name) {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()), null);
        LOGGER.fine("creating " + name + " type mark");
        this.setWellKnownName(name);
    }

    public MarkImpl(FilterFactory filterFactory, ExternalMark external) {
        this.filterFactory = filterFactory;
        LOGGER.fine("creating defaultMark");
        try {
            StyleFactoryImpl sfac = new StyleFactoryImpl();
            this.fill = FillImpl.cast(sfac.getDefaultFill());
            this.stroke = StrokeImpl.cast(sfac.getDefaultStroke());
            this.wellKnownName = filterFactory.literal("square");
        }
        catch (IllegalFilterException ife) {
            MarkImpl.severe("<init>", "Failed to build default mark: ", ife);
        }
        this.external = ExternalMarkImpl.cast(external);
    }

    private static void severe(String method, String message, Exception exception) {
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setSourceMethodName(method);
        record.setThrown(exception);
        LOGGER.log(record);
    }

    @Override
    public FillImpl getFill() {
        return this.fill;
    }

    @Override
    public StrokeImpl getStroke() {
        return this.stroke;
    }

    @Override
    public Expression getWellKnownName() {
        return this.wellKnownName;
    }

    @Override
    public void setFill(Fill fill) {
        this.fill = FillImpl.cast(fill);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = StrokeImpl.cast(stroke);
    }

    @Override
    public void setWellKnownName(Expression wellKnownName) {
        LOGGER.entering("DefaultMark", "setWellKnownName");
        this.wellKnownName = wellKnownName;
    }

    public void setWellKnownName(String name) {
        this.setWellKnownName(this.filterFactory.literal(name));
    }

    public String toString() {
        return this.wellKnownName.toString();
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            MarkImpl clone = (MarkImpl)super.clone();
            if (this.fill != null) {
                clone.fill = (FillImpl)this.fill.clone();
            }
            if (this.stroke != null && this.stroke instanceof Cloneable) {
                clone.stroke = (StrokeImpl)this.stroke.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone MarkImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.stroke != null) {
            result = 1000003 * result + this.stroke.hashCode();
        }
        if (this.wellKnownName != null) {
            result = 1000003 * result + this.wellKnownName.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        MarkImpl other = (MarkImpl)oth;
        if (this.wellKnownName == null ? other.wellKnownName != null : !this.wellKnownName.equals(other.wellKnownName)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        return !(this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke));
    }

    @Override
    public ExternalMarkImpl getExternalMark() {
        return this.external;
    }

    @Override
    public void setExternalMark(org.opengis.style.ExternalMark external) {
        this.external = ExternalMarkImpl.cast(external);
    }

    static MarkImpl cast(GraphicalSymbol item) {
        if (item == null) {
            return null;
        }
        if (item instanceof MarkImpl) {
            return (MarkImpl)item;
        }
        if (item instanceof Mark) {
            Mark mark = (Mark)item;
            MarkImpl copy = new MarkImpl();
            copy.setStroke(mark.getStroke());
            copy.setWellKnownName(mark.getWellKnownName());
            copy.setExternalMark(mark.getExternalMark());
            return copy;
        }
        return null;
    }
}

