/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.styling.visitor.Measure;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.geotools.styling.visitor.RescalingMode;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class DpiRescaleStyleVisitor
extends RescaleStyleVisitor {
    public DpiRescaleStyleVisitor(double scale) {
        super(scale);
    }

    public DpiRescaleStyleVisitor(FilterFactory2 filterFactory, double scale) {
        super(filterFactory, scale);
    }

    @Override
    protected Expression rescale(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr == Expression.NIL) {
            return Expression.NIL;
        }
        Measure v = new Measure(expr, (Unit<Length>)this.defaultUnit);
        return RescalingMode.Pixels.rescaleToExpression(this.scale, v);
    }

    @Override
    protected void rescaleOption(Map<String, String> options, String key, double defaultValue) {
        double scaleFactor = this.scale.evaluate(null, Double.class);
        String value = options.get(key);
        if (value == null) {
            value = String.valueOf(defaultValue);
        }
        Measure v = new Measure(value, (Unit<Length>)this.defaultUnit);
        String rescaled = RescalingMode.Pixels.rescaleToString(scaleFactor, v);
        options.put(key, String.valueOf(rescaled));
    }

    @Override
    protected void rescaleOption(Map<String, String> options, String key, int defaultValue) {
        double scaleFactor = this.scale.evaluate(null, Double.class);
        String value = options.get(key);
        if (value == null) {
            value = String.valueOf(defaultValue);
        }
        Measure v = new Measure(value, (Unit<Length>)this.defaultUnit);
        String rescaled = RescalingMode.Pixels.rescaleToString(scaleFactor, v);
        options.put(key, String.valueOf(rescaled));
    }
}

