/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.geotools.util.ObjectCache;

final class DefaultObjectCache
implements ObjectCache {
    private final Map cache;

    public DefaultObjectCache() {
        this.cache = new HashMap();
    }

    public DefaultObjectCache(int initialSize) {
        this.cache = new HashMap(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.getEntry(key).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object peek(Object key) {
        Map map = this.cache;
        synchronized (map) {
            if (!this.cache.containsKey(key)) {
                return null;
            }
            return this.getEntry(key).peek();
        }
    }

    @Override
    public void writeLock(Object key) {
        this.getEntry(key).writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnLock(Object key) {
        Map map = this.cache;
        synchronized (map) {
            if (!this.cache.containsKey(key)) {
                throw new IllegalStateException("Cannot unlock prior to locking");
            }
            this.getEntry(key).writeUnLock();
        }
    }

    @Override
    public void put(Object key, Object object) {
        this.getEntry(key).setValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectCacheEntry getEntry(Object key) {
        Map map = this.cache;
        synchronized (map) {
            ObjectCacheEntry entry = (ObjectCacheEntry)this.cache.get(key);
            if (entry == null) {
                entry = new ObjectCacheEntry();
                this.cache.put(key, entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> getKeys() {
        HashSet<Object> ret = null;
        Map map = this.cache;
        synchronized (map) {
            ret = new HashSet<Object>(this.cache.keySet());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) {
        Map map = this.cache;
        synchronized (map) {
            this.cache.remove(key);
        }
    }

    static final class ObjectCacheEntry {
        private volatile Object value;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        public ObjectCacheEntry() {
        }

        public ObjectCacheEntry(Object value) {
            this.value = value;
        }

        public Object peek() {
            try {
                this.lock.writeLock().lock();
                Object object = this.value;
                return object;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public Object getValue() {
            try {
                this.lock.readLock().lock();
                Object object = this.value;
                return object;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setValue(Object value) {
            try {
                this.lock.writeLock().lock();
                this.value = value;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public boolean writeLock() {
            this.lock.writeLock().lock();
            return true;
        }

        public void writeUnLock() {
            this.lock.writeLock().unlock();
        }
    }
}

