/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.geotools.resources.i18n.Errors;

public class FrequencySortedSet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Comparator<E>,
Serializable {
    private static final long serialVersionUID = 6034102231354388179L;
    private final Map<E, Integer> count;
    private final int order;
    private transient E[] sorted;
    private transient int[] frequencies;
    private static final Comparator<Map.Entry<?, Integer>> COMPARATOR = new Comparator<Map.Entry<?, Integer>>(){

        @Override
        public int compare(Map.Entry<?, Integer> o1, Map.Entry<?, Integer> o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    };

    public FrequencySortedSet() {
        this(false);
    }

    public FrequencySortedSet(boolean reversed) {
        this(16, reversed);
    }

    public FrequencySortedSet(int initialCapacity, boolean reversed) {
        this.count = new LinkedHashMap<E, Integer>(initialCapacity);
        this.order = reversed ? -1 : 1;
    }

    @Override
    public int size() {
        return this.count.size();
    }

    @Override
    public boolean isEmpty() {
        return this.count.isEmpty();
    }

    public boolean add(E element, int occurence) throws IllegalArgumentException {
        if (occurence != 0) {
            if (occurence < 0) {
                throw new IllegalArgumentException(Errors.format(125, occurence));
            }
            this.sorted = null;
            Integer n = this.count.put(element, occurence *= this.order);
            if (n == null) {
                return true;
            }
            this.count.put(element, n + occurence);
        }
        return false;
    }

    @Override
    public boolean add(E element) {
        return this.add(element, 1);
    }

    @Override
    public boolean contains(Object element) {
        return this.count.containsKey(element);
    }

    @Override
    public boolean remove(Object element) {
        if (this.count.remove(element) != null) {
            this.sorted = null;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.sorted = null;
        this.count.clear();
    }

    @Override
    public Iterator<E> iterator() {
        this.ensureSorted();
        return new Iter();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public E first() throws NoSuchElementException {
        this.ensureSorted();
        if (this.sorted.length != 0) {
            return this.sorted[0];
        }
        throw new NoSuchElementException();
    }

    @Override
    public E last() throws NoSuchElementException {
        this.ensureSorted();
        int length = this.sorted.length;
        if (length != 0) {
            return this.sorted[length - 1];
        }
        throw new NoSuchElementException();
    }

    private void ensureSorted() {
        if (this.sorted != null) {
            return;
        }
        Map.Entry[] entries = this.count.entrySet().toArray(new Map.Entry[this.count.size()]);
        Arrays.sort(entries, COMPARATOR);
        int length = entries.length;
        this.sorted = new Object[length];
        if (this.frequencies == null || this.frequencies.length != length) {
            this.frequencies = new int[length];
        }
        for (int i = 0; i < length; ++i) {
            Map.Entry entry = entries[i];
            this.sorted[i] = entry.getKey();
            this.frequencies[i] = Math.abs((Integer)entry.getValue());
        }
    }

    @Override
    public final Comparator<E> comparator() {
        return this;
    }

    @Override
    public final int compare(E o1, E o2) {
        return this.signedFrequency(o1) - this.signedFrequency(o2);
    }

    private int signedFrequency(E element) {
        Integer n = this.count.get(element);
        return n != null ? n : 0;
    }

    public int frequency(E element) {
        return Math.abs(this.signedFrequency(element));
    }

    public int[] frequencies() {
        this.ensureSorted();
        return (int[])this.frequencies.clone();
    }

    @Override
    public Object[] toArray() {
        this.ensureSorted();
        return (Object[])this.sorted.clone();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.ensureSorted();
        if (array.length < this.sorted.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.sorted.length);
        }
        System.arraycopy(this.sorted, 0, array, 0, this.sorted.length);
        return array;
    }

    private final class Iter
    implements Iterator<E> {
        private final E[] elements;
        private int index;

        Iter() {
            this.elements = FrequencySortedSet.this.sorted;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.elements.length;
        }

        @Override
        public E next() {
            if (this.index >= this.elements.length) {
                throw new NoSuchElementException();
            }
            return this.elements[this.index++];
        }

        @Override
        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            if (!FrequencySortedSet.this.remove(this.elements[this.index - 1])) {
                throw new IllegalStateException();
            }
        }
    }
}

