/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

public class Formatter
implements IScriptFunctionExecutor {
    private static final String WRONG_ARGUMENT = "Wrong number of arguments for BirtFormatter function: {0}";
    private static final String FORMAT = "format";
    private IScriptFunctionExecutor executor;
    private IScriptFunctionContext scriptContext;
    private ULocale locale = null;
    private TimeZone timeZone = null;
    private ThreadLocal<HashMap<String, StringFormatter>> stringFormatters = new ThreadLocal<HashMap<String, StringFormatter>>(){

        @Override
        protected HashMap<String, StringFormatter> initialValue() {
            return new HashMap<String, StringFormatter>();
        }
    };
    private ThreadLocal<HashMap<String, NumberFormatter>> numberFormatters = new ThreadLocal<HashMap<String, NumberFormatter>>(){

        @Override
        protected HashMap<String, NumberFormatter> initialValue() {
            return new HashMap<String, NumberFormatter>();
        }
    };
    private ThreadLocal<HashMap<String, DateFormatter>> dateFormatters = new ThreadLocal<HashMap<String, DateFormatter>>(){

        @Override
        protected HashMap<String, DateFormatter> initialValue() {
            return new HashMap<String, DateFormatter>();
        }
    };

    Formatter(String functionName) throws BirtException {
        if (FORMAT.equals(functionName)) {
            this.executor = new Function_Format(this);
        }
    }

    public DateFormatter getDateFormatter(String pattern) {
        String key = String.valueOf(pattern) + ":" + this.locale.toString();
        DateFormatter fmt = this.dateFormatters.get().get(key);
        if (fmt == null) {
            fmt = new DateFormatter(pattern, this.locale, this.timeZone);
            this.dateFormatters.get().put(key, fmt);
        }
        return fmt;
    }

    @Override
    public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
        this.scriptContext = context;
        if (this.scriptContext != null) {
            this.locale = (ULocale)this.scriptContext.findProperty("org.eclipse.birt.core.script.functionservice.context.locale");
            this.timeZone = (TimeZone)this.scriptContext.findProperty("org.eclipse.birt.core.script.functionservice.context.timeZone");
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.executor.execute(arguments, context);
    }

    public StringFormatter getStringFormatter(String pattern) {
        String key = String.valueOf(pattern) + ":" + this.locale.toString();
        StringFormatter fmt = this.stringFormatters.get().get(key);
        if (fmt == null) {
            fmt = new StringFormatter(pattern, this.locale);
            this.stringFormatters.get().put(key, fmt);
        }
        return fmt;
    }

    public NumberFormatter getNumberFormatter(String pattern) {
        String key = String.valueOf(pattern) + ":" + this.locale.toString();
        NumberFormatter fmt = this.numberFormatters.get().get(key);
        if (fmt == null) {
            fmt = new NumberFormatter(pattern, this.locale);
            this.numberFormatters.get().put(key, fmt);
        }
        return fmt;
    }

    private class Function_Format
    implements IScriptFunctionExecutor {
        private Formatter formatter;

        Function_Format(Formatter formatter2) {
            this.formatter = formatter2;
        }

        @Override
        public Object execute(Object[] args, IScriptFunctionContext context) throws BirtException {
            if (args == null || args.length < 2) {
                throw new IllegalArgumentException(MessageFormat.format(Formatter.WRONG_ARGUMENT, Formatter.FORMAT));
            }
            if (args[0] != null) {
                String pattern = null;
                if (args[1] != null) {
                    pattern = args[1].toString();
                }
                if (args[0] instanceof Number) {
                    NumberFormatter fmt = this.formatter.getNumberFormatter(pattern);
                    return fmt.format((Number)args[0]);
                }
                if (args[0] instanceof String) {
                    StringFormatter fmt = this.formatter.getStringFormatter(pattern);
                    return fmt.format((String)args[0]);
                }
                if (args[0] instanceof Date) {
                    DateFormatter fmt = this.formatter.getDateFormatter(pattern);
                    return fmt.format((Date)args[0]);
                }
                return args[0].toString();
            }
            return "NULL";
        }
    }
}

