/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.script.IBaseDataSetEventHandler;

public class BaseDataSetDesign
implements IBaseDataSetDesign {
    private String name;
    private String dataSourceName;
    private List parameters;
    private List resultSetHints;
    private List computedColumns;
    private List filters;
    private Collection inputParamBindings;
    private String beforeOpenScript;
    private String afterOpenScript;
    private String onFetchScript;
    private String beforeCloseScript;
    private String afterCloseScript;
    private IBaseDataSetEventHandler eventHandler;
    private int fetchRowLimit;
    private int cacheRowCount;
    private boolean distinctValue;
    private IScriptExpression dataSetACL;
    private Map<String, IScriptExpression> columnACL = new HashMap<String, IScriptExpression>();
    private IScriptExpression rowACL;
    private String nullOrdering;
    private ULocale uLocale;
    private List<ISortDefinition> sortHints = null;
    private boolean needCache = true;
    private Object queryContextVisitor = null;

    public BaseDataSetDesign(String name) {
        this.name = name;
    }

    public BaseDataSetDesign(String name, String dataSourceName) {
        this.name = name;
        this.dataSourceName = dataSourceName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCacheRowCount() {
        return this.cacheRowCount;
    }

    public void setCacheRowCount(int cacheRowCount) {
        this.cacheRowCount = cacheRowCount;
    }

    @Override
    public boolean needDistinctValue() {
        return this.distinctValue;
    }

    public void setDistinctValue(boolean distinctValue) {
        this.distinctValue = distinctValue;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSource(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Override
    public List getComputedColumns() {
        if (this.computedColumns == null) {
            this.computedColumns = new ArrayList();
        }
        return this.computedColumns;
    }

    public void addComputedColumn(IComputedColumn column) {
        if (column != null) {
            this.getComputedColumns().add(column);
        }
    }

    @Override
    public List getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        return this.filters;
    }

    public void addFilter(IFilterDefinition filter) {
        if (filter != null) {
            this.getFilters().add(filter);
        }
    }

    @Override
    public List<ISortDefinition> getSortHints() {
        if (this.sortHints == null) {
            this.sortHints = new ArrayList<ISortDefinition>();
        }
        return this.sortHints;
    }

    public void addSortHint(ISortDefinition sortHint) {
        if (sortHint != null) {
            this.getSortHints().add(sortHint);
        }
    }

    @Override
    public List getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        return this.parameters;
    }

    public void addParameter(IParameterDefinition param) {
        if (param != null) {
            this.getParameters().add(param);
        }
    }

    @Override
    public List getResultSetHints() {
        if (this.resultSetHints == null) {
            this.resultSetHints = new ArrayList();
        }
        return this.resultSetHints;
    }

    public void addResultSetHint(IColumnDefinition col) {
        if (col != null) {
            this.getResultSetHints().add(col);
        }
    }

    @Override
    public Collection getInputParamBindings() {
        if (this.inputParamBindings == null) {
            this.inputParamBindings = new ArrayList();
        }
        return this.inputParamBindings;
    }

    public void addInputParamBinding(IInputParameterBinding binding) {
        if (binding != null) {
            this.getInputParamBindings().add(binding);
        }
    }

    @Override
    public String getBeforeOpenScript() {
        return this.beforeOpenScript;
    }

    public void setBeforeOpenScript(String beforeOpenScript) {
        this.beforeOpenScript = beforeOpenScript;
    }

    @Override
    public String getAfterOpenScript() {
        return this.afterOpenScript;
    }

    public void setAfterOpenScript(String afterOpenScript) {
        this.afterOpenScript = afterOpenScript;
    }

    @Override
    public String getOnFetchScript() {
        return this.onFetchScript;
    }

    public void setOnFetchScript(String onFetchScript) {
        this.onFetchScript = onFetchScript;
    }

    @Override
    public String getBeforeCloseScript() {
        return this.beforeCloseScript;
    }

    public void setBeforeCloseScript(String beforeCloseScript) {
        this.beforeCloseScript = beforeCloseScript;
    }

    @Override
    public String getAfterCloseScript() {
        return this.afterCloseScript;
    }

    public void setAfterCloseScript(String afterCloseScript) {
        this.afterCloseScript = afterCloseScript;
    }

    @Override
    public IBaseDataSetEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(IBaseDataSetEventHandler handler) {
        this.eventHandler = handler;
    }

    @Override
    public int getRowFetchLimit() {
        return this.fetchRowLimit;
    }

    @Override
    public void setRowFetchLimit(int max) {
        this.fetchRowLimit = max <= 0 ? 0 : max;
    }

    public IScriptExpression getDataSetColumnACL(String columnName) {
        return this.columnACL.get(columnName);
    }

    public IScriptExpression getDataSetACL() {
        return this.dataSetACL;
    }

    public IScriptExpression getRowACL() {
        return this.rowACL;
    }

    public void setDataSetACL(IScriptExpression acl) {
        this.dataSetACL = acl;
    }

    public void setDataSetColumnACL(String columnName, IScriptExpression acl) {
        this.columnACL.put(columnName, acl);
    }

    public void setRowACL(IScriptExpression expr) {
        this.rowACL = expr;
    }

    @Override
    public ULocale getCompareLocale() {
        return this.uLocale;
    }

    @Override
    public String getNullsOrdering() {
        return this.nullOrdering;
    }

    public void setCompareLocale(ULocale ulocale) {
        this.uLocale = ulocale;
    }

    public void setNullsOrdering(String nullOrdering) {
        this.nullOrdering = nullOrdering;
    }

    public boolean needCache() {
        return this.needCache;
    }

    public void setNeedCache(boolean needCache) {
        this.needCache = needCache;
    }

    public void setQueryContextVisitor(Object visitor) {
        this.queryContextVisitor = visitor;
    }

    public Object getQueryContextVisitor() {
        return this.queryContextVisitor;
    }
}

