/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportDocument;

public class RunStatusReader {
    protected RAInputStream runStatusStream;
    protected static Logger logger = Logger.getLogger(RunStatusReader.class.getName());
    private List<String> errors = Collections.EMPTY_LIST;

    public RunStatusReader(IReportDocument document) {
        try {
            IDocArchiveReader reader = document.getArchive();
            boolean existStream = reader.exists("/runStatus");
            if (existStream) {
                this.runStatusStream = reader.getStream("/runStatus");
            }
            this.read();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Unable to create stream to read run task status");
            this.close();
        }
    }

    public void close() {
        try {
            if (this.runStatusStream != null) {
                this.runStatusStream.close();
                this.runStatusStream = null;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Unable to close the stream reading run task status");
        }
    }

    public List<String> getGenerationErrors() {
        return this.errors;
    }

    public String getErrorsAsString() {
        if (this.errors == null || this.errors.isEmpty()) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        for (String error : this.errors) {
            message.append(error).append("\n");
        }
        return message.toString();
    }

    private void read() throws IOException {
        if (this.runStatusStream == null) {
            return;
        }
        DataInputStream in = new DataInputStream(this.runStatusStream);
        int errorSize = IOUtil.readInt(in);
        if (errorSize > 0) {
            this.errors = new ArrayList<String>();
            int i = 0;
            while (i < errorSize) {
                this.errors.add(IOUtil.readString(in));
                ++i;
            }
        }
    }
}

