/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx;

import org.eclipse.birt.report.engine.emitter.pptx.TreeVisitor;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;

public class TableVisitor
extends TreeVisitor<IArea> {
    TableVisitor() {
    }

    public RowArea getNextRow(RowArea row, final int rowSpan) {
        assert (row != null);
        assert (rowSpan >= 1);
        AreaTreeNode currentRow = new AreaTreeNode(row);
        TreeVisitor.ITreeNode<IArea> nextRow = new TreeVisitor<IArea>().forEach(currentRow, new TreeVisitor.IFilter<IArea>(){
            int rowCount = 0;

            @Override
            public int getRowCount() {
                return this.rowCount;
            }

            @Override
            public boolean matches(IArea value) {
                if (value instanceof RowArea) {
                    ++this.rowCount;
                    if (this.rowCount > rowSpan) {
                        return true;
                    }
                }
                return false;
            }
        });
        if (nextRow == null) {
            return null;
        }
        return (RowArea)nextRow.getValue();
    }

    public class AreaTreeNode
    implements TreeVisitor.ITreeNode<IArea> {
        private AreaTreeNode parent;
        private int index;
        private IArea value;

        public AreaTreeNode(IArea value) {
            this.parent = null;
            this.index = 0;
            this.value = value;
        }

        public AreaTreeNode(AreaTreeNode parent, int index, IArea area) {
            this.parent = parent;
            this.index = index;
            this.value = area;
        }

        @Override
        public TreeVisitor.ITreeNode<IArea> getParent() {
            this.initParent();
            return this.parent;
        }

        @Override
        public TreeVisitor.ITreeNode<IArea> getNext() {
            this.initParent();
            if (this.parent == null) {
                return null;
            }
            IArea next = this.getChildValue(this.parent.getValue(), this.index + 1);
            if (next != null) {
                return new AreaTreeNode(this.parent, this.index + 1, next);
            }
            return null;
        }

        @Override
        public TreeVisitor.ITreeNode<IArea> getChild() {
            if (this.getChildCount(this.value) <= 0) {
                return null;
            }
            return new AreaTreeNode(this, 0, this.getChildValue(this.value, 0));
        }

        @Override
        public IArea getValue() {
            return this.value;
        }

        private void initParent() {
            IArea container;
            if (this.parent == null && (container = this.getParent(this.value)) != null) {
                this.index = this.getChildIndex(container, this.value);
                this.parent = new AreaTreeNode(container);
            }
        }

        private IArea getParent(IArea area) {
            if (area instanceof TableArea) {
                return null;
            }
            if (area instanceof ContainerArea) {
                return ((ContainerArea)area).getParent();
            }
            return null;
        }

        private int getChildIndex(IArea parent, IArea child) {
            if (parent instanceof ContainerArea) {
                ContainerArea container = (ContainerArea)parent;
                int i = 0;
                while (i < container.getChildrenCount()) {
                    if (container.getChild(i) == child) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        private IArea getChildValue(IArea value, int index) {
            ContainerArea container;
            if (value instanceof ContainerArea && (container = (ContainerArea)value).getChildrenCount() > index) {
                return container.getChild(index);
            }
            return null;
        }

        private int getChildCount(IArea value) {
            if (value == null) {
                return 0;
            }
            if (value instanceof RowArea) {
                return 0;
            }
            if (value instanceof ContainerArea) {
                return ((ContainerArea)value).getChildrenCount();
            }
            return 0;
        }
    }
}

