/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=Slots.class)
public @interface Slot {
    public SlotKind value();

    public boolean isComplex() default false;

    public static enum SlotKind {
        nb_bool("__bool__"),
        nb_add("__add__, __radd__"),
        nb_subtract("__sub__, __rsub__"),
        nb_multiply("__mul__, __rmul__"),
        nb_remainder("__mod__, __rmod__"),
        nb_divmod("__divmod__, __rdivmod__"),
        nb_lshift("__lshift__, __rlshift__"),
        nb_rshift("__rshift__, __rrshift__"),
        nb_and("__and__, __rand__"),
        nb_xor("__xor__, __rxor__"),
        nb_or("__or__, __ror__"),
        nb_floor_divide("__floordiv__, __rfloordiv__"),
        nb_true_divide("__truediv__, __rtruediv__"),
        nb_matrix_multiply("__matmul__, __rmatmul__"),
        sq_length("__len__"),
        sq_item("__getitem__"),
        sq_ass_item("__setitem__"),
        sq_concat("__add__"),
        sq_repeat("__mul__"),
        mp_length("__len__"),
        mp_subscript("__getitem__"),
        mp_ass_subscript("__setitem__"),
        tp_descr_get("__get__"),
        tp_descr_set("__set__, __delete__"),
        tp_getattro("__getattribute__, __getattr__"),
        tp_setattro("__setattr__, __delattr__");


        private SlotKind(String specialMethods) {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SlotSignature {
        public int minNumOfPositionalArgs() default 0;

        public boolean takesVarArgs() default false;

        public boolean takesVarKeywordArgs() default false;

        public String[] parameterNames() default {};

        public boolean needsFrame() default false;

        public boolean alwaysNeedsCallerFrame() default false;

        public String raiseErrorName() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Slots {
        public Slot[] value();
    }
}

