/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.BoundBuiltinCallable;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.util.BiConsumer;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PythonBuiltins {
    private final Map<TruffleString, Object> builtinConstants = new HashMap<TruffleString, Object>();
    private final Map<TruffleString, BoundBuiltinCallable<?>> builtinFunctions = new HashMap();
    private boolean initialized;
    private static final Set<String> SLOTS = Set.of("__abs__", "__add__", "__aiter__", "__and__", "__anext__", "__await__", "__bool__", "__call__", "__contains__", "__delattr__", "__delete__", "__delitem__", "__del__", "__divmod__", "__eq__", "__float__", "__floordiv__", "__getattribute__", "__getattr__", "__getitem__", "__get__", "__ge__", "__gt__", "__hash__", "__iadd__", "__iand__", "__ifloordiv__", "__ilshift__", "__imatmul__", "__imod__", "__imul__", "__index__", "__init__", "__int__", "__invert__", "__ior__", "__ipow__", "__irshift__", "__isub__", "__iter__", "__itruediv__", "__ixor__", "__len__", "__le__", "__lshift__", "__lt__", "__matmul__", "__mod__", "__mul__", "__neg__", "__new__", "__next__", "__ne__", "__or__", "__pos__", "__pow__", "__radd__", "__rand__", "__rdivmod__", "__repr__", "__rfloordiv__", "__rlshift__", "__rmatmul__", "__rmod__", "__rmul__", "__ror__", "__rpow__", "__rrshift__", "__rshift__", "__rsub__", "__rtruediv__", "__rxor__", "__setattr__", "__setitem__", "__set__", "__str__", "__sub__", "__truediv__", "__xor__");

    protected abstract List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories();

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void initialize(Python3Core core) {
        if (this.builtinFunctions.size() > 0) {
            return;
        }
        this.initializeEachFactoryWith((factory, builtin) -> {
            boolean declaresExplicitSelf;
            CoreFunctions annotation = this.getClass().getAnnotation(CoreFunctions.class);
            PythonBuiltinClassType constructsClass = builtin.constructsClass();
            if ((annotation.defineModule().length() > 0 || annotation.extendsModule().length() > 0) && constructsClass == PythonBuiltinClassType.nil) {
                assert (!builtin.isGetter());
                assert (!builtin.isSetter());
                assert (annotation.extendClasses().length == 0);
                declaresExplicitSelf = builtin.declaresExplicitSelf();
            } else {
                declaresExplicitSelf = builtin.constructsClass() == PythonBuiltinClassType.nil;
            }
            TruffleString tsName = PythonUtils.toTruffleStringUncached(builtin.name());
            RootCallTarget callTarget = core.getLanguage().initBuiltinCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)((Object)l)), (Builtin)builtin, (NodeFactory<? extends PythonBuiltinBaseNode>)factory, declaresExplicitSelf), factory.getNodeClass(), builtin.name());
            PNone builtinDoc = builtin.doc().isEmpty() ? PNone.NONE : PythonUtils.toTruffleStringUncached(builtin.doc());
            int flags = PBuiltinFunction.getFlags(builtin, callTarget);
            if (constructsClass != PythonBuiltinClassType.nil) {
                assert (!(builtin.isGetter() || builtin.isSetter() || builtin.isClassmethod() || builtin.isStaticmethod()));
                PBuiltinFunction newFunc = core.factory().createBuiltinFunction(SpecialMethodNames.T___NEW__, (Object)constructsClass, PythonBuiltins.numDefaults(builtin), flags, callTarget);
                PBuiltinMethod newMethod = core.factory().createBuiltinMethod((Object)constructsClass, newFunc);
                PythonBuiltinClass builtinClass = core.lookupType(constructsClass);
                builtinClass.setAttributeUnsafe(SpecialMethodNames.T___NEW__, newMethod);
                Object currentBuiltinDoc = builtinClass.getAttribute(SpecialAttributeNames.T___DOC__);
                if (PGuards.isPNone(currentBuiltinDoc)) {
                    builtinClass.setAttribute(SpecialAttributeNames.T___DOC__, builtinDoc);
                }
            } else {
                PBuiltinFunction function = PythonBuiltins.isSlotMethod(builtin) ? core.factory().createWrapperDescriptor(tsName, null, PythonBuiltins.numDefaults(builtin), flags, callTarget, null, null) : core.factory().createBuiltinFunction(tsName, null, PythonBuiltins.numDefaults(builtin), flags, callTarget);
                function.setAttribute(SpecialAttributeNames.T___DOC__, builtinDoc);
                PythonBuiltinObject callable = function;
                if (builtin.isGetter() || builtin.isSetter()) {
                    assert (!builtin.isClassmethod() && !builtin.isStaticmethod());
                    PBuiltinFunction get = builtin.isGetter() ? function : null;
                    PBuiltinFunction set = builtin.isSetter() ? function : null;
                    callable = core.factory().createGetSetDescriptor(get, set, tsName, null, builtin.allowsDelete());
                } else if (builtin.isClassmethod()) {
                    assert (!builtin.isStaticmethod());
                    callable = core.factory().createBuiltinClassmethodFromCallableObj(function);
                } else if (builtin.isStaticmethod()) {
                    callable = core.factory().createStaticmethodFromCallableObj(function);
                }
                this.builtinFunctions.put(PythonUtils.toTruffleStringUncached(builtin.name()), (BoundBuiltinCallable<?>)((Object)callable));
            }
        });
    }

    private static boolean isSlotMethod(Builtin builtin) {
        return builtin.name().startsWith("__") && SLOTS.contains(builtin.name());
    }

    public void postInitialize(Python3Core core) {
    }

    private void initializeEachFactoryWith(BiConsumer<NodeFactory<? extends PythonBuiltinBaseNode>, Builtin> func) {
        List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> factories = this.getNodeFactories();
        assert (factories != null) : "No factories found. Override getFactories() to resolve this.";
        PythonOS currentOs = PythonOS.getPythonOS();
        block0: for (NodeFactory<? extends PythonBuiltinBaseNode> nodeFactory : factories) {
            Boolean needsFrame = null;
            boolean initialized = false;
            for (Builtin builtin : (Builtin[])nodeFactory.getNodeClass().getAnnotationsByType(Builtin.class)) {
                if (!builtin.autoRegister()) {
                    assert (!initialized) : "Builtin annotations on " + nodeFactory.getNodeClass().getName() + " do not agree on 'autoInitialize' property.";
                    continue block0;
                }
                if (builtin.os() != PythonOS.PLATFORM_ANY && builtin.os() != currentOs) continue;
                if (needsFrame == null) {
                    needsFrame = builtin.needsFrame();
                } else if (needsFrame.booleanValue() != builtin.needsFrame()) {
                    throw new IllegalStateException(String.format("Implementation error in %s: all @Builtin annotations must agree if the node needs a frame.", nodeFactory.getNodeClass().getName()));
                }
                func.accept(nodeFactory, builtin);
            }
        }
    }

    public static int numDefaults(Builtin builtin) {
        int parameterNameCount = builtin.parameterNames().length;
        int maxNumPosArgs = Math.max(builtin.minNumOfPositionalArgs(), parameterNameCount);
        if (builtin.maxNumOfPositionalArgs() >= 0) {
            maxNumPosArgs = builtin.maxNumOfPositionalArgs();
            assert (parameterNameCount == 0) : "either give all parameter names explicitly, or define the max number: " + builtin.name();
        }
        return maxNumPosArgs - builtin.minNumOfPositionalArgs();
    }

    protected final void addBuiltinConstant(String name, Object value) {
        this.addBuiltinConstant(PythonUtils.toTruffleStringUncached(name), value);
    }

    protected final void addBuiltinConstant(TruffleString name, Object value) {
        this.builtinConstants.put(name, TruffleStringMigrationHelpers.ensureNoJavaString(value));
    }

    protected Object getBuiltinConstant(TruffleString name) {
        return this.builtinConstants.get(name);
    }

    void addConstantsToModuleObject(PythonObject obj) {
        for (Map.Entry<TruffleString, Object> entry : this.builtinConstants.entrySet()) {
            Object value = TruffleStringMigrationHelpers.assertNoJavaString(entry.getValue());
            obj.setAttribute(entry.getKey(), value);
        }
    }

    void addFunctionsToModuleObject(PythonObject obj, PythonObjectSlowPathFactory factory) {
        PythonBuiltins.addFunctionsToModuleObject(this.builtinFunctions, obj, factory);
    }

    static void addFunctionsToModuleObject(Map<TruffleString, BoundBuiltinCallable<?>> builtinFunctions, PythonObject obj, PythonObjectSlowPathFactory factory) {
        for (Map.Entry<TruffleString, BoundBuiltinCallable<?>> entry : builtinFunctions.entrySet()) {
            assert (obj instanceof PythonModule || obj instanceof PythonBuiltinClass) : "unexpected object while adding builtins";
            PBuiltinMethod value = obj instanceof PythonModule ? factory.createBuiltinMethod((Object)obj, (PBuiltinFunction)entry.getValue()) : entry.getValue().boundToObject(((PythonBuiltinClass)obj).getType(), factory);
            obj.setAttribute(entry.getKey(), value);
        }
    }
}

