/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.GcModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.GcModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

@CoreFunctions(defineModule="gc")
public final class GcModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString CALLBACKS = PythonUtils.tsLiteral("callbacks");
    private static final TruffleString START = PythonUtils.tsLiteral("start");
    private static final TruffleString STOP = PythonUtils.tsLiteral("stop");
    private static final TruffleString GENERATION = PythonUtils.tsLiteral("generation");
    private static final TruffleString COLLECTED = PythonUtils.tsLiteral("collected");
    private static final TruffleString UNCOLLECTABLE = PythonUtils.tsLiteral("uncollectable");
    private static final int DEBUG_STATS = 1;
    private static final int DEBUG_COLLECTABLE = 2;
    private static final int DEBUG_UNCOLLECTABLE = 4;
    private static final int DEBUG_SAVEALL = 32;
    private static final int DEBUG_LEAK = 38;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GcModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("DEBUG_STATS", (Object)1);
        this.addBuiltinConstant("DEBUG_COLLECTABLE", (Object)2);
        this.addBuiltinConstant("DEBUG_UNCOLLECTABLE", (Object)4);
        this.addBuiltinConstant("DEBUG_SAVEALL", (Object)32);
        this.addBuiltinConstant("DEBUG_LEAK", (Object)38);
        this.addBuiltinConstant(CALLBACKS, (Object)core.factory().createList());
        super.initialize(core);
    }

    @Builtin(name="get_referrers", takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class GcGetReferrersNode
    extends PythonBuiltinNode {
        GcGetReferrersNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PList doGeneric(Object objects) {
            return PythonContext.get(null).factory().createList();
        }
    }

    @Builtin(name="get_referents", takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class GcGetReferentsNode
    extends PythonBuiltinNode {
        GcGetReferentsNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PList getReferents(Object objects) {
            return PythonContext.get(null).factory().createList();
        }
    }

    @Builtin(name="is_tracked", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GcIsTrackedNode
    extends PythonBuiltinNode {
        GcIsTrackedNode() {
        }

        @Specialization
        static boolean doNative(PythonNativeObject object) {
            return false;
        }

        @Fallback
        static boolean doManaged(Object object) {
            return true;
        }
    }

    @Builtin(name="get_count", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GcCountNode
    extends PythonBuiltinNode {
        GcCountNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PTuple count() {
            List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            long count = 0L;
            for (GarbageCollectorMXBean gcbean : garbageCollectorMXBeans) {
                long cc = gcbean.getCollectionCount();
                if (cc <= 0L) continue;
                count += cc;
            }
            return PythonContext.get(null).factory().createTuple(new Object[]{count, 0, 0});
        }
    }

    @Builtin(name="set_debug", minNumOfPositionalArgs=1, parameterNames={"flags"})
    @GenerateNodeFactory
    @ArgumentClinic(name="flags", conversion=ArgumentClinic.ClinicConversion.Int)
    static abstract class SetDebugNode
    extends PythonUnaryClinicBuiltinNode {
        SetDebugNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return GcModuleBuiltinsClinicProviders.SetDebugNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone doGeneric(int flags) {
            PythonContext context = PythonContext.get(null);
            context.getGcState().setDebug(flags);
            CApiContext cApiContext = context.getCApiContext();
            if (cApiContext != null) {
                CStructAccess.WriteIntNode.writeUncached(cApiContext.getGCState(), CFields.GCState__debug, flags);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="get_debug", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetDebugNode
    extends PythonBuiltinNode {
        GetDebugNode() {
        }

        @Specialization
        int getDebug() {
            return this.getContext().getGcState().getDebug();
        }
    }

    @Builtin(name="enable", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class EnableNode
    extends PythonBuiltinNode {
        EnableNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone enable() {
            PythonContext context = PythonContext.get(null);
            context.getGcState().setEnabled(true);
            CApiContext cApiContext = context.getCApiContext();
            if (cApiContext != null) {
                CStructAccess.WriteIntNode.writeUncached(cApiContext.getGCState(), CFields.GCState__enabled, 1);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="disable", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class DisableNode
    extends PythonBuiltinNode {
        DisableNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PNone disable() {
            PythonContext context = PythonContext.get(null);
            context.getGcState().setEnabled(false);
            CApiContext cApiContext = context.getCApiContext();
            if (cApiContext != null) {
                CStructAccess.WriteIntNode.writeUncached(cApiContext.getGCState(), CFields.GCState__enabled, 0);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="isenabled", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GcIsEnabledNode
    extends PythonBuiltinNode {
        GcIsEnabledNode() {
        }

        @Specialization
        boolean doGeneric() {
            return this.getContext().getGcState().isEnabled();
        }
    }

    @Builtin(name="collect", parameterNames={"$self", "generation"}, declaresExplicitSelf=true)
    @ArgumentClinic(name="generation", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="2")
    @GenerateNodeFactory
    static abstract class GcCollectNode
    extends PythonBinaryClinicBuiltinNode {
        private static final NativeCAPISymbol SYMBOL = NativeCAPISymbol.FUN_GRAALPY_GC_COLLECT;
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, SYMBOL.getName());

        GcCollectNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return GcModuleBuiltinsClinicProviders.GcCollectNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static long collect(VirtualFrame frame, PythonModule self, Object level, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Cached PyObjectGetIter getIter, @Cached(neverDefault=true) PyIterNextNode next, @Cached PythonObjectFactory factory, @Cached CallBinaryMethodNode call, @Cached GilNode gil, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode invokeNode2, @Cached ExternalFunctionNodes.CheckPrimitiveFunctionResultNode checkPrimitiveFunctionResultNode) {
            Object callbacks = getAttr.execute((Frame)frame, inliningTarget, self, CALLBACKS);
            Object iter = getIter.execute((Frame)frame, inliningTarget, callbacks);
            Object cb = next.execute((Frame)frame, iter);
            TruffleString phase = null;
            PDict info = null;
            long res = 0L;
            if (cb != null) {
                phase = START;
                info = factory.createDict(new PKeyword[]{new PKeyword(GENERATION, 2), new PKeyword(COLLECTED, 0), new PKeyword(UNCOLLECTABLE, 0)});
                do {
                    call.executeObject((Frame)frame, cb, phase, info);
                } while ((cb = next.execute((Frame)frame, iter)) != null);
            }
            long freedMemory = GcCollectNode.javaCollect(inliningTarget, gil);
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            if (PythonContext.get(inliningTarget).getCApiContext() != null && PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.PythonGC).booleanValue()) {
                Object executable = CApiContext.getNativeSymbol(inliningTarget, SYMBOL);
                PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget);
                Object result = invokeNode2.call(frame, inliningTarget, threadState, C_API_TIMING, SYMBOL.getTsName(), executable, level);
                res = checkPrimitiveFunctionResultNode.executeLong(threadState, SYMBOL.getTsName(), result);
            }
            if (phase != null) {
                phase = STOP;
                info = factory.createDict(new PKeyword[]{new PKeyword(GENERATION, 2), new PKeyword(COLLECTED, freedMemory), new PKeyword(UNCOLLECTABLE, 0)});
                iter = getIter.execute((Frame)frame, inliningTarget, callbacks);
                while ((cb = next.execute((Frame)frame, iter)) != null) {
                    call.executeObject((Frame)frame, cb, phase, info);
                }
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        static long javaCollect(Node inliningTarget, GilNode gil) {
            gil.release(true);
            Runtime runtime = Runtime.getRuntime();
            long freeMemory = runtime.freeMemory();
            try {
                PythonUtils.forceFullGC();
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                gil.acquire();
            }
            PythonContext.triggerAsyncActions(inliningTarget);
            CApiTransitions.pollReferenceQueue();
            return Math.max(0L, runtime.freeMemory() - freeMemory);
        }
    }
}

