/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.RandomModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.random.PRandom;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_random")
public final class RandomModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return RandomModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="Random", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PRandom, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class PRandomNode
    extends PythonBuiltinNode {
        private static final TruffleString T_SEED = PythonUtils.tsLiteral("seed");
        @Node.Child
        LookupAndCallBinaryNode setSeed = LookupAndCallBinaryNode.create(T_SEED);

        PRandomNode() {
        }

        @Specialization
        PRandom random(VirtualFrame frame, Object cls, Object seed, @Cached PythonObjectFactory factory) {
            PRandom random = factory.createRandom(cls);
            this.setSeed.executeObject(frame, random, seed != PNone.NO_VALUE ? seed : PNone.NONE);
            return random;
        }
    }
}

