/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextComplexBuiltins {
    static boolean isComplexSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PComplex);
    }

    static abstract class PyComplex_FromDoubles
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyComplex_FromDoubles() {
        }

        @Specialization
        static PComplex asDouble(double r, double i, @Cached PythonObjectFactory factory) {
            return factory.createComplex(r, i);
        }
    }

    @ImportStatic(value={PythonCextComplexBuiltins.class})
    static abstract class PyTruffleComplex_ImagAsDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        public static final TruffleString T_IMAG = PythonUtils.tsLiteral("imag");

        PyTruffleComplex_ImagAsDouble() {
        }

        @Specialization
        static double asDouble(PComplex d) {
            return d.getImag();
        }

        @Specialization(guards={"!isPComplex(obj)", "isComplexSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object asDouble(Object obj, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Cached CallNode callNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return callNode.executeWithoutFrame(getAttr.execute(null, inliningTarget, obj, T_IMAG), new Object[0]);
        }

        @Specialization(guards={"!isPComplex(obj)", "!isComplexSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object asDouble(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return 0.0;
        }
    }

    @ImportStatic(value={PythonCextComplexBuiltins.class})
    static abstract class PyTruffleComplex_RealAsDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        public static final TruffleString T_REAL = PythonUtils.tsLiteral("real");

        PyTruffleComplex_RealAsDouble() {
        }

        @Specialization
        static double asDouble(PComplex d) {
            return d.getReal();
        }

        @Specialization(guards={"!isPComplex(obj)"})
        static Object asDouble(Object obj, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile isComplexSubtypeProfile, @Cached PyObjectGetAttr getAttr, @Cached CallNode callNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString name = isComplexSubtypeProfile.profile(inliningTarget, PythonCextComplexBuiltins.isComplexSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)) ? T_REAL : SpecialMethodNames.T___FLOAT__;
            try {
                return callNode.executeWithoutFrame(getAttr.execute(null, inliningTarget, obj, name), new Object[0]);
            }
            catch (PException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError);
            }
        }
    }

    static abstract class PyTruffleComplex_AsCComplex
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleComplex_AsCComplex() {
        }

        @Specialization
        static int asComplex(PComplex c, Object out, @Cached.Shared @Cached CStructAccess.WriteDoubleNode writeDoubleNode) {
            writeDoubleNode.write(out, CFields.Py_complex__real, c.getReal());
            writeDoubleNode.write(out, CFields.Py_complex__imag, c.getImag());
            return 0;
        }

        @Specialization(guards={"!isPComplex(obj)"})
        static int doGeneric(Object obj, Object out, @Cached BuiltinConstructors.ComplexNode complexNode, @Cached.Shared @Cached CStructAccess.WriteDoubleNode writeDoubleNode) {
            PComplex c = (PComplex)complexNode.execute(null, (Object)PythonBuiltinClassType.PComplex, obj, PNone.NO_VALUE);
            writeDoubleNode.write(out, CFields.Py_complex__real, c.getReal());
            writeDoubleNode.write(out, CFields.Py_complex__imag, c.getImag());
            return 0;
        }
    }
}

