/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextFuncBuiltins {

    static abstract class PyTruffleCFunction_SetDoc
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleCFunction_SetDoc() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object setString(Object functionObj, TruffleString doc) {
            return PyTruffleCFunction_SetDoc.setDoc(functionObj, doc);
        }

        @Specialization(guards={"isNoValue(nullValue)"})
        @CompilerDirectives.TruffleBoundary
        static Object setNull(Object functionObj, PNone nullValue) {
            return PyTruffleCFunction_SetDoc.setDoc(functionObj, null);
        }

        private static PNone setDoc(Object functionObj, TruffleString doc) {
            PBuiltinFunction function;
            if (functionObj instanceof PBuiltinFunction) {
                PBuiltinFunction builtinFunction;
                function = builtinFunction = (PBuiltinFunction)functionObj;
            } else if (functionObj instanceof PBuiltinMethod) {
                PBuiltinMethod builtinMethod = (PBuiltinMethod)functionObj;
                function = builtinMethod.getBuiltinFunction();
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected object passed to GraalPyCFunction_SetDoc");
            }
            function.setAttribute(SpecialAttributeNames.T___DOC__, doc != null ? doc : PNone.NONE);
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyClassMethod_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyClassMethod_New() {
        }

        @Specialization
        static Object staticmethod(Object callable, @Cached PythonObjectFactory factory) {
            return factory.createClassmethodFromCallableObj(callable);
        }
    }

    static abstract class PyStaticMethod_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyStaticMethod_New() {
        }

        @Specialization
        static Object staticmethod(Object func, @Cached PythonObjectFactory factory) {
            PDecoratedMethod res = factory.createStaticmethod((Object)PythonBuiltinClassType.PStaticmethod);
            res.setCallable(func);
            return res;
        }
    }
}

