/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.csv;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.csv.CSVDialect;
import com.oracle.graal.python.builtins.modules.csv.CSVDialectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.CSVDialect})
public final class CSVDialectBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CSVDialectBuiltinsFactory.getFactories();
    }

    @Builtin(name="strict", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StrictNode
    extends PythonUnaryBuiltinNode {
        StrictNode() {
        }

        @Specialization
        static boolean doIt(CSVDialect self) {
            return self.strict;
        }
    }

    @Builtin(name="skipinitialspace", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class SkipInitialSpaceNode
    extends PythonUnaryBuiltinNode {
        SkipInitialSpaceNode() {
        }

        @Specialization
        static boolean doIt(CSVDialect self) {
            return self.skipInitialSpace;
        }
    }

    @Builtin(name="quoting", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class QuotingNode
    extends PythonUnaryBuiltinNode {
        QuotingNode() {
        }

        @Specialization
        static int doIt(CSVDialect self) {
            return self.quoting.ordinal();
        }
    }

    @Builtin(name="quotechar", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class QuoteCharNode
    extends PythonUnaryBuiltinNode {
        QuoteCharNode() {
        }

        @Specialization
        static Object doIt(CSVDialect self) {
            return self.quoteCharCodePoint == -1 ? PNone.NONE : self.quoteChar;
        }
    }

    @Builtin(name="lineterminator", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class LineTerminatorNode
    extends PythonUnaryBuiltinNode {
        LineTerminatorNode() {
        }

        @Specialization
        static TruffleString doIt(CSVDialect self) {
            return self.lineTerminator;
        }
    }

    @Builtin(name="escapechar", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EscapeCharNode
    extends PythonUnaryBuiltinNode {
        EscapeCharNode() {
        }

        @Specialization
        static Object doIt(CSVDialect self) {
            return self.escapeCharCodePoint == -1 ? PNone.NONE : self.escapeChar;
        }
    }

    @Builtin(name="doublequote", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DoubleQuoteNode
    extends PythonUnaryBuiltinNode {
        DoubleQuoteNode() {
        }

        @Specialization
        static boolean doIt(CSVDialect self) {
            return self.doubleQuote;
        }
    }

    @Builtin(name="delimiter", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DelimiterNode
    extends PythonUnaryBuiltinNode {
        DelimiterNode() {
        }

        @Specialization
        static TruffleString doIt(CSVDialect self) {
            return self.delimiter;
        }
    }
}

