/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CArgObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArgObject;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.CArgObject})
public final class CArgObjectBuiltins
extends PythonBuiltins {
    protected static final int PyCArrayTypeParamFunc = 1;
    protected static final int PyCFuncPtrTypeParamFunc = 2;
    protected static final int PyCPointerTypeParamFunc = 4;
    protected static final int PyCSimpleTypeParamFunc = 8;
    protected static final int StructUnionTypeParamFunc = 16;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CArgObjectBuiltinsFactory.getFactories();
    }

    static boolean isPrintable(char c) {
        return true;
    }

    static boolean isLiteralChar(char c) {
        return c < '\u0080' && CArgObjectBuiltins.isPrintable(c) && c != '\\' && c != '\'';
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class ParamFuncNode
    extends Node {
        ParamFuncNode() {
        }

        abstract PyCArgObject execute(Node var1, CDataObject var2, StgDictObject var3);

        @Specialization
        static PyCArgObject paramFunc(CDataObject self, StgDictObject stgDict, @Cached(inline=false) PythonObjectFactory factory, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            PyCArgObject parg = factory.createCArgObject();
            switch (stgDict.paramfunc) {
                case 1: {
                    parg.tag = (char)80;
                    parg.pffi_type = FFIType.ffi_type_pointer;
                    parg.valuePointer = self.b_ptr.createReference();
                    parg.obj = self;
                    return parg;
                }
                case 2: 
                case 4: {
                    parg.tag = (char)80;
                    parg.pffi_type = FFIType.ffi_type_pointer;
                    parg.obj = self;
                    parg.valuePointer = self.b_ptr;
                    return parg;
                }
                case 8: {
                    TruffleString fmt = (TruffleString)stgDict.proto;
                    assert (fmt != null);
                    char code = (char)codePointAtIndexNode.execute((AbstractTruffleString)fmt, 0, PythonUtils.TS_ENCODING);
                    FFIType.FieldDesc fd = FFIType._ctypes_get_fielddesc(code);
                    assert (fd != null);
                    parg.tag = code;
                    parg.pffi_type = fd.pffi_type;
                    parg.obj = self;
                    parg.valuePointer = self.b_ptr;
                    return parg;
                }
                case 16: {
                    Pointer ptr = self.b_ptr;
                    parg.pffi_type = stgDict.ffi_type_pointer;
                    parg.tag = (char)86;
                    parg.valuePointer = ptr;
                    parg.size = self.b_size;
                    parg.obj = self;
                    return parg;
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"Unknown function parameter");
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        TruffleString doit(PyCArgObject self, @Bind(value="this") Node inliningTarget, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PointerNodes.ReadByteNode readByteNode) {
            return fromJavaStringNode.execute(switch (self.tag) {
                case 'B', 'H', 'I', 'L', 'Q', 'b', 'h', 'i', 'l', 'q' -> PythonUtils.formatJString("<cparam '%c' (%d)>", Character.valueOf(self.tag), self.valuePointer);
                case 'd', 'f' -> PythonUtils.formatJString("<cparam '%c' (%f)>", Character.valueOf(self.tag), self.valuePointer);
                case 'c' -> {
                    byte val = readByteNode.execute(inliningTarget, self.valuePointer);
                    if (CArgObjectBuiltins.isLiteralChar((char)val)) {
                        yield PythonUtils.formatJString("<cparam '%c' ('%c')>", Character.valueOf(self.tag), self.valuePointer);
                    }
                    yield PythonUtils.formatJString("<cparam '%c' ('\\x%02x')>", Character.valueOf(self.tag), PythonAbstractObject.systemHashCode(self.valuePointer));
                }
                case 'P', 'Z', 'z' -> PythonUtils.formatJString("<cparam '%c' 0x%x>", Character.valueOf(self.tag), PythonAbstractObject.systemHashCode(self.valuePointer));
                default -> CArgObjectBuiltins.isLiteralChar(self.tag) ? PythonUtils.formatJString("<cparam '%c' at 0x%x>", Character.valueOf(self.tag), PythonAbstractObject.systemHashCode(self)) : PythonUtils.formatJString("<cparam 0x%02x at 0x%x>", Character.valueOf(self.tag), PythonAbstractObject.systemHashCode(self));
            }, PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="_obj", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ObjNode
    extends PythonUnaryBuiltinNode {
        ObjNode() {
        }

        @Specialization
        static Object doit(PyCArgObject self) {
            return self.obj;
        }
    }
}

