/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArgObject;
import com.oracle.graal.python.builtins.modules.ctypes.PyCPointerTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCPointerType})
public final class PyCPointerTypeBuiltins
extends PythonBuiltins {
    protected static final TruffleString T__TYPE_ = PythonUtils.tsLiteral("_type_");
    protected static final String J_SET_TYPE = "set_type";
    protected static final TruffleString T_UPPER_B = PythonUtils.tsLiteral("B");
    protected static final TruffleString T_UPPER_T_LEFTBRACE = PythonUtils.tsLiteral("T{");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCPointerTypeBuiltinsFactory.getFactories();
    }

    static void PyCPointerType_SetProto(Node inliningTarget, StgDictObject stgdict, Object proto, TypeNodes.IsTypeNode isTypeNode, StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, PRaiseNode.Lazy raiseNode) {
        if (proto == null || !isTypeNode.execute(inliningTarget, proto)) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_MUST_BE_A_TYPE);
        }
        if (pyTypeStgDictNode.execute(inliningTarget, proto) == null) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_MUST_HAVE_STORAGE_INFO);
        }
        stgdict.proto = proto;
    }

    @Builtin(name="set_type", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class SetTypeNode
    extends PythonBuiltinNode {
        protected SetTypeNode() {
        }

        @Specialization
        static Object PyCPointerType_set_type(Object self, TruffleString type, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, self, raiseNode);
            PyCPointerTypeBuiltins.PyCPointerType_SetProto(inliningTarget, dict, type, isTypeNode, pyTypeStgDictNode, raiseNode);
            dict.setDictStorage(setItem.execute(inliningTarget, dict.getDictStorage(), T__TYPE_, type));
            return PNone.NONE;
        }

        @Specialization(guards={"!isString(type)"})
        static Object error(Object self, Object type, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.TYPE_MUST_BE_A_TYPE);
        }
    }

    @Builtin(name="from_param", minNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    protected static abstract class FromParamNode
    extends PythonBinaryBuiltinNode {
        protected FromParamNode() {
        }

        static PyCArgObject byref(Node inliningTarget, Object obj, CtypesNodes.PyTypeCheck pyTypeCheck, PythonObjectFactory factory, PRaiseNode.Lazy raiseNode) {
            if (!pyTypeCheck.isCDataObject(inliningTarget, obj)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_CDATA_INSTANCE);
            }
            CDataObject cdata = (CDataObject)obj;
            PyCArgObject parg = factory.createCArgObject();
            parg.tag = (char)80;
            parg.pffi_type = FFIType.ffi_type_pointer;
            parg.obj = cdata;
            parg.valuePointer = cdata.b_ptr.createReference();
            return parg;
        }

        @Specialization
        static Object none(Object type, PNone value) {
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(value)"})
        static Object PyCPointerType_from_param(VirtualFrame frame, Object type, Object value, @Bind(value="this") Node inliningTarget, @Cached CtypesNodes.PyTypeCheck pyTypeCheck, @Cached CastToJavaBooleanNode toJavaBooleanNode, @Cached BuiltinFunctions.IsInstanceNode isInstanceNode, @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CDataTypeBuiltins.CDataTypeFromParamNode fromParamNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject typedict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            if (isInstanceNode.executeWith(frame, value, typedict.proto)) {
                return FromParamNode.byref(inliningTarget, value, pyTypeCheck, factory, raiseNode);
            }
            if (pyTypeCheck.isPointerObject(inliningTarget, value) || pyTypeCheck.isArrayObject(inliningTarget, value)) {
                StgDictObject v = pyObjectStgDictNode.execute(inliningTarget, value);
                assert (v != null) : "Cannot be NULL for pointer or array objects";
                if (toJavaBooleanNode.execute(inliningTarget, isSubClassNode.execute(frame, v.proto, typedict.proto))) {
                    return value;
                }
            }
            return fromParamNode.execute(frame, type, value);
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @ImportStatic(value={PyCPointerTypeBuiltins.class})
    @GenerateNodeFactory
    protected static abstract class PyCPointerTypeNewNode
    extends PythonBuiltinNode {
        protected PyCPointerTypeNewNode() {
        }

        @Specialization
        static Object PyCPointerType_new(VirtualFrame frame, Object type, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode, @Cached GetDictIfExistsNode getDict, @Cached SetDictNode setDict, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached BuiltinConstructors.TypeNode newType, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached StringUtils.SimpleTruffleStringFormatNode formatNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object result;
            PDict resDict;
            StgDictObject stgdict = factory.createStgDictObject((Object)PythonBuiltinClassType.StgDict);
            stgdict.size = 8;
            stgdict.align = FFIType.FieldDesc.P.pffi_type.alignment;
            stgdict.length = 1;
            stgdict.ffi_type_pointer = FFIType.ffi_type_pointer;
            stgdict.paramfunc = 4;
            stgdict.flags |= 0x100;
            PDict typedict = (PDict)args[2];
            Object proto = getItem.execute(inliningTarget, typedict.getDictStorage(), T__TYPE_);
            if (proto != null) {
                PyCPointerTypeBuiltins.PyCPointerType_SetProto(inliningTarget, stgdict, proto, isTypeNode, pyTypeStgDictNode, raiseNode);
                StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, proto);
                TruffleString current_format = itemdict.format != null ? itemdict.format : T_UPPER_B;
                stgdict.format = itemdict.shape != null ? CtypesModuleBuiltins._ctypes_alloc_format_string_with_shape(itemdict.ndim, itemdict.shape, StringLiterals.T_AMPERSAND, current_format, appendStringNode, toStringNode, formatNode) : StringUtils.cat(StringLiterals.T_AMPERSAND, current_format);
            }
            if ((resDict = getDict.execute(result = newType.execute(frame, type, args[0], args[1], typedict, kwds))) == null) {
                resDict = factory.createDictFixedStorage((PythonObject)result);
            }
            addAllToOtherNode.execute((Frame)frame, inliningTarget, resDict.getDictStorage(), stgdict);
            setDict.execute(inliningTarget, result, stgdict);
            return result;
        }
    }
}

