/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.io.AbstractBufferedIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIONodes;
import com.oracle.graal.python.builtins.modules.io.BufferedIOUtil;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

public class BufferedWriterNodes {
    private static void adjustPosition(PBuffered self, int newPos) {
        self.setPos(newPos);
        if (BufferedIOUtil.isValidReadBuffer(self) && self.getReadEnd() < newPos) {
            self.setReadEnd(newPos);
        }
    }

    @GenerateInline(value=false)
    static abstract class FlushUnlockedNode
    extends PNodeWithContext {
        FlushUnlockedNode() {
        }

        public abstract void execute(VirtualFrame var1, PBuffered var2);

        @Specialization
        protected static void bufferedwriterFlushUnlocked(VirtualFrame frame, PBuffered self, @Bind(value="this") Node inliningTarget, @Cached AbstractBufferedIOBuiltins.LazyRaiseBlockingIOError raiseBlockingIOError, @Cached RawWriteNode rawWriteNode, @Cached BufferedIONodes.RawSeekNode rawSeekNode) {
            if (!BufferedIOUtil.isValidWriteBuffer(self) || self.getWritePos() == self.getWriteEnd()) {
                self.resetWrite();
                return;
            }
            long rewind = BufferedIOUtil.rawOffset(self) + (long)(self.getPos() - self.getWritePos());
            if (rewind != 0L) {
                rawSeekNode.execute(frame, self, -rewind, 1);
                self.incRawPos(-rewind);
            }
            while (self.getWritePos() < self.getWriteEnd()) {
                byte[] buf = PythonUtils.arrayCopyOfRange(self.getBuffer(), self.getWritePos(), self.getWriteEnd());
                int n = rawWriteNode.execute(frame, inliningTarget, self, buf, buf.length);
                if (n == -2) {
                    throw raiseBlockingIOError.get(inliningTarget).raiseEAGAIN(ErrorMessages.WRITE_COULD_NOT_COMPLETE_WITHOUT_BLOCKING, 0);
                }
                self.incWritePos(n);
                self.setRawPos(self.getWritePos());
            }
            self.resetWrite();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class RawWriteNode
    extends PNodeWithContext {
        RawWriteNode() {
        }

        public abstract int execute(VirtualFrame var1, Node var2, PBuffered var3, byte[] var4, int var5);

        @Specialization
        static int bufferedwriterRawWrite(VirtualFrame frame, Node inliningTarget, PBuffered self, byte[] buf, int len, @Cached(inline=false) PythonObjectFactory factory, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyNumberAsSizeNode asSizeNode, @Cached PRaiseNode.Lazy lazyRaiseNode) {
            PBytes memobj = factory.createBytes(buf, len);
            Object res = callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_WRITE, memobj);
            if (res == PNone.NONE) {
                return -2;
            }
            int n = asSizeNode.executeExact((Frame)frame, inliningTarget, res, PythonErrorType.ValueError);
            if (n < 0 || n > len) {
                throw lazyRaiseNode.get(inliningTarget).raise(PythonErrorType.OSError, ErrorMessages.IO_S_INVALID_LENGTH, "write()", n, len);
            }
            if (n > 0 && self.getAbsPos() != -1L) {
                self.incAbsPos(n);
            }
            return n;
        }
    }

    static abstract class WriteNode
    extends Node {
        WriteNode() {
        }

        public abstract int execute(VirtualFrame var1, Node var2, PBuffered var3, Object var4);

        @Specialization
        static int bufferedWriterWrite(VirtualFrame frame, Node ignored, PBuffered self, Object buffer, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached AbstractBufferedIOBuiltins.LazyRaiseBlockingIOError raiseBlockingIOError, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile, @Cached BufferedIONodes.RawSeekNode rawSeekNode, @Cached RawWriteNode rawWriteNode, @Cached FlushUnlockedNode flushUnlockedNode, @Cached ExceptionNodes.GetArgsNode getArgsNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode) {
            int remaining;
            int n;
            int avail;
            int bufLen = bufferLib.getBufferLength(buffer);
            if (!BufferedIOUtil.isValidReadBuffer(self) && !BufferedIOUtil.isValidWriteBuffer(self)) {
                self.setPos(0);
                self.setRawPos(0L);
            }
            if (bufLen <= (avail = self.getBufferSize() - self.getPos())) {
                bufferLib.readIntoByteArray(buffer, 0, self.getBuffer(), self.getPos(), bufLen);
                if (!BufferedIOUtil.isValidWriteBuffer(self) || self.getWritePos() > self.getPos()) {
                    self.setWritePos(self.getPos());
                }
                BufferedWriterNodes.adjustPosition(self, self.getPos() + bufLen);
                if (self.getPos() > self.getWriteEnd()) {
                    self.setWriteEnd(self.getPos());
                }
                return bufLen;
            }
            try {
                flushUnlockedNode.execute(frame, self);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.BlockingIOError, isBuiltinClassProfile);
                if (self.isReadable()) {
                    self.resetRead();
                }
                assert (BufferedIOUtil.isValidWriteBuffer(self));
                int n2 = self.getWriteEnd() - self.getWritePos();
                byte[] from = PythonUtils.arrayCopyOfRange(self.getBuffer(), self.getWritePos(), self.getWritePos() + n2);
                PythonUtils.arraycopy(from, 0, self.getBuffer(), 0, n2);
                self.setWriteEnd(n2);
                self.setRawPos(self.getRawPos() - (long)self.getWritePos());
                self.setPos(self.getPos() - self.getWritePos());
                self.setWritePos(0);
                avail = self.getBufferSize() - self.getWriteEnd();
                if (bufLen <= avail) {
                    bufferLib.readIntoByteArray(buffer, 0, self.getBuffer(), self.getWriteEnd(), bufLen);
                    self.incWriteEnd(bufLen);
                    self.incPos(bufLen);
                    return bufLen;
                }
                bufferLib.readIntoByteArray(buffer, 0, self.getBuffer(), self.getWriteEnd(), avail);
                self.incWriteEnd(avail);
                self.incPos(avail);
                Object pythonException = e.getUnreifiedException();
                PTuple args = getArgsNode.execute(inliningTarget, pythonException);
                Object errno = getItemScalarNode.execute(inliningTarget, args.getSequenceStorage(), 0);
                throw raiseBlockingIOError.get(inliningTarget).raise(errno, ErrorMessages.WRITE_COULD_NOT_COMPLETE_WITHOUT_BLOCKING, avail);
            }
            long offset = BufferedIOUtil.rawOffset(self);
            if (offset != 0L) {
                rawSeekNode.execute(frame, self, -offset, 1);
                self.setRawPos(self.getRawPos() - offset);
            }
            int written = 0;
            for (remaining = bufLen; remaining > self.getBufferSize(); remaining -= n) {
                byte[] buf = new byte[bufLen];
                bufferLib.readIntoByteArray(buffer, written, buf, 0, bufLen - written);
                n = rawWriteNode.execute(frame, inliningTarget, self, buf, bufLen - written);
                if (n == -2) {
                    if (remaining <= self.getBufferSize()) break;
                    bufferLib.readIntoByteArray(buffer, written, self.getBuffer(), 0, self.getBufferSize());
                    self.setRawPos(0L);
                    BufferedWriterNodes.adjustPosition(self, self.getBufferSize());
                    self.setWriteEnd(self.getBufferSize());
                    throw raiseBlockingIOError.get(inliningTarget).raiseEWOULDBLOCK(ErrorMessages.WRITE_COULD_NOT_COMPLETE_WITHOUT_BLOCKING, written += self.getBufferSize());
                }
                written += n;
            }
            if (self.isReadable()) {
                self.resetRead();
            }
            if (remaining > 0) {
                bufferLib.readIntoByteArray(buffer, written, self.getBuffer(), 0, remaining);
                written += remaining;
            }
            self.setWritePos(0);
            self.setWriteEnd(remaining);
            BufferedWriterNodes.adjustPosition(self, remaining);
            self.setRawPos(0L);
            return written;
        }
    }
}

