/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.lzma;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.lzma.LZMAModuleBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMANodesFactory;
import com.oracle.graal.python.builtins.modules.lzma.LZMAObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.runtime.NFILZMASupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.graalvm.shadowed.org.tukaani.xz.ARMOptions;
import org.graalvm.shadowed.org.tukaani.xz.ARMThumbOptions;
import org.graalvm.shadowed.org.tukaani.xz.CorruptedInputException;
import org.graalvm.shadowed.org.tukaani.xz.DeltaOptions;
import org.graalvm.shadowed.org.tukaani.xz.FilterOptions;
import org.graalvm.shadowed.org.tukaani.xz.IA64Options;
import org.graalvm.shadowed.org.tukaani.xz.LZMA2Options;
import org.graalvm.shadowed.org.tukaani.xz.MemoryLimitException;
import org.graalvm.shadowed.org.tukaani.xz.PowerPCOptions;
import org.graalvm.shadowed.org.tukaani.xz.SPARCOptions;
import org.graalvm.shadowed.org.tukaani.xz.UnsupportedOptionsException;
import org.graalvm.shadowed.org.tukaani.xz.X86Options;
import org.graalvm.shadowed.org.tukaani.xz.XZFormatException;
import org.graalvm.shadowed.org.tukaani.xz.check.Check;

public class LZMANodes {
    public static final long MAX_UINT32 = 0x100000000L;
    protected static final int LZMA_RUN = 0;
    protected static final int LZMA_FINISH = 3;
    private static final int LZMA_OK = 0;
    private static final int LZMA_STREAM_END = 1;
    private static final int LZMA_NO_CHECK = 2;
    private static final int LZMA_UNSUPPORTED_CHECK = 3;
    private static final int LZMA_GET_CHECK = 4;
    private static final int LZMA_MEM_ERROR = 5;
    private static final int LZMA_MEMLIMIT_ERROR = 6;
    private static final int LZMA_FORMAT_ERROR = 7;
    private static final int LZMA_OPTIONS_ERROR = 8;
    private static final int LZMA_DATA_ERROR = 9;
    private static final int LZMA_BUF_ERROR = 10;
    private static final int LZMA_PROG_ERROR = 11;

    @CompilerDirectives.TruffleBoundary
    protected static LZMA2Options parseLZMAOptions(long preset) {
        LZMA2Options lzmaOptions = null;
        try {
            lzmaOptions = new LZMA2Options();
            lzmaOptions.setPreset((int)preset);
        }
        catch (UnsupportedOptionsException e) {
            try {
                lzmaOptions.setPreset(9);
            }
            catch (UnsupportedOptionsException e1) {
                throw new IllegalStateException("should not be reached");
            }
        }
        return lzmaOptions;
    }

    protected static int errorHandling(Node inliningTarget, int lzret, PRaiseNode.Lazy raiseNode) {
        switch (lzret) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return 0;
            }
            case 3: {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.UNSUPPORTED_INTEGRITY_CHECK);
            }
            case 5: {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.MemoryError);
            }
            case 6: {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.MEM_USAGE_LIMIT_EXCEEDED);
            }
            case 7: {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INPUT_FMT_NOT_SUPPORTED_BY_DECODER);
            }
            case 8: {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_UNSUPPORTED_OPTIONS);
            }
            case 9: {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.CORRUPT_INPUT_DATA);
            }
            case 10: {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INSUFFICIENT_BUFFER_SPACE);
            }
            case 11: {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INTERNAL_ERROR);
            }
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.UNRECOGNIZED_ERROR_FROM_LIBLZMA, lzret);
    }

    protected static class LZMAByteInputStream
    extends ByteArrayInputStream {
        public LZMAByteInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        public void setBuffer(byte[] bytes, int off) {
            this.buf = bytes;
            this.pos = off;
            this.mark = off;
            this.count = bytes.length;
        }

        public int getNextInIndex() {
            return this.pos;
        }

        public int getAvailIn() {
            return this.available();
        }
    }

    public static abstract class DecodeFilterProperties
    extends Node {
        public abstract void execute(VirtualFrame var1, long var2, byte[] var4, PDict var5);

        @NonIdempotent
        protected boolean useNativeContext() {
            return PythonContext.get(this).getNFILZMASupport().isAvailable();
        }

        @Specialization(guards={"useNativeContext()"})
        static void decodeNative(VirtualFrame frame, long id, byte[] encoded, PDict dict, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction decodeFilter, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached InlinedConditionProfile errProfile, @Cached PRaiseNode.Lazy raiseNode) {
            Object filter;
            PythonContext ctxt = PythonContext.get(inliningTarget);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            long[] opts = new long[10];
            int len = encoded.length;
            Object encodedProps = ctxt.getEnv().asGuestValue((Object)encoded);
            int lzret = lzmaSupport.decodeFilter(id, encodedProps, len, filter = ctxt.getEnv().asGuestValue((Object)opts), decodeFilter);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                if (lzret == 98) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_FILTER, opts[LZMAOption.id.ordinal()]);
                }
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
            DecodeFilterProperties.buildFilterSpec(frame, inliningTarget, opts, dict, setItem);
        }

        @Specialization(guards={"!useNativeContext()"})
        static void decodeJava(long id, byte[] encoded, PDict dict, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, LZMAModuleBuiltins.T_LZMA_JAVA_ERROR);
        }

        static void buildFilterSpec(VirtualFrame frame, Node inliningTarget, long[] opts, PDict dict, HashingStorageNodes.HashingStorageSetItem setItem) {
            long id = opts[LZMAOption.id.ordinal()];
            DecodeFilterProperties.addField(frame, inliningTarget, setItem, dict, LZMAOption.id.OptName(), id);
            switch (LZMAFilter.from(id).ordinal()) {
                case 0: {
                    DecodeFilterProperties.addField(frame, inliningTarget, setItem, dict, LZMAOption.lc.OptName(), opts[LZMAOption.lc.ordinal()]);
                    DecodeFilterProperties.addField(frame, inliningTarget, setItem, dict, LZMAOption.lp.OptName(), opts[LZMAOption.lp.ordinal()]);
                    DecodeFilterProperties.addField(frame, inliningTarget, setItem, dict, LZMAOption.pb.OptName(), opts[LZMAOption.pb.ordinal()]);
                    DecodeFilterProperties.addField(frame, inliningTarget, setItem, dict, LZMAOption.dict_size.OptName(), opts[LZMAOption.dict_size.ordinal()]);
                    break;
                }
                case 1: {
                    DecodeFilterProperties.addField(frame, inliningTarget, setItem, dict, LZMAOption.dict_size.OptName(), opts[LZMAOption.dict_size.ordinal()]);
                    break;
                }
                case 2: {
                    DecodeFilterProperties.addField(frame, inliningTarget, setItem, dict, DeltaOption.dist.OptName(), opts[DeltaOption.dist.ordinal()]);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    DecodeFilterProperties.addField(frame, inliningTarget, setItem, dict, BCJOption.start_offset.OptName(), opts[BCJOption.start_offset.ordinal()]);
                }
            }
        }

        static void addField(VirtualFrame frame, Node inliningTarget, HashingStorageNodes.HashingStorageSetItem setItem, PDict dict, TruffleString key, long val) {
            dict.setDictStorage(setItem.execute((Frame)frame, inliningTarget, dict.getDictStorage(), key, val));
        }
    }

    public static abstract class EncodeFilterProperties
    extends Node {
        public abstract byte[] execute(VirtualFrame var1, Object var2);

        @NonIdempotent
        protected boolean useNativeContext() {
            return PythonContext.get(this).getNFILZMASupport().isAvailable();
        }

        @Specialization(guards={"useNativeContext()"})
        static byte[] encodeNative(VirtualFrame frame, Object filter, @Bind(value="this") Node inliningTarget, @Cached LZMAFilterConverter filterConverter, @Cached GetOutputNativeBufferNode getBuffer, @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached NativeLibrary.InvokeNativeFunction encodeFilter, @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached InlinedConditionProfile errProfile, @Cached PRaiseNode.Lazy raiseNode) {
            PythonContext ctxt = PythonContext.get(inliningTarget);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            long[] opts = filterConverter.execute(frame, filter);
            int lzret = lzmaSupport.encodeFilter(lzmast, ctxt.getEnv().asGuestValue((Object)opts), encodeFilter);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                lzmaSupport.deallocateStream(lzmast, deallocateStream);
                if (lzret == 99) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_COMPRESSION_PRESET, opts[LZMAOption.preset.ordinal()]);
                }
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
            byte[] encoded = getBuffer.execute(inliningTarget, lzmast, ctxt);
            lzmaSupport.deallocateStream(lzmast, deallocateStream);
            return encoded;
        }

        @Specialization(guards={"!useNativeContext()"})
        static byte[] encodeJava(Object filter, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, LZMAModuleBuiltins.T_LZMA_JAVA_ERROR);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IsCheckSupported
    extends Node {
        public abstract boolean execute(Node var1, int var2);

        @NonIdempotent
        protected boolean useNativeContext() {
            return PythonContext.get(this).getNFILZMASupport().isAvailable();
        }

        @Specialization(guards={"useNativeContext()"})
        static boolean checkNative(Node inliningTarget, int checkId, @Cached(inline=false) NativeLibrary.InvokeNativeFunction checkIsSupported) {
            return PythonContext.get(inliningTarget).getNFILZMASupport().checkIsSupported(checkId, checkIsSupported) == 1;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!useNativeContext()"})
        static boolean checkJava(int checkId) {
            try {
                Check.getInstance((int)checkId);
                return true;
            }
            catch (UnsupportedOptionsException e) {
                return false;
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetOutputNativeBufferNode
    extends Node {
        public abstract byte[] execute(Node var1, Object var2, PythonContext var3);

        @Specialization
        static byte[] getBuffer(Node inliningTarget, Object lzmast, PythonContext context, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getBufferSize, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getBuffer, @Cached PRaiseNode.Lazy raiseNode) {
            int size;
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            try {
                size = PInt.intValueExact(lzmaSupport.getOutputBufferSize(lzmast, getBufferSize));
            }
            catch (OverflowException of) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.VALUE_TOO_LARGE_TO_FIT_INTO_INDEX);
            }
            if (size == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            byte[] resultArray = new byte[size];
            Object out = context.getEnv().asGuestValue((Object)resultArray);
            lzmaSupport.getOutputBuffer(lzmast, out, getBuffer);
            return resultArray;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class InternalDecompressNode
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, LZMAObject.LZMADecompressor var2, int var3);

        @Specialization
        static byte[] nativeInternalDecompress(Node inliningTarget, LZMAObject.LZMADecompressor.Native self, int maxLength, @Cached(inline=false) NativeLibrary.InvokeNativeFunction decompress, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getLzsAvailIn, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getLzsAvailOut, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getNextInIndex, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getLzsCheck, @Cached GetOutputNativeBufferNode getBuffer, @Cached.Exclusive @Cached PRaiseNode.Lazy lazyRaiseNode, @Cached InlinedConditionProfile errProfile) {
            PythonContext context = PythonContext.get(inliningTarget);
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            Object inGuest = context.getEnv().asGuestValue((Object)self.getNextIn());
            int offset = self.getNextInIndex();
            int err = lzmaSupport.decompress(self.getLzs(), inGuest, offset, maxLength, 8192L, self.getLzsAvailIn(), decompress);
            long nextInIdx = lzmaSupport.getNextInIndex(self.getLzs(), getNextInIndex);
            long lzsAvailIn = lzmaSupport.getLzsAvailIn(self.getLzs(), getLzsAvailIn);
            long lzsAvailOut = lzmaSupport.getLzsAvailOut(self.getLzs(), getLzsAvailOut);
            self.setCheck(lzmaSupport.getLzsCheck(self.getLzs(), getLzsCheck));
            try {
                self.setNextInIndex(nextInIdx);
                self.setLzsAvailIn(lzsAvailIn);
                self.setLzsAvailOut(lzsAvailOut);
            }
            catch (OverflowException of) {
                throw lazyRaiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.VALUE_TOO_LARGE_TO_FIT_INTO_INDEX);
            }
            if (err == 1) {
                self.setEOF();
            } else if (errProfile.profile(inliningTarget, err != 0)) {
                LZMANodes.errorHandling(inliningTarget, err, lazyRaiseNode);
            }
            return getBuffer.execute(inliningTarget, self.getLzs(), context);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static byte[] javaInternalDecompress(Node inliningTarget, LZMAObject.LZMADecompressor.Java self, int maxLength, @Cached.Exclusive @Cached PRaiseNode.Lazy lazyRaiseNode) {
            if (maxLength == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            self.setInput();
            int maxLen = maxLength == -1 ? Integer.MAX_VALUE : maxLength;
            byte[] result = new byte[Math.min(maxLen, 8192)];
            ByteArrayOutputStream baos = BytesUtils.createOutputStream(result.length);
            int dataSize = -1;
            boolean isInitialized = self.isInitialized();
            try {
                while (true) {
                    try {
                        if (!isInitialized) {
                            self.initialize();
                        }
                        InternalDecompressNode.doDecompression(self, baos, result, maxLen);
                    }
                    catch (IOException ioe) {
                        isInitialized = true;
                        if (self.isFormatAuto()) {
                            if (dataSize != baos.size()) {
                                dataSize = baos.size();
                                self.switchStream();
                                continue;
                            }
                            break;
                        }
                        throw ioe;
                    }
                    break;
                }
            }
            catch (UnsupportedOptionsException o) {
                LZMANodes.errorHandling(inliningTarget, 8, lazyRaiseNode);
            }
            catch (CorruptedInputException c) {
                if (self.isFormatAuto() && baos.size() > 0) {
                    self.setEOF();
                } else {
                    LZMANodes.errorHandling(inliningTarget, 9, lazyRaiseNode);
                }
            }
            catch (MemoryLimitException m) {
                LZMANodes.errorHandling(inliningTarget, 6, lazyRaiseNode);
            }
            catch (XZFormatException f) {
                LZMANodes.errorHandling(inliningTarget, 7, lazyRaiseNode);
            }
            catch (EOFException eof) {
                self.setEOF();
            }
            catch (IOException e) {
                PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.OSError, e);
            }
            byte[] ret = BytesUtils.toByteArray(baos);
            self.decompressedData(ret.length);
            self.update(maxLen - ret.length);
            return ret;
        }

        @CompilerDirectives.TruffleBoundary
        private static void doDecompression(LZMAObject.LZMADecompressor.Java self, ByteArrayOutputStream baos, byte[] result, int maxLen) throws IOException {
            while (baos.size() < maxLen) {
                int read;
                try {
                    read = self.read(result);
                }
                catch (EOFException eof) {
                    if (!self.sameData()) break;
                    self.setEOF();
                    break;
                }
                if (read == -1) {
                    self.setEOF();
                    break;
                }
                BytesUtils.append(baos, result, 0, read);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class DecompressNode
    extends Node {
        public abstract byte[] execute(Node var1, LZMAObject.LZMADecompressor var2, byte[] var3, int var4, int var5);

        @Specialization
        static byte[] nativeDecompress(Node inliningTarget, LZMAObject.LZMADecompressor self, byte[] bytes, int len, int maxLength, @Cached InternalDecompressNode decompress) {
            boolean inputBufferInUse;
            if (self.getNextIn() != null) {
                int availNow = self.getInputBufferSize() - (self.getNextInIndex() + self.getLzsAvailIn());
                int availTotal = self.getInputBufferSize() - self.getLzsAvailIn();
                if (availTotal < len) {
                    int newSize = self.getInputBufferSize() + len - availNow;
                    self.resizeInputBuffer(newSize);
                    self.setNextIn(self.getInputBuffer());
                } else if (availNow < len) {
                    PythonUtils.arraycopy(self.getNextIn(), self.getNextInIndex(), self.getInputBuffer(), 0, self.getLzsAvailIn());
                    self.setNextIn(self.getInputBuffer());
                    self.setNextInIndex(0);
                }
                PythonUtils.arraycopy(bytes, 0, self.getNextIn(), self.getNextInIndex() + self.getLzsAvailIn(), len);
                self.incLzsAvailIn(len);
                inputBufferInUse = true;
            } else {
                self.setNextIn(bytes);
                self.setLzsAvailIn(len);
                inputBufferInUse = false;
            }
            byte[] result = decompress.execute(inliningTarget, self, maxLength);
            if (self.isEOF()) {
                self.setNeedsInput(false);
                if (self.getLzsAvailIn() > 0) {
                    self.setUnusedData();
                }
            } else if (self.getLzsAvailIn() == 0) {
                self.clearNextIn();
                self.setNextInIndex(0);
                self.setNeedsInput(self.getLzsAvailOut() != 0);
            } else {
                self.setNeedsInput(false);
                if (!inputBufferInUse) {
                    if (self.getInputBuffer() != null && self.getInputBufferSize() < self.getLzsAvailIn()) {
                        self.discardInputBuffer();
                    }
                    if (self.getInputBuffer() == null) {
                        self.createInputBuffer(self.getLzsAvailIn());
                    }
                    PythonUtils.arraycopy(self.getNextIn(), self.getNextInIndex(), self.getInputBuffer(), 0, self.getLzsAvailIn());
                    self.setNextIn(self.getInputBuffer());
                    self.setNextInIndex(0);
                }
            }
            return result;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={LZMAModuleBuiltins.class})
    public static abstract class LZMARawDecompressInit
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, LZMAObject.LZMADecompressor var3, Object var4);

        @Specialization
        static void rawJava(VirtualFrame frame, LZMAObject.LZMADecompressor.Java self, Object filters, @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, LZMAModuleBuiltins.T_LZMA_JAVA_ERROR);
        }

        @Specialization
        static void rawNative(VirtualFrame frame, Node inliningTarget, LZMAObject.LZMADecompressor.Native self, Object filters, @Cached(inline=false) NativeLibrary.InvokeNativeFunction createStream, @Cached(inline=false) NativeLibrary.InvokeNativeFunction lzmaRawDecoder, @Cached(inline=false) NativeFilterChain filterChain, @Cached InlinedConditionProfile errProfile, @Cached PRaiseNode.Lazy raiseNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            filterChain.execute(frame, lzmast, context, filters);
            int lzret = lzmaSupport.lzmaRawDecoder(lzmast, lzmaRawDecoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }
    }

    @ImportStatic(value={LZMAModuleBuiltins.class})
    public static abstract class LZMADecompressInit
    extends Node {
        public abstract void execute(VirtualFrame var1, LZMAObject.LZMADecompressor var2, int var3, Object var4);

        @Specialization
        static void init(LZMAObject.LZMADecompressor.Java self, int format, int memlimit) {
        }

        @Specialization(guards={"format == FORMAT_AUTO"})
        static void auto(LZMAObject.LZMADecompressor.Native self, int format, int memlimit, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaAutoDecoder, @Cached.Shared @Cached InlinedConditionProfile errProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            NFILZMASupport lzmaSupport = PythonContext.get(inliningTarget).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int decoderFlags = 5;
            int lzret = lzmaSupport.lzmaAutoDecoder(lzmast, memlimit, decoderFlags, lzmaAutoDecoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }

        @Specialization(guards={"format == FORMAT_XZ"})
        static void xz(LZMAObject.LZMADecompressor.Native self, int format, int memlimit, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaStreamDecoder, @Cached.Shared @Cached InlinedConditionProfile errProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            NFILZMASupport lzmaSupport = PythonContext.get(inliningTarget).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int decoderFlags = 5;
            int lzret = lzmaSupport.lzmaStreamDecoder(lzmast, memlimit, decoderFlags, lzmaStreamDecoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE"})
        static void alone(LZMAObject.LZMADecompressor.Native self, int format, int memlimit, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaAloneDecoder, @Cached.Shared @Cached InlinedConditionProfile errProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            NFILZMASupport lzmaSupport = PythonContext.get(inliningTarget).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int lzret = lzmaSupport.lzmaAloneDecoder(lzmast, memlimit, lzmaAloneDecoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={LZMANodes.class})
    public static abstract class CompressNode
    extends Node {
        public abstract byte[] execute(Node var1, LZMAObject.LZMACompressor var2, PythonContext var3, byte[] var4, int var5, int var6);

        public byte[] compress(Node inliningTarget, LZMAObject.LZMACompressor self, PythonContext context, byte[] bytes, int len) {
            return this.execute(inliningTarget, self, context, bytes, len, 0);
        }

        public byte[] flush(Node inliningTarget, LZMAObject.LZMACompressor self, PythonContext context) {
            return this.execute(inliningTarget, self, context, PythonUtils.EMPTY_BYTE_ARRAY, 0, 3);
        }

        @Specialization
        static byte[] nativeCompress(Node inliningTarget, LZMAObject.LZMACompressor.Native self, PythonContext context, byte[] bytes, int len, int action, @Cached(inline=false) NativeLibrary.InvokeNativeFunction compress, @Cached GetOutputNativeBufferNode getBuffer, @Cached InlinedConditionProfile errProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            Object inGuest = context.getEnv().asGuestValue((Object)bytes);
            int err = lzmaSupport.compress(self.getLzs(), inGuest, len, action, 8192L, compress);
            if (errProfile.profile(inliningTarget, err != 0)) {
                LZMANodes.errorHandling(inliningTarget, err, raiseNode);
            }
            return getBuffer.execute(inliningTarget, self.getLzs(), context);
        }

        @Specialization(guards={"action == LZMA_RUN"})
        static byte[] javaCompress(Node inliningTarget, LZMAObject.LZMACompressor.Java self, PythonContext context, byte[] bytes, int len, int action, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            try {
                self.write(bytes, 0, len);
                byte[] result = self.getByteArray();
                self.resetBuffer();
                return result;
            }
            catch (IOException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"action == LZMA_FINISH"})
        static byte[] javaFlush(Node inliningTarget, LZMAObject.LZMACompressor.Java self, PythonContext context, byte[] bytes, int len, int action, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            try {
                self.finish();
                return self.getByteArray();
            }
            catch (IOException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.M, e);
            }
        }
    }

    @ImportStatic(value={LZMAModuleBuiltins.class, PGuards.class})
    public static abstract class LZMACompressInit
    extends Node {
        public abstract void execute(VirtualFrame var1, LZMAObject.LZMACompressor var2, int var3, long var4, Object var6);

        @Specialization(guards={"format == FORMAT_XZ"})
        static void xz(LZMAObject.LZMACompressor.Native self, int format, long preset, PNone filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaEasyEncoder, @Cached.Shared @Cached InlinedConditionProfile errProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            NFILZMASupport lzmaSupport = PythonContext.get(inliningTarget).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int lzret = lzmaSupport.lzmaEasyEncoder(lzmast, preset, self.getCheck(), lzmaEasyEncoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }

        @Specialization(guards={"format == FORMAT_XZ", "!isPNone(filters)"})
        static void xz(VirtualFrame frame, LZMAObject.LZMACompressor.Native self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaStreamEncoder, @Cached.Exclusive @Cached NativeFilterChain filterChain, @Cached.Shared @Cached InlinedConditionProfile errProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PythonContext ctxt = PythonContext.get(inliningTarget);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            filterChain.execute(frame, lzmast, ctxt, filters);
            int lzret = lzmaSupport.lzmaStreamEncoder(lzmast, self.getCheck(), lzmaStreamEncoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE"})
        static void alone(LZMAObject.LZMACompressor.Native self, int format, long preset, PNone filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaAloneEncoderPreset, @Cached.Shared @Cached InlinedConditionProfile errProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            NFILZMASupport lzmaSupport = PythonContext.get(inliningTarget).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int lzret = lzmaSupport.lzmaAloneEncoderPreset(lzmast, preset, lzmaAloneEncoderPreset);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE", "!isPNone(filters)"})
        static void alone(VirtualFrame frame, LZMAObject.LZMACompressor.Native self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaAloneEncoder, @Cached.Exclusive @Cached NativeFilterChain filterChain, @Cached.Shared @Cached InlinedConditionProfile errProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PythonContext ctxt = PythonContext.get(inliningTarget);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            filterChain.execute(frame, lzmast, ctxt, filters);
            int lzret = lzmaSupport.lzmaAloneEncoder(lzmast, lzmaAloneEncoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }

        @Specialization(guards={"format == FORMAT_RAW"})
        static void raw(VirtualFrame frame, LZMAObject.LZMACompressor.Native self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaRawEncoder, @Cached.Exclusive @Cached NativeFilterChain filterChain, @Cached.Shared @Cached InlinedConditionProfile errProfile, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PythonContext ctxt = PythonContext.get(inliningTarget);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            filterChain.execute(frame, lzmast, ctxt, filters);
            int lzret = lzmaSupport.lzmaRawEncoder(lzmast, lzmaRawEncoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(inliningTarget, lzret, raiseNode);
            }
        }

        @Specialization(guards={"format == FORMAT_XZ"})
        static void xz(LZMAObject.LZMACompressor.Java self, int format, long preset, PNone filters, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                self.lzmaEasyEncoder(LZMANodes.parseLZMAOptions(preset));
            }
            catch (IOException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"format == FORMAT_XZ", "!isPNone(filters)"})
        static void xz(VirtualFrame frame, LZMAObject.LZMACompressor.Java self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached JavaFilterChain filterChain, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                self.lzmaStreamEncoder(filterChain.execute(frame, inliningTarget, filters));
            }
            catch (IOException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE"})
        static void alone(LZMAObject.LZMACompressor.Java self, int format, long preset, PNone filters, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                self.lzmaAloneEncoder(LZMANodes.parseLZMAOptions(preset));
            }
            catch (IOException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE", "!isPNone(filters)"})
        static void alone(VirtualFrame frame, LZMAObject.LZMACompressor.Java self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached JavaFilterChain filterChain, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            FilterOptions[] optionsChain = filterChain.execute(frame, inliningTarget, filters);
            if (optionsChain.length != 1 && !(optionsChain[0] instanceof LZMA2Options)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER_CHAIN_FOR_FORMAT);
            }
            try {
                self.lzmaAloneEncoder((LZMA2Options)optionsChain[0]);
            }
            catch (IOException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"format == FORMAT_RAW"})
        static void raw(VirtualFrame frame, LZMAObject.LZMACompressor.Java self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached JavaFilterChain filterChain, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            FilterOptions[] optionsChain = filterChain.execute(frame, inliningTarget, filters);
            if (optionsChain.length != 1 && !(optionsChain[0] instanceof LZMA2Options)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER_CHAIN_FOR_FORMAT);
            }
            try {
                self.lzmaRawEncoder(optionsChain);
            }
            catch (IOException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, e);
            }
        }

        @Fallback
        static void error(VirtualFrame frame, LZMAObject.LZMACompressor self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_CONTAINER_FORMAT, format);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class JavaFilterChain
    extends Node {
        protected JavaFilterChain() {
        }

        public abstract FilterOptions[] execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static FilterOptions[] parseFilterChainSpec(VirtualFrame frame, Node inliningTarget, Object filterSpecs, @Cached(inline=false) LZMAParseFilterChain parseFilterChain, @Cached PRaiseNode.Lazy raiseNode) {
            long[][] filters = parseFilterChain.execute(frame, filterSpecs);
            FilterOptions[] optionsChain = new FilterOptions[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                try {
                    optionsChain[i] = JavaFilterChain.getFilterOptions(filters[i], inliningTarget);
                    continue;
                }
                catch (UnsupportedOptionsException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, new Object[]{e});
                }
            }
            return optionsChain;
        }

        @CompilerDirectives.TruffleBoundary
        private static String getMessage(UnsupportedOptionsException e) {
            return e.getMessage();
        }

        @CompilerDirectives.TruffleBoundary
        private static FilterOptions getFilterOptions(long[] longFilter, Node raisingNode) throws UnsupportedOptionsException {
            int[] filter = new int[longFilter.length];
            for (int i = 0; i < longFilter.length; ++i) {
                filter[i] = (int)longFilter[i];
            }
            switch (LZMAFilter.from(longFilter[0]).ordinal()) {
                case 0: 
                case 1: {
                    LZMA2Options lzma2Options;
                    try {
                        lzma2Options = new LZMA2Options(filter[1]);
                    }
                    catch (UnsupportedOptionsException e) {
                        throw PRaiseNode.raiseUncached(raisingNode, PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_COMPRESSION_PRESET, filter[LZMAOption.preset.ordinal()]);
                    }
                    for (int j = 2; j < filter.length; ++j) {
                        JavaFilterChain.setLZMAOption(lzma2Options, j, filter[j]);
                    }
                    return lzma2Options;
                }
                case 2: {
                    DeltaOptions deltaOptions = filter[DeltaOption.dist.ordinal()] != -1 ? new DeltaOptions(filter[DeltaOption.dist.ordinal()]) : new DeltaOptions();
                    return deltaOptions;
                }
                case 3: {
                    X86Options x86Options = new X86Options();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        x86Options.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return x86Options;
                }
                case 4: {
                    PowerPCOptions powerPCOptions = new PowerPCOptions();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        powerPCOptions.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return powerPCOptions;
                }
                case 5: {
                    IA64Options ia64Options = new IA64Options();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        ia64Options.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return ia64Options;
                }
                case 6: {
                    ARMOptions armOptions = new ARMOptions();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        armOptions.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return armOptions;
                }
                case 7: {
                    ARMThumbOptions armThumbOptions = new ARMThumbOptions();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        armThumbOptions.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return armThumbOptions;
                }
                case 8: {
                    SPARCOptions sparcOptions = new SPARCOptions();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        sparcOptions.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return sparcOptions;
                }
            }
            throw PRaiseNode.raiseUncached(raisingNode, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER, longFilter[0]);
        }

        @CompilerDirectives.TruffleBoundary
        private static void setLZMAOption(LZMA2Options lzma2Options, int idx, int value) throws UnsupportedOptionsException {
            if (value == -1) {
                return;
            }
            switch (LZMAOption.values()[idx].ordinal()) {
                case 2: {
                    lzma2Options.setDictSize(value);
                    break;
                }
                case 3: {
                    lzma2Options.setLc(value);
                    break;
                }
                case 4: {
                    lzma2Options.setLp(value);
                    break;
                }
                case 5: {
                    lzma2Options.setPb(value);
                    break;
                }
                case 6: {
                    lzma2Options.setMode(value);
                    break;
                }
                case 7: {
                    lzma2Options.setNiceLen(value);
                    break;
                }
                case 8: {
                    lzma2Options.setMatchFinder(value);
                    break;
                }
                case 9: {
                    lzma2Options.setDepthLimit(value);
                }
            }
        }
    }

    protected static abstract class NativeFilterChain
    extends Node {
        protected NativeFilterChain() {
        }

        public abstract void execute(VirtualFrame var1, Object var2, PythonContext var3, Object var4);

        @Specialization
        static void parseFilterChainSpec(VirtualFrame frame, Object lzmast, PythonContext context, Object filterSpecs, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction setFilterSpecLZMA, @Cached NativeLibrary.InvokeNativeFunction setFilterSpecDelta, @Cached NativeLibrary.InvokeNativeFunction setFilterSpecBCJ, @Cached LZMAParseFilterChain parseFilterChain, @Cached PRaiseNode.Lazy raiseNode) {
            long[][] filters = parseFilterChain.execute(frame, filterSpecs);
            for (int i = 0; i < filters.length; ++i) {
                NativeFilterChain.setFilterOptions(inliningTarget, lzmast, filters[i], i, context, setFilterSpecLZMA, setFilterSpecDelta, setFilterSpecBCJ, raiseNode);
            }
        }

        private static void setFilterOptions(Node inliningTarget, Object lzmast, long[] filter, int fidx, PythonContext context, NativeLibrary.InvokeNativeFunction setFilterSpecLZMA, NativeLibrary.InvokeNativeFunction setFilterSpecDelta, NativeLibrary.InvokeNativeFunction setFilterSpecBCJ, PRaiseNode.Lazy raiseNode) {
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            Object opts = context.getEnv().asGuestValue((Object)filter);
            long id = filter[0];
            switch (LZMAFilter.from(id).ordinal()) {
                case 0: 
                case 1: {
                    assert (filter.length == 10);
                    int err = lzmaSupport.setFilterSpecLZMA(lzmast, fidx, opts, setFilterSpecLZMA);
                    if (err != 0) {
                        if (err == 99) {
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_COMPRESSION_PRESET, filter[LZMAOption.preset.ordinal()]);
                        }
                        LZMANodes.errorHandling(inliningTarget, err, raiseNode);
                    }
                    return;
                }
                case 2: {
                    assert (filter.length == 2);
                    int err = lzmaSupport.setFilterSpecDelta(lzmast, fidx, opts, setFilterSpecDelta);
                    if (err != 0) {
                        LZMANodes.errorHandling(inliningTarget, err, raiseNode);
                    }
                    return;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    assert (filter.length == 2);
                    int err = lzmaSupport.setFilterSpecBCJ(lzmast, fidx, opts, setFilterSpecBCJ);
                    if (err != 0) {
                        LZMANodes.errorHandling(inliningTarget, err, raiseNode);
                    }
                    return;
                }
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER, id);
        }
    }

    public static abstract class LZMAParseFilterChain
    extends Node {
        public abstract long[][] execute(VirtualFrame var1, Object var2);

        @Specialization
        long[][] parseFilter(VirtualFrame frame, Object filterSpecs, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetItem getItemNode, @Cached LZMAFilterConverter converter, @Cached SequenceNodes.CheckIsSequenceNode checkIsSequenceNode, @Cached PyObjectSizeNode sizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            checkIsSequenceNode.execute(inliningTarget, filterSpecs);
            int numFilters = sizeNode.execute((Frame)frame, inliningTarget, filterSpecs);
            if (numFilters > 4) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.TOO_MAMNY_FILTERS_LZMA_SUPPORTS_MAX_S, 4);
            }
            long[][] filters = new long[numFilters][0];
            for (int i = 0; i < numFilters; ++i) {
                filters[i] = converter.execute(frame, getItemNode.execute((Frame)frame, inliningTarget, filterSpecs, i));
            }
            return filters;
        }
    }

    public static abstract class LZMAFilterConverter
    extends Node {
        public abstract long[] execute(VirtualFrame var1, Object var2);

        @Specialization
        static long[] converter(VirtualFrame frame, Object spec, @Bind(value="this") Node inliningTarget, @Cached ForEachOption getOptions, @Cached CastToJavaLongLossyNode toLong, @Cached GetOptionsDict getOptionsDict, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached HashingStorageNodes.HashingStorageForEach forEachNode, @Cached PRaiseNode.Lazy raiseNode) {
            long[] options;
            HashingStorage dict = getOptionsDict.execute(frame, spec);
            Object idObj = getItem.execute(inliningTarget, dict, StringLiterals.T_ID);
            long id = toLong.execute(inliningTarget, idObj);
            OptionsState state = switch (LZMAFilter.from(id).ordinal()) {
                case 0, 1 -> {
                    options = new long[LZMAOption.values().length];
                    Arrays.fill(options, -1L);
                    options[LZMAOption.preset.ordinal()] = LZMAModuleBuiltins.PRESET_DEFAULT;
                    yield new OptionsState("LZMA", LZMAOption.values(), options, dict);
                }
                case 2 -> {
                    options = new long[DeltaOption.values().length];
                    Arrays.fill(options, -1L);
                    yield new OptionsState("delta", DeltaOption.values(), options, dict);
                }
                case 3, 4, 5, 6, 7, 8 -> {
                    options = new long[BCJOption.values().length];
                    Arrays.fill(options, -1L);
                    yield new OptionsState("BCJ", BCJOption.values(), options, dict);
                }
                default -> throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER, id);
            };
            options[0] = id;
            forEachNode.execute((Frame)frame, inliningTarget, dict, getOptions, state);
            return options;
        }
    }

    static enum BCJOption implements Option
    {
        id("id"),
        start_offset("start_offset");

        private final TruffleString optname;

        private BCJOption(String name) {
            this.optname = PythonUtils.tsLiteral(name);
        }

        @Override
        public TruffleString OptName() {
            return this.optname;
        }
    }

    static enum DeltaOption implements Option
    {
        id("id"),
        dist("dist");

        private final TruffleString optname;

        private DeltaOption(String name) {
            this.optname = PythonUtils.tsLiteral(name);
        }

        @Override
        public TruffleString OptName() {
            return this.optname;
        }
    }

    static enum LZMAOption implements Option
    {
        id("id"),
        preset("preset"),
        dict_size("dict_size"),
        lc("lc"),
        lp("lp"),
        pb("pb"),
        mode("mode"),
        nice_len("nice_len"),
        mf("mf"),
        depth("depth");

        private final TruffleString optname;

        private LZMAOption(String name) {
            this.optname = PythonUtils.tsLiteral(name);
        }

        @Override
        public TruffleString OptName() {
            return this.optname;
        }
    }

    static enum LZMAFilter {
        LZMA_FILTER_LZMA1,
        LZMA_FILTER_LZMA2,
        LZMA_FILTER_DELTA,
        LZMA_FILTER_X86,
        LZMA_FILTER_POWERPC,
        LZMA_FILTER_IA64,
        LZMA_FILTER_ARM,
        LZMA_FILTER_ARMTHUMB,
        LZMA_FILTER_SPARC,
        UNKNOWN;


        public long v() {
            return LZMAModuleBuiltins.FILTERS[this.ordinal()];
        }

        @ExplodeLoop
        public static LZMAFilter from(long v) {
            for (int i = 0; i < LZMAModuleBuiltins.FILTERS.length; ++i) {
                if (LZMAModuleBuiltins.FILTERS[i] != v) continue;
                return LZMAFilter.values()[i];
            }
            return UNKNOWN;
        }
    }

    static interface Option {
        public TruffleString OptName();

        public int ordinal();
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class ForEachOption
    extends HashingStorageNodes.HashingStorageForEachCallback<OptionsState> {
        protected ForEachOption() {
        }

        private static int getOptionIndex(TruffleString key, OptionsState s, TruffleString.EqualNode equalNode) {
            for (int i = 0; i < s.optnames.length; ++i) {
                if (!equalNode.execute((AbstractTruffleString)key, (AbstractTruffleString)s.optnames[i].OptName(), PythonUtils.TS_ENCODING)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public abstract OptionsState execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, OptionsState var5);

        @Specialization
        static OptionsState doit(Frame frame, Node inliningTarget, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, OptionsState s, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached PyObjectStrAsTruffleStringNode strNode, @Cached CastToJavaLongLossyNode toLong, @Cached InlinedConditionProfile errProfile, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode.Lazy raise, @Cached(inline=false) TruffleString.EqualNode equalNode) {
            Object key = itKey.execute(inliningTarget, storage, it);
            TruffleString skey = strNode.execute(frame, inliningTarget, key);
            int idx = ForEachOption.getOptionIndex(skey, s, equalNode);
            if (errProfile.profile(inliningTarget, idx == -1)) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER_SPECIFIED_FOR_FILTER, s.filterType);
            }
            long l = toLong.execute(inliningTarget, getItem.execute(inliningTarget, s.dictStorage, skey));
            if (errProfile.profile(inliningTarget, l < 0L)) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CANT_CONVERT_NEG_INT_TO_UNSIGNED);
            }
            if (errProfile.profile(inliningTarget, l > 0x100000000L && idx > 0)) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.VALUE_TOO_LARGE_FOR_UINT32);
            }
            s.options[idx] = l;
            return s;
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class GetOptionsDict
    extends Node {
        public abstract HashingStorage execute(VirtualFrame var1, Object var2);

        @Specialization
        static HashingStorage fast(VirtualFrame frame, PDict dict, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            HashingStorage storage = dict.getDictStorage();
            if (!getItem.hasKey((Frame)frame, inliningTarget, storage, StringLiterals.T_ID)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.FILTER_SPECIFIER_MUST_HAVE);
            }
            return storage;
        }

        @Specialization(guards={"!isDict(object)"})
        static HashingStorage slow(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached GetDictIfExistsNode getDict, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PDict dict = getDict.execute(object);
            if (dict == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.FILTER_SPEC_MUST_BE_DICT);
            }
            return GetOptionsDict.fast(frame, dict, inliningTarget, getItem, raiseNode);
        }
    }

    @ImportStatic(value={LZMANodes.class})
    public static abstract class ToUINT32Option
    extends Node {
        private final boolean with32BitLimit;

        public ToUINT32Option(boolean with32BitLimit) {
            this.with32BitLimit = with32BitLimit;
        }

        public abstract long execute(Object var1);

        @Specialization(guards={"i >= 0"})
        long i(int i) {
            return i;
        }

        @Specialization(guards={"l >= 0", "l <= MAX_UINT32"})
        long l(long l) {
            return l;
        }

        @Specialization
        long ll(long l, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (l < 0L) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CANT_CONVERT_NEG_INT_TO_UNSIGNED);
            }
            if (l > 0x100000000L && this.with32BitLimit) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.VALUE_TOO_LARGE_FOR_UINT32);
            }
            return l;
        }

        @Specialization
        long o(Object o, @Bind(value="this") Node inliningTarget, @Cached CastToJavaLongExactNode cast, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return this.ll(cast.execute(inliningTarget, o), inliningTarget, raiseNode);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INTEGER_REQUIRED);
            }
        }

        @NeverDefault
        public static ToUINT32Option create(boolean with32BitLimit) {
            return LZMANodesFactory.ToUINT32OptionNodeGen.create(with32BitLimit);
        }

        @NeverDefault
        public static ToUINT32Option create() {
            return ToUINT32Option.create(true);
        }
    }

    protected static class OptionsState {
        private final String filterType;
        private final Option[] optnames;
        private final long[] options;
        public final HashingStorage dictStorage;

        public OptionsState(String filterType, Option[] optnames, long[] options, HashingStorage dictStorage) {
            this.filterType = filterType;
            this.optnames = optnames;
            this.options = options;
            this.dictStorage = dictStorage;
        }
    }
}

