/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.multiprocessing;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.multiprocessing.GraalPySemLockBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.multiprocessing.PGraalPySemLock;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import java.util.concurrent.Semaphore;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGraalPySemLock})
public final class GraalPySemLockBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GraalPySemLockBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("SEM_VALUE_MAX", (Object)Integer.MAX_VALUE);
        super.initialize(core);
    }

    @Builtin(name="__exit__", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class ExitLockNode
    extends PythonBuiltinNode {
        ExitLockNode() {
        }

        @Specialization
        static Object exit(PGraalPySemLock self, Object type, Object value, Object traceback) {
            self.release();
            return PNone.NONE;
        }
    }

    @Builtin(name="release", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReleaseLockNode
    extends PythonUnaryBuiltinNode {
        ReleaseLockNode() {
        }

        @Specialization
        static Object doRelease(PGraalPySemLock self, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (self.getKind() == 0) {
                if (!self.isMine()) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AssertionError, ErrorMessages.ATTEMP_TO_RELEASE_RECURSIVE_LOCK);
                }
                if (self.getCount() > 1) {
                    self.decreaseCount();
                    return PNone.NONE;
                }
                assert (self.getCount() == 1);
            }
            self.release();
            return PNone.NONE;
        }
    }

    @Builtin(name="_rebuild", minNumOfPositionalArgs=4, parameterNames={"handle", "kind", "maxvalue", "name"})
    @ArgumentsClinic(value={@ArgumentClinic(name="kind", conversion=ArgumentClinic.ClinicConversion.Int), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    static abstract class RebuildNode
    extends PythonClinicBuiltinNode {
        RebuildNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return GraalPySemLockBuiltinsClinicProviders.RebuildNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object doEnter(Object handle, int kind, Object maxvalue, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory) {
            PythonContext.SharedMultiprocessingData multiprocessing = PythonContext.get(inliningTarget).getSharedMultiprocessingData();
            Semaphore semaphore = multiprocessing.getNamedSemaphore(name);
            if (semaphore == null) {
                semaphore = RebuildNode.newSemaphore();
            }
            return factory.createGraalPySemLock((Object)PythonBuiltinClassType.PGraalPySemLock, name, kind, semaphore);
        }

        @CompilerDirectives.TruffleBoundary
        private static Semaphore newSemaphore() {
            return new Semaphore(0);
        }
    }

    @Builtin(name="__enter__", minNumOfPositionalArgs=1, parameterNames={"self", "blocking", "timeout"})
    @GenerateNodeFactory
    static abstract class EnterLockNode
    extends PythonTernaryBuiltinNode {
        EnterLockNode() {
        }

        @Specialization
        static Object doEnter(VirtualFrame frame, PGraalPySemLock self, Object blocking, Object timeout, @Cached AcquireNode acquireNode) {
            return acquireNode.execute(frame, self, blocking, timeout);
        }
    }

    @Builtin(name="acquire", minNumOfPositionalArgs=1, parameterNames={"self", "blocking", "timeout"})
    @ArgumentClinic(name="blocking", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")
    @GenerateNodeFactory
    static abstract class AcquireNode
    extends PythonTernaryClinicBuiltinNode {
        AcquireNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return GraalPySemLockBuiltinsClinicProviders.AcquireNodeClinicProviderGen.INSTANCE;
        }

        protected static boolean isFast(PGraalPySemLock self) {
            return self.getKind() == 0 && self.isMine();
        }

        @Specialization(guards={"isFast(self)"})
        static boolean fast(PGraalPySemLock self, boolean blocking, Object timeout) {
            self.increaseCount();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isFast(self)"})
        static boolean slow(VirtualFrame frame, PGraalPySemLock self, boolean blocking, Object timeoutObj, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached GilNode gil) {
            boolean acquired;
            boolean hasDeadline = !(timeoutObj instanceof PNone);
            long timeoutMs = 0L;
            if (hasDeadline && (timeoutMs = (long)(asDoubleNode.execute(frame, inliningTarget, timeoutObj) * 1000.0)) < 0L) {
                timeoutMs = 0L;
            }
            if (acquired = self.acquireNonBlocking()) {
                return true;
            }
            if (!blocking) {
                return false;
            }
            gil.release(true);
            try {
                if (hasDeadline) {
                    boolean bl = self.acquireTimeout(inliningTarget, timeoutMs);
                    return bl;
                }
                boolean bl = self.acquireBlocking(inliningTarget);
                return bl;
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="kind", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetKindNode
    extends PythonUnaryBuiltinNode {
        GetKindNode() {
        }

        @Specialization
        static int getKind(PGraalPySemLock self) {
            return self.getKind();
        }
    }

    @Builtin(name="maxvalue", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetMaxValue
    extends PythonUnaryBuiltinNode {
        GetMaxValue() {
        }

        @Specialization
        static Object getMax(PGraalPySemLock self) {
            return Integer.MAX_VALUE;
        }
    }

    @Builtin(name="name", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetNameNode
    extends PythonUnaryBuiltinNode {
        GetNameNode() {
        }

        @Specialization
        static TruffleString getName(PGraalPySemLock self) {
            return self.getName();
        }
    }

    @Builtin(name="handle", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class GetHandleNode
    extends PythonUnaryBuiltinNode {
        GetHandleNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int getHandle(PGraalPySemLock self) {
            return self.hashCode();
        }
    }

    @Builtin(name="_get_value", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetValueNode
    extends PythonUnaryBuiltinNode {
        GetValueNode() {
        }

        @Specialization
        static int getValue(PGraalPySemLock self) {
            return self.getValue();
        }
    }

    @Builtin(name="_is_zero", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsZeroNode
    extends PythonUnaryBuiltinNode {
        IsZeroNode() {
        }

        @Specialization
        static boolean isZero(PGraalPySemLock self) {
            return self.isZero();
        }
    }

    @Builtin(name="_is_mine", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsMineNode
    extends PythonUnaryBuiltinNode {
        IsMineNode() {
        }

        @Specialization
        static boolean isMine(PGraalPySemLock self) {
            return self.isMine();
        }
    }

    @Builtin(name="_count", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CountNode
    extends PythonUnaryBuiltinNode {
        CountNode() {
        }

        @Specialization
        static int getCount(PGraalPySemLock self) {
            return self.getCount();
        }
    }
}

