/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinConstructorsFactory;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.pickle.ByteArrayView;
import com.oracle.graal.python.builtins.modules.pickle.PUnpickler;
import com.oracle.graal.python.builtins.modules.pickle.PickleState;
import com.oracle.graal.python.builtins.modules.pickle.PickleUtils;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNodeGen;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.graalvm.collections.Pair;

public final class PicklerNodes {

    static abstract class BasePickleNode
    extends Node {
        private static final TruffleString T_LOCALS = PythonUtils.tsLiteral("<locals>");
        static final TruffleString T_SYS_MODULES = PythonUtils.tsLiteral("sys.modules");
        public static final TruffleString T_CODEC_RAW_UNICODE_ESCAPE = PythonUtils.tsLiteral("raw_unicode_escape");
        public static final TruffleString T_CODEC_BYTES = PythonUtils.tsLiteral("bytes");
        public static final TruffleString T_CODEC_ASCII = PythonUtils.tsLiteral("ascii");
        public static final TruffleString T_ERRORS_SURROGATEPASS = PythonUtils.tsLiteral("surrogatepass");
        public static final TruffleString T_ERRORS_STRICT = PythonUtils.tsLiteral("strict");
        @Node.Child
        private PyObjectGetItem getItemNode = PyObjectGetItem.create();
        @Node.Child
        private PyIterNextNode getNextNode = PyIterNextNode.create();
        @Node.Child
        CastToTruffleStringNode toStringNode = CastToTruffleStringNode.create();
        @Node.Child
        private PythonObjectFactory objectFactory;
        @Node.Child
        private HiddenAttr.ReadNode readHiddenAttributeNode;
        @Node.Child
        private BuiltinClassProfiles.IsBuiltinObjectProfile errProfile;
        @Node.Child
        private BuiltinClassProfiles.InlineIsBuiltinClassProfile isBuiltinClassProfile;
        @Node.Child
        private HashingStorageNodes.HashingStorageSetItem setHashingStorageItemNode;
        @Node.Child
        private PyObjectSetItem pyObjectSetItemNode;
        @Node.Child
        private HashingStorageNodes.CachedHashingStorageGetItem getHashingStorageItemNode;
        @Node.Child
        private SequenceStorageNodes.GetItemNode getSeqStorageItemNode;
        @Node.Child
        private PyNumberAsSizeNode asSizeNode;
        @Node.Child
        private CastToTruffleStringNode castToTruffleStringNode;
        @Node.Child
        private SequenceNodes.GetSequenceStorageNode getSequenceStorageNode;
        @Node.Child
        private CallVarargsMethodNode callVarargsMethodNode;
        @Node.Child
        private ExecutePositionalStarargsNode getArgsNode;
        @Node.Child
        private ExpandKeywordStarargsNode getKwArgsNode;
        @Node.Child
        private BuiltinConstructors.IntNode intNode;
        @Node.Child
        private CodecsModuleBuiltins.CodecsDecodeNode codecsDecodeNode;
        @Node.Child
        private CodecsModuleBuiltins.CodecsEscapeDecodeNode codecsEscapeDecodeNode;
        @Node.Child
        private CodecsModuleBuiltins.CodecsEncodeNode codecsEncodeNode;
        @Node.Child
        private PyIterCheckNode isIteratorObjectNode;
        @Node.Child
        private GetClassNode getClassNode;
        @Node.Child
        private PyObjectSizeNode sizeNode;
        @Node.Child
        private PyObjectLookupAttr lookupAttrNode;
        @Node.Child
        private BytesNodes.ToBytesNode toBytesNode;
        @Node.Child
        private PyObjectReprAsTruffleStringNode reprNode;
        @Node.Child
        private TruffleString.FromByteArrayNode tsFromByteArrayNode;
        @Node.Child
        private TruffleString.CodePointLengthNode tsCodePointLengthNode;
        @Node.Child
        private TruffleString.CodePointAtIndexNode tsCodePointAtIndexNode;
        @Node.Child
        private TruffleString.FromLongNode tsFromLongNode;
        @Node.Child
        private TruffleString.IndexOfStringNode tsIndexOfStringNode;
        @Node.Child
        private TruffleString.SubstringNode tsSubstringNode;
        @Node.Child
        private TruffleString.EqualNode tsEqualNode;
        @Node.Child
        private TruffleString.CopyToByteArrayNode tsCopyToByteArrayNode;
        @Node.Child
        private TruffleString.GetCodeRangeNode tsGetCodeRangeNode;
        @Node.Child
        private TruffleString.SwitchEncodingNode tsSwitchEncodingNode;
        @Node.Child
        private HashingStorageNodes.HashingStorageGetIterator getHashingStorageIteratorNode;
        @Node.Child
        private HashingStorageNodes.HashingStorageIteratorNext hashingStorageItNext;
        @Node.Child
        private HashingStorageNodes.HashingStorageIteratorKey hashingStorageItKey;
        @Node.Child
        private HashingStorageNodes.HashingStorageIteratorValue hashingStorageItValue;
        @Node.Child
        private PRaiseNode raiseNode;

        BasePickleNode() {
        }

        protected final PRaiseNode getRaiseNode() {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = this.isAdoptable() ? (PRaiseNode)this.insert(PRaiseNode.create()) : PRaiseNode.getUncached();
            }
            return this.raiseNode;
        }

        protected PException raise(PythonBuiltinClassType type, TruffleString string) {
            return this.getRaiseNode().raise(type, string);
        }

        protected PException raise(PythonBuiltinClassType exceptionType) {
            return this.getRaiseNode().raise(exceptionType);
        }

        protected final PException raise(PythonBuiltinClassType type, TruffleString format, Object ... arguments) {
            return this.getRaiseNode().raise(type, format, arguments);
        }

        protected TruffleString.FromByteArrayNode ensureTsFromByteArray() {
            if (this.tsFromByteArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsFromByteArrayNode = (TruffleString.FromByteArrayNode)this.insert((Node)TruffleString.FromByteArrayNode.create());
            }
            return this.tsFromByteArrayNode;
        }

        protected TruffleString.CodePointLengthNode ensureTsCodePointLengthNode() {
            if (this.tsCodePointLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsCodePointLengthNode = (TruffleString.CodePointLengthNode)this.insert((Node)TruffleString.CodePointLengthNode.create());
            }
            return this.tsCodePointLengthNode;
        }

        protected TruffleString.CodePointAtIndexNode ensureTsCodePointAtIndexNode() {
            if (this.tsCodePointAtIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsCodePointAtIndexNode = (TruffleString.CodePointAtIndexNode)this.insert((Node)TruffleString.CodePointAtIndexNode.create());
            }
            return this.tsCodePointAtIndexNode;
        }

        protected TruffleString.FromLongNode ensureTsFromLongNode() {
            if (this.tsFromLongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsFromLongNode = (TruffleString.FromLongNode)this.insert((Node)TruffleString.FromLongNode.create());
            }
            return this.tsFromLongNode;
        }

        protected TruffleString.IndexOfStringNode ensureTsIndexOfStringNode() {
            if (this.tsIndexOfStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsIndexOfStringNode = (TruffleString.IndexOfStringNode)this.insert((Node)TruffleString.IndexOfStringNode.create());
            }
            return this.tsIndexOfStringNode;
        }

        protected TruffleString.SubstringNode ensureTsSubstringNode() {
            if (this.tsSubstringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsSubstringNode = (TruffleString.SubstringNode)this.insert((Node)TruffleString.SubstringNode.create());
            }
            return this.tsSubstringNode;
        }

        protected TruffleString.EqualNode ensureTsEqualNode() {
            if (this.tsEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsEqualNode = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
            }
            return this.tsEqualNode;
        }

        protected TruffleString.CopyToByteArrayNode ensureTsCopyToByteArrayNode() {
            if (this.tsCopyToByteArrayNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsCopyToByteArrayNode = (TruffleString.CopyToByteArrayNode)this.insert((Node)TruffleString.CopyToByteArrayNode.create());
            }
            return this.tsCopyToByteArrayNode;
        }

        protected TruffleString.GetCodeRangeNode ensureTsGetCodeRangeNode() {
            if (this.tsGetCodeRangeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsGetCodeRangeNode = (TruffleString.GetCodeRangeNode)this.insert((Node)TruffleString.GetCodeRangeNode.create());
            }
            return this.tsGetCodeRangeNode;
        }

        protected TruffleString.SwitchEncodingNode ensureTsSwitchEncodingNode() {
            if (this.tsSwitchEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.tsSwitchEncodingNode = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
            }
            return this.tsSwitchEncodingNode;
        }

        protected byte[] toBytes(VirtualFrame frame, Object obj) {
            if (this.toBytesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toBytesNode = (BytesNodes.ToBytesNode)this.insert(BytesNodes.ToBytesNode.create());
            }
            return this.toBytesNode.execute(frame, obj);
        }

        private PyObjectReprAsTruffleStringNode getReprNode() {
            if (this.reprNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reprNode = (PyObjectReprAsTruffleStringNode)this.insert(PyObjectReprAsTruffleStringNode.create());
            }
            return this.reprNode;
        }

        protected HashingStorageNodes.HashingStorageIterator getHashingStorageIterator(HashingStorage s) {
            if (this.getHashingStorageIteratorNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getHashingStorageIteratorNode = (HashingStorageNodes.HashingStorageGetIterator)this.insert(HashingStorageNodes.HashingStorageGetIterator.create());
            }
            return this.getHashingStorageIteratorNode.executeCached(s);
        }

        protected HashingStorageNodes.HashingStorageIteratorNext ensureHashingStorageIteratorNext() {
            if (this.hashingStorageItNext == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hashingStorageItNext = (HashingStorageNodes.HashingStorageIteratorNext)this.insert(HashingStorageNodes.HashingStorageIteratorNext.create());
            }
            return this.hashingStorageItNext;
        }

        protected HashingStorageNodes.HashingStorageIteratorKey ensureHashingStorageIteratorKey() {
            if (this.hashingStorageItKey == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hashingStorageItKey = (HashingStorageNodes.HashingStorageIteratorKey)this.insert(HashingStorageNodes.HashingStorageIteratorKey.create());
            }
            return this.hashingStorageItKey;
        }

        protected HashingStorageNodes.HashingStorageIteratorValue ensureHashingStorageIteratorValue() {
            if (this.hashingStorageItValue == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.hashingStorageItValue = (HashingStorageNodes.HashingStorageIteratorValue)this.insert(HashingStorageNodes.HashingStorageIteratorValue.create());
            }
            return this.hashingStorageItValue;
        }

        protected final PythonObjectFactory factory() {
            if (this.objectFactory == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.objectFactory = (PythonObjectFactory)this.insert(PythonObjectFactory.create());
            }
            return this.objectFactory;
        }

        protected int length(VirtualFrame frame, Object object) {
            if (this.sizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.sizeNode = (PyObjectSizeNode)this.insert(PyObjectSizeNode.create());
            }
            return this.sizeNode.executeCached((Frame)frame, object);
        }

        protected boolean isIterator(Object iter) {
            if (this.isIteratorObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isIteratorObjectNode = (PyIterCheckNode)this.insert(PyIterCheckNode.create());
            }
            return this.isIteratorObjectNode.executeCached(iter);
        }

        protected Object encode(Object value, TruffleString encoding, TruffleString errors) {
            if (this.codecsEncodeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.codecsEncodeNode = (CodecsModuleBuiltins.CodecsEncodeNode)this.insert(CodecsModuleBuiltinsFactory.CodecsEncodeNodeFactory.create());
            }
            return this.codecsEncodeNode.execute(value, encoding, errors);
        }

        private CodecsModuleBuiltins.CodecsDecodeNode ensureCodecsDecodeNode() {
            if (this.codecsDecodeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.codecsDecodeNode = (CodecsModuleBuiltins.CodecsDecodeNode)this.insert(CodecsModuleBuiltinsFactory.CodecsDecodeNodeFactory.create());
            }
            return this.codecsDecodeNode;
        }

        protected CodecsModuleBuiltins.CodecsEscapeDecodeNode ensureEscapeDecodeNode() {
            if (this.codecsEscapeDecodeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.codecsEscapeDecodeNode = (CodecsModuleBuiltins.CodecsEscapeDecodeNode)this.insert(CodecsModuleBuiltinsFactory.CodecsEscapeDecodeNodeFactory.create());
            }
            return this.codecsEscapeDecodeNode;
        }

        protected Object unicodeRawDecodeEscape(VirtualFrame frame, byte[] bytes, int len) {
            return this.decode(frame, this.factory().createBytes(bytes, 0, len), T_CODEC_RAW_UNICODE_ESCAPE);
        }

        protected Object decodeASCII(VirtualFrame frame, byte[] bytes, int len, TruffleString errors) {
            return this.decode(frame, this.factory().createBytes(bytes, 0, len), T_CODEC_ASCII, errors);
        }

        protected Object decodeUTF8(VirtualFrame frame, ByteArrayView bytes, int len, TruffleString errors) {
            return this.decode(frame, this.factory().createBytes(bytes.getBytes(len), 0, len), StringLiterals.T_UTF8, errors);
        }

        protected Object decode(VirtualFrame frame, Object value, TruffleString encoding) {
            return this.getItem(frame, this.ensureCodecsDecodeNode().call(frame, value, encoding, T_ERRORS_STRICT, false), (Object)0);
        }

        protected Object decode(VirtualFrame frame, Object value, TruffleString encoding, TruffleString errors) {
            return this.getItem(frame, this.ensureCodecsDecodeNode().call(frame, value, encoding, errors, false), (Object)0);
        }

        protected Object escapeDecode(VirtualFrame frame, PythonObjectFactory factory, byte[] data, int offset, int len) {
            if (len == 0) {
                return factory.createEmptyBytes();
            }
            return this.escapeDecode(frame, PythonUtils.arrayCopyOfRange(data, offset, offset + len));
        }

        protected Object escapeDecode(VirtualFrame frame, byte[] data) {
            return this.getItem(frame, this.ensureEscapeDecodeNode().execute(frame, data, T_ERRORS_STRICT), (Object)0);
        }

        protected Object parseInt(VirtualFrame frame, byte[] bytes) {
            return this.parseInt(frame, PickleUtils.getValidIntString(bytes));
        }

        protected Object parseInt(VirtualFrame frame, TruffleString number) {
            if (this.intNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.intNode = (BuiltinConstructors.IntNode)this.insert(BuiltinConstructorsFactory.IntNodeFactory.create());
            }
            return this.intNode.executeWith(frame, number);
        }

        protected CallVarargsMethodNode ensureCallVarargsNode() {
            if (this.callVarargsMethodNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callVarargsMethodNode = (CallVarargsMethodNode)this.insert(CallVarargsMethodNode.create());
            }
            return this.callVarargsMethodNode;
        }

        protected ExecutePositionalStarargsNode ensureGetArgsNode() {
            if (this.getArgsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getArgsNode = (ExecutePositionalStarargsNode)this.insert(ExecutePositionalStarargsNode.create());
            }
            return this.getArgsNode;
        }

        protected ExpandKeywordStarargsNode ensureExpandKwArgsNode() {
            if (this.getKwArgsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getKwArgsNode = (ExpandKeywordStarargsNode)this.insert(ExpandKeywordStarargsNodeGen.create());
            }
            return this.getKwArgsNode;
        }

        protected PyObjectLookupAttr getLookupAttrNode() {
            if (this.lookupAttrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupAttrNode = (PyObjectLookupAttr)this.insert(PyObjectLookupAttr.create());
            }
            return this.lookupAttrNode;
        }

        protected Object lookupAttribute(Frame frame, Object receiver, TruffleString name) {
            return this.getLookupAttrNode().executeCached(frame, receiver, name);
        }

        protected Object lookupAttributeStrict(Frame frame, Object receiver, TruffleString name) {
            Object attr = this.lookupAttribute(frame, receiver, name);
            if (attr == PNone.NO_VALUE) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, attr, name);
            }
            return attr;
        }

        protected Object getClass(Object object) {
            if (this.getClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getClassNode = (GetClassNode)this.insert(GetClassNode.create());
            }
            return this.getClassNode.executeCached(object);
        }

        protected Object getClass(Frame frame, Object object) {
            Object cls = this.getLookupAttrNode().executeCached(frame, object, SpecialAttributeNames.T___CLASS__);
            if (cls == PNone.NO_VALUE) {
                cls = this.getClass(object);
            }
            return cls;
        }

        protected Object callNew(VirtualFrame frame, Object tpNew, Object cls) {
            return this.ensureCallVarargsNode().execute((Frame)frame, tpNew, new Object[]{cls}, PKeyword.EMPTY_KEYWORDS);
        }

        protected Object callNew(VirtualFrame frame, Object tpNew, Object cls, Object args) {
            return this.callNew(frame, tpNew, cls, args, null);
        }

        protected Object callNew(VirtualFrame frame, Object tpNew, Object cls, Object args, Object kwargs) {
            Object[] stargs = this.ensureGetArgsNode().executeWith((Frame)frame, args);
            Object[] newArgs = new Object[stargs.length + 1];
            newArgs[0] = cls;
            PythonUtils.arraycopy(stargs, 0, newArgs, 1, stargs.length);
            PKeyword[] keywords = kwargs == null ? PKeyword.EMPTY_KEYWORDS : this.ensureExpandKwArgsNode().executeCached(kwargs);
            return this.ensureCallVarargsNode().execute((Frame)frame, tpNew, newArgs, keywords);
        }

        protected Object call(VirtualFrame frame, Object method, Object ... args) {
            return this.ensureCallVarargsNode().execute((Frame)frame, method, args, PKeyword.EMPTY_KEYWORDS);
        }

        protected Object callStarArgs(VirtualFrame frame, Object method, Object args) {
            return this.callStarArgsAndKwArgs(frame, method, args, null);
        }

        protected Object callStarArgsAndKwArgs(VirtualFrame frame, Object method, Object args, Object kwargs) {
            PKeyword[] keywords = kwargs == null ? PKeyword.EMPTY_KEYWORDS : this.ensureExpandKwArgsNode().executeCached(kwargs);
            return this.ensureCallVarargsNode().execute((Frame)frame, method, this.ensureGetArgsNode().executeWith((Frame)frame, args), keywords);
        }

        protected SequenceStorage getSequenceStorage(Object iterator) {
            if (this.getSequenceStorageNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSequenceStorageNode = (SequenceNodes.GetSequenceStorageNode)this.insert(SequenceNodes.GetSequenceStorageNode.create());
            }
            return this.getSequenceStorageNode.executeCached(iterator);
        }

        protected TruffleString castToString(Object value) {
            if (this.castToTruffleStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.castToTruffleStringNode = (CastToTruffleStringNode)this.insert(CastToTruffleStringNode.create());
            }
            return this.castToTruffleStringNode.executeCached(value);
        }

        public int asSizeExact(VirtualFrame frame, Object pyNumber) {
            if (this.asSizeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asSizeNode = (PyNumberAsSizeNode)this.insert(PyNumberAsSizeNode.create());
            }
            return this.asSizeNode.executeExactCached((Frame)frame, pyNumber);
        }

        protected HiddenAttr.ReadNode ensureReadHiddenAttrNode() {
            if (this.readHiddenAttributeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readHiddenAttributeNode = (HiddenAttr.ReadNode)this.insert(HiddenAttr.ReadNode.create());
            }
            return this.readHiddenAttributeNode;
        }

        public PickleState getGlobalState(Python3Core core) {
            Object state = this.ensureReadHiddenAttrNode().executeCached(core.lookupType(PythonBuiltinClassType.Pickler), HiddenAttr.PICKLE_STATE, PNone.NO_VALUE);
            assert (state instanceof PickleState);
            return (PickleState)state;
        }

        protected Object getDictItem(VirtualFrame frame, PDict dict, Object key) {
            if (this.getHashingStorageItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getHashingStorageItemNode = (HashingStorageNodes.CachedHashingStorageGetItem)this.insert(HashingStorageNodes.CachedHashingStorageGetItem.create());
            }
            return this.getHashingStorageItemNode.execute((Frame)frame, dict.getDictStorage(), key);
        }

        protected void setDictItem(VirtualFrame frame, PDict dict, Object key, Object value) {
            HashingStorage newStorage = this.setHashingStorageItem(frame, dict.getDictStorage(), key, value);
            dict.setDictStorage(newStorage);
        }

        protected HashingStorage setHashingStorageItem(VirtualFrame frame, HashingStorage storage, Object key, Object value) {
            if (this.setHashingStorageItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setHashingStorageItemNode = (HashingStorageNodes.HashingStorageSetItem)this.insert(HashingStorageNodes.HashingStorageSetItem.create());
            }
            return this.setHashingStorageItemNode.executeCached((Frame)frame, storage, key, value);
        }

        protected void pyObjectSetItem(VirtualFrame frame, Object container, Object key, Object value) {
            if (this.pyObjectSetItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.pyObjectSetItemNode = (PyObjectSetItem)this.insert(PyObjectSetItem.create());
            }
            this.pyObjectSetItemNode.executeCached((Frame)frame, container, key, value);
        }

        protected BuiltinClassProfiles.IsBuiltinObjectProfile ensureErrProfile() {
            if (this.errProfile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.errProfile = (BuiltinClassProfiles.IsBuiltinObjectProfile)this.insert(BuiltinClassProfiles.IsBuiltinObjectProfile.create());
            }
            return this.errProfile;
        }

        protected boolean isBuiltinClass(Object cls, PythonBuiltinClassType type) {
            if (this.isBuiltinClassProfile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isBuiltinClassProfile = (BuiltinClassProfiles.InlineIsBuiltinClassProfile)this.insert(BuiltinClassProfiles.InlineIsBuiltinClassProfile.create());
            }
            return this.isBuiltinClassProfile.profileClassCached(cls, type);
        }

        public Object getNextItem(VirtualFrame frame, Object iterator) {
            return this.getNextNode.execute((Frame)frame, iterator);
        }

        public Object getItem(VirtualFrame frame, SequenceStorage storage, int i) {
            if (this.getSeqStorageItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getSeqStorageItemNode = (SequenceStorageNodes.GetItemNode)this.insert(SequenceStorageNodes.GetItemNode.create());
            }
            return this.getSeqStorageItemNode.execute(frame, storage, i);
        }

        public Object getItem(VirtualFrame frame, Object obj, Object slice) {
            return this.getItemNode.executeCached((Frame)frame, obj, slice);
        }

        public Object getItem(VirtualFrame frame, Object obj, int size, int pos, Object defaultValue) {
            if (size > pos) {
                return this.getItemNode.executeCached((Frame)frame, obj, pos);
            }
            return defaultValue;
        }

        public TruffleString asString(Object value) {
            if (value instanceof TruffleString) {
                return (TruffleString)value;
            }
            try {
                return this.toStringNode.executeCached(value);
            }
            catch (CannotCastException e) {
                return null;
            }
        }

        public TruffleString asStringStrict(Object value) {
            if (value instanceof TruffleString) {
                return (TruffleString)value;
            }
            try {
                return this.toStringNode.executeCached(value);
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, value);
            }
        }

        public static Pair<Object, Object> getDeepAttribute(VirtualFrame frame, PyObjectLookupAttr lookup, Object obj, TruffleString[] names) {
            Object parent = null;
            Object object = obj;
            TruffleString[] truffleStringArray = names;
            int n = truffleStringArray.length;
            for (int i = 0; i < n; ++i) {
                parent = object;
                TruffleString name = truffleStringArray[i];
                if ((object = lookup.executeCached((Frame)frame, parent, name)) != PNone.NO_VALUE) continue;
                return null;
            }
            return Pair.create((Object)object, parent);
        }

        public TruffleString[] getDottedPath(Object obj, TruffleString name) {
            TruffleString[] dottedPath = StringUtils.split(name, StringLiterals.T_DOT, this.ensureTsCodePointLengthNode(), this.ensureTsIndexOfStringNode(), this.ensureTsSubstringNode(), this.ensureTsEqualNode());
            assert (dottedPath.length > 0);
            for (TruffleString subPath : dottedPath) {
                if (!this.ensureTsEqualNode().execute((AbstractTruffleString)subPath, (AbstractTruffleString)T_LOCALS, PythonUtils.TS_ENCODING)) continue;
                if (obj == null) {
                    throw this.raise(PythonErrorType.AttributeError, ErrorMessages.CANT_PICKLE_LOCAL_OBJ_S, name);
                }
                throw this.raise(PythonErrorType.AttributeError, ErrorMessages.CANT_PICKLE_ATTR_S_OF_P, name, obj);
            }
            return dottedPath;
        }

        public Object getattribute(VirtualFrame frame, Object obj, TruffleString name, boolean allowQualname) {
            if (allowQualname) {
                TruffleString[] dottedPath = this.getDottedPath(obj, name);
                Pair<Object, Object> result = BasePickleNode.getDeepAttribute(frame, this.getLookupAttrNode(), obj, dottedPath);
                if (result != null) {
                    return result.getLeft();
                }
                throw this.raise(PythonErrorType.AttributeError, ErrorMessages.CANT_GET_ATTRIBUTE_S_ON_S, name, this.getReprNode().execute((Frame)frame, null, obj));
            }
            return this.lookupAttributeStrict((Frame)frame, obj, name);
        }

        protected Pair<TruffleString, TruffleString> get3to2Mapping(VirtualFrame frame, Python3Core core, TruffleString moduleName, TruffleString globalName) {
            PickleState state = this.getGlobalState(core);
            return this.getMapping(frame, state.nameMapping3To2, state.importMapping3To2, PickleUtils.T_CP_REVERSE_NAME_MAPPING, PickleUtils.T_CP_REVERSE_IMPORT_MAPPING, moduleName, globalName);
        }

        protected Pair<TruffleString, TruffleString> get2To3Mapping(VirtualFrame frame, Python3Core core, TruffleString moduleName, TruffleString globalName) {
            PickleState state = this.getGlobalState(core);
            return this.getMapping(frame, state.nameMapping2To3, state.importMapping2To3, PickleUtils.T_CP_NAME_MAPPING, PickleUtils.T_CP_IMPORT_MAPPING, moduleName, globalName);
        }

        private Pair<TruffleString, TruffleString> getMapping(VirtualFrame frame, PDict nameMapping, PDict importMapping, TruffleString nameMappingLabel, TruffleString importMappingLabel, TruffleString moduleName, TruffleString globalName) {
            PTuple key = this.factory().createTuple(new Object[]{moduleName, globalName});
            Object item = this.getDictItem(frame, nameMapping, key);
            if (item != null) {
                if (!(item instanceof PTuple) || this.length(frame, item) != 2) {
                    throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.S_SHOULD_BE_S_NOT_P, nameMappingLabel, "2-tuples", item);
                }
                Object mappedModuleName = this.getItem(frame, item, (Object)0);
                Object mappedGlobalName = this.getItem(frame, item, (Object)1);
                if (!PGuards.isString(mappedModuleName) || !PGuards.isString(mappedGlobalName)) {
                    throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.S_SHOULD_BE_S_NOT_P_P, nameMappingLabel, "str", mappedModuleName, mappedGlobalName);
                }
                return Pair.create((Object)this.asString(mappedModuleName), (Object)this.asString(mappedGlobalName));
            }
            item = this.getDictItem(frame, importMapping, moduleName);
            if (item != null) {
                if (!PGuards.isString(item)) {
                    throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.S_SHOULD_BE_S_NOT_P, importMappingLabel, "strings", item);
                }
                return Pair.create((Object)this.asString(item), (Object)globalName);
            }
            return Pair.create((Object)moduleName, (Object)globalName);
        }

        public Object findClass(VirtualFrame frame, Python3Core core, PUnpickler self, Object moduleName, Object globalName) {
            return this.findClass(frame, core, self, this.castToString(moduleName), this.castToString(globalName));
        }

        public Object findClass(VirtualFrame frame, Python3Core core, PUnpickler self, TruffleString moduleName, TruffleString globalName) {
            TruffleString mName = moduleName;
            TruffleString gName = globalName;
            if (self.getProto() < 3 && self.isFixImports()) {
                Pair<TruffleString, TruffleString> to3Mapping = this.get2To3Mapping(frame, core, mName, gName);
                mName = (TruffleString)to3Mapping.getLeft();
                gName = (TruffleString)to3Mapping.getRight();
            }
            PythonModule module = AbstractImportNode.importModule(mName);
            return this.getattribute(frame, module, gName, self.getProto() >= 4);
        }

        private static boolean checkModule(VirtualFrame frame, PyObjectLookupAttr lookup, Object moduleName, Object module, Object global, TruffleString[] dottedPath) {
            if (module == PNone.NONE) {
                return false;
            }
            assert (!(moduleName instanceof String)) : "moduleName shouldn't be j.l.String";
            if (moduleName instanceof TruffleString && ((TruffleString)moduleName).equalsUncached((AbstractTruffleString)BuiltinNames.T___MAIN__, PythonUtils.TS_ENCODING)) {
                return false;
            }
            Pair<Object, Object> pair = BasePickleNode.getDeepAttribute(frame, lookup, module, dottedPath);
            if (pair == null) {
                return false;
            }
            return pair.getLeft() == global;
        }

        public TruffleString whichModule(VirtualFrame frame, PythonContext context, Object global, TruffleString[] dottedPath) {
            Object moduleName = this.lookupAttribute((Frame)frame, global, SpecialAttributeNames.T___MODULE__);
            if (moduleName != PNone.NO_VALUE && moduleName != PNone.NONE) {
                return this.asStringStrict(moduleName);
            }
            PDict sysModules = context.getSysModules();
            if (sysModules == null) {
                throw this.raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.UNABLE_TO_GET_S, T_SYS_MODULES);
            }
            HashingStorage storage = sysModules.getDictStorage();
            HashingStorageNodes.HashingStorageIterator it = this.getHashingStorageIterator(storage);
            HashingStorageNodes.HashingStorageIteratorNext nextNode = this.ensureHashingStorageIteratorNext();
            HashingStorageNodes.HashingStorageIteratorKey getKeyNode = this.ensureHashingStorageIteratorKey();
            HashingStorageNodes.HashingStorageIteratorValue getValueNode = this.ensureHashingStorageIteratorValue();
            while (nextNode.executeCached(storage, it)) {
                Object value = getValueNode.executeCached(storage, it);
                Object key = getKeyNode.executeCached(storage, it);
                if (!BasePickleNode.checkModule(frame, this.getLookupAttrNode(), moduleName, value, global, dottedPath)) continue;
                return this.asStringStrict(key);
            }
            return BuiltinNames.T___MAIN__;
        }
    }
}

