/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.pickle.PUnpickler;
import com.oracle.graal.python.builtins.modules.pickle.PUnpicklerMemoProxy;
import com.oracle.graal.python.builtins.modules.pickle.PickleUtils;
import com.oracle.graal.python.builtins.modules.pickle.UnpicklerBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.pickle.UnpicklerBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Unpickler})
public class UnpicklerBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return UnpicklerBuiltinsFactory.getFactories();
    }

    @Builtin(name="memo", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class UnpicklerMemoNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object get(PUnpickler self, PNone none, @Cached PythonObjectFactory factory) {
            return factory.createUnpicklerMemoProxy(self);
        }

        @Specialization(guards={"!isNoValue(obj)", "!isDeleteMarker(obj)"})
        static Object set(VirtualFrame frame, PUnpickler self, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached PyObjectSizeNode sizeNode, @Cached HashingStorageNodes.HashingStorageGetIterator getStorageIter, @Cached HashingStorageNodes.HashingStorageIteratorNext storageIterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey storageIterKey, @Cached HashingStorageNodes.HashingStorageIteratorValue storageIterValue, @Cached PRaiseNode.Lazy raiseNode) {
            if (obj instanceof PUnpicklerMemoProxy) {
                PUnpickler unpickler = ((PUnpicklerMemoProxy)obj).getUnpickler();
                self.setMemo(unpickler.getMemoCopy());
            } else if (obj instanceof PDict) {
                PDict dict = (PDict)obj;
                self.setMemo(new Object[sizeNode.execute((Frame)frame, inliningTarget, obj)]);
                HashingStorage dictStorage = dict.getDictStorage();
                HashingStorageNodes.HashingStorageIterator it = getStorageIter.execute(inliningTarget, dictStorage);
                while (storageIterNext.execute(inliningTarget, dictStorage, it)) {
                    Object key = storageIterKey.execute(inliningTarget, dictStorage, it);
                    Object value = storageIterValue.execute(inliningTarget, dictStorage, it);
                    if (!PGuards.canBeInteger(key)) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MEMO_KEY_MUST_BE_INT);
                    }
                    int idx = asSizeNode.executeExact((Frame)frame, inliningTarget, key);
                    if (idx < 0) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.MEMO_KEY_MUST_BE_POS_INT);
                    }
                    self.memoPut(idx, value);
                }
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_MUST_BE_A_OR_B_NOT_C, "memo", "UnpicklerMemoProxy", "dict", obj);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="persistent_load", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class UnpicklerPersistentLoadNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object get(PUnpickler self, PNone none, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object persFunc = self.getPersFunc();
            if (persFunc == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, PickleUtils.T_METHOD_PERSISTENT_LOAD);
            }
            return PickleUtils.reconstructMethod(factory, persFunc, self.getPersFuncSelf());
        }

        @Specialization(guards={"!isNoValue(obj)"})
        static Object set(PUnpickler self, Object obj, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (PGuards.isDeleteMarker(obj)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATRIBUTE_DELETION_NOT_SUPPORTED);
            }
            if (!callableCheck.execute(inliningTarget, obj)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_MUST_BE_A_CALLABLE, PickleUtils.T_METHOD_PERSISTENT_LOAD, "one argument");
            }
            self.setPersFuncSelf(null);
            self.setPersFunc(obj);
            return PNone.NONE;
        }
    }

    @Builtin(name="find_class", minNumOfPositionalArgs=3, parameterNames={"$self", "module", "name"})
    @ArgumentsClinic(value={@ArgumentClinic(name="module", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)})
    @GenerateNodeFactory
    public static abstract class UnpicklerFindClassNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return UnpicklerBuiltinsClinicProviders.UnpicklerFindClassNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object findClass(VirtualFrame frame, PUnpickler self, TruffleString module, TruffleString name, @Cached PUnpickler.FindClassNode findClassNode) {
            return findClassNode.execute(frame, self, module, name);
        }
    }

    @Builtin(name="load", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class UnpicklerLoadNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object load(VirtualFrame frame, PUnpickler self, @Bind(value="this") Node inliningTarget, @Cached PUnpickler.LoadNode loadNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (self.getRead() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.UnpicklingError, ErrorMessages.INIT_CALLED_WITH, "Unpickler", self);
            }
            return loadNode.execute(frame, self);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2, declaresExplicitSelf=true, parameterNames={"$self", "file"}, varArgsMarker=true, keywordOnlyNames={"fix_imports", "encoding", "errors", "buffers"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fix_imports", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true"), @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_ASCII_UPPERCASE"), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT")})
    @GenerateNodeFactory
    public static abstract class UnpicklerInitNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return UnpicklerBuiltinsClinicProviders.UnpicklerInitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object load(VirtualFrame frame, PUnpickler self, Object file, boolean fixImports, TruffleString encoding, TruffleString errors, Object buffers, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            self.setInputStream(frame, inliningTarget, raiseNode, lookup, file);
            self.setInputEncoding(encoding, errors);
            self.setBuffers(frame, inliningTarget, getIter, buffers);
            self.setFixImports(fixImports);
            self.initInternals(frame, inliningTarget, lookup);
            self.setProto(0);
            return PNone.NONE;
        }
    }
}

