/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.NoneBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.NoneBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PNone})
public final class NoneBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = NoneBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return NoneBuiltinsFactory.getFactories();
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static Object doNone(Object none) {
            assert (none == PNone.NONE || IsForeignObjectNode.executeUncached(none));
            return StringLiterals.T_NONE;
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class BoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        BoolNode() {
        }

        @Specialization
        static boolean doNone(Object none) {
            assert (none == PNone.NONE || IsForeignObjectNode.executeUncached(none));
            return false;
        }
    }
}

