/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGCSupport;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyCFunctionWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyProcsWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetNativeWrapperNode;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.GetNextVaArgNode;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.exception.GetEscapedExceptionNode;
import com.oracle.graal.python.builtins.objects.exception.GetUnreifiedExceptionNode;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.ModuleGetNameNode;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.traceback.MaterializeLazyTracebackNode;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNodeGen;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.util.ComparisonOp;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class CExtNodes {
    private static final String J_UNICODE = "unicode";
    private static final String J_SUBTYPE_NEW = "_subtype_new";
    private static final long SIZEOF_PY_OBJECT_PTR = 8L;

    @CompilerDirectives.TruffleBoundary
    public static Object lookupNativeMemberInMRO(PythonManagedClass cls, CFields nativeMemberName, HiddenAttr managedMemberName) {
        NativeCAPISymbol symbol = null;
        if (managedMemberName == HiddenAttr.ALLOC) {
            symbol = NativeCAPISymbol.FUN_PY_TYPE_GENERIC_ALLOC;
        } else if (managedMemberName == HiddenAttr.FREE) {
            symbol = (TypeNodes.GetTypeFlagsNode.executeUncached(cls) & 0x4000L) != 0L ? NativeCAPISymbol.FUN_GRAALPY_OBJECT_GC_DEL : NativeCAPISymbol.FUN_PY_OBJECT_FREE;
        } else if (managedMemberName == HiddenAttr.TRAVERSE) {
            symbol = cls instanceof PythonBuiltinClass ? NativeCAPISymbol.FUN_NO_OP_TRAVERSE : NativeCAPISymbol.FUN_SUBTYPE_TRAVERSE;
        } else if (managedMemberName == HiddenAttr.CLEAR) {
            symbol = NativeCAPISymbol.FUN_NO_OP_CLEAR;
        }
        if (symbol != null) {
            Object func = HiddenAttr.ReadNode.executeUncached(cls, managedMemberName, null);
            if (func != null) {
                return func;
            }
            return CApiContext.getNativeSymbol(null, symbol);
        }
        MroSequenceStorage mroStorage = TypeNodes.GetMroStorageNode.executeUncached(cls);
        int n = mroStorage.length();
        for (int i = 0; i < n; ++i) {
            Object result;
            PythonAbstractClass mroCls = (PythonAbstractClass)SequenceStorageNodes.GetItemDynamicNode.executeUncached(mroStorage, i);
            if (PGuards.isManagedClass(mroCls)) {
                result = HiddenAttr.ReadNode.executeUncached((PythonObject)((Object)mroCls), managedMemberName, null);
                if (result == null) continue;
                return result;
            }
            assert (PGuards.isNativeClass(mroCls)) : "invalid class inheritance structure; expected native class";
            result = CStructAccess.ReadPointerNode.getUncached().readFromObj((PythonNativeClass)mroCls, nativeMemberName);
            if (PGuards.isNullOrZero(result, InteropLibrary.getUncached())) continue;
            return result;
        }
        if (managedMemberName == HiddenAttr.CLEAR && (TypeNodes.GetTypeFlagsNode.executeUncached(cls) & 0x4000L) != 0L) {
            return CApiContext.getNativeSymbol(null, NativeCAPISymbol.FUN_NO_OP_CLEAR);
        }
        return HiddenAttr.ReadNode.executeUncached(PythonContext.get(null).lookupType(PythonBuiltinClassType.PythonObject), managedMemberName, PNone.NO_VALUE);
    }

    @CompilerDirectives.TruffleBoundary
    public static long lookupNativeI64MemberInMRO(Object cls, CFields nativeMemberName, Object managedMemberName) {
        long l;
        boolean isBasicsizeOrWeaklistoffset;
        assert (managedMemberName instanceof HiddenAttr || managedMemberName instanceof TruffleString);
        MroSequenceStorage mroStorage = TypeNodes.GetMroStorageNode.executeUncached(cls);
        int n = mroStorage.length();
        boolean bl = isBasicsizeOrWeaklistoffset = nativeMemberName == CFields.PyTypeObject__tp_basicsize || nativeMemberName == CFields.PyTypeObject__tp_weaklistoffset;
        if (isBasicsizeOrWeaklistoffset && cls instanceof PythonManagedClass) {
            PythonManagedClass pmc = (PythonManagedClass)cls;
            l = (long)pmc.getIndexedSlotCount() * 8L;
        } else {
            l = 0L;
        }
        long indexedSlotsSize = l;
        for (int i = 0; i < n; ++i) {
            PythonAbstractClass mroCls = (PythonAbstractClass)SequenceStorageNodes.GetItemDynamicNode.executeUncached(mroStorage, i);
            if (PGuards.isManagedClass(mroCls)) {
                Object attr;
                if (managedMemberName instanceof HiddenAttr) {
                    HiddenAttr ha = (HiddenAttr)managedMemberName;
                    attr = HiddenAttr.ReadNode.executeUncached((PythonAbstractObject)((Object)mroCls), ha, PNone.NO_VALUE);
                } else {
                    attr = ReadAttributeFromObjectNode.getUncachedForceType().execute(mroCls, (TruffleString)CompilerDirectives.castExact((Object)managedMemberName, TruffleString.class));
                }
                if (attr != PNone.NO_VALUE) {
                    return PyNumberAsSizeNode.executeExactUncached(attr);
                }
                if (indexedSlotsSize == 0L) continue;
                break;
            }
            assert (PGuards.isNativeClass(mroCls)) : "invalid class inheritance structure; expected native class";
            return CStructAccess.ReadI64Node.getUncached().readFromObj((PythonNativeClass)mroCls, nativeMemberName);
        }
        return isBasicsizeOrWeaklistoffset ? indexedSlotsSize + (long)CStructs.PyObject.size() : 0L;
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class VisitNode
    extends Node {
        public abstract int execute(VirtualFrame var1, Node var2, PythonContext.PythonThreadState var3, Object var4, Object var5, Object var6);

        @Specialization
        static int doGeneric(VirtualFrame frame, Node inliningTarget, PythonContext.PythonThreadState threadState, Object item, Object visitFunction, Object visitArg, @Cached InlinedConditionProfile isNativeObjectProfile, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalFunctionInvokeNode, @Cached(inline=false) ExternalFunctionNodes.CheckPrimitiveFunctionResultNode checkPrimitiveFunctionResultNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode) {
            assert (InteropLibrary.getUncached().isExecutable(visitFunction));
            if (isNativeObjectProfile.profile(inliningTarget, item instanceof PythonAbstractNativeObject)) {
                Object result = externalFunctionInvokeNode.call(frame, inliningTarget, threadState, CApiGCSupport.VISIT_TIMING, StringLiterals.T_VISIT, visitFunction, toNativeNode.execute(item), visitArg);
                return (int)checkPrimitiveFunctionResultNode.executeLong(threadState, StringLiterals.T_VISIT, result);
            }
            return 0;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CApiGuards.class, PGuards.class})
    public static abstract class CreateFunctionNode
    extends Node {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(CreateFunctionNode.class);

        public static PythonObject executeUncached(TruffleString name, Object callable, int wrapper, Object type, Object flags) {
            return CExtNodesFactory.CreateFunctionNodeGen.getUncached().execute(null, name, callable, wrapper, type, flags);
        }

        public abstract PythonObject execute(Node var1, TruffleString var2, Object var3, int var4, Object var5, Object var6);

        @Specialization(guards={"!isNoValue(type)"})
        @CompilerDirectives.TruffleBoundary
        static PythonObject doPythonCallable(TruffleString name, PythonNativeWrapper callable, int signature, Object type, int flags) {
            Object managedCallable = callable.getDelegate();
            PythonContext context = PythonContext.get(null);
            PythonLanguage language = context.getLanguage();
            boolean doArgAndResultConversion = false;
            if (managedCallable instanceof TpSlot.TpSlotBuiltin) {
                TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)managedCallable;
                PBuiltinFunction builtin = builtinSlot.createBuiltin(context, type, name, ExternalFunctionNodes.PExternalFunctionWrapper.fromValue(signature));
                if (builtin != null) {
                    return builtin;
                }
                assert (callable instanceof PyProcsWrapper.TpSlotWrapper);
                managedCallable = callable;
                doArgAndResultConversion = true;
            } else if (managedCallable instanceof TpSlot.TpSlotPython) {
                TpSlot.TpSlotPython pythonSlot = (TpSlot.TpSlotPython)managedCallable;
                assert (callable instanceof PyProcsWrapper.TpSlotWrapper);
                TpSlot.TpSlotPython newPythonSlot = pythonSlot.forNewType(type);
                managedCallable = newPythonSlot != pythonSlot ? ((PyProcsWrapper.TpSlotWrapper)callable).cloneWith(newPythonSlot) : callable;
                doArgAndResultConversion = true;
            }
            PBuiltinFunction function = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, managedCallable, type, flags, signature, language, (PythonObjectFactory)context.factory(), doArgAndResultConversion);
            return function != null ? function : CreateFunctionNode.castToPythonObject(managedCallable);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PBuiltinFunction doPyCFunctionWrapper(TruffleString name, PyCFunctionWrapper wrapper, int signature, Object type, int flags) {
            Object delegate = wrapper.getDelegate();
            assert (!(delegate instanceof PythonAbstractObject));
            PythonContext context = PythonContext.get(null);
            PythonLanguage language = context.getLanguage();
            return ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, delegate, type, flags, signature, language, (PythonObjectFactory)context.factory(), false);
        }

        @Specialization(guards={"!isNativeWrapper(callable)"})
        @CompilerDirectives.TruffleBoundary
        static PythonObject doNativeCallableWithWrapper(TruffleString name, Object callable, int signature, Object type, int flags, @CachedLibrary(limit="3") InteropLibrary lib) {
            boolean doArgAndResultConversion;
            PythonContext context = PythonContext.get(null);
            Object resolvedCallable = CreateFunctionNode.resolveClosurePointer(context, callable, lib);
            assert (!(resolvedCallable instanceof TpSlot.TpSlotNative));
            if (resolvedCallable instanceof TpSlot.TpSlotBuiltin) {
                TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)resolvedCallable;
                PBuiltinFunction builtin = builtinSlot.createBuiltin(context, type, name, ExternalFunctionNodes.PExternalFunctionWrapper.fromValue(signature));
                if (builtin != null) {
                    return builtin;
                }
                resolvedCallable = null;
            } else if (resolvedCallable instanceof TpSlot.TpSlotPython) {
                TpSlot.TpSlotPython pythonSlot = (TpSlot.TpSlotPython)resolvedCallable;
                TpSlot.TpSlotPython newSlot = pythonSlot.forNewType(type);
                try {
                    Object wrapper = context.getCApiContext().getClosureExecutable(lib.asPointer(callable));
                    if (wrapper instanceof PyProcsWrapper.TpSlotWrapper) {
                        PyProcsWrapper.TpSlotWrapper slotWrapper = (PyProcsWrapper.TpSlotWrapper)wrapper;
                        PyProcsWrapper.TpSlotWrapper newWrapper = newSlot != pythonSlot ? slotWrapper.cloneWith(newSlot) : slotWrapper;
                        newWrapper.toNative(SignatureLibrary.getUncached());
                        callable = context.getCApiContext().getClosureForExecutable(newWrapper);
                    }
                    resolvedCallable = null;
                }
                catch (UnsupportedMessageException ignore) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (resolvedCallable != null) {
                doArgAndResultConversion = false;
            } else {
                doArgAndResultConversion = true;
                resolvedCallable = callable;
            }
            PythonLanguage language = context.getLanguage();
            PBuiltinFunction function = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(name, resolvedCallable, type, flags, signature, language, (PythonObjectFactory)context.factory(), doArgAndResultConversion);
            return function != null ? function : CreateFunctionNode.castToPythonObject(resolvedCallable);
        }

        private static PythonObject castToPythonObject(Object callable) {
            if (callable instanceof PythonObject) {
                PythonObject pythonObject = (PythonObject)callable;
                return pythonObject;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)("Unexpected class of callable: " + String.valueOf(callable.getClass())));
        }

        @CompilerDirectives.TruffleBoundary
        public static Object resolveClosurePointerToBuiltinFun(PythonContext context, Object callable, InteropLibrary lib, Object type, TruffleString name, ExternalFunctionNodes.PExternalFunctionWrapper signature) {
            Object delegate = CreateFunctionNode.resolveClosurePointer(context, callable, lib);
            if (delegate instanceof TpSlot.TpSlotBuiltin) {
                TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)delegate;
                return builtinSlot.createBuiltin(context, type, name, signature);
            }
            return delegate;
        }

        @CompilerDirectives.TruffleBoundary
        public static Object resolveClosurePointer(PythonContext context, Object callable, InteropLibrary lib) {
            if (lib.isPointer(callable)) {
                long pointer;
                try {
                    pointer = lib.asPointer(callable);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                Object delegate = context.getCApiContext().getClosureDelegate(pointer);
                if (delegate != null) {
                    LOGGER.fine(() -> PythonUtils.formatJString("resolved closure pointer %d 0x%x to %s", pointer, pointer, delegate));
                    return delegate;
                }
            }
            return null;
        }
    }

    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    static abstract class ReleaseNativeWrapperNode
    extends Node {
        ReleaseNativeWrapperNode() {
        }

        public abstract void execute(Object var1);

        @Specialization
        static void doNativeWrapper(PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper) {
        }

        @Specialization(guards={"!isNativeWrapper(object)"})
        static void doOther(Object object) {
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CreateMemoryViewFromNativeNode
    extends PNodeWithContext {
        public abstract PMemoryView execute(Node var1, PythonNativeObject var2, int var3);

        @Specialization
        static PMemoryView fromNative(PythonNativeObject buf, int flags, @Cached(inline=false) CApiTransitions.PythonToNativeNode toSulongNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode asPythonObjectNode, @Cached(inline=false) PCallCapiFunction callCapiFunction, @Cached(inline=false) ExternalFunctionNodes.DefaultCheckFunctionResultNode checkFunctionResultNode) {
            Object result = callCapiFunction.call(NativeCAPISymbol.FUN_PY_TRUFFLE_MEMORYVIEW_FROM_OBJECT, toSulongNode.execute(buf), flags);
            checkFunctionResultNode.execute(PythonContext.get(callCapiFunction), NativeCAPISymbol.FUN_PY_TRUFFLE_MEMORYVIEW_FROM_OBJECT.getTsName(), result);
            return (PMemoryView)asPythonObjectNode.execute(result);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class HasNativeBufferNode
    extends PNodeWithContext {
        public abstract boolean execute(Node var1, PythonAbstractNativeObject var2);

        @Specialization
        static boolean readTpAsBuffer(PythonAbstractNativeObject object, @CachedLibrary(limit="3") InteropLibrary lib, @Cached(inline=false) CStructAccess.ReadPointerNode readType, @Cached(inline=false) CStructAccess.ReadPointerNode readAsBuffer) {
            Object type = readType.readFromObj(object, CFields.PyObject__ob_type);
            Object result = readAsBuffer.read(type, CFields.PyTypeObject__tp_as_buffer);
            return !PGuards.isNullOrZero(result, lib);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CreateMethodNode
    extends PNodeWithContext {
        public abstract PBuiltinFunction execute(Node var1, Object var2, int var3);

        @Specialization
        static PBuiltinFunction doIt(Node inliningTarget, Object methodDef, int element, @CachedLibrary(limit="2") InteropLibrary resultLib, @Cached(inline=false) CStructAccess.ReadPointerNode readPointerNode, @Cached(inline=false) CStructAccess.ReadI32Node readI32Node, @Cached(inline=false) FromCharPointerNode fromCharPointerNode, @Cached(inline=false) PythonObjectFactory factory, @Cached CExtCommonNodes.EnsureExecutableNode ensureCallableNode, @Cached HiddenAttr.WriteNode writeHiddenAttrNode, @Cached(inline=false) WriteAttributeToPythonObjectNode writeAttributeToPythonObjectNode) {
            Object methodNamePtr = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_name);
            if (resultLib.isNull(methodNamePtr) || methodNamePtr instanceof Long && (Long)methodNamePtr == 0L) {
                return null;
            }
            TruffleString methodName = fromCharPointerNode.execute(methodNamePtr);
            PNone methodDoc = PNone.NONE;
            Object methodDocPtr = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_doc);
            if (!resultLib.isNull(methodDocPtr)) {
                methodDoc = fromCharPointerNode.execute(methodDocPtr, false);
            }
            int flags = readI32Node.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_flags);
            Object mlMethObj = readPointerNode.readStructArrayElement(methodDef, element, CFields.PyMethodDef__ml_meth);
            ExternalFunctionNodes.PExternalFunctionWrapper sig = ExternalFunctionNodes.PExternalFunctionWrapper.fromMethodFlags(flags);
            RootCallTarget callTarget = ExternalFunctionNodes.PExternalFunctionWrapper.getOrCreateCallTarget(sig, PythonLanguage.get(factory), methodName, true, CExtContext.isMethStatic(flags));
            mlMethObj = ensureCallableNode.execute(inliningTarget, mlMethObj, sig);
            PKeyword[] kwDefaults = ExternalFunctionNodes.createKwDefaults(mlMethObj);
            PBuiltinFunction function = factory.createBuiltinFunction(methodName, null, PythonUtils.EMPTY_OBJECT_ARRAY, kwDefaults, flags, callTarget);
            writeHiddenAttrNode.execute(inliningTarget, function, HiddenAttr.METHOD_DEF_PTR, methodDef);
            writeAttributeToPythonObjectNode.execute(function, SpecialAttributeNames.T___DOC__, methodDoc);
            return function;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ExecModuleNode
    extends MultiPhaseExtensionModuleInitNode {
        private static final String NFI_EXEC_SRC = "(POINTER):SINT32";
        private static final Source NFI_LIBFFI_EXEC = Source.newBuilder((String)"nfi", (CharSequence)"(POINTER):SINT32", (String)"exec").build();
        private static final Source NFI_PANAMA_EXEC = Source.newBuilder((String)"nfi", (CharSequence)"with panama (POINTER):SINT32", (String)"exec").build();

        public abstract int execute(CApiContext var1, PythonModule var2, Object var3);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int doGeneric(CApiContext capiContext, PythonModule module, Object moduleDef, @Bind(value="this") Node inliningTarget, @Cached ModuleGetNameNode getNameNode, @Cached CStructAccess.ReadI64Node readI64, @Cached CStructAccess.AllocateNode alloc, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.ReadI32Node readI32Node, @CachedLibrary(limit="3") InteropLibrary interopLib, @CachedLibrary(limit="1") SignatureLibrary signatureLibrary, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode, @Cached PRaiseNode raiseNode) {
            block12: {
                InteropLibrary U = InteropLibrary.getUncached();
                TruffleString mName = getNameNode.execute(inliningTarget, module);
                long mSize = readI64.read(moduleDef, CFields.PyModuleDef__m_size);
                try {
                    Object slotDefinitions;
                    if (mSize >= 0L) {
                        Object mdState = alloc.alloc(mSize == 0L ? 1L : mSize);
                        assert (mdState != null && !InteropLibrary.getUncached().isNull(mdState));
                        module.setNativeModuleState(mdState);
                    }
                    if (interopLib.isNull(slotDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_slots))) {
                        return 0;
                    }
                    int i = 0;
                    while (true) {
                        int slotId = readI32Node.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__slot);
                        switch (slotId) {
                            case 0: {
                                break block12;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                Object execFunction = readPointerNode.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__value);
                                PythonContext context = capiContext.getContext();
                                if (!U.isExecutable(execFunction)) {
                                    boolean panama = context.getOption(PythonOptions.UsePanama);
                                    Object signature = context.getEnv().parseInternal(panama ? NFI_PANAMA_EXEC : NFI_LIBFFI_EXEC, new String[0]).call(new Object[0]);
                                    execFunction = signatureLibrary.bind(signature, execFunction);
                                }
                                Object result = interopLib.execute(execFunction, new Object[]{CApiTransitions.PythonToNativeNode.executeUncached(module)});
                                int iResult = interopLib.asInt(result);
                                PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget);
                                transformExceptionFromNativeNode.execute(inliningTarget, threadState, mName, iResult != 0, true, ErrorMessages.EXECUTION_FAILED_WITHOUT_EXCEPTION, ErrorMessages.EXECUTION_RAISED_EXCEPTION);
                                break;
                            }
                            default: {
                                throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.MODULE_INITIALIZED_WITH_UNKNOWN_SLOT, mName, slotId);
                            }
                        }
                        ++i;
                    }
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return 0;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CreateModuleNode
    extends MultiPhaseExtensionModuleInitNode {
        private static final String NFI_CREATE_NAME = "create";
        private static final String NFI_CREATE_SRC = "(POINTER,POINTER):POINTER";
        private static final Source NFI_LIBFFI_CREATE = Source.newBuilder((String)"nfi", (CharSequence)"(POINTER,POINTER):POINTER", (String)"create").build();
        private static final Source NFI_PANAMA_CREATE = Source.newBuilder((String)"nfi", (CharSequence)"with panama (POINTER,POINTER):POINTER", (String)"create").build();

        public abstract Object execute(CApiContext var1, CApiContext.ModuleSpec var2, Object var3, Object var4);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(CApiContext capiContext, CApiContext.ModuleSpec moduleSpec, Object moduleDefWrapper, Object library, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached CStructAccess.ReadPointerNode readPointer, @Cached CStructAccess.ReadI64Node readI64, @CachedLibrary(limit="3") InteropLibrary interopLib, @Cached FromCharPointerNode fromCharPointerNode, @Cached WriteAttributeToObjectNode writeAttrNode, @Cached WriteAttributeToPythonObjectNode writeAttrToMethodNode, @Cached CreateMethodNode addLegacyMethodNode, @Cached CApiTransitions.NativeToPythonTransferNode toJavaNode, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.ReadI32Node readI32Node, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object module;
            Object moduleDef = moduleDefWrapper instanceof PythonAbstractNativeObject ? ((PythonAbstractNativeObject)moduleDefWrapper).getPtr() : moduleDefWrapper;
            TruffleString mName = moduleSpec.name;
            Object docPtr = readPointer.read(moduleDef, CFields.PyModuleDef__m_doc);
            PNone mDoc = PGuards.isNullOrZero(docPtr, interopLib) ? PNone.NO_VALUE : fromCharPointerNode.execute(docPtr);
            long mSize = readI64.read(moduleDef, CFields.PyModuleDef__m_size);
            if (mSize < 0L) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.M_SIZE_CANNOT_BE_NEGATIVE, mName);
            }
            Object createFunction = null;
            boolean hasExecutionSlots = false;
            Object slotDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_slots);
            if (!interopLib.isNull(slotDefinitions)) {
                int i = 0;
                block7: while (true) {
                    int slotId = readI32Node.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__slot);
                    switch (slotId) {
                        case 0: {
                            break block7;
                        }
                        case 1: {
                            if (createFunction != null) {
                                throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.MODULE_HAS_MULTIPLE_CREATE_SLOTS, mName);
                            }
                            createFunction = readPointerNode.readStructArrayElement(slotDefinitions, i, CFields.PyModuleDef_Slot__value);
                            break;
                        }
                        case 2: {
                            hasExecutionSlots = true;
                            break;
                        }
                        default: {
                            throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.MODULE_USES_UNKNOW_SLOT_ID, mName, slotId);
                        }
                    }
                    ++i;
                }
            }
            if (createFunction != null && !interopLib.isNull(createFunction)) {
                Object[] cArguments = new Object[]{CApiTransitions.PythonToNativeNode.executeUncached(moduleSpec.originalModuleSpec), moduleDef};
                try {
                    Object result;
                    PythonContext context = capiContext.getContext();
                    if (!interopLib.isExecutable(createFunction)) {
                        boolean panama = context.getOption(PythonOptions.UsePanama);
                        Object signature = context.getEnv().parseInternal(panama ? NFI_PANAMA_CREATE : NFI_LIBFFI_CREATE, new String[0]).call(new Object[0]);
                        result = interopLib.execute(SignatureLibrary.getUncached().bind(signature, createFunction), cArguments);
                    } else {
                        result = interopLib.execute(createFunction, cArguments);
                    }
                    PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget);
                    transformExceptionFromNativeNode.execute(inliningTarget, threadState, mName, interopLib.isNull(result), true, ErrorMessages.CREATION_FAILD_WITHOUT_EXCEPTION, ErrorMessages.CREATION_RAISED_EXCEPTION);
                    module = toJavaNode.execute(result);
                }
                catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                if (!(module instanceof PythonModule)) {
                    if (mSize > 0L) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.NOT_A_MODULE_OBJECT_BUT_REQUESTS_MODULE_STATE, mName);
                    }
                    if (hasExecutionSlots) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.MODULE_SPECIFIES_EXEC_SLOTS_BUT_DIDNT_CREATE_INSTANCE, mName);
                    }
                } else {
                    ((PythonModule)module).setNativeModuleDef(moduleDef);
                }
            } else {
                PythonModule pythonModule = factory.createPythonModule(mName);
                pythonModule.setNativeModuleDef(moduleDef);
                module = pythonModule;
            }
            Object methodDefinitions = readPointerNode.read(moduleDef, CFields.PyModuleDef__m_methods);
            if (!interopLib.isNull(methodDefinitions)) {
                PBuiltinFunction fun;
                int i = 0;
                while ((fun = addLegacyMethodNode.execute(inliningTarget, methodDefinitions, i)) != null) {
                    PBuiltinMethod method = factory.createBuiltinMethod(module, fun);
                    writeAttrToMethodNode.execute(method, SpecialAttributeNames.T___MODULE__, mName);
                    writeAttrNode.execute(module, fun.getName(), method);
                    ++i;
                }
            }
            writeAttrNode.execute(module, SpecialAttributeNames.T___DOC__, mDoc);
            writeAttrNode.execute(module, SpecialAttributeNames.T___LIBRARY__, library);
            capiContext.addLoadedExtensionLibrary(library);
            return module;
        }
    }

    static abstract class MultiPhaseExtensionModuleInitNode
    extends Node {
        static final int SLOT_PY_MOD_CREATE = 1;
        static final int SLOT_PY_MOD_EXEC = 2;

        MultiPhaseExtensionModuleInitNode() {
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class UnicodeFromFormatNode
    extends Node {
        private static Pattern pattern;

        public static Object executeUncached(TruffleString format, Object vaList) {
            return CExtNodesFactory.UnicodeFromFormatNodeGen.getUncached().execute(null, format, vaList);
        }

        private static Matcher match(String formatStr) {
            if (pattern == null) {
                pattern = Pattern.compile("%(?<flags>[-+ #0])?(?<width>\\d+)?(\\.(?<prec>\\d+))?(?<len>(l|ll|z))?(?<spec>[%cduixspAUVSR])");
            }
            return pattern.matcher(formatStr);
        }

        public abstract Object execute(Node var1, TruffleString var2, Object var3);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(TruffleString f, Object vaList) {
            String format = f.toJavaStringUncached();
            CApiTransitions.NativeToPythonNode toJavaNode = CApiTransitionsFactory.NativeToPythonNodeGen.getUncached();
            CastToJavaStringNode castToJavaStringNode = CastToJavaStringNodeGen.getUncached();
            FromCharPointerNode fromCharPointerNode = CExtNodesFactory.FromCharPointerNodeGen.getUncached();
            InteropLibrary interopLibrary = InteropLibrary.getUncached();
            PRaiseNode raiseNode = PRaiseNode.getUncached();
            StringBuilder result = new StringBuilder();
            int vaArgIdx = 0;
            try {
                Matcher matcher = UnicodeFromFormatNode.match(format);
                int cur = 0;
                while (matcher.find(cur)) {
                    boolean valid = false;
                    result.append(format, cur, matcher.start());
                    cur = matcher.end();
                    String spec = matcher.group("spec");
                    String len = matcher.group("len");
                    int prec = UnicodeFromFormatNode.getPrec(matcher.group("prec"));
                    assert (spec.length() == 1);
                    char la = spec.charAt(0);
                    PythonContext context = PythonContext.get(raiseNode);
                    switch (la) {
                        case '%': {
                            result.append('%');
                            valid = true;
                            break;
                        }
                        case 'c': {
                            int ordinal = UnicodeFromFormatNode.getAndCastToInt(interopLibrary, raiseNode, vaList);
                            if (ordinal < 0 || ordinal > 0x110000) {
                                throw raiseNode.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CHARACTER_ARG_NOT_IN_RANGE);
                            }
                            result.append((char)ordinal);
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'd': 
                        case 'i': {
                            if (len != null) {
                                switch (len) {
                                    case "ll": 
                                    case "l": 
                                    case "z": {
                                        ++vaArgIdx;
                                        result.append(UnicodeFromFormatNode.castToLong(interopLibrary, raiseNode, GetNextVaArgNode.executeUncached(vaList)));
                                        valid = true;
                                    }
                                }
                                break;
                            }
                            result.append(UnicodeFromFormatNode.getAndCastToInt(interopLibrary, raiseNode, vaList));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'u': {
                            if (len != null) {
                                switch (len) {
                                    case "ll": 
                                    case "l": 
                                    case "z": {
                                        ++vaArgIdx;
                                        result.append(UnicodeFromFormatNode.castToLong(interopLibrary, raiseNode, GetNextVaArgNode.executeUncached(vaList)));
                                        valid = true;
                                    }
                                }
                                break;
                            }
                            result.append(Integer.toUnsignedString(UnicodeFromFormatNode.getAndCastToInt(interopLibrary, raiseNode, vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'x': {
                            result.append(Integer.toHexString(UnicodeFromFormatNode.getAndCastToInt(interopLibrary, raiseNode, vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 's': {
                            Object unicodeObj;
                            String sValue;
                            Object charPtr = GetNextVaArgNode.executeUncached(vaList);
                            if (interopLibrary.isNull(charPtr)) {
                                sValue = "(NULL)";
                            } else {
                                unicodeObj = fromCharPointerNode.execute(charPtr);
                                sValue = castToJavaStringNode.execute(unicodeObj);
                            }
                            try {
                                if (prec == -1) {
                                    result.append(sValue);
                                } else {
                                    result.append(sValue, 0, Math.min(sValue.length(), prec));
                                }
                            }
                            catch (CannotCastException e) {
                                throw CompilerDirectives.shouldNotReachHere();
                            }
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'p': {
                            Object ptr = GetNextVaArgNode.executeUncached(vaList);
                            long value = interopLibrary.isPointer(ptr) ? interopLibrary.asPointer(ptr) : (interopLibrary.hasIdentity(ptr) ? (long)interopLibrary.identityHashCode(ptr) : (long)System.identityHashCode(ptr));
                            result.append(PythonUtils.formatJString("0x%x", value));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'A': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_ASCII, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'U': {
                            result.append(castToJavaStringNode.execute(UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'V': {
                            Object pyObjectPtr = GetNextVaArgNode.executeUncached(vaList);
                            Object unicodeObj = InteropLibrary.getUncached().isNull(pyObjectPtr) ? fromCharPointerNode.execute(GetNextVaArgNode.executeUncached(vaList)) : toJavaNode.execute(pyObjectPtr);
                            result.append(castToJavaStringNode.execute(unicodeObj));
                            vaArgIdx += 2;
                            valid = true;
                            break;
                        }
                        case 'S': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_STR, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                            break;
                        }
                        case 'R': {
                            result.append(UnicodeFromFormatNode.callBuiltin(context, BuiltinNames.T_REPR, UnicodeFromFormatNode.getPyObject(vaList)));
                            ++vaArgIdx;
                            valid = true;
                        }
                    }
                    if (valid) continue;
                    result.append(matcher.group());
                }
                result.append(format, cur, format.length());
            }
            catch (InteropException e) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.ERROR_WHEN_ACCESSING_VAR_ARG_AT_POS, vaArgIdx);
            }
            return PythonUtils.toTruffleStringUncached(result.toString());
        }

        private static int getPrec(String prec) {
            if (prec == null) {
                return -1;
            }
            return Integer.parseInt(prec);
        }

        private static int getAndCastToInt(InteropLibrary lib, PRaiseNode raiseNode, Object vaList) throws InteropException {
            Object value = GetNextVaArgNode.executeUncached(vaList);
            if (lib.fitsInInt(value)) {
                try {
                    return lib.asInt(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (!lib.isPointer(value)) {
                lib.toNative(value);
            }
            if (lib.isPointer(value)) {
                try {
                    return (int)lib.asPointer(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.P_OBJ_CANT_BE_INTEPRETED_AS_INTEGER, value);
        }

        private static long castToLong(InteropLibrary lib, PRaiseNode raiseNode, Object value) {
            if (lib.fitsInLong(value)) {
                try {
                    return lib.asLong(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (!lib.isPointer(value)) {
                lib.toNative(value);
            }
            if (lib.isPointer(value)) {
                try {
                    return lib.asPointer(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.P_OBJ_CANT_BE_INTEPRETED_AS_INTEGER, value);
        }

        private static Object getPyObject(Object vaList) throws InteropException {
            return CApiTransitions.NativeToPythonNode.executeUncached(GetNextVaArgNode.executeUncached(vaList));
        }

        @CompilerDirectives.TruffleBoundary
        private static Object callBuiltin(PythonContext context, TruffleString builtinName, Object object) {
            Object attribute = PyObjectLookupAttr.executeUncached(context.getBuiltins(), builtinName);
            return CastToJavaStringNodeGen.getUncached().execute(CallNode.executeUncached(attribute, object));
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class ObSizeNode
    extends PNodeWithContext {
        public abstract long execute(Node var1, Object var2);

        @Specialization
        static long doBoolean(boolean object) {
            return object ? 1L : 0L;
        }

        @Specialization
        static long doInteger(int object) {
            return ObSizeNode.doLong(object);
        }

        @Specialization
        static long doLong(long object) {
            int sign = object < 0L ? -1 : 1;
            int size = 0;
            for (long t = PInt.abs(object); t != 0L; t >>>= CConstants.PYLONG_BITS_IN_DIGIT.intValue()) {
                ++size;
            }
            return size * sign;
        }

        @Specialization
        static long doPInt(PInt object) {
            int bw = CConstants.PYLONG_BITS_IN_DIGIT.intValue();
            int len = (PInt.bitLength(object.abs()) + bw - 1) / bw;
            return object.isNegative() ? (long)(-len) : (long)len;
        }

        @Specialization
        static long doPythonNativeVoidPtr(PythonNativeVoidPtr object) {
            return 63 / CConstants.PYLONG_BITS_IN_DIGIT.intValue() + 1;
        }

        @Specialization
        static long doClass(PythonManagedClass object) {
            return 0L;
        }

        @Fallback
        static long doOther(Node inliningTarget, Object object, @Cached PyObjectSizeNode sizeNode) {
            try {
                return sizeNode.execute(null, inliningTarget, object);
            }
            catch (PException e) {
                return -1L;
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ResolvePointerNode
    extends PNodeWithContext {
        public static Object executeUncached(Object pointerObject) {
            return CExtNodesFactory.ResolvePointerNodeGen.getUncached().execute(null, pointerObject);
        }

        public abstract Object execute(Node var1, Object var2);

        public abstract Object executeLong(Node var1, long var2);

        @Specialization
        static Object resolveLongCached(Node inliningTarget, long pointer, @Cached.Exclusive @Cached CApiTransitions.ResolveHandleNode resolveHandleNode, @Cached.Exclusive @Cached CApiTransitions.UpdateStrongRefNode updateRefNode) {
            Object lookup = CApiTransitions.lookupNative(pointer);
            if (lookup != null) {
                if (lookup instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                    PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)lookup;
                    updateRefNode.execute(inliningTarget, objectNativeWrapper, objectNativeWrapper.incRef());
                }
                return lookup;
            }
            if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(pointer)) {
                return resolveHandleNode.execute(inliningTarget, pointer);
            }
            return pointer;
        }

        @Specialization(guards={"!isLong(pointerObject)"})
        static Object resolveGeneric(Node inliningTarget, Object pointerObject, @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Exclusive @Cached CApiTransitions.ResolveHandleNode resolveHandleNode, @Cached.Exclusive @Cached CApiTransitions.UpdateStrongRefNode updateRefNode) {
            if (lib.isPointer(pointerObject)) {
                long pointer;
                try {
                    pointer = lib.asPointer(pointerObject);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                Object lookup = CApiTransitions.lookupNative(pointer);
                if (lookup != null) {
                    if (lookup instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                        PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)lookup;
                        updateRefNode.execute(inliningTarget, objectNativeWrapper, objectNativeWrapper.incRef());
                    }
                    return lookup;
                }
                if (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(pointer)) {
                    return resolveHandleNode.execute(inliningTarget, pointer);
                }
            }
            return pointerObject;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class ClearNativeWrapperNode
    extends Node {
        public abstract void execute(Node var1, Object var2, PythonNativeWrapper var3);

        @Specialization(guards={"!isPrimitiveNativeWrapper(nativeWrapper)"})
        static void doPythonAbstractObject(PythonAbstractObject delegate, PythonNativeWrapper nativeWrapper) {
            assert (!(nativeWrapper instanceof PythonObjectNativeWrapper) || delegate.getNativeWrapper() == nativeWrapper) : "inconsistent native wrappers";
            delegate.clearNativeWrapper();
        }

        @Specialization(guards={"delegate == null"})
        static void doPrimitiveNativeWrapper(Node inliningTarget, Object delegate, PrimitiveNativeWrapper nativeWrapper) {
            assert (!ClearNativeWrapperNode.isSmallIntegerWrapperSingleton(nativeWrapper, PythonContext.get(inliningTarget))) : "clearing primitive native wrapper singleton of small integer";
        }

        @Specialization(guards={"delegate != null"})
        static void doPrimitiveNativeWrapperMaterialized(Node inliningTarget, PythonAbstractObject delegate, PrimitiveNativeWrapper nativeWrapper, @Cached InlinedConditionProfile profile) {
            if (profile.profile(inliningTarget, delegate.getNativeWrapper() == nativeWrapper)) {
                assert (!ClearNativeWrapperNode.isSmallIntegerWrapperSingleton(nativeWrapper, PythonContext.get(inliningTarget))) : "clearing primitive native wrapper singleton of small integer";
                delegate.clearNativeWrapper();
            }
        }

        @Specialization(guards={"delegate != null", "!isAnyPythonObject(delegate)"})
        static void doOther(Object delegate, PythonNativeWrapper nativeWrapper) {
            assert (!ClearNativeWrapperNode.isPrimitiveNativeWrapper(nativeWrapper));
        }

        static boolean isPrimitiveNativeWrapper(PythonNativeWrapper nativeWrapper) {
            return nativeWrapper instanceof PrimitiveNativeWrapper;
        }

        private static boolean isSmallIntegerWrapperSingleton(PrimitiveNativeWrapper nativeWrapper, PythonContext context) {
            return CApiGuards.isSmallIntegerWrapper(nativeWrapper) && GetNativeWrapperNode.doLongSmall(nativeWrapper.getLong(), context) == nativeWrapper;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class XDecRefPointerNode
    extends PNodeWithContext {
        public static void executeUncached(Object pointer) {
            CExtNodesFactory.XDecRefPointerNodeGen.getUncached().execute(null, pointer);
        }

        public abstract void execute(Node var1, Object var2);

        @Specialization
        static void doDecref(Node inliningTarget, Object pointerObj, @CachedLibrary(limit="2") InteropLibrary lib, @Cached(inline=false) CApiTransitions.ToPythonWrapperNode toPythonWrapperNode, @Cached InlinedBranchProfile isWrapperProfile, @Cached InlinedBranchProfile isNativeObject, @Cached CApiTransitions.UpdateStrongRefNode updateRefNode, @Cached(inline=false) CStructAccess.ReadI64Node readRefcount, @Cached(inline=false) CStructAccess.WriteLongNode writeRefcount, @Cached(inline=false) PCallCapiFunction callDealloc) {
            long pointer;
            if (pointerObj instanceof Long) {
                Long longPointer = (Long)pointerObj;
                pointer = longPointer;
            } else if (lib.isPointer(pointerObj)) {
                try {
                    pointer = lib.asPointer(pointerObj);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            } else {
                return;
            }
            if (pointer == 0L) {
                return;
            }
            PythonNativeWrapper wrapper = toPythonWrapperNode.executeWrapper(pointer, false);
            if (wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
                isWrapperProfile.enter(inliningTarget);
                updateRefNode.execute(inliningTarget, objectWrapper, objectWrapper.decRef());
            } else if (wrapper == null) {
                isNativeObject.enter(inliningTarget);
                assert (CApiTransitions.NativeToPythonNode.executeUncached(new NativePointer(pointer)) instanceof PythonAbstractNativeObject);
                long refcount = readRefcount.read(pointer, CFields.PyObject__ob_refcnt);
                if (refcount != 0x3FFFFFFFFFFFFFFFL) {
                    writeRefcount.write(pointer, CFields.PyObject__ob_refcnt, --refcount);
                    if (refcount == 0L) {
                        callDealloc.call(NativeCAPISymbol.FUN_PY_DEALLOC, pointer);
                    }
                }
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"Cannot DECREF non-object");
            }
        }
    }

    @GenerateUncached
    @GenerateCached
    @GenerateInline(value=false)
    public static abstract class PRaiseNativeNode
    extends Node {
        public final int raiseInt(Frame frame, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(frame, errorValue, errType, format, arguments);
        }

        public final <T> T raise(Frame frame, T errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            Object result = this.execute(frame, errorValue, errType, format, arguments);
            assert (result == errorValue);
            return errorValue;
        }

        public final int raiseIntWithoutFrame(int errorValue, PythonBuiltinClassType errType, TruffleString format, Object ... arguments) {
            return this.executeInt(null, errorValue, errType, format, arguments);
        }

        public abstract Object execute(Frame var1, Object var2, PythonBuiltinClassType var3, TruffleString var4, Object[] var5);

        public abstract int executeInt(Frame var1, int var2, PythonBuiltinClassType var3, TruffleString var4, Object[] var5);

        @Specialization
        static int doInt(Frame frame, int errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode) {
            PRaiseNativeNode.raiseNative(frame, inliningTarget, errType, format, arguments, raiseNode, transformExceptionToNativeNode);
            return errorValue;
        }

        @Specialization
        static Object doObject(Frame frame, Object errorValue, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="transformExceptionToNativeNode") @Cached CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode) {
            PRaiseNativeNode.raiseNative(frame, inliningTarget, errType, format, arguments, raiseNode, transformExceptionToNativeNode);
            return errorValue;
        }

        private static void raiseNative(Frame frame, Node inliningTarget, PythonBuiltinClassType errType, TruffleString format, Object[] arguments, PRaiseNode raiseNode, CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode) {
            try {
                throw raiseNode.raise(errType, format, arguments);
            }
            catch (PException p) {
                transformExceptionToNativeNode.execute(frame, inliningTarget, p);
                return;
            }
        }

        @GenerateInline
        @GenerateUncached
        @GenerateCached(value=false)
        public static abstract class Lazy
        extends Node {
            public final PRaiseNativeNode get(Node inliningTarget) {
                return this.execute(inliningTarget);
            }

            abstract PRaiseNativeNode execute(Node var1);

            @Specialization
            static PRaiseNativeNode doIt(@Cached(inline=false) PRaiseNativeNode node) {
                return node;
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class PyErrFetchNode
    extends Node {
        public static ExceptionState executeUncached(PythonContext.PythonThreadState threadState) {
            return CExtNodesFactory.PyErrFetchNodeGen.getUncached().execute(null, threadState);
        }

        public abstract ExceptionState execute(Node var1, PythonContext.PythonThreadState var2);

        @Specialization
        static ExceptionState doGeneric(Node inliningTarget, PythonContext.PythonThreadState threadState, @Cached GetClassNode getClassNode, @Cached MaterializeLazyTracebackNode materializeTraceback, @Cached GetEscapedExceptionNode getEscapedExceptionNode, @Cached CExtCommonNodes.ClearCurrentExceptionNode clearCurrentExceptionNode) {
            AbstractTruffleException currentException = threadState.getCurrentException();
            if (currentException == null) {
                return null;
            }
            Object exception = getEscapedExceptionNode.execute(inliningTarget, currentException);
            PTraceback traceback = null;
            if (threadState.getCurrentTraceback() != null) {
                traceback = materializeTraceback.execute(inliningTarget, threadState.getCurrentTraceback());
            }
            clearCurrentExceptionNode.execute(inliningTarget, threadState);
            return new ExceptionState(getClassNode.execute(inliningTarget, exception), exception, traceback);
        }
    }

    public record ExceptionState(Object type, Object value, Object traceback) {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class PyErrOccurredNode
    extends Node {
        public static Object executeUncached(PythonContext.PythonThreadState threadState) {
            return CExtNodesFactory.PyErrOccurredNodeGen.getUncached().execute(null, threadState);
        }

        public abstract Object execute(Node var1, PythonContext.PythonThreadState var2);

        @Specialization
        static Object doGeneric(Node inliningTarget, PythonContext.PythonThreadState threadState, @Cached GetClassNode getClassNode, @Cached GetUnreifiedExceptionNode getUnreifiedExceptionNode) {
            AbstractTruffleException currentException = threadState.getCurrentException();
            if (currentException != null) {
                return getClassNode.execute(inliningTarget, getUnreifiedExceptionNode.execute(inliningTarget, currentException));
            }
            return null;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class LookupNativeI64MemberFromBaseNode
    extends Node {
        public final long execute(Object cls, CFields nativeMemberName, HiddenAttr managedMemberName) {
            return this.execute(cls, nativeMemberName, managedMemberName, null);
        }

        public abstract long execute(Object var1, CFields var2, HiddenAttr var3, Function<PythonBuiltinClassType, Integer> var4);

        @Specialization
        static long doSingleContext(Object cls, CFields nativeMember, HiddenAttr managedMemberName, Function<PythonBuiltinClassType, Integer> builtinCallback, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetBaseClassNode getBaseClassNode, @Cached HiddenAttr.ReadNode readAttrNode, @Cached CStructAccess.ReadI64Node getTypeMemberNode, @Cached PyNumberAsSizeNode asSizeNode) {
            long indexedSlotsSize;
            boolean isBasicsizeOrWeaklistoffset;
            CompilerAsserts.partialEvaluationConstant(builtinCallback);
            Object current = cls;
            boolean bl = isBasicsizeOrWeaklistoffset = nativeMember == CFields.PyTypeObject__tp_basicsize || nativeMember == CFields.PyTypeObject__tp_weaklistoffset;
            if (isBasicsizeOrWeaklistoffset && cls instanceof PythonManagedClass) {
                PythonManagedClass pmc = (PythonManagedClass)cls;
                v1 = (long)pmc.getIndexedSlotCount() * 8L;
            } else {
                v1 = indexedSlotsSize = 0L;
            }
            do {
                if (current instanceof PythonBuiltinClassType) {
                    PythonBuiltinClassType pbct = (PythonBuiltinClassType)((Object)current);
                    current = PythonContext.get(inliningTarget).lookupType(pbct);
                }
                if (builtinCallback != null && current instanceof PythonBuiltinClass) {
                    PythonBuiltinClass builtinClass = (PythonBuiltinClass)current;
                    return ((Integer)builtinCallback.apply(builtinClass.getType())).intValue();
                }
                if (PGuards.isManagedClass(current)) {
                    Object attr = readAttrNode.execute(inliningTarget, (PythonObject)current, managedMemberName, null);
                    if (attr != null) {
                        return asSizeNode.executeExact(null, inliningTarget, attr);
                    }
                    if (indexedSlotsSize == 0L) continue;
                    break;
                }
                assert (PGuards.isNativeClass(current)) : "invalid class inheritance structure; expected native class";
                return getTypeMemberNode.readFromObj((PythonNativeClass)current, nativeMember);
            } while ((current = getBaseClassNode.execute(inliningTarget, current)) != null);
            return isBasicsizeOrWeaklistoffset ? indexedSlotsSize + (long)CStructs.PyObject.size() : 0L;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PCallCapiFunction
    extends Node {
        public static Object callUncached(NativeCAPISymbol symbol, Object ... args) {
            return PCallCapiFunction.getUncached().execute(symbol, args);
        }

        public final Object call(NativeCAPISymbol symbol, Object ... args) {
            return this.execute(symbol, args);
        }

        protected abstract Object execute(NativeCAPISymbol var1, Object[] var2);

        @Specialization
        static Object doWithoutContext(NativeCAPISymbol symbol, Object[] args, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached CExtCommonNodes.EnsureTruffleStringNode ensureTruffleStringNode) {
            try {
                PythonContext pythonContext = PythonContext.get(inliningTarget);
                if (!pythonContext.hasCApiContext()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    CApiContext.ensureCapiWasLoaded("call internal native GraalPy function");
                }
                Object callable = CApiContext.getNativeSymbol(inliningTarget, symbol);
                return ensureTruffleStringNode.execute(inliningTarget, interopLibrary.execute(callable, args));
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @NeverDefault
        public static PCallCapiFunction create() {
            return CExtNodesFactory.PCallCapiFunctionNodeGen.create();
        }

        public static PCallCapiFunction getUncached() {
            return CExtNodesFactory.PCallCapiFunctionNodeGen.getUncached();
        }
    }

    @ImportStatic(value={PythonUtils.class})
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class CastToNativeLongNode
    extends PNodeWithContext {
        public abstract long execute(Node var1, boolean var2);

        public abstract long execute(Node var1, byte var2);

        public abstract long execute(Node var1, int var2);

        public abstract long execute(Node var1, long var2);

        public abstract long execute(Node var1, double var2);

        public abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"lengthNode.execute(value, TS_ENCODING) == 1"}, limit="1")
        static long doString(TruffleString value, @Cached(inline=false) TruffleString.CodePointAtIndexNode codepointAtIndexNode, @Cached(inline=false) TruffleString.CodePointLengthNode lengthNode) {
            return codepointAtIndexNode.execute((AbstractTruffleString)value, 0, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static long doBoolean(boolean value) {
            return value ? 1L : 0L;
        }

        @Specialization
        static long doByte(byte value) {
            return value;
        }

        @Specialization
        static long doInt(int value) {
            return value;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Specialization
        static long doDouble(double value) {
            return (long)value;
        }

        @Specialization
        static long doPInt(PInt value) {
            return value.longValue();
        }

        @Specialization
        static long doPFloat(PFloat value) {
            return (long)value.getValue();
        }

        @Specialization
        static Object doPythonNativeVoidPtr(PythonNativeVoidPtr object) {
            return object.getPointerObject();
        }

        @Specialization(guards={"!object.isDouble()"})
        static long doLongNativeWrapper(PrimitiveNativeWrapper object) {
            return object.getLong();
        }

        @Specialization(guards={"object.isDouble()"})
        static long doDoubleNativeWrapper(PrimitiveNativeWrapper object) {
            return (long)object.getDouble();
        }

        @Specialization
        static Object run(Node inliningTarget, PythonNativeWrapper value, @Cached(inline=false) CastToNativeLongNode recursive) {
            return recursive.execute(inliningTarget, value.getDelegate());
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class AsNativeComplexNode
    extends PNodeWithContext {
        public abstract PComplex execute(Node var1, boolean var2);

        public abstract PComplex execute(Node var1, int var2);

        public abstract PComplex execute(Node var1, long var2);

        public abstract PComplex execute(Node var1, double var2);

        public abstract PComplex execute(Node var1, Object var2);

        @Specialization
        static PComplex doPComplex(PComplex value) {
            return value;
        }

        @Specialization
        static PComplex doBoolean(boolean value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value ? 1.0 : 0.0, 0.0);
        }

        @Specialization
        static PComplex doInt(int value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value, 0.0);
        }

        @Specialization
        static PComplex doLong(long value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value, 0.0);
        }

        @Specialization
        PComplex doDouble(double value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value, 0.0);
        }

        @Specialization
        static PComplex doPInt(PInt value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value.doubleValue(), 0.0);
        }

        @Specialization
        static PComplex doPFloat(PFloat value, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createComplex(value.getValue(), 0.0);
        }

        @Specialization(replaces={"doPComplex", "doBoolean", "doInt", "doLong", "doDouble", "doPInt", "doPFloat"})
        static PComplex runGeneric(Node inliningTarget, Object value, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached(inline=false) LookupAndCallUnaryNode.LookupAndCallUnaryDynamicNode callComplex, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object result = callComplex.executeObject(value, SpecialMethodNames.T___COMPLEX__);
            if (result != PNone.NO_VALUE) {
                if (result instanceof PComplex) {
                    return (PComplex)result;
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.COMPLEX_RETURNED_NON_COMPLEX, value);
            }
            return factory.createComplex(asDoubleNode.execute(null, inliningTarget, value), 0.0);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PointerCompareNode
    extends Node {
        public abstract boolean execute(Node var1, ComparisonOp var2, Object var3, Object var4);

        @Specialization(guards={"op.isEqualityOp()"}, limit="2")
        static boolean doEqNe(ComparisonOp op, PythonAbstractNativeObject a, PythonAbstractNativeObject b, @CachedLibrary(value="a") InteropLibrary aLib, @CachedLibrary(limit="3") InteropLibrary bLib) {
            return aLib.isIdentical((Object)a, (Object)b, bLib) == (op == ComparisonOp.EQ);
        }

        @Specialization(guards={"isNativeObjectOrVoidPointer(a)", "isNativeObjectOrLong(b)"})
        static boolean doGeneric(Node inliningTarget, ComparisonOp op, Object a, Object b, @CachedLibrary(limit="1") InteropLibrary interopLibrary, @Cached InlinedConditionProfile aProfile, @Cached InlinedConditionProfile bProfile) {
            Object ptrB;
            Object ptrA;
            CompilerAsserts.partialEvaluationConstant((Object)((Object)op));
            if (aProfile.profile(inliningTarget, a instanceof PythonNativeObject)) {
                ptrA = ((PythonNativeObject)a).getPtr();
            } else {
                assert (a instanceof PythonNativeVoidPtr);
                ptrA = ((PythonNativeVoidPtr)a).getNativePointer();
            }
            if (bProfile.profile(inliningTarget, b instanceof PythonNativeObject)) {
                ptrB = ((PythonNativeObject)b).getPtr();
            } else {
                assert (b instanceof Long);
                ptrB = b;
            }
            try {
                Object sym = CApiContext.getNativeSymbol(inliningTarget, NativeCAPISymbol.FUN_PTR_COMPARE);
                return (Integer)interopLibrary.execute(sym, new Object[]{ptrA, ptrB, op.opCode}) != 0;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        static boolean isNativeObjectOrVoidPointer(Object object) {
            return object instanceof PythonNativeObject || object instanceof PythonNativeVoidPtr;
        }

        static boolean isNativeObjectOrLong(Object object) {
            return object instanceof PythonNativeObject || object instanceof Long;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class GetNativeClassNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, PythonAbstractNativeObject var2);

        @Specialization
        static Object getNativeClass(Node inliningTarget, PythonAbstractNativeObject object, @Cached(inline=false) CStructAccess.ReadObjectNode callGetObTypeNode, @Cached TypeNodes.ProfileClassNode classProfile) {
            return classProfile.profile(inliningTarget, callGetObTypeNode.readFromObj(object, CFields.PyObject__ob_type));
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class FromCharPointerNode
    extends Node {
        public final TruffleString execute(Object charPtr) {
            return this.execute(charPtr, true);
        }

        public abstract TruffleString execute(Object var1, boolean var2);

        @Specialization
        static TruffleString doCStringWrapper(CArrayWrappers.CStringWrapper cStringWrapper, boolean copy) {
            return cStringWrapper.getString();
        }

        @Specialization
        static TruffleString doCByteArrayWrapper(CArrayWrappers.CByteArrayWrapper cByteArrayWrapper, boolean copy, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromBytes, @Cached.Shared(value="switchEncoding") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            CompilerAsserts.partialEvaluationConstant((boolean)copy);
            byte[] byteArray = cByteArrayWrapper.getByteArray();
            return switchEncodingNode.execute((AbstractTruffleString)fromBytes.execute(byteArray, 0, byteArray.length, TruffleString.Encoding.UTF_8, copy), PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"!isCArrayWrapper(charPtr)"}, limit="3")
        static TruffleString doPointer(Object charPtr, boolean copy, @Cached CStructAccess.ReadByteNode read, @CachedLibrary(value="charPtr") InteropLibrary lib, @Cached TruffleString.FromNativePointerNode fromNative, @Cached.Shared @Cached TruffleString.FromByteArrayNode fromBytes, @Cached.Shared(value="switchEncoding") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            int length = 0;
            while (read.readArrayElement(charPtr, length) != 0) {
                ++length;
            }
            if (lib.isPointer(charPtr)) {
                return switchEncodingNode.execute((AbstractTruffleString)fromNative.execute(charPtr, 0, length, TruffleString.Encoding.UTF_8, copy), PythonUtils.TS_ENCODING);
            }
            byte[] result = read.readByteArray(charPtr, length);
            return switchEncodingNode.execute((AbstractTruffleString)fromBytes.execute(result, TruffleString.Encoding.UTF_8, false), PythonUtils.TS_ENCODING);
        }

        static boolean isCArrayWrapper(Object object) {
            return object instanceof CArrayWrappers.CArrayWrapper || object instanceof PySequenceArrayWrapper;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class AsCharPointerNode
    extends Node {
        public abstract Object execute(Object var1, boolean var2);

        public abstract Object execute(TruffleString var1, boolean var2);

        public final Object execute(Object obj) {
            return this.execute(obj, false);
        }

        @Specialization
        static Object doPString(PString str, boolean allocatePyMem, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleString.CopyToByteArrayNode toBytes, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            TruffleString value = castToStringNode.execute(inliningTarget, str);
            byte[] bytes = toBytes.execute((AbstractTruffleString)switchEncoding.execute((AbstractTruffleString)value, TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
            Object mem = alloc.alloc(bytes.length + 1, allocatePyMem);
            write.writeByteArray(mem, bytes);
            return mem;
        }

        @Specialization
        static Object doString(TruffleString str, boolean allocatePyMem, @Cached.Shared @Cached TruffleString.CopyToByteArrayNode toBytes, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            byte[] bytes = toBytes.execute((AbstractTruffleString)switchEncoding.execute((AbstractTruffleString)str, TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
            Object mem = alloc.alloc(bytes.length + 1, allocatePyMem);
            write.writeByteArray(mem, bytes);
            return mem;
        }

        @Specialization
        static Object doBytes(PBytes bytes, boolean allocatePyMem, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ToByteArrayNode toBytesNode, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            return AsCharPointerNode.doByteArray(toBytesNode.execute(inliningTarget, bytes.getSequenceStorage()), allocatePyMem, alloc, write);
        }

        @Specialization
        static Object doBytes(PByteArray bytes, boolean allocatePyMem, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SequenceStorageNodes.ToByteArrayNode toBytesNode, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            return AsCharPointerNode.doByteArray(toBytesNode.execute(inliningTarget, bytes.getSequenceStorage()), allocatePyMem, alloc, write);
        }

        @Specialization
        static Object doByteArray(byte[] arr, boolean allocatePyMem, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.WriteByteNode write) {
            Object mem = alloc.alloc(arr.length + 1, allocatePyMem);
            write.writeByteArray(mem, arr);
            return mem;
        }

        public static AsCharPointerNode getUncached() {
            return CExtNodesFactory.AsCharPointerNodeGen.getUncached();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={CApiGuards.class})
    public static abstract class MaterializeDelegateNode
    extends Node {
        public abstract Object execute(Node var1, PythonNativeWrapper var2);

        @Specialization(guards={"!isMaterialized(object)", "object.isBool()"})
        static PInt doBoolNativeWrapper(Node inliningTarget, PrimitiveNativeWrapper object) {
            PythonContext core = PythonContext.get(inliningTarget);
            PInt materializedInt = object.getBool() ? core.getTrue() : core.getFalse();
            object.setMaterializedObject(materializedInt);
            if (materializedInt.getNativeWrapper() != null) {
                object.setNativePointer(materializedInt.getNativeWrapper().getNativePointer());
            } else {
                materializedInt.setNativeWrapper(object);
            }
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isInt()"})
        static PInt doIntNativeWrapper(PrimitiveNativeWrapper object, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            PInt materializedInt = factory.createInt(object.getInt());
            object.setMaterializedObject(materializedInt);
            materializedInt.setNativeWrapper(object);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isLong()"})
        static PInt doLongNativeWrapper(PrimitiveNativeWrapper object, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            PInt materializedInt = factory.createInt(object.getLong());
            object.setMaterializedObject(materializedInt);
            materializedInt.setNativeWrapper(object);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isDouble()", "!isNaN(object)"})
        static PFloat doDoubleNativeWrapper(PrimitiveNativeWrapper object, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            PFloat materializedInt = factory.createFloat(object.getDouble());
            materializedInt.setNativeWrapper(object);
            object.setMaterializedObject(materializedInt);
            return materializedInt;
        }

        @Specialization(guards={"!isMaterialized(object)", "object.isDouble()", "isNaN(object)"})
        static PFloat doDoubleNativeWrapperNaN(Node inliningTarget, PrimitiveNativeWrapper object) {
            PFloat materializedFloat = PythonContext.get(inliningTarget).getNaN();
            object.setMaterializedObject(materializedFloat);
            if (materializedFloat.getNativeWrapper() != null) {
                object.setNativePointer(materializedFloat.getNativeWrapper().getNativePointer());
            } else {
                materializedFloat.setNativeWrapper(object);
            }
            return materializedFloat;
        }

        @Specialization(guards={"isMaterialized(object)"})
        static Object doMaterialized(PrimitiveNativeWrapper object) {
            return object.getDelegate();
        }

        @Specialization(guards={"!isPrimitiveNativeWrapper(object)"})
        static Object doNativeWrapperGeneric(PythonNativeWrapper object) {
            return object.getDelegate();
        }

        protected static boolean isPrimitiveNativeWrapper(PythonNativeWrapper object) {
            return object instanceof PrimitiveNativeWrapper;
        }

        protected static boolean isNaN(PrimitiveNativeWrapper object) {
            assert (object.isDouble());
            return Double.isNaN(object.getDouble());
        }

        static boolean isMaterialized(PrimitiveNativeWrapper wrapper) {
            return wrapper.getDelegate() != null;
        }
    }

    @GenerateInline(value=false)
    public static abstract class FromNativeSubclassNode
    extends Node {
        public abstract Double execute(VirtualFrame var1, PythonAbstractNativeObject var2);

        @Specialization
        static Double doDouble(VirtualFrame frame, PythonAbstractNativeObject object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached IsSubtypeNode isSubtype, @Cached CStructAccess.ReadDoubleNode read) {
            if (FromNativeSubclassNode.isFloatSubtype(frame, inliningTarget, object, getClass, isSubtype)) {
                return read.readFromObj(object, CFields.PyFloatObject__ob_fval);
            }
            return null;
        }

        public static boolean isFloatSubtype(VirtualFrame frame, Node inliningTarget, Object object, GetClassNode getClass, IsSubtypeNode isSubtype) {
            return isSubtype.execute(frame, getClass.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PFloat);
        }

        public static boolean isFloatSubtype(VirtualFrame frame, Node inliningTarget, PythonAbstractNativeObject object, GetClassNode.GetPythonObjectClassNode getClass, IsSubtypeNode isSubtype) {
            return isSubtype.execute(frame, getClass.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PFloat);
        }

        @NeverDefault
        public static FromNativeSubclassNode create() {
            return CExtNodesFactory.FromNativeSubclassNodeGen.create();
        }
    }

    public static abstract class StringSubtypeNew
    extends SubtypeNew {
        private static final NativeCAPISymbol NEW_FUNCTION = StringSubtypeNew.getFunction("unicode");
        @Node.Child
        private CApiTransitions.PythonToNativeNode toSulongNode;

        @Override
        protected final NativeCAPISymbol getFunction() {
            return NEW_FUNCTION;
        }

        public final Object call(Object object, Object arg) {
            if (this.toSulongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toSulongNode = (CApiTransitions.PythonToNativeNode)this.insert(CApiTransitionsFactory.PythonToNativeNodeGen.create());
            }
            return this.execute(object, this.toSulongNode.execute(arg));
        }

        public static StringSubtypeNew create() {
            return CExtNodesFactory.StringSubtypeNewNodeGen.create();
        }
    }

    public static abstract class TupleSubtypeNew
    extends SubtypeNew {
        private static final NativeCAPISymbol NEW_FUNCTION = TupleSubtypeNew.getFunction("tuple");
        @Node.Child
        private CApiTransitions.PythonToNativeNode toSulongNode;

        @Override
        protected final NativeCAPISymbol getFunction() {
            return NEW_FUNCTION;
        }

        public final Object call(Object object, Object arg) {
            if (this.toSulongNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toSulongNode = (CApiTransitions.PythonToNativeNode)this.insert(CApiTransitionsFactory.PythonToNativeNodeGen.create());
            }
            return this.execute(object, this.toSulongNode.execute(arg));
        }

        @NeverDefault
        public static TupleSubtypeNew create() {
            return CExtNodesFactory.TupleSubtypeNewNodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class FloatSubtypeNew
    extends SubtypeNew {
        private static final NativeCAPISymbol NEW_FUNCTION = FloatSubtypeNew.getFunction("float");

        @Override
        protected final NativeCAPISymbol getFunction() {
            return NEW_FUNCTION;
        }

        public final Object call(Object object, double arg) {
            return this.execute(object, arg);
        }

        public static FloatSubtypeNew create() {
            return CExtNodesFactory.FloatSubtypeNewNodeGen.create();
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    public static abstract class SubtypeNew
    extends Node {
        protected NativeCAPISymbol getFunction() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        protected abstract Object execute(Object var1, Object var2);

        protected static NativeCAPISymbol getFunction(String typenamePrefix) {
            CompilerAsserts.neverPartOfCompilation();
            String subtypeNewFunctionName = typenamePrefix + CExtNodes.J_SUBTYPE_NEW;
            NativeCAPISymbol result = NativeCAPISymbol.getByName(subtypeNewFunctionName);
            assert (result != null) : "SubtypeNew function not found: " + subtypeNewFunctionName;
            return result;
        }

        @Specialization
        Object callNativeConstructor(Object object, Object arg, @Bind(value="this") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNode toSulongNode, @Cached CApiTransitions.NativeToPythonTransferNode toJavaNode, @CachedLibrary(limit="1") InteropLibrary interopLibrary) {
            assert (TypeNodes.NeedsNativeAllocationNode.executeUncached(object));
            try {
                Object callable = CApiContext.getNativeSymbol(inliningTarget, this.getFunction());
                Object result = interopLibrary.execute(callable, new Object[]{toSulongNode.execute(object), arg});
                return toJavaNode.execute(result);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"C subtype_new function failed", (Throwable)e);
            }
        }
    }
}

