/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonClassNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.TruffleObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetNativeWrapperNodeGen;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@ImportStatic(value={PGuards.class, CApiGuards.class})
public abstract class GetNativeWrapperNode
extends PNodeWithContext {
    public static PythonNativeWrapper executeUncached(Object value) {
        return GetNativeWrapperNodeGen.getUncached().execute(value);
    }

    public abstract PythonNativeWrapper execute(Object var1);

    @Specialization
    static PythonNativeWrapper.PythonAbstractObjectNativeWrapper doString(TruffleString str, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached InlinedConditionProfile noWrapperProfile) {
        return PythonObjectNativeWrapper.wrap(factory.createString(str), inliningTarget, noWrapperProfile);
    }

    @Specialization
    static PythonNativeWrapper.PythonAbstractObjectNativeWrapper doBoolean(boolean b, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile profile) {
        PythonContext core = PythonContext.get(inliningTarget);
        PInt boxed = b ? core.getTrue() : core.getFalse();
        PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper = boxed.getNativeWrapper();
        if (profile.profile(inliningTarget, nativeWrapper == null)) {
            CompilerDirectives.transferToInterpreter();
            nativeWrapper = PrimitiveNativeWrapper.createBool(b);
            boxed.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper;
    }

    @Specialization(guards={"isSmallInteger(i)"})
    static PrimitiveNativeWrapper doIntegerSmall(int i, @Bind(value="this") Node inliningTarget) {
        PythonContext context = PythonContext.get(inliningTarget);
        if (context.getCApiContext() != null) {
            return context.getCApiContext().getCachedPrimitiveNativeWrapper(i);
        }
        return PrimitiveNativeWrapper.createInt(i);
    }

    @Specialization(guards={"!isSmallInteger(i)"})
    static PrimitiveNativeWrapper doInteger(int i) {
        return PrimitiveNativeWrapper.createInt(i);
    }

    public static PrimitiveNativeWrapper doLongSmall(long l, PythonContext context) {
        if (context.getCApiContext() != null) {
            return context.getCApiContext().getCachedPrimitiveNativeWrapper(l);
        }
        return PrimitiveNativeWrapper.createLong(l);
    }

    @Specialization(guards={"isSmallLong(l)"})
    static PrimitiveNativeWrapper doLongSmall(long l, @Bind(value="this") Node inliningTarget) {
        return GetNativeWrapperNode.doLongSmall(l, PythonContext.get(inliningTarget));
    }

    @Specialization(guards={"!isSmallLong(l)"})
    static PrimitiveNativeWrapper doLong(long l) {
        return PrimitiveNativeWrapper.createLong(l);
    }

    @Specialization(guards={"!isNaN(d)"})
    static PrimitiveNativeWrapper doDouble(double d) {
        return PrimitiveNativeWrapper.createDouble(d);
    }

    @Specialization(guards={"isNaN(d)"})
    static PythonNativeWrapper doDoubleNaN(double d, @Bind(value="this") Node inliningTarget) {
        PFloat boxed = PythonContext.get(inliningTarget).getNaN();
        PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper = boxed.getNativeWrapper();
        if (nativeWrapper == null) {
            CompilerDirectives.transferToInterpreter();
            nativeWrapper = PrimitiveNativeWrapper.createDouble(Double.NaN);
            boxed.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper;
    }

    @Specialization(guards={"isSpecialSingleton(object)"})
    static PythonNativeWrapper doSingleton(PythonAbstractObject object, @Bind(value="this") Node inliningTarget) {
        PythonContext context = PythonContext.get(inliningTarget);
        PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper = context.getCApiContext().getSingletonNativeWrapper(object);
        assert (nativeWrapper != null);
        return nativeWrapper;
    }

    @Specialization
    static PythonNativeWrapper doPythonClassUncached(PythonManagedClass object, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.GetNameNode getNameNode, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding) {
        return PythonClassNativeWrapper.wrap(object, getNameNode.execute(inliningTarget, object), switchEncoding);
    }

    @Specialization
    static PythonNativeWrapper doPythonTypeUncached(PythonBuiltinClassType object, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TruffleString.SwitchEncodingNode switchEncoding) {
        PythonBuiltinClass type = PythonContext.get(inliningTarget).lookupType(object);
        return PythonClassNativeWrapper.wrap(type, type.getName(), switchEncoding);
    }

    @Specialization(guards={"!isClass(inliningTarget, object, isTypeNode)", "!isNativeObject(object)", "!isSpecialSingleton(object)"}, limit="1")
    static PythonNativeWrapper runAbstractObject(PythonAbstractObject object, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile noWrapperProfile, @Cached TypeNodes.IsTypeNode isTypeNode) {
        assert (object != PNone.NO_VALUE);
        return PythonObjectNativeWrapper.wrap(object, inliningTarget, noWrapperProfile);
    }

    @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, object)", "!isNativeWrapper(object)", "!isNativeNull(object)"}, limit="1")
    static PythonNativeWrapper doForeignObject(Object object, @Bind(value="this") Node inliningTarget, @Cached IsForeignObjectNode isForeignObjectNode) {
        assert (!CApiTransitions.isBackendPointerObject(object));
        assert (!(object instanceof String));
        return TruffleObjectNativeWrapper.wrap(object);
    }

    protected static boolean isNaN(double d) {
        return Double.isNaN(d);
    }
}

