/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBoxing;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContextFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMContext;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=false)})
public final class GraalHPyHandle
implements TruffleObject {
    private static final int UNINITIALIZED = Integer.MIN_VALUE;
    public static final Object NULL_HANDLE_DELEGATE = PNone.NO_VALUE;
    public static final GraalHPyHandle NULL_HANDLE = new GraalHPyHandle();
    public static final String J_I = "_i";
    public static final TruffleString T_I = PythonUtils.tsLiteral("_i");
    private final Object delegate;
    private int id;

    private GraalHPyHandle() {
        this(NULL_HANDLE_DELEGATE, 0);
    }

    private GraalHPyHandle(Object delegate) {
        this(delegate, Integer.MIN_VALUE);
    }

    private GraalHPyHandle(Object delegate, int id) {
        assert (delegate != null) : "HPy handles to Java null are not allowed";
        assert (delegate != NULL_HANDLE_DELEGATE || id == 0) : "must not not create more than on HPy_NULL";
        this.delegate = TruffleStringMigrationHelpers.assertNoJavaString(delegate);
        this.id = id;
    }

    public static GraalHPyHandle createSingleton(Object delegate, int handle) {
        assert (handle <= 3);
        return new GraalHPyHandle(delegate, handle);
    }

    public static GraalHPyHandle create(Object delegate) {
        return new GraalHPyHandle(delegate);
    }

    public static GraalHPyHandle createField(Object delegate, int idx) {
        return new GraalHPyHandle(delegate, idx);
    }

    public static GraalHPyHandle createGlobal(Object delegate, int idx) {
        return new GraalHPyHandle(delegate, idx);
    }

    public int getIdUncached(GraalHPyContext context) {
        return this.getId(context, ConditionProfile.getUncached(), GraalHPyContextFactory.GetHPyHandleForSingletonNodeGen.getUncached());
    }

    public int getId(GraalHPyContext context, ConditionProfile hasIdProfile, GraalHPyContext.GetHPyHandleForSingleton getSingletonNode) {
        int result = this.id;
        if (!this.isPointer(hasIdProfile)) {
            assert (!GraalHPyBoxing.isBoxablePrimitive(this.delegate)) : "allocating handle for value that could be boxed";
            result = getSingletonNode.execute(this.delegate);
            if (result == -1) {
                result = context.getHPyHandleForNonSingleton(this.delegate);
            }
            this.id = result;
        }
        assert (this.isValidId(this.delegate, result));
        return result;
    }

    public boolean isValidId(Object obj, int newId) {
        if (this.delegate == PNone.NO_VALUE) {
            return newId == 0;
        }
        int singletonId = GraalHPyContext.getHPyHandleForSingleton(obj);
        return singletonId == -1 || singletonId == newId;
    }

    @ExportMessage
    boolean isPointer(@Cached.Exclusive @Cached(inline=false) ConditionProfile isNativeProfile) {
        return isNativeProfile.profile(this.id >= 0 || this.delegate instanceof Integer || this.delegate instanceof Double);
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (!this.isPointer(ConditionProfile.getUncached())) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedMessageException.create();
        }
        if (this.id != Integer.MIN_VALUE) {
            return GraalHPyBoxing.boxHandle(this.id);
        }
        if (this.delegate instanceof Integer) {
            return GraalHPyBoxing.boxInt((Integer)this.delegate);
        }
        if (this.delegate instanceof Double) {
            return GraalHPyBoxing.boxDouble((Double)this.delegate);
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    void toNative(@Cached.Exclusive @Cached(inline=false) ConditionProfile isNativeProfile, @Cached GraalHPyContext.GetHPyHandleForSingleton getSingletonNode, @CachedLibrary(value="this") InteropLibrary lib) {
        this.getId(PythonContext.get((Node)lib).getHPyContext(), isNativeProfile, getSingletonNode);
    }

    @ExportMessage
    boolean hasNativeType(@Bind(value="$node") Node node) {
        return PythonContext.get(node).getHPyContext().getBackend() instanceof GraalHPyLLVMContext;
    }

    @ExportMessage
    Object getNativeType(@Bind(value="$node") Node node) {
        GraalHPyNativeContext graalHPyNativeContext = PythonContext.get(node).getHPyContext().getBackend();
        if (graalHPyNativeContext instanceof GraalHPyLLVMContext) {
            GraalHPyLLVMContext backend = (GraalHPyLLVMContext)graalHPyNativeContext;
            return backend.getHPyNativeType();
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public Object getDelegate() {
        return this.delegate;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new PythonAbstractObject.Keys(new TruffleString[]{T_I});
    }

    @ExportMessage
    boolean isMemberReadable(String key, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) {
        TruffleString tmember = fromJavaStringNode.execute(key, PythonUtils.TS_ENCODING);
        return eqNode.execute((AbstractTruffleString)T_I, (AbstractTruffleString)tmember, PythonUtils.TS_ENCODING);
    }

    @ExportMessage
    Object readMember(String key, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="eq") @Cached TruffleString.EqualNode eqNode) throws UnknownIdentifierException {
        TruffleString tmember = fromJavaStringNode.execute(key, PythonUtils.TS_ENCODING);
        if (eqNode.execute((AbstractTruffleString)T_I, (AbstractTruffleString)tmember, PythonUtils.TS_ENCODING)) {
            return this;
        }
        throw UnknownIdentifierException.create((String)key);
    }

    @ExportMessage
    boolean isNull() {
        return this.id == 0;
    }

    static boolean isAllocated(int id) {
        return id != Integer.MIN_VALUE && id != 0;
    }

    boolean isAllocated() {
        return GraalHPyHandle.isAllocated(this.id);
    }

    boolean isValid() {
        return this.id > 0;
    }

    void closeAndInvalidate(GraalHPyContext hpyContext) {
        assert (this.id != Integer.MIN_VALUE);
        if (hpyContext.releaseHPyHandleForObject(this.id)) {
            this.id = -this.id;
        }
    }

    int getGlobalId() {
        assert (this.id > 0) : "any HPyGlobal handle already has an id";
        return this.id;
    }

    int getFieldId() {
        assert (this.id >= 0) : "any HPyField handle already has an id";
        return this.id;
    }

    public GraalHPyHandle copy() {
        return new GraalHPyHandle(this.delegate);
    }

    static boolean wasAllocated(int id) {
        return id != Integer.MIN_VALUE;
    }
}

