/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.structs;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;

public enum CConstants {
    PYLONG_BITS_IN_DIGIT,
    READONLY,
    CHAR_MIN,
    _PY_NSMALLNEGINTS,
    _PY_NSMALLPOSINTS;

    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final CConstants[] VALUES;
    @CompilerDirectives.CompilationFinal
    private long longValue = -1L;
    @CompilerDirectives.CompilationFinal
    private int intValue = -1;

    public long longValue() {
        long o = this.longValue;
        if (o == -1L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            CConstants.resolve();
            return this.longValue;
        }
        return o;
    }

    public int intValue() {
        int o = this.intValue;
        if (o == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            CConstants.resolve();
            if (this.intValue == -1) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.SystemError, ErrorMessages.INTERNAL_INT_OVERFLOW);
            }
            return this.intValue;
        }
        return o;
    }

    private static void resolve() {
        CompilerAsserts.neverPartOfCompilation();
        Object constantsPointer = CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PYTRUFFLE_CONSTANTS, new Object[0]);
        long[] constants = CStructAccessFactory.ReadI64NodeGen.getUncached().readLongArray(constantsPointer, VALUES.length);
        for (CConstants constant : VALUES) {
            constant.longValue = constants[constant.ordinal()];
            if (constant.longValue == -1L) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.SystemError, PythonUtils.toTruffleStringUncached("internal limitation - cannot extract constants with value '-1'"));
            }
            if ((constant.longValue & 0xFFFF0000L) == 3735879680L) {
                throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.SystemError, PythonUtils.toTruffleStringUncached("marker value reached, regenerate C code (mx python-capi)"));
            }
            if (constant.longValue != (long)((int)constant.longValue)) continue;
            constant.intValue = (int)constant.longValue;
        }
    }

    static {
        VALUES = CConstants.values();
    }
}

