/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.IteratorBuiltins;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.range.RangeNodes;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.expression.CoerceToBooleanNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToByteNode;
import com.oracle.graal.python.nodes.util.CastToJavaByteNode;
import com.oracle.graal.python.runtime.NativeBufferContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.native_memory.NativeBuffer;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ForeignSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeIntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativePrimitiveSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorageFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStoreException;
import com.oracle.graal.python.util.BiFunction;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.reflect.Array;
import java.util.Arrays;
import sun.misc.Unsafe;

public abstract class SequenceStorageNodes {

    public static abstract class CreateStorageFromIteratorNode
    extends Node {
        private static final int START_SIZE = 4;

        public abstract SequenceStorage execute(VirtualFrame var1, Object var2, int var3);

        public final SequenceStorage execute(VirtualFrame frame, Object iterator) {
            return this.execute(frame, iterator, -1);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected SequenceStorage createStorage(VirtualFrame frame, Object iterator, int len, SequenceStorage.StorageType type, GetNextNode nextNode, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, Node inliningTarget, InlinedCountingConditionProfile growArrayProfile) {
            Object[] elements;
            int i;
            block42: {
                double[] elements2;
                block41: {
                    long[] elements3;
                    block40: {
                        int[] elements4;
                        block39: {
                            byte[] elements5;
                            block38: {
                                boolean[] elements6;
                                int size;
                                int n = size = len > 0 ? len : 4;
                                if (type == SequenceStorage.StorageType.Uninitialized || type == SequenceStorage.StorageType.Empty) {
                                    return this.createStorageUninitialized(frame, inliningTarget, iterator, nextNode, errorProfile, size);
                                }
                                i = 0;
                                Object var11_11 = null;
                                try {
                                    switch (type) {
                                        case Boolean: {
                                            boolean[] blArray = elements6 = new boolean[size];
                                            try {}
                                            catch (PException e) {
                                                LoopNode.reportLoopCount((Node)this, (int)i);
                                                e.expectStopIteration(inliningTarget, errorProfile);
                                                return new BoolSequenceStorage(elements6, i);
                                            }
                                            break;
                                        }
                                        case Byte: {
                                            byte[] byArray = elements5 = new byte[size];
                                            try {}
                                            catch (PException e) {
                                                LoopNode.reportLoopCount((Node)this, (int)i);
                                                e.expectStopIteration(inliningTarget, errorProfile);
                                                return new ByteSequenceStorage(elements5, i);
                                            }
                                            break block38;
                                        }
                                        case Int: {
                                            int[] nArray = elements4 = new int[size];
                                            try {}
                                            catch (PException e) {
                                                LoopNode.reportLoopCount((Node)this, (int)i);
                                                e.expectStopIteration(inliningTarget, errorProfile);
                                                return new IntSequenceStorage(elements4, i);
                                            }
                                            break block39;
                                        }
                                        case Long: {
                                            long[] lArray = elements3 = new long[size];
                                            try {}
                                            catch (PException e) {
                                                LoopNode.reportLoopCount((Node)this, (int)i);
                                                e.expectStopIteration(inliningTarget, errorProfile);
                                                return new LongSequenceStorage(elements3, i);
                                            }
                                            break block40;
                                        }
                                        case Double: {
                                            double[] dArray = elements2 = new double[size];
                                            try {}
                                            catch (PException e) {
                                                LoopNode.reportLoopCount((Node)this, (int)i);
                                                e.expectStopIteration(inliningTarget, errorProfile);
                                                return new DoubleSequenceStorage(elements2, i);
                                            }
                                            break block41;
                                        }
                                        case Generic: {
                                            elements = new Object[size];
                                            try {}
                                            catch (PException e) {
                                                LoopNode.reportLoopCount((Node)this, (int)i);
                                                e.expectStopIteration(inliningTarget, errorProfile);
                                                return new ObjectSequenceStorage(elements, i);
                                            }
                                            break block42;
                                        }
                                        default: {
                                            CompilerDirectives.transferToInterpreterAndInvalidate();
                                            throw new RuntimeException("unexpected state");
                                        }
                                    }
                                }
                                catch (UnexpectedResultException e) {
                                    return this.genericFallback(frame, iterator, var11_11, i, e.getResult(), nextNode, errorProfile, inliningTarget, growArrayProfile);
                                }
                                while (true) {
                                    boolean value = nextNode.executeBoolean(frame, iterator);
                                    if (growArrayProfile.profile(inliningTarget, i >= elements6.length)) {
                                        elements6 = PythonUtils.arrayCopyOf(elements6, elements6.length * 2);
                                        boolean[] blArray = elements6;
                                    }
                                    elements6[i++] = value;
                                }
                            }
                            while (true) {
                                int value = nextNode.executeInt(frame, iterator);
                                try {
                                    byte bvalue = PInt.byteValueExact(value);
                                    if (growArrayProfile.profile(inliningTarget, i >= elements5.length)) {
                                        elements5 = PythonUtils.arrayCopyOf(elements5, elements5.length * 2);
                                        byte[] byArray = elements5;
                                    }
                                    elements5[i++] = bvalue;
                                }
                                catch (OverflowException e) {
                                    throw new UnexpectedResultException((Object)value);
                                }
                            }
                        }
                        while (true) {
                            int value = nextNode.executeInt(frame, iterator);
                            if (growArrayProfile.profile(inliningTarget, i >= elements4.length)) {
                                elements4 = PythonUtils.arrayCopyOf(elements4, elements4.length * 2);
                                int[] nArray = elements4;
                            }
                            elements4[i++] = value;
                        }
                    }
                    while (true) {
                        long value = nextNode.executeLong(frame, iterator);
                        if (growArrayProfile.profile(inliningTarget, i >= elements3.length)) {
                            elements3 = PythonUtils.arrayCopyOf(elements3, elements3.length * 2);
                            long[] lArray = elements3;
                        }
                        elements3[i++] = value;
                    }
                }
                while (true) {
                    double value = nextNode.executeDouble(frame, iterator);
                    if (growArrayProfile.profile(inliningTarget, i >= elements2.length)) {
                        elements2 = PythonUtils.arrayCopyOf(elements2, elements2.length * 2);
                        double[] dArray = elements2;
                    }
                    elements2[i++] = value;
                }
            }
            while (true) {
                Object value = nextNode.execute((Frame)frame, iterator);
                if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                    elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                }
                elements[i++] = value;
            }
        }

        private SequenceStorage createStorageUninitialized(VirtualFrame frame, Node inliningTarget, Object iterator, GetNextNode nextNode, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, int size) {
            Object[] elements = new Object[size];
            int i = 0;
            try {
                while (true) {
                    Object value = nextNode.execute((Frame)frame, iterator);
                    if (i >= elements.length) {
                        elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                    }
                    elements[i++] = value;
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                LoopNode.reportLoopCount((Node)this, (int)i);
                return SequenceStorageFactory.createStorage(PythonUtils.arrayCopyOf(elements, i));
            }
        }

        private SequenceStorage genericFallback(VirtualFrame frame, Object iterator, Object array, int count, Object result, GetNextNode nextNode, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, Node inliningTarget, InlinedCountingConditionProfile growArrayProfile) {
            int i;
            Object[] elements = new Object[Array.getLength(array) * 2];
            for (i = 0; i < count; ++i) {
                elements[i] = Array.get(array, i);
            }
            elements[i++] = result;
            try {
                while (true) {
                    Object value = nextNode.execute((Frame)frame, iterator);
                    if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                        elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                    }
                    elements[i++] = value;
                }
            }
            catch (PException e) {
                LoopNode.reportLoopCount((Node)this, (int)i);
                e.expectStopIteration(inliningTarget, errorProfile);
                return new ObjectSequenceStorage(elements, i);
            }
        }

        protected static SequenceStorage createStorageFromBuiltin(VirtualFrame frame, PBuiltinIterator iterator, int len, SequenceStorage.StorageType type, IteratorBuiltins.NextHelperNode nextNode, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, Node inliningTarget, InlinedCountingConditionProfile growArrayProfile, InlinedLoopConditionProfile loopProfile) {
            int size;
            int n = size = len > 0 ? len : 4;
            if (type == SequenceStorage.StorageType.Uninitialized || type == SequenceStorage.StorageType.Empty) {
                Object[] elements = new Object[size];
                int i = 0;
                try {
                    Object value;
                    while (loopProfile.profile(inliningTarget, (value = nextNode.execute(frame, inliningTarget, iterator, false)) != IteratorBuiltins.NextHelperNode.STOP_MARKER)) {
                        if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                            elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                        }
                        elements[i] = value;
                        ++i;
                    }
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                }
                return SequenceStorageFactory.createStorage(PythonUtils.arrayCopyOf(elements, i));
            }
            int i = 0;
            Object[] array = null;
            try {
                switch (type) {
                    case Boolean: {
                        boolean[] elements;
                        array = elements = new boolean[size];
                        try {
                            Object value;
                            while (loopProfile.profile(inliningTarget, (value = nextNode.execute(frame, inliningTarget, iterator, false)) != IteratorBuiltins.NextHelperNode.STOP_MARKER)) {
                                if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                                    array = elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                                }
                                elements[i] = PGuards.expectBoolean(value);
                                ++i;
                            }
                        }
                        catch (PException e) {
                            e.expectStopIteration(inliningTarget, errorProfile);
                        }
                        return new BoolSequenceStorage(elements, i);
                    }
                    case Byte: {
                        byte[] elements = new byte[size];
                        array = elements;
                        try {
                            Object value;
                            while (loopProfile.profile(inliningTarget, (value = nextNode.execute(frame, inliningTarget, iterator, false)) != IteratorBuiltins.NextHelperNode.STOP_MARKER)) {
                                try {
                                    byte bvalue = PInt.byteValueExact(PGuards.expectInteger(value));
                                    if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                                        elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                                        array = elements;
                                    }
                                    elements[i] = bvalue;
                                }
                                catch (OverflowException e) {
                                    throw new UnexpectedResultException(value);
                                }
                                ++i;
                            }
                        }
                        catch (PException e) {
                            e.expectStopIteration(inliningTarget, errorProfile);
                        }
                        return new ByteSequenceStorage(elements, i);
                    }
                    case Int: {
                        int[] elements = new int[size];
                        array = elements;
                        try {
                            Object value;
                            while (loopProfile.profile(inliningTarget, (value = nextNode.execute(frame, inliningTarget, iterator, false)) != IteratorBuiltins.NextHelperNode.STOP_MARKER)) {
                                if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                                    elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                                    array = elements;
                                }
                                elements[i] = PGuards.expectInteger(value);
                                ++i;
                            }
                        }
                        catch (PException e) {
                            e.expectStopIteration(inliningTarget, errorProfile);
                        }
                        return new IntSequenceStorage(elements, i);
                    }
                    case Long: {
                        long[] elements = new long[size];
                        array = elements;
                        try {
                            Object value;
                            while (loopProfile.profile(inliningTarget, (value = nextNode.execute(frame, inliningTarget, iterator, false)) != IteratorBuiltins.NextHelperNode.STOP_MARKER)) {
                                if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                                    elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                                    array = elements;
                                }
                                elements[i] = PGuards.expectLong(value);
                                ++i;
                            }
                        }
                        catch (PException e) {
                            e.expectStopIteration(inliningTarget, errorProfile);
                        }
                        return new LongSequenceStorage(elements, i);
                    }
                    case Double: {
                        double[] elements = new double[size];
                        array = elements;
                        try {
                            Object value;
                            while (loopProfile.profile(inliningTarget, (value = nextNode.execute(frame, inliningTarget, iterator, false)) != IteratorBuiltins.NextHelperNode.STOP_MARKER)) {
                                if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                                    elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                                    array = elements;
                                }
                                elements[i] = PGuards.expectDouble(value);
                                ++i;
                            }
                        }
                        catch (PException e) {
                            e.expectStopIteration(inliningTarget, errorProfile);
                        }
                        return new DoubleSequenceStorage(elements, i);
                    }
                    case Generic: {
                        Object[] elements = new Object[size];
                        try {
                            Object value;
                            while (loopProfile.profile(inliningTarget, (value = nextNode.execute(frame, inliningTarget, iterator, false)) != IteratorBuiltins.NextHelperNode.STOP_MARKER)) {
                                if (growArrayProfile.profile(inliningTarget, i >= elements.length)) {
                                    elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                                }
                                elements[i] = value;
                                ++i;
                            }
                        }
                        catch (PException e) {
                            e.expectStopIteration(inliningTarget, errorProfile);
                        }
                        return new ObjectSequenceStorage(elements, i);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new RuntimeException("unexpected state");
            }
            catch (UnexpectedResultException e) {
                return CreateStorageFromIteratorNode.genericFallback(frame, iterator, array, i, e.getResult(), nextNode, inliningTarget, errorProfile);
            }
        }

        private static SequenceStorage genericFallback(VirtualFrame frame, PBuiltinIterator iterator, Object array, int count, Object result, IteratorBuiltins.NextHelperNode nextNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            int i;
            Object[] elements = new Object[Array.getLength(array) * 2];
            for (i = 0; i < count; ++i) {
                elements[i] = Array.get(array, i);
            }
            elements[i++] = result;
            try {
                Object value;
                while ((value = nextNode.execute(frame, inliningTarget, iterator, false)) != IteratorBuiltins.NextHelperNode.STOP_MARKER) {
                    if (i >= elements.length) {
                        elements = PythonUtils.arrayCopyOf(elements, elements.length * 2);
                    }
                    elements[i++] = value;
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
            }
            return new ObjectSequenceStorage(elements, i);
        }

        @NeverDefault
        public static CreateStorageFromIteratorNode create() {
            return SequenceStorageNodesFactory.CreateStorageFromIteratorNodeFactory.CreateStorageFromIteratorNodeCachedNodeGen.create();
        }

        public static CreateStorageFromIteratorNode getUncached() {
            return CreateStorageFromIteratorUncachedNode.INSTANCE;
        }

        public static abstract class CreateStorageFromIteratorNodeCached
        extends CreateStorageFromIteratorNode {
            @CompilerDirectives.CompilationFinal
            private SequenceStorage.StorageType expectedElementType = SequenceStorage.StorageType.Uninitialized;
            private static final int MAX_PREALLOCATE_SIZE = 32;
            @CompilerDirectives.CompilationFinal
            int startSizeProfiled = 4;

            public boolean isBuiltinIterator(GetClassNode getClass, Node inliningTarget, Object iterator) {
                return iterator instanceof PBuiltinIterator && getClass.execute(inliningTarget, (PBuiltinIterator)iterator) == PythonBuiltinClassType.PIterator;
            }

            public static SequenceStorage getSequenceStorage(Node inliningTarget, IteratorNodes.GetInternalIteratorSequenceStorage node, PBuiltinIterator iterator) {
                return iterator.index != 0 || iterator.isExhausted() ? null : node.execute(inliningTarget, iterator);
            }

            @Specialization(guards={"isBuiltinIterator(getClassNode, inliningTarget, it)", "storage != null"}, limit="3")
            public static SequenceStorage createBuiltinFastPath(PBuiltinIterator it, int len, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached IteratorNodes.GetInternalIteratorSequenceStorage getIterSeqStorageNode, @Bind(value="getSequenceStorage(inliningTarget, getIterSeqStorageNode, it)") SequenceStorage storage, @Cached CopyNode copyNode) {
                it.setExhausted();
                return copyNode.execute(inliningTarget, storage);
            }

            @Specialization(replaces={"createBuiltinFastPath"}, guards={"isBuiltinIterator(getClassNode, inliningTarget, iterator)", "len < 0"}, limit="3")
            public SequenceStorage createBuiltinUnknownLen(VirtualFrame frame, PBuiltinIterator iterator, int len, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached IteratorNodes.BuiltinIteratorLengthHint lengthHint, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached InlinedCountingConditionProfile arrayGrowProfile, @Cached.Exclusive @Cached GetElementType getElementType, @Cached.Exclusive @Cached IteratorBuiltins.NextHelperNode nextNode) {
                int expectedLen = lengthHint.execute(inliningTarget, iterator);
                if (expectedLen < 0) {
                    expectedLen = this.startSizeProfiled;
                }
                SequenceStorage s = CreateStorageFromIteratorNodeCached.createStorageFromBuiltin(frame, iterator, expectedLen, this.expectedElementType, nextNode, errorProfile, inliningTarget, arrayGrowProfile, loopProfile);
                return this.profileResult(getElementType, inliningTarget, s, true);
            }

            @Specialization(replaces={"createBuiltinFastPath"}, guards={"isBuiltinIterator(getClassNode, inliningTarget, iterator)", "len >= 0"}, limit="3")
            public SequenceStorage createBuiltinKnownLen(VirtualFrame frame, PBuiltinIterator iterator, int len, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached InlinedLoopConditionProfile loopProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached InlinedCountingConditionProfile arrayGrowProfile, @Cached.Exclusive @Cached GetElementType getElementType, @Cached.Exclusive @Cached IteratorBuiltins.NextHelperNode nextNode) {
                SequenceStorage s = CreateStorageFromIteratorNodeCached.createStorageFromBuiltin(frame, iterator, len, this.expectedElementType, nextNode, errorProfile, inliningTarget, arrayGrowProfile, loopProfile);
                return this.profileResult(getElementType, inliningTarget, s, false);
            }

            @Specialization(guards={"!isBuiltinIterator(getClassNode, inliningTarget, iterator)", "len < 0"})
            public SequenceStorage createGenericUnknownLen(VirtualFrame frame, Object iterator, int len, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared(value="errProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="arrayGrowProfile") @Cached InlinedCountingConditionProfile arrayGrowProfile, @Cached.Shared @Cached GetElementType getElementType, @Cached.Shared @Cached GetNextNode getNextNode) {
                SequenceStorage s = this.createStorage(frame, iterator, this.startSizeProfiled, this.expectedElementType, getNextNode, errorProfile, inliningTarget, arrayGrowProfile);
                return this.profileResult(getElementType, inliningTarget, s, true);
            }

            @Specialization(guards={"!isBuiltinIterator(getClassNode, inliningTarget, iterator)", "len >= 0"})
            public SequenceStorage createGenericKnownLen(VirtualFrame frame, Object iterator, int len, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared(value="errProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="arrayGrowProfile") @Cached InlinedCountingConditionProfile arrayGrowProfile, @Cached.Shared @Cached GetElementType getElementType, @Cached.Shared @Cached GetNextNode getNextNode) {
                SequenceStorage s = this.createStorage(frame, iterator, len, this.expectedElementType, getNextNode, errorProfile, inliningTarget, arrayGrowProfile);
                return this.profileResult(getElementType, inliningTarget, s, false);
            }

            private SequenceStorage profileResult(GetElementType getElementType, Node inliningTarget, SequenceStorage storage, boolean profileLength) {
                SequenceStorage.StorageType actualElementType;
                int actualLen;
                if (CompilerDirectives.inInterpreter() && profileLength && this.startSizeProfiled < (actualLen = storage.length()) && actualLen <= 32) {
                    this.startSizeProfiled = actualLen;
                }
                if (this.expectedElementType != (actualElementType = getElementType.execute(inliningTarget, storage))) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.expectedElementType = actualElementType;
                }
                return storage;
            }
        }

        private static final class CreateStorageFromIteratorUncachedNode
        extends CreateStorageFromIteratorNode {
            public static final CreateStorageFromIteratorUncachedNode INSTANCE = new CreateStorageFromIteratorUncachedNode();

            private CreateStorageFromIteratorUncachedNode() {
            }

            @Override
            public SequenceStorage execute(VirtualFrame frame, Object iterator, int len) {
                return CreateStorageFromIteratorUncachedNode.executeImpl(iterator, len);
            }

            @CompilerDirectives.TruffleBoundary
            private static SequenceStorage executeImpl(Object iterator, int len) {
                SequenceStorage s;
                PBuiltinIterator pbi;
                if (iterator instanceof PBuiltinIterator && GetClassNode.GetPythonObjectClassNode.executeUncached(pbi = (PBuiltinIterator)iterator) == PythonBuiltinClassType.PIterator && pbi.index == 0 && !pbi.isExhausted() && (s = IteratorNodes.GetInternalIteratorSequenceStorage.executeUncached(pbi)) != null) {
                    return CopyNode.executeUncached(s);
                }
                return CreateStorageFromIteratorUncachedNode.create().createStorageUninitialized(null, null, iterator, GetNextNode.getUncached(), BuiltinClassProfiles.IsBuiltinObjectProfile.getUncached(), len >= 0 ? len : 4);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class InsertItemNode
    extends Node {
        public static SequenceStorage executeUncached(SequenceStorage storage, int index, Object value) {
            return SequenceStorageNodesFactory.InsertItemNodeGen.getUncached().execute(null, storage, index, value);
        }

        public abstract SequenceStorage execute(Node var1, SequenceStorage var2, int var3, Object var4);

        @Specialization
        protected static SequenceStorage doEmptyStorage(Node inliningTarget, EmptySequenceStorage storage, int index, Object value, @Cached.Shared @Cached InsertItemArrayBasedStorageNode insertArrayBasedNode) {
            ArrayBasedSequenceStorage newStorage = storage.generalizeFor(value);
            return insertArrayBasedNode.execute(inliningTarget, newStorage, index, value);
        }

        @Specialization
        static SequenceStorage doArrayBasedStorage(Node inliningTarget, ArrayBasedSequenceStorage storage, int index, Object value, @Cached.Shared @Cached InsertItemArrayBasedStorageNode insertArrayBasedNode) {
            return insertArrayBasedNode.execute(inliningTarget, storage, index, value);
        }

        @Specialization
        static SequenceStorage doNativeInt(Node inliningTarget, NativeIntSequenceStorage storage, int index, int value, @Cached.Exclusive @Cached EnsureCapacityNode ensureCapacity) {
            int length = storage.length();
            PythonContext context = PythonContext.get(inliningTarget);
            Unsafe unsafe = context.getUnsafe();
            long itemSize = storage.getItemSize();
            ensureCapacity.execute(inliningTarget, storage, length + 1);
            long startAddr = storage.getValueBufferAddr() + (long)index * itemSize;
            long endAddr = startAddr + itemSize;
            long sizeInBytes = (long)(length - index) * itemSize;
            unsafe.copyMemory(startAddr, endAddr, sizeInBytes);
            storage.setIntItemNormalized(index, value);
            storage.incLength();
            return storage;
        }

        @Specialization
        protected static SequenceStorage doNativeObjectStorage(Node inliningTarget, NativeObjectSequenceStorage storage, int index, Object value, @Cached.Exclusive @Cached EnsureCapacityNode ensureCapacityNode, @Cached(inline=false) CStructAccess.ReadPointerNode readPointerNode, @Cached(inline=false) CStructAccess.WritePointerNode writePointerNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNative) {
            int newLength = storage.length() + 1;
            ensureCapacityNode.execute(inliningTarget, storage, newLength);
            for (int i = storage.length(); i > index; --i) {
                writePointerNode.writeArrayElement(storage.getPtr(), i, readPointerNode.readArrayElement(storage.getPtr(), i - 1));
            }
            writePointerNode.writeArrayElement(storage.getPtr(), index, toNative.execute(value));
            storage.setNewLength(newLength);
            return storage;
        }

        @Specialization
        protected static SequenceStorage doNativeByteStorage(Node inliningTarget, NativeByteSequenceStorage storage, int index, Object value, @Cached.Exclusive @Cached EnsureCapacityNode ensureCapacityNode, @Cached(inline=false) CStructAccess.ReadByteNode readByteNode, @Cached(inline=false) CStructAccess.WriteByteNode writeByteNode, @Cached CastToByteNode castToByteNode) {
            int newLength = storage.length() + 1;
            ensureCapacityNode.execute(inliningTarget, storage, newLength);
            for (int i = storage.length(); i > index; --i) {
                writeByteNode.writeArrayElement(storage.getPtr(), i, readByteNode.readArrayElement(storage.getPtr(), i - 1));
            }
            writeByteNode.writeArrayElement(storage.getPtr(), index, castToByteNode.execute(null, value));
            storage.setNewLength(newLength);
            return storage;
        }

        @Specialization
        protected static SequenceStorage doForeign(Node inliningTarget, ForeignSequenceStorage storage, int index, Object value, @Cached ForeignSequenceStorage.ReadNode getItem, @Cached ForeignSequenceStorage.WriteNode setItem) {
            int newLength = storage.length() + 1;
            for (int i = storage.length(); i > index; --i) {
                setItem.execute(inliningTarget, storage, i, getItem.execute(inliningTarget, storage, i - 1));
            }
            setItem.execute(inliningTarget, storage, index, value);
            storage.setNewLength(newLength);
            return storage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @ImportStatic(value={PInt.class})
    public static abstract class InsertItemArrayBasedStorageNode
    extends Node {
        public static SequenceStorage executeUncached(ArrayBasedSequenceStorage storage, int index, Object value) {
            return SequenceStorageNodesFactory.InsertItemArrayBasedStorageNodeGen.getUncached().execute(null, storage, index, value);
        }

        protected abstract SequenceStorage execute(Node var1, ArrayBasedSequenceStorage var2, int var3, Object var4);

        @Specialization
        static SequenceStorage doIntStorage(IntSequenceStorage storage, int idx, int value) {
            storage.insertIntItem(idx, value);
            return storage;
        }

        @Specialization
        static SequenceStorage doDoubleStorage(DoubleSequenceStorage storage, int idx, double value) {
            storage.insertDoubleItem(idx, value);
            return storage;
        }

        @Specialization
        static SequenceStorage doLongWithLongStorage(LongSequenceStorage storage, int idx, long value) {
            storage.insertLongItem(idx, value);
            return storage;
        }

        @Specialization
        static SequenceStorage doIntWithLongStorage(LongSequenceStorage storage, int idx, int value) {
            storage.insertLongItem(idx, value);
            return storage;
        }

        @Specialization(guards={"isIntRange(value)"})
        static SequenceStorage doLongWithIntStorage(IntSequenceStorage storage, int idx, long value) {
            storage.insertIntItem(idx, (int)value);
            return storage;
        }

        @Specialization
        static SequenceStorage doByteWithByteStorage(ByteSequenceStorage storage, int idx, byte value) {
            storage.insertByteItem(idx, value);
            return storage;
        }

        @Specialization
        static SequenceStorage doBoolStorage(BoolSequenceStorage storage, int idx, boolean value) {
            storage.insertBoolItem(idx, value);
            return storage;
        }

        @Specialization
        static SequenceStorage doObjectStorage(ObjectSequenceStorage storage, int idx, Object value) {
            storage.insertItem(idx, value);
            return storage;
        }

        @Specialization
        static SequenceStorage doMroStorage(MroSequenceStorage storage, int idx, Object value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Fallback
        static SequenceStorage doGeneralization(Node inliningTarget, ArrayBasedSequenceStorage storage, int idx, Object value, @Cached GetInternalObjectArrayNode getInternalObjectArrayNode) {
            Object[] values = getInternalObjectArrayNode.execute(inliningTarget, storage);
            ObjectSequenceStorage newStorage = new ObjectSequenceStorage(values);
            newStorage.insertItem(idx, value);
            return newStorage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ToArrayNode
    extends Node {
        public abstract Object[] execute(Node var1, SequenceStorage var2);

        @Specialization
        static Object[] doObjectSequenceStorage(Node inliningTarget, ObjectSequenceStorage s, @Cached InlinedConditionProfile profile) {
            Object[] objects = GetInternalObjectArrayNode.doObjectSequenceStorage(s);
            int storageLength = s.length();
            if (profile.profile(inliningTarget, storageLength != objects.length)) {
                return ToArrayNode.exactCopy(objects, storageLength);
            }
            return objects;
        }

        @Specialization(guards={"!isObjectSequenceStorage(s)"})
        static Object[] doOther(Node inliningTarget, SequenceStorage s, @Cached GetInternalObjectArrayNode getInternalObjectArrayNode) {
            return getInternalObjectArrayNode.execute(inliningTarget, s);
        }

        private static Object[] exactCopy(Object[] barr, int len) {
            return PythonUtils.arrayCopyOf(barr, len);
        }

        static boolean isObjectSequenceStorage(SequenceStorage s) {
            return s instanceof ObjectSequenceStorage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetInternalObjectArrayNode
    extends Node {
        public abstract Object[] execute(Node var1, SequenceStorage var2);

        public static Object[] executeUncached(SequenceStorage s) {
            return SequenceStorageNodesFactory.GetInternalObjectArrayNodeGen.getUncached().execute(null, s);
        }

        @Specialization
        static Object[] doObjectSequenceStorage(ObjectSequenceStorage s) {
            return s.getInternalObjectArray();
        }

        @Specialization
        static Object[] doMroSequenceStorage(MroSequenceStorage s) {
            return s.getInternalClassArray();
        }

        @Specialization(guards={"!isObjectStorage(s)", "!isMroStorage(s)"})
        static Object[] doArrayBasedSequenceStorage(Node inliningTarget, ArrayBasedSequenceStorage s, @Cached CopyInternalArrayNode copy) {
            Object[] internalArray = copy.execute(inliningTarget, s);
            assert (internalArray.length == s.length());
            return internalArray;
        }

        @Specialization
        static Object[] doNativeObject(Node inliningTarget, NativeSequenceStorage s, @Cached.Exclusive @Cached GetItemScalarNode getItemNode) {
            return GetInternalObjectArrayNode.materializeGeneric(inliningTarget, s, s.length(), getItemNode);
        }

        @Specialization
        static Object[] doEmptySequenceStorage(EmptySequenceStorage s) {
            return PythonUtils.EMPTY_OBJECT_ARRAY;
        }

        @Specialization(guards={"!isObjectStorage(s)", "!isMroStorage(s)"}, replaces={"doArrayBasedSequenceStorage", "doNativeObject", "doEmptySequenceStorage"})
        static Object[] doGeneric(Node inliningTarget, SequenceStorage s, @Cached.Exclusive @Cached GetItemScalarNode getItemNode) {
            return GetInternalObjectArrayNode.materializeGeneric(inliningTarget, s, s.length(), getItemNode);
        }

        private static Object[] materializeGeneric(Node inliningTarget, SequenceStorage s, int len, GetItemScalarNode getItemNode) {
            Object[] barr = new Object[len];
            for (int i = 0; i < barr.length; ++i) {
                barr[i] = getItemNode.execute(inliningTarget, s, i);
            }
            return barr;
        }

        protected static boolean isObjectStorage(SequenceStorage storage) {
            return storage instanceof ObjectSequenceStorage;
        }

        protected static boolean isMroStorage(SequenceStorage storage) {
            return storage instanceof MroSequenceStorage;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class ItemIndexNode
    extends SequenceStorageBaseNode {
        public abstract int execute(VirtualFrame var1, Node var2, SequenceStorage var3, Object var4, int var5, int var6);

        @Specialization
        int doBoolean(BoolSequenceStorage s, boolean item, int start, int end) {
            for (int i = start; i < ItemIndexNode.getLength(s, end); ++i) {
                if (s.getBoolItemNormalized(i) != item) continue;
                return i;
            }
            return -1;
        }

        @Specialization
        int doInt(IntSequenceStorage s, int item, int start, int end) {
            for (int i = start; i < ItemIndexNode.getLength(s, end); ++i) {
                if (s.getIntItemNormalized(i) != item) continue;
                return i;
            }
            return -1;
        }

        @Specialization
        int doByte(ByteSequenceStorage s, int item, int start, int end) {
            for (int i = start; i < ItemIndexNode.getLength(s, end); ++i) {
                if (s.getIntItemNormalized(i) != item) continue;
                return i;
            }
            return -1;
        }

        @Specialization
        int doLong(LongSequenceStorage s, long item, int start, int end) {
            for (int i = start; i < ItemIndexNode.getLength(s, end); ++i) {
                if (s.getLongItemNormalized(i) != item) continue;
                return i;
            }
            return -1;
        }

        @Specialization
        int doDouble(DoubleSequenceStorage s, double item, int start, int end) {
            for (int i = start; i < ItemIndexNode.getLength(s, end); ++i) {
                if (Double.compare(s.getDoubleItemNormalized(i), item) != 0) continue;
                return i;
            }
            return -1;
        }

        @Specialization
        static int doGeneric(VirtualFrame frame, Node inliningTarget, SequenceStorage s, Object item, int start, int end, @Cached GetItemScalarNode getItemNode, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            for (int i = start; i < ItemIndexNode.getLength(s, end); ++i) {
                Object seqItem = getItemNode.execute(inliningTarget, s, i);
                if (!eqNode.compare((Frame)frame, inliningTarget, seqItem, item)) continue;
                return i;
            }
            return -1;
        }

        private static int getLength(SequenceStorage s, int end) {
            return Math.min(s.length(), end);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class GetElementType
    extends Node {
        public abstract SequenceStorage.StorageType execute(Node var1, SequenceStorage var2);

        @Specialization
        static SequenceStorage.StorageType type(EmptySequenceStorage s) {
            return SequenceStorage.StorageType.Empty;
        }

        @Specialization
        static SequenceStorage.StorageType type(BoolSequenceStorage s) {
            return SequenceStorage.StorageType.Boolean;
        }

        @Specialization
        static SequenceStorage.StorageType type(ByteSequenceStorage s) {
            return SequenceStorage.StorageType.Byte;
        }

        @Specialization
        static SequenceStorage.StorageType type(NativeByteSequenceStorage s) {
            return SequenceStorage.StorageType.Byte;
        }

        @Specialization
        static SequenceStorage.StorageType type(IntSequenceStorage s) {
            return SequenceStorage.StorageType.Int;
        }

        @Specialization
        static SequenceStorage.StorageType type(NativeIntSequenceStorage s) {
            return SequenceStorage.StorageType.Int;
        }

        @Specialization
        static SequenceStorage.StorageType type(LongSequenceStorage s) {
            return SequenceStorage.StorageType.Long;
        }

        @Specialization
        static SequenceStorage.StorageType type(DoubleSequenceStorage s) {
            return SequenceStorage.StorageType.Double;
        }

        @Fallback
        static SequenceStorage.StorageType type(SequenceStorage s) {
            assert (s.getElementType() == SequenceStorage.StorageType.Generic) : String.valueOf(s) + ": " + String.valueOf((Object)s.getElementType());
            return SequenceStorage.StorageType.Generic;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class DeleteSliceNode
    extends SequenceStorageBaseNode {
        public abstract void execute(Node var1, SequenceStorage var2, PSlice.SliceInfo var3);

        @Specialization(guards={"sinfo.step == 1"})
        static void singleStep(Node inliningTarget, SequenceStorage store, PSlice.SliceInfo sinfo, @Cached InlinedConditionProfile shortCircuitProfile, @Cached.Exclusive @Cached SetLenNode setLenNode, @Cached.Exclusive @Cached MemMoveNode memove) {
            int length = store.length();
            int sliceLength = sinfo.sliceLength;
            if (shortCircuitProfile.profile(inliningTarget, sliceLength == 0)) {
                return;
            }
            int ilow = sinfo.start;
            int ihigh = sinfo.stop;
            int n = 0;
            ilow = ilow < 0 ? 0 : Math.min(ilow, length);
            ihigh = ihigh < ilow ? ilow : Math.min(ihigh, length);
            int norig = ihigh - ilow;
            assert (norig >= 0) : "Something wrong with slice info";
            int d = n - norig;
            if (length + d == 0) {
                setLenNode.execute(inliningTarget, store, 0);
                return;
            }
            if (d == 0) {
                return;
            }
            int tail = length - ihigh;
            memove.execute(inliningTarget, store, ihigh + d, ihigh, tail);
            setLenNode.execute(inliningTarget, store, length + d);
        }

        @Specialization(guards={"sinfo.step != 1"})
        static void multipleSteps(Node inliningTarget, SequenceStorage store, PSlice.SliceInfo sinfo, @Cached EnsureCapacityNode ensureCapacityNode, @Cached.Exclusive @Cached SetLenNode setLenNode, @Cached.Exclusive @Cached MemMoveNode memove) {
            DeleteSliceNode.multipleSteps(store, sinfo, inliningTarget, setLenNode, ensureCapacityNode, memove);
        }

        static void multipleSteps(SequenceStorage self, PSlice.SliceInfo sinfo, Node inliningTarget, SetLenNode setLenNode, EnsureCapacityNode ensureCapacityNode, MemMoveNode memove) {
            int start = sinfo.start;
            int step = sinfo.step;
            int slicelen = sinfo.sliceLength;
            int len = self.length();
            step = step > len + 1 ? len : step;
            ensureCapacityNode.execute(inliningTarget, self, len - slicelen);
            if (slicelen == 0) {
                return;
            }
            if (step < 0) {
                int stop = start + 1;
                start = stop + step * (slicelen - 1) - 1;
                step = -step;
            }
            int cur = start;
            for (int i = 0; i < slicelen; ++i) {
                int lim = step - 1;
                if (cur + step >= len) {
                    lim = len - cur - 1;
                }
                memove.execute(inliningTarget, self, cur - i, cur + 1, lim);
                cur += step;
            }
            cur = start + slicelen * step;
            if (cur < len) {
                memove.execute(inliningTarget, self, cur - slicelen, cur, len - cur);
            }
            setLenNode.execute(inliningTarget, self, len - slicelen);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class DeleteItemNode
    extends SequenceStorageBaseNode {
        public abstract void execute(Node var1, SequenceStorage var2, int var3);

        @Specialization(guards={"isLastItem(s, idx)", "!isForeignSequenceStorage(s)"})
        static void doLastItem(Node inliningTarget, SequenceStorage s, int idx, @Cached.Exclusive @Cached SetLenNode setLenNode) {
            setLenNode.execute(inliningTarget, s, s.length() - 1);
        }

        @Specialization(guards={"!isNativeObjectStorage(s)", "!isForeignSequenceStorage(s)"})
        static void doGeneric(Node inliningTarget, SequenceStorage s, int idx, @Cached GetItemScalarNode getItemNode, @Cached SetItemScalarNode setItemNode, @Cached.Exclusive @Cached SetLenNode setLenNode) {
            int len = s.length();
            for (int i = idx; i < len - 1; ++i) {
                setItemNode.execute(inliningTarget, s, i, getItemNode.execute(inliningTarget, s, i + 1));
            }
            setLenNode.execute(inliningTarget, s, len - 1);
        }

        @Specialization
        static void doNativeObjectStorage(Node inliningTarget, NativeObjectSequenceStorage s, int idx, @Cached(inline=false) CStructAccess.ReadPointerNode readPointerNode, @Cached(inline=false) CStructAccess.WritePointerNode writePointerNode, @Cached CExtNodes.XDecRefPointerNode decRefNode) {
            int len = s.length();
            Object deleted = readPointerNode.readArrayElement(s.getPtr(), idx);
            for (int i = idx; i < len - 1; ++i) {
                writePointerNode.writeArrayElement(s.getPtr(), i, readPointerNode.readArrayElement(s.getPtr(), i + 1));
            }
            writePointerNode.writeArrayElement(s.getPtr(), len - 1, 0L);
            s.setNewLength(len - 1);
            decRefNode.execute(inliningTarget, deleted);
        }

        @Specialization
        static void doForeign(Node inliningTarget, ForeignSequenceStorage s, int idx, @Cached ForeignSequenceStorage.RemoveNode removeNode2) {
            removeNode2.execute(inliningTarget, s, idx);
        }

        protected static boolean isLastItem(SequenceStorage s, int idx) {
            return idx == s.length() - 1;
        }
    }

    public static abstract class DeleteNode
    extends NormalizingNode {
        public DeleteNode(IndexNodes.NormalizeIndexNode normalizeIndexNode) {
            super(normalizeIndexNode);
        }

        public abstract void execute(VirtualFrame var1, SequenceStorage var2, Object var3);

        public abstract void execute(VirtualFrame var1, SequenceStorage var2, int var3);

        public abstract void execute(VirtualFrame var1, SequenceStorage var2, long var3);

        @Specialization
        protected void doScalarInt(SequenceStorage storage, int idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached DeleteItemNode deleteItemNode) {
            deleteItemNode.execute(inliningTarget, storage, this.normalizeIndex(idx, storage));
        }

        @Specialization
        protected void doScalarLong(VirtualFrame frame, SequenceStorage storage, long idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached DeleteItemNode deleteItemNode, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            deleteItemNode.execute(inliningTarget, storage, this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage));
        }

        @Specialization
        protected void doScalarPInt(VirtualFrame frame, SequenceStorage storage, PInt idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached DeleteItemNode deleteItemNode, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            deleteItemNode.execute(inliningTarget, storage, this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage));
        }

        @Specialization(guards={"!isPSlice(idx)"})
        protected void doScalarGeneric(VirtualFrame frame, SequenceStorage storage, Object idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached DeleteItemNode deleteItemNode, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            deleteItemNode.execute(inliningTarget, storage, this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage));
        }

        @Specialization
        protected static void doSlice(SequenceStorage storage, PSlice slice, @Bind(value="this") Node inliningTarget, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.SliceUnpack unpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached DeleteSliceNode deleteSliceNode) {
            int len = storage.length();
            PSlice.SliceInfo unadjusted = unpack.execute(inliningTarget, sliceCast.execute(inliningTarget, slice));
            PSlice.SliceInfo info = adjustIndices.execute(inliningTarget, len, unadjusted);
            try {
                deleteSliceNode.execute(inliningTarget, storage, info);
            }
            catch (SequenceStoreException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
        }

        @NeverDefault
        public static DeleteNode create(IndexNodes.NormalizeIndexNode normalizeIndexNode) {
            return SequenceStorageNodesFactory.DeleteNodeGen.create(normalizeIndexNode);
        }

        @NeverDefault
        public static DeleteNode create() {
            return SequenceStorageNodesFactory.DeleteNodeGen.create(IndexNodes.NormalizeIndexNode.create());
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class SetNativeLenNode
    extends Node {
        public abstract void execute(NativeSequenceStorage var1, int var2);

        @Specialization(guards={"len < s.length()"})
        @HostCompilerDirectives.InliningCutoff
        static void doShrink(NativeObjectSequenceStorage s, int len, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.ReadPointerNode readNode, @Cached CStructAccess.WritePointerNode writeNode, @Cached CExtNodes.XDecRefPointerNode decRefPointerNode) {
            if (len < s.length()) {
                for (int i = len; i < s.length(); ++i) {
                    Object elementPointer = readNode.readArrayElement(s.getPtr(), i);
                    decRefPointerNode.execute(inliningTarget, elementPointer);
                    writeNode.writeArrayElement(s.getPtr(), i, 0L);
                }
            }
            s.setNewLength(len);
        }

        @Fallback
        static void doOther(NativeSequenceStorage s, int len) {
            s.setNewLength(len);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class SetLenNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, SequenceStorage var2, int var3);

        @Specialization
        static void doBasic(ArrayBasedSequenceStorage s, int len) {
            s.setNewLength(len);
        }

        @Specialization
        static void doEmpty(EmptySequenceStorage s, int len) {
            assert (len == 0);
        }

        @Specialization
        static void doNative(NativeSequenceStorage s, int len, @Cached(inline=false) SetNativeLenNode setLen) {
            setLen.execute(s, len);
        }

        @Specialization
        static void doNativePrimitive(NativePrimitiveSequenceStorage s, int len) {
            s.setNewLength(len);
        }

        @Specialization
        static void doForeign(Node inliningTarget, ForeignSequenceStorage s, int len, @CachedLibrary(limit="getCallSiteInlineCacheMaxDepth()") InteropLibrary interop, @Cached InlinedBranchProfile errorProfile, @Cached ForeignSequenceStorage.RemoveNode removeNode2) {
            int size;
            while ((size = s.getArraySize(inliningTarget, interop, errorProfile)) > len) {
                removeNode2.execute(inliningTarget, s, size - 1);
            }
            s.setNewLength(size);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class CopyInternalArrayNode
    extends Node {
        public abstract Object[] execute(Node var1, SequenceStorage var2);

        public static Object[] executeUncached(SequenceStorage s) {
            return SequenceStorageNodesFactory.CopyInternalArrayNodeGen.getUncached().execute(null, s);
        }

        @Specialization
        static Object[] doInt(IntSequenceStorage storage) {
            return storage.getCopyOfInternalArray();
        }

        @Specialization
        static Object[] doDouble(DoubleSequenceStorage storage) {
            return storage.getCopyOfInternalArray();
        }

        @Specialization
        static Object[] doByte(ByteSequenceStorage storage) {
            return storage.getCopyOfInternalArray();
        }

        @Specialization
        static Object[] doLong(LongSequenceStorage storage) {
            return storage.getCopyOfInternalArray();
        }

        @Specialization
        static Object[] doObject(ObjectSequenceStorage storage) {
            return storage.getCopyOfInternalArray();
        }

        @Specialization
        static Object[] doBool(BoolSequenceStorage storage) {
            return storage.getCopyOfInternalArray();
        }

        @Specialization
        static Object[] doMro(MroSequenceStorage storage) {
            return storage.getCopyOfInternalArray();
        }

        @Specialization
        static Object[] doEmpty(EmptySequenceStorage s) {
            return PythonUtils.EMPTY_OBJECT_ARRAY;
        }

        @Specialization
        static Object[] doNative(NativeSequenceStorage s, @Cached(inline=false) GetNativeItemScalarNode getNativeItemScalarNode) {
            Object[] result = new Object[s.length()];
            for (int i = 0; i < s.length(); ++i) {
                result[i] = getNativeItemScalarNode.execute(s, i);
            }
            return result;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CopyNode
    extends Node {
        public abstract SequenceStorage execute(Node var1, SequenceStorage var2);

        public static SequenceStorage executeUncached(SequenceStorage s) {
            return SequenceStorageNodesFactory.CopyNodeGen.getUncached().execute(null, s);
        }

        @Specialization
        static SequenceStorage doEmpty(EmptySequenceStorage s) {
            return s;
        }

        @Specialization
        static SequenceStorage doInt(IntSequenceStorage storage) {
            return new IntSequenceStorage(PythonUtils.arrayCopyOf(storage.getInternalIntArray(), storage.length()));
        }

        @Specialization
        static SequenceStorage doLong(LongSequenceStorage storage) {
            return new LongSequenceStorage(PythonUtils.arrayCopyOf(storage.getInternalLongArray(), storage.length()));
        }

        @Specialization
        static SequenceStorage doDouble(DoubleSequenceStorage storage) {
            return new DoubleSequenceStorage(PythonUtils.arrayCopyOf(storage.getInternalDoubleArray(), storage.length()));
        }

        @Specialization
        static SequenceStorage doByte(ByteSequenceStorage storage) {
            return new ByteSequenceStorage(PythonUtils.arrayCopyOf(storage.getInternalByteArray(), storage.length()));
        }

        @Specialization
        static SequenceStorage doBoolean(BoolSequenceStorage storage) {
            return new BoolSequenceStorage(PythonUtils.arrayCopyOf(storage.getInternalBoolArray(), storage.length()));
        }

        @Specialization
        static SequenceStorage doObject(ObjectSequenceStorage storage) {
            return new ObjectSequenceStorage(PythonUtils.arrayCopyOf(storage.getInternalObjectArray(), storage.length()));
        }

        @Specialization
        static SequenceStorage doMro(MroSequenceStorage storage) {
            return new ObjectSequenceStorage(PythonUtils.arrayCopyOf(storage.getInternalClassArray(), storage.length()));
        }

        @Specialization
        static SequenceStorage doNativeInt(Node inliningTarget, NativeIntSequenceStorage storage) {
            NativeBufferContext nativeContext = PythonContext.get((Node)inliningTarget).getContext().nativeBufferContext;
            NativeBuffer copiedBuffer = storage.getValueBuffer().copy();
            return nativeContext.createNativeIntStorage(copiedBuffer, storage.length());
        }

        @Specialization
        static SequenceStorage doNativeBytes(NativeByteSequenceStorage s, @Cached.Shared @Cached(inline=false) GetNativeItemScalarNode getItem) {
            byte[] bytes = new byte[s.length()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)((Integer)getItem.execute(s, i)).intValue();
            }
            return new ByteSequenceStorage(bytes);
        }

        @Specialization
        static SequenceStorage doNativeObjects(NativeObjectSequenceStorage s, @Cached.Shared @Cached(inline=false) GetNativeItemScalarNode getItem) {
            Object[] objects = new Object[s.length()];
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = getItem.execute(s, i);
            }
            return new ObjectSequenceStorage(objects);
        }

        @Specialization
        static SequenceStorage doForeign(Node inliningTarget, ForeignSequenceStorage s, @Cached ForeignSequenceStorage.ReadNode readNode) {
            Object[] objects = new Object[s.length()];
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = readNode.execute(inliningTarget, s, i);
            }
            return new ObjectSequenceStorage(objects);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class EnsureCapacityNode
    extends SequenceStorageBaseNode {
        public abstract void execute(Node var1, SequenceStorage var2, int var3);

        @Specialization
        static void doEmpty(EmptySequenceStorage s, int cap) {
        }

        @Specialization
        static void doInt(IntSequenceStorage storage, int cap) {
            storage.ensureCapacity(cap);
        }

        @Specialization
        static void doLong(LongSequenceStorage storage, int cap) {
            storage.ensureCapacity(cap);
        }

        @Specialization
        static void doDouble(DoubleSequenceStorage storage, int cap) {
            storage.ensureCapacity(cap);
        }

        @Specialization
        static void doByte(ByteSequenceStorage storage, int cap) {
            storage.ensureCapacity(cap);
        }

        @Specialization
        static void doObject(ObjectSequenceStorage storage, int cap) {
            storage.ensureCapacity(cap);
        }

        @Specialization
        static void doNativePrimitive(NativePrimitiveSequenceStorage storage, int cap) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (cap > storage.getCapacity() ? 1 : 0) != 0)) {
                storage.reallocate(cap);
            }
        }

        @Specialization
        static void doBool(BoolSequenceStorage storage, int cap) {
            storage.ensureCapacity(cap);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void doNative(NativeSequenceStorage s, int cap, @Cached(inline=false) EnsureCapacityNativeNode helper) {
            helper.execute(s, cap);
        }

        @Specialization
        static void doMro(MroSequenceStorage storage, int cap) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization
        static void doForeign(ForeignSequenceStorage storage, int cap) {
        }

        @GenerateInline(value=false)
        @GenerateUncached
        static abstract class EnsureCapacityNativeNode
        extends Node {
            EnsureCapacityNativeNode() {
            }

            abstract void execute(NativeSequenceStorage var1, int var2);

            @Specialization
            static void doNativeByte(NativeByteSequenceStorage s, int cap, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="2") InteropLibrary lib, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.FreeNode free, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode, @Cached CStructAccess.ReadByteNode read, @Cached CStructAccess.WriteByteNode write) {
                int oldCapacity = s.getCapacity();
                if (cap > oldCapacity) {
                    int newCapacity = EnsureCapacityNativeNode.computeNewCapacity(cap);
                    Object oldMem = s.getPtr();
                    Object newMem = alloc.alloc(newCapacity);
                    if (lib.isNull(newMem)) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.MemoryError);
                    }
                    for (long i = 0L; i < (long)oldCapacity; ++i) {
                        write.writeArrayElement(newMem, i, read.readArrayElement(oldMem, i));
                    }
                    free.free(oldMem);
                    s.setPtr(newMem);
                    s.setCapacity(newCapacity);
                }
            }

            @Specialization
            static void doNativeObject(NativeObjectSequenceStorage s, int cap, @Bind(value="this") Node inliningTarget, @Cached.Shared @CachedLibrary(limit="2") InteropLibrary lib, @Cached.Shared @Cached CStructAccess.AllocateNode alloc, @Cached.Shared @Cached CStructAccess.FreeNode free, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode, @Cached CStructAccess.ReadPointerNode read, @Cached CStructAccess.WritePointerNode write) {
                int oldCapacity = s.getCapacity();
                if (cap > oldCapacity) {
                    int newCapacity = EnsureCapacityNativeNode.computeNewCapacity(cap);
                    Object oldMem = s.getPtr();
                    long bytes = newCapacity * 8;
                    Object newMem = alloc.alloc(bytes);
                    if (lib.isNull(newMem)) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.MemoryError);
                    }
                    for (long i = 0L; i < (long)oldCapacity; ++i) {
                        write.writeArrayElement(newMem, i, read.readArrayElement(oldMem, i));
                    }
                    free.free(oldMem);
                    s.setPtr(newMem);
                    s.setCapacity(newCapacity);
                }
            }

            private static int computeNewCapacity(int cap) {
                int newCapacity;
                try {
                    newCapacity = Math.max(16, PythonUtils.multiplyExact(cap, 2));
                }
                catch (OverflowException e) {
                    newCapacity = cap;
                }
                return newCapacity;
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CreateEmptyForTypeNode
    extends SequenceStorageBaseNode {
        CreateEmptyForTypeNode() {
        }

        public abstract ArrayBasedSequenceStorage execute(Node var1, SequenceStorage.StorageType var2, int var3);

        @Specialization(guards={"isBoolean(type)"})
        static BoolSequenceStorage doBoolean(SequenceStorage.StorageType type, int cap) {
            return new BoolSequenceStorage(cap);
        }

        @Specialization(guards={"isByte(type)"})
        static ByteSequenceStorage doByte(SequenceStorage.StorageType type, int cap) {
            return new ByteSequenceStorage(cap);
        }

        @Specialization(guards={"isInt(type)"})
        static IntSequenceStorage doInt(SequenceStorage.StorageType type, int cap) {
            return new IntSequenceStorage(cap);
        }

        @Specialization(guards={"isLong(type)"})
        static LongSequenceStorage doLong(SequenceStorage.StorageType type, int cap) {
            return new LongSequenceStorage(cap);
        }

        @Specialization(guards={"isDouble(type)"})
        static DoubleSequenceStorage doDouble(SequenceStorage.StorageType type, int cap) {
            return new DoubleSequenceStorage(cap);
        }

        @Fallback
        static ObjectSequenceStorage doObject(SequenceStorage.StorageType type, int cap) {
            return new ObjectSequenceStorage(cap);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CreateEmptyNode
    extends SequenceStorageBaseNode {
        public abstract ArrayBasedSequenceStorage execute(Node var1, SequenceStorage var2, int var3, int var4);

        @Specialization
        static ArrayBasedSequenceStorage doIt(Node inliningTarget, SequenceStorage s, int cap, int len, @Cached EnsureCapacityNode ensureCapacityNode, @Cached GetElementType getElementType, @Cached CreateEmptyForTypeNode createEmptyForTypeNode) {
            ArrayBasedSequenceStorage ss = createEmptyForTypeNode.execute(inliningTarget, getElementType.execute(inliningTarget, s), cap);
            if (len != -1) {
                ensureCapacityNode.execute(inliningTarget, ss, len);
                ss.setNewLength(len);
            }
            return ss;
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class AppendNode
    extends Node {
        public abstract SequenceStorage execute(Node var1, SequenceStorage var2, Object var3, GenNodeSupplier var4);

        public static SequenceStorage executeUncached(SequenceStorage s, Object val, GenNodeSupplier genNodeSupplier) {
            return SequenceStorageNodesFactory.AppendNodeGen.getUncached().execute(null, s, val, genNodeSupplier);
        }

        @Specialization
        static SequenceStorage doEmpty(Node inliningTarget, EmptySequenceStorage s, Object val, GenNodeSupplier genNodeSupplier, @Cached(inline=false) AppendNode recursive, @Cached.Exclusive @Cached DoGeneralizationNode doGenNode) {
            SequenceStorage newStorage = doGenNode.execute(inliningTarget, genNodeSupplier, s, val);
            return recursive.execute(inliningTarget, newStorage, val, genNodeSupplier);
        }

        @Fallback
        static SequenceStorage doNonEmpty(Node inliningTarget, SequenceStorage s, Object val, GenNodeSupplier genNodeSupplier, @Cached EnsureCapacityNode ensureCapacity, @Cached SetLenNode setLenNode, @Cached InitializeItemScalarNode initializeItemNode, @Cached.Exclusive @Cached DoGeneralizationNode doGenNode) {
            int capacity;
            int len = s.length();
            int newLen = len + 1;
            if (newLen > (capacity = s.getCapacity())) {
                ensureCapacity.execute(inliningTarget, s, len + 1);
            }
            try {
                initializeItemNode.execute(inliningTarget, s, len, val);
                setLenNode.execute(inliningTarget, s, len + 1);
                return s;
            }
            catch (SequenceStoreException e) {
                return AppendNode.generalize(inliningTarget, s, val, genNodeSupplier, ensureCapacity, setLenNode, initializeItemNode, doGenNode, len, e);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private static SequenceStorage generalize(Node inliningTarget, SequenceStorage s, Object val, GenNodeSupplier genNodeSupplier, EnsureCapacityNode ensureCapacity, SetLenNode setLenNode, InitializeItemScalarNode initializeItemNode, DoGeneralizationNode doGenNode, int len, SequenceStoreException e) {
            SequenceStorage generalized = doGenNode.execute(inliningTarget, genNodeSupplier, s, e.getIndicationValue());
            ensureCapacity.execute(inliningTarget, generalized, len + 1);
            try {
                initializeItemNode.execute(inliningTarget, generalized, len, val);
                setLenNode.execute(inliningTarget, generalized, len + 1);
                return generalized;
            }
            catch (SequenceStoreException e1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
        }

        @NeverDefault
        public static AppendNode create() {
            return SequenceStorageNodesFactory.AppendNodeGen.create();
        }

        public static AppendNode getUncached() {
            return SequenceStorageNodesFactory.AppendNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    public static abstract class ListGeneralizationNode
    extends GeneralizationNode {
        public static final GenNodeSupplier SUPPLIER = new GenNodeSupplier(){

            @Override
            public GeneralizationNode getUncached() {
                return SequenceStorageNodesFactory.ListGeneralizationNodeGen.getUncached();
            }

            @Override
            public GeneralizationNode create() {
                return SequenceStorageNodesFactory.ListGeneralizationNodeGen.create();
            }
        };
        private static final int DEFAULT_CAPACITY = 8;

        @Override
        public final SequenceStorage executeCached(SequenceStorage toGeneralize, Object indicationValue) {
            return this.execute(this, toGeneralize, indicationValue);
        }

        public abstract SequenceStorage execute(Node var1, SequenceStorage var2, Object var3);

        @Specialization
        static ObjectSequenceStorage doObject(ObjectSequenceStorage s, Object indicationValue) {
            return s;
        }

        @Specialization
        static SequenceStorage doEmptyStorage(Node inliningTarget, EmptySequenceStorage s, ArrayBasedSequenceStorage other, @Cached.Exclusive @Cached InlinedExactClassProfile otherProfile) {
            return ((ArrayBasedSequenceStorage)otherProfile.profile(inliningTarget, (Object)other)).createEmpty(8);
        }

        @Specialization
        static ByteSequenceStorage doEmptyByte(EmptySequenceStorage s, byte val) {
            return new ByteSequenceStorage(8);
        }

        @Specialization
        static IntSequenceStorage doEmptyInteger(EmptySequenceStorage s, int val) {
            return new IntSequenceStorage();
        }

        @Specialization
        static LongSequenceStorage doEmptyLong(EmptySequenceStorage s, long val) {
            return new LongSequenceStorage();
        }

        @Specialization
        static DoubleSequenceStorage doEmptyDouble(EmptySequenceStorage s, double val) {
            return new DoubleSequenceStorage();
        }

        protected static boolean isKnownType(Object val) {
            return val instanceof Byte || val instanceof Integer || val instanceof Long || val instanceof Double;
        }

        @Specialization(guards={"!isKnownType(val)"})
        static ObjectSequenceStorage doEmptyObject(EmptySequenceStorage s, Object val) {
            return new ObjectSequenceStorage(8);
        }

        @Specialization
        static ByteSequenceStorage doByteByte(ByteSequenceStorage s, byte val) {
            return s;
        }

        @Specialization
        static IntSequenceStorage doByteInteger(ByteSequenceStorage s, int val) {
            int[] copied = new int[s.length()];
            for (int i = 0; i < copied.length; ++i) {
                copied[i] = s.getIntItemNormalized(i);
            }
            return new IntSequenceStorage(copied);
        }

        @Specialization
        static LongSequenceStorage doByteLong(ByteSequenceStorage s, long val) {
            long[] copied = new long[s.length()];
            for (int i = 0; i < copied.length; ++i) {
                copied[i] = s.getIntItemNormalized(i);
            }
            return new LongSequenceStorage(copied);
        }

        @Specialization
        static SequenceStorage doIntegerInteger(IntSequenceStorage s, int val) {
            return s;
        }

        @Specialization
        static SequenceStorage doIntegerLong(IntSequenceStorage s, long val) {
            long[] copied = new long[s.length()];
            for (int i = 0; i < copied.length; ++i) {
                copied[i] = s.getIntItemNormalized(i);
            }
            return new LongSequenceStorage(copied);
        }

        @Specialization
        static LongSequenceStorage doLongByte(LongSequenceStorage s, byte val) {
            return s;
        }

        @Specialization
        static LongSequenceStorage doLongInteger(LongSequenceStorage s, int val) {
            return s;
        }

        @Specialization
        static LongSequenceStorage doLongLong(LongSequenceStorage s, long val) {
            return s;
        }

        @Specialization
        static NativeObjectSequenceStorage doNative(NativeObjectSequenceStorage s, Object val) {
            return s;
        }

        @Specialization(guards={"isFallbackCase(s, value)"})
        static SequenceStorage doGeneric(Node inliningTarget, SequenceStorage s, Object value, @Cached GetInternalObjectArrayNode getInternalObjectArrayNode, @Cached IsAssignCompatibleNode isAssignCompatibleNode) {
            SequenceStorage other;
            if (value instanceof SequenceStorage && isAssignCompatibleNode.execute(inliningTarget, s, other = (SequenceStorage)value)) {
                return s;
            }
            return new ObjectSequenceStorage(getInternalObjectArrayNode.execute(inliningTarget, s));
        }

        protected static boolean isFallbackCase(SequenceStorage s, Object value) {
            if (s instanceof EmptySequenceStorage || s instanceof ObjectSequenceStorage || s instanceof NativeSequenceStorage) {
                return false;
            }
            return !(s instanceof ByteSequenceStorage) && !(s instanceof IntSequenceStorage) && !(s instanceof LongSequenceStorage) || !(value instanceof Byte) && !(value instanceof Integer) && !(value instanceof Long);
        }

        public static ListGeneralizationNode create() {
            return SequenceStorageNodesFactory.ListGeneralizationNodeGen.create();
        }
    }

    public static abstract class NoGeneralizationCustomMessageNode
    extends NoGeneralizationNode {
        private final TruffleString errorMessage;

        public NoGeneralizationCustomMessageNode(TruffleString errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        protected final TruffleString getErrorMessage() {
            return this.errorMessage;
        }

        @NeverDefault
        public static NoGeneralizationCustomMessageNode create(TruffleString msg) {
            return SequenceStorageNodesFactory.NoGeneralizationCustomMessageNodeGen.create(msg);
        }
    }

    @GenerateUncached
    public static abstract class NoGeneralizationNode
    extends GeneralizationNode {
        public static final GenNodeSupplier DEFAULT = new GenNodeSupplier(){

            @Override
            public GeneralizationNode getUncached() {
                return SequenceStorageNodesFactory.NoGeneralizationNodeGen.getUncached();
            }

            @Override
            public GeneralizationNode create() {
                return SequenceStorageNodesFactory.NoGeneralizationNodeGen.create();
            }
        };

        @Specialization
        protected SequenceStorage doGeneric(SequenceStorage s, Object indicationVal, @Bind(value="this") Node inliningTarget, @Cached IsAssignCompatibleNode isAssignCompatibleNode, @Cached GetElementType getElementType, @Cached InlinedExactClassProfile valTypeProfile, @Cached PRaiseNode raiseNode) {
            Object val = valTypeProfile.profile(inliningTarget, indicationVal);
            if (val instanceof SequenceStorage && isAssignCompatibleNode.execute(inliningTarget, s, (SequenceStorage)val)) {
                return s;
            }
            SequenceStorage.StorageType et = getElementType.execute(inliningTarget, s);
            if (val instanceof Byte && SequenceStorageBaseNode.isByteLike(et) || val instanceof Integer && (SequenceStorageBaseNode.isInt(et) || SequenceStorageBaseNode.isLong(et)) || val instanceof Long && SequenceStorageBaseNode.isLong(et) || SequenceStorageBaseNode.isObject(et)) {
                return s;
            }
            throw raiseNode.raise(PythonErrorType.TypeError, this.getErrorMessage());
        }

        protected TruffleString getErrorMessage() {
            return StringLiterals.T_EMPTY_STRING;
        }
    }

    public static abstract class GeneralizationNode
    extends Node {
        public abstract SequenceStorage executeCached(SequenceStorage var1, Object var2);
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IndexOfNode
    extends SequenceStorageBaseNode {
        public abstract int execute(VirtualFrame var1, Node var2, SequenceStorage var3, Object var4);

        @Specialization(guards={"left.length() == 0"})
        static int doEmpty(SequenceStorage left, Object item) {
            return -1;
        }

        @Specialization
        public static int doByteStorage(ByteSequenceStorage s, int item) {
            return s.indexOfInt(item);
        }

        @Specialization
        public static int doByteStorage(ByteSequenceStorage s, byte item) {
            return s.indexOfByte(item);
        }

        @Specialization
        public static int doIntStorage(IntSequenceStorage s, int item) {
            return s.indexOfInt(item);
        }

        @Specialization
        public static int doLongStorage(LongSequenceStorage s, long item) {
            return s.indexOfLong(item);
        }

        @Specialization
        public static int doDoubleStorage(DoubleSequenceStorage s, double item) {
            return s.indexOfDouble(item);
        }

        @Specialization
        static int doGeneric(VirtualFrame frame, Node inliningTarget, SequenceStorage self, Object item, @Cached(inline=false) GetItemScalarNode getItemNode, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            for (int i = 0; i < self.length(); ++i) {
                Object seqItem = getItemNode.execute(inliningTarget, self, i);
                if (!eqNode.compare((Frame)frame, inliningTarget, seqItem, item)) continue;
                return i;
            }
            return -1;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ContainsNode
    extends SequenceStorageBaseNode {
        public abstract boolean execute(VirtualFrame var1, Node var2, SequenceStorage var3, Object var4);

        @Specialization
        public static boolean doIndexOf(VirtualFrame frame, Node inliningTarget, SequenceStorage left, Object item, @Cached IndexOfNode indexOfNode) {
            return indexOfNode.execute(frame, inliningTarget, left, item) != -1;
        }
    }

    public static abstract class RepeatNode
    extends SequenceStorageBaseNode {
        @Node.Child
        private RepeatNode recursive;
        private final PythonBuiltinClassType errorForOverflow;

        protected RepeatNode(PythonBuiltinClassType errorForOverflow) {
            this.errorForOverflow = errorForOverflow;
        }

        public abstract SequenceStorage execute(VirtualFrame var1, SequenceStorage var2, Object var3);

        public abstract SequenceStorage execute(VirtualFrame var1, SequenceStorage var2, int var3);

        @Specialization
        static SequenceStorage doEmpty(EmptySequenceStorage s, int times) {
            return s;
        }

        @Specialization(guards={"times <= 0"})
        static SequenceStorage doZeroRepeat(SequenceStorage s, int times, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CreateEmptyNode createEmptyNode) {
            return createEmptyNode.execute(inliningTarget, s, 0, -1);
        }

        @Specialization(guards={"s.length() == 1", "times > 0"})
        BoolSequenceStorage doBoolSingleElement(BoolSequenceStorage s, int times, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                boolean[] repeated = new boolean[PythonUtils.multiplyExact(s.length(), times)];
                Arrays.fill(repeated, s.getBoolItemNormalized(0));
                return new BoolSequenceStorage(repeated);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        @Specialization(guards={"s.length() == 1", "times > 0"})
        ByteSequenceStorage doByteSingleElement(ByteSequenceStorage s, int times, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                byte[] repeated = new byte[PythonUtils.multiplyExact(s.length(), times)];
                Arrays.fill(repeated, s.getByteItemNormalized(0));
                return new ByteSequenceStorage(repeated);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        @Specialization(guards={"s.length() == 1", "times > 0"})
        IntSequenceStorage doIntSingleElement(IntSequenceStorage s, int times, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                int[] repeated = new int[PythonUtils.multiplyExact(s.length(), times)];
                Arrays.fill(repeated, s.getIntItemNormalized(0));
                return new IntSequenceStorage(repeated);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        @Specialization(guards={"s.length() == 1", "times > 0"})
        LongSequenceStorage doLongSingleElement(LongSequenceStorage s, int times, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                long[] repeated = new long[PythonUtils.multiplyExact(s.length(), times)];
                Arrays.fill(repeated, s.getLongItemNormalized(0));
                return new LongSequenceStorage(repeated);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        @Specialization(guards={"s.length() == 1", "times > 0"})
        DoubleSequenceStorage doDoubleSingleElement(DoubleSequenceStorage s, int times, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                double[] repeated = new double[PythonUtils.multiplyExact(s.length(), times)];
                Arrays.fill(repeated, s.getDoubleItemNormalized(0));
                return new DoubleSequenceStorage(repeated);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        @Specialization(guards={"s.length() == 1", "times > 0"})
        ObjectSequenceStorage doObjectSingleElement(ObjectSequenceStorage s, int times, @Cached.Shared @Cached PRaiseNode raiseNode) {
            try {
                Object[] repeated = new Object[PythonUtils.multiplyExact(s.length(), times)];
                Arrays.fill(repeated, s.getObjectItemNormalized(0));
                return new ObjectSequenceStorage(repeated);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        @Specialization(limit="MAX_BASIC_STORAGES", guards={"times > 0", "!isNative(s)", "s.getClass() == cachedClass"})
        SequenceStorage doArrayBasedManaged(ArrayBasedSequenceStorage s, int times, @Cached.Shared @Cached PRaiseNode raiseNode, @Cached(value="s.getClass()") Class<? extends ArrayBasedSequenceStorage> cachedClass) {
            try {
                ArrayBasedSequenceStorage profiled = cachedClass.cast(s);
                Object arr1 = profiled.getInternalArrayObject();
                int len = profiled.length();
                int newLength = PythonUtils.multiplyExact(len, times);
                ArrayBasedSequenceStorage repeated = profiled.createEmpty(newLength);
                Object destArr = repeated.getInternalArrayObject();
                RepeatNode.repeat(destArr, arr1, len, times);
                repeated.setNewLength(newLength);
                return repeated;
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        @Specialization(replaces={"doArrayBasedManaged"}, guards={"times > 0"})
        SequenceStorage doGeneric(SequenceStorage s, int times, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode raiseNode, @Cached.Exclusive @Cached CreateEmptyNode createEmptyNode, @Cached GetItemScalarNode getItemNode, @Cached SetItemScalarNode setItemNode, @Cached GetItemScalarNode getDestItemNode) {
            try {
                int len = s.length();
                int newLen = PythonUtils.multiplyExact(len, times);
                ArrayBasedSequenceStorage repeated = createEmptyNode.execute(inliningTarget, s, newLen, -1);
                for (int i = 0; i < len; ++i) {
                    setItemNode.execute(inliningTarget, repeated, i, getItemNode.execute(inliningTarget, s, i));
                }
                for (int j = 1; j < times; ++j) {
                    for (int i = 0; i < len; ++i) {
                        setItemNode.execute(inliningTarget, repeated, j * len + i, getDestItemNode.execute(inliningTarget, repeated, i));
                    }
                }
                repeated.setNewLength(newLen);
                return repeated;
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        @Specialization(guards={"!isInt(times)"})
        SequenceStorage doNonInt(VirtualFrame frame, SequenceStorage s, Object times, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (!indexCheckNode.execute(inliningTarget, times)) {
                throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.CANT_MULTIPLY_SEQ_BY_NON_INT, times);
            }
            int i = asSizeNode.executeExact((Frame)frame, inliningTarget, times);
            if (this.recursive == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.recursive = (RepeatNode)this.insert(SequenceStorageNodesFactory.RepeatNodeGen.create(this.errorForOverflow));
            }
            return this.recursive.execute(frame, s, i);
        }

        private static void repeat(Object dest, Object src, int len, int times) {
            for (int i = 0; i < times; ++i) {
                PythonUtils.arraycopy(src, 0, dest, i * len, len);
            }
        }

        protected static boolean isInt(Object times) {
            return times instanceof Integer;
        }

        @NeverDefault
        public static RepeatNode create() {
            return SequenceStorageNodesFactory.RepeatNodeGen.create(PythonErrorType.MemoryError);
        }

        @NeverDefault
        public static RepeatNode createWithOverflowError() {
            return SequenceStorageNodesFactory.RepeatNodeGen.create(PythonErrorType.OverflowError);
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class ExtendNode
    extends SequenceStorageBaseNode {
        @Node.Child
        private GeneralizationNode genNode;
        private final GenNodeSupplier genNodeProvider;

        public ExtendNode(GenNodeSupplier genNodeProvider) {
            this.genNodeProvider = genNodeProvider;
        }

        public abstract SequenceStorage execute(VirtualFrame var1, SequenceStorage var2, Object var3, int var4);

        private static int lengthResult(int current, int ext) {
            try {
                return PythonUtils.addExact(current, ext);
            }
            catch (OverflowException e) {
                return current;
            }
        }

        @Specialization(guards={"hasStorage(seq)", "isBuiltinSequence(seq)"})
        SequenceStorage doWithStorage(SequenceStorage left, PSequence seq, int len, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getStorageNode, @Cached.Exclusive @Cached EnsureCapacityNode ensureCapacityNode, @Cached ConcatBaseNode concatStoragesNode) {
            SequenceStorage right = getStorageNode.execute(inliningTarget, seq);
            int lenLeft = left.length();
            int lenResult = len > 0 ? ExtendNode.lengthResult(lenLeft, len) : ExtendNode.lengthResult(lenLeft, right.length());
            while (true) {
                try {
                    ensureCapacityNode.execute(inliningTarget, left, lenResult);
                    return concatStoragesNode.execute(left, left, right);
                }
                catch (SequenceStoreException e) {
                    left = this.generalizeStore(left, e.getIndicationValue());
                    continue;
                }
                break;
            }
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        SequenceStorage doWithoutStorage(VirtualFrame frame, SequenceStorage left, Object iterable, int len, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached EnsureCapacityNode ensureCapacityNode, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached AppendNode appendNode) {
            SequenceStorage currentStore = left;
            int lenLeft = currentStore.length();
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            if (len > 0) {
                ensureCapacityNode.execute(inliningTarget, left, ExtendNode.lengthResult(lenLeft, len));
            }
            try {
                while (true) {
                    Object value = getNextNode.execute((Frame)frame, it);
                    currentStore = appendNode.execute(inliningTarget, currentStore, value, this.genNodeProvider);
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return currentStore;
            }
        }

        private SequenceStorage generalizeStore(SequenceStorage storage, Object value) {
            if (this.genNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.genNode = (GeneralizationNode)this.insert(this.genNodeProvider.create());
            }
            return this.genNode.executeCached(storage, value);
        }

        @NeverDefault
        protected ExtendNode createRecursive() {
            return SequenceStorageNodesFactory.ExtendNodeGen.create(this.genNodeProvider);
        }

        @NeverDefault
        public static ExtendNode create(GenNodeSupplier genNodeProvider) {
            return SequenceStorageNodesFactory.ExtendNodeGen.create(genNodeProvider);
        }
    }

    public static abstract class ConcatNode
    extends SequenceStorageBaseNode {
        private static final TruffleString DEFAULT_ERROR_MSG = ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP;
        @Node.Child
        private ConcatBaseNode concatBaseNode = SequenceStorageNodesFactory.ConcatBaseNodeGen.create();
        @Node.Child
        private GeneralizationNode genNode;
        private final Supplier<GeneralizationNode> genNodeProvider;
        private final PythonBuiltinClassType errorForOverflow;

        ConcatNode(Supplier<GeneralizationNode> genNodeProvider, PythonBuiltinClassType errorForOverflow) {
            this.genNodeProvider = genNodeProvider;
            this.errorForOverflow = errorForOverflow;
        }

        public abstract SequenceStorage execute(SequenceStorage var1, SequenceStorage var2);

        @Specialization
        SequenceStorage doRight(SequenceStorage left, SequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached CreateEmptyNode createEmptyNode, @Cached InlinedConditionProfile shouldOverflow, @Cached PRaiseNode raiseNode) {
            int destlen = 0;
            try {
                int len1 = left.length();
                int len2 = right.length();
                destlen = PythonUtils.addExact(len1, len2);
                if (this.errorForOverflow == PythonErrorType.OverflowError && shouldOverflow.profile(inliningTarget, destlen >= Integer.MAX_VALUE)) {
                    throw raiseNode.raise(PythonErrorType.OverflowError);
                }
                SequenceStorage generalized = this.generalizeStore(this.createEmpty(createEmptyNode, inliningTarget, left, right, destlen), right);
                return this.doConcat(generalized, left, right);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(this.errorForOverflow);
            }
        }

        private SequenceStorage createEmpty(CreateEmptyNode createEmptyNode, Node inliningTarget, SequenceStorage l, SequenceStorage r, int len) {
            if (l instanceof EmptySequenceStorage) {
                return createEmptyNode.execute(inliningTarget, r, len, -1);
            }
            return createEmptyNode.execute(inliningTarget, l, len, len);
        }

        private SequenceStorage doConcat(SequenceStorage dest, SequenceStorage leftProfiled, SequenceStorage rightProfiled) {
            try {
                return this.concatBaseNode.execute(dest, leftProfiled, rightProfiled);
            }
            catch (SequenceStoreException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("generalized sequence storage cannot take value: " + String.valueOf(e.getIndicationValue()));
            }
        }

        private SequenceStorage generalizeStore(SequenceStorage storage, Object value) {
            if (this.genNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.genNode = (GeneralizationNode)this.insert((GeneralizationNode)((Object)this.genNodeProvider.get()));
            }
            return this.genNode.executeCached(storage, value);
        }

        @NeverDefault
        public static ConcatNode create() {
            return ConcatNode.create(() -> NoGeneralizationCustomMessageNode.create(DEFAULT_ERROR_MSG), PythonErrorType.MemoryError);
        }

        @NeverDefault
        public static ConcatNode createWithOverflowError() {
            return ConcatNode.create(() -> NoGeneralizationCustomMessageNode.create(DEFAULT_ERROR_MSG), PythonErrorType.OverflowError);
        }

        @NeverDefault
        public static ConcatNode create(TruffleString msg) {
            return ConcatNode.create(() -> NoGeneralizationCustomMessageNode.create(msg), PythonErrorType.MemoryError);
        }

        @NeverDefault
        public static ConcatNode create(Supplier<GeneralizationNode> genNodeProvider) {
            return ConcatNode.create(genNodeProvider, PythonErrorType.MemoryError);
        }

        @NeverDefault
        private static ConcatNode create(Supplier<GeneralizationNode> genNodeProvider, PythonBuiltinClassType errorForOverflow) {
            return SequenceStorageNodesFactory.ConcatNodeGen.create(genNodeProvider, errorForOverflow);
        }
    }

    public static abstract class ConcatBaseNode
    extends SequenceStorageBaseNode {
        public abstract SequenceStorage execute(SequenceStorage var1, SequenceStorage var2, SequenceStorage var3);

        @Specialization(guards={"!isNative(right)"})
        static SequenceStorage doLeftEmpty(EmptySequenceStorage dest, EmptySequenceStorage left, SequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="copyNode") @Cached CopyNode copyNode) {
            try {
                return copyNode.execute(inliningTarget, right);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
        }

        @Specialization(guards={"!isNative(left)"})
        static SequenceStorage doRightEmpty(EmptySequenceStorage dest, SequenceStorage left, EmptySequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="copyNode") @Cached CopyNode copyNode) {
            try {
                return copyNode.execute(inliningTarget, left);
            }
            catch (OutOfMemoryError e) {
                throw raiseNode.raise(PythonErrorType.MemoryError);
            }
        }

        @Specialization(guards={"dest == left", "left.getClass() == right.getClass()", "cachedClass == left.getClass()"}, limit="1")
        static SequenceStorage doArrayBasedManagedManagedSameTypeInplace(ArrayBasedSequenceStorage dest, ArrayBasedSequenceStorage left, ArrayBasedSequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached(value="left.getClass()") Class<? extends ArrayBasedSequenceStorage> cachedClass, @Cached.Shared @Cached SetLenNode setLenNode) {
            ArrayBasedSequenceStorage leftProfiled = cachedClass.cast(left);
            ArrayBasedSequenceStorage rightProfiled = cachedClass.cast(right);
            Object arr1 = leftProfiled.getInternalArrayObject();
            int len1 = leftProfiled.length();
            Object arr2 = rightProfiled.getInternalArrayObject();
            int len2 = rightProfiled.length();
            PythonUtils.arraycopy(arr2, 0, arr1, len1, len2);
            setLenNode.execute(inliningTarget, leftProfiled, len1 + len2);
            return leftProfiled;
        }

        @Specialization(guards={"dest != left", "dest.getClass() == left.getClass()", "left.getClass() == right.getClass()", "cachedClass == dest.getClass()"}, limit="1")
        static SequenceStorage doArrayBasedManagedManagedSameType(ArrayBasedSequenceStorage dest, ArrayBasedSequenceStorage left, ArrayBasedSequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached(value="left.getClass()") Class<? extends ArrayBasedSequenceStorage> cachedClass, @Cached.Shared @Cached SetLenNode setLenNode) {
            ArrayBasedSequenceStorage destProfiled = cachedClass.cast(dest);
            ArrayBasedSequenceStorage leftProfiled = cachedClass.cast(left);
            ArrayBasedSequenceStorage rightProfiled = cachedClass.cast(right);
            Object arr1 = leftProfiled.getInternalArrayObject();
            int len1 = leftProfiled.length();
            Object arr2 = rightProfiled.getInternalArrayObject();
            int len2 = rightProfiled.length();
            ConcatBaseNode.concat(destProfiled.getInternalArrayObject(), arr1, len1, arr2, len2);
            setLenNode.execute(inliningTarget, destProfiled, len1 + len2);
            return destProfiled;
        }

        @Specialization(guards={"dest.getClass() == right.getClass()", "cachedClass == dest.getClass()"}, limit="1")
        static SequenceStorage doArrayBasedEmptyManagedSameType(ArrayBasedSequenceStorage dest, EmptySequenceStorage left, ArrayBasedSequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached(value="dest.getClass()") Class<? extends ArrayBasedSequenceStorage> cachedClass, @Cached.Shared @Cached SetLenNode setLenNode) {
            ArrayBasedSequenceStorage destProfiled = cachedClass.cast(dest);
            ArrayBasedSequenceStorage rightProfiled = cachedClass.cast(right);
            Object arr2 = rightProfiled.getInternalArrayObject();
            int len2 = rightProfiled.length();
            PythonUtils.arraycopy(arr2, 0, destProfiled.getInternalArrayObject(), 0, len2);
            setLenNode.execute(inliningTarget, destProfiled, len2);
            return destProfiled;
        }

        @Specialization(guards={"dest.getClass() == left.getClass()", "cachedClass == dest.getClass()"}, limit="1")
        static SequenceStorage doArrayBasedManagedEmptySameType(ArrayBasedSequenceStorage dest, ArrayBasedSequenceStorage left, EmptySequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached(value="left.getClass()") Class<? extends ArrayBasedSequenceStorage> cachedClass, @Cached.Shared @Cached SetLenNode setLenNode) {
            ArrayBasedSequenceStorage destProfiled = cachedClass.cast(dest);
            ArrayBasedSequenceStorage leftProfiled = cachedClass.cast(left);
            Object arr1 = leftProfiled.getInternalArrayObject();
            int len1 = leftProfiled.length();
            PythonUtils.arraycopy(arr1, 0, destProfiled.getInternalArrayObject(), 0, len1);
            setLenNode.execute(inliningTarget, destProfiled, len1);
            return destProfiled;
        }

        @Specialization(guards={"dest == left"})
        static SequenceStorage doGenericInplace(SequenceStorage dest, SequenceStorage left, SequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetItemScalarNode getItemRightNode, @Cached.Exclusive @Cached InitializeItemScalarNode initializeItemNode, @Cached.Exclusive @Cached SetLenNode setLenNode) {
            int len1 = left.length();
            int len2 = right.length();
            for (int i = 0; i < len2; ++i) {
                initializeItemNode.execute(inliningTarget, left, i + len1, getItemRightNode.execute(inliningTarget, right, i));
            }
            setLenNode.execute(inliningTarget, left, len1 + len2);
            return left;
        }

        @Specialization(guards={"dest != left"})
        static SequenceStorage doGeneric(SequenceStorage dest, SequenceStorage left, SequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetItemScalarNode getItemLeftNode, @Cached.Exclusive @Cached GetItemScalarNode getItemRightNode, @Cached.Exclusive @Cached InitializeItemScalarNode initializeItemNode, @Cached.Exclusive @Cached SetLenNode setLenNode) {
            int i;
            int len1 = left.length();
            int len2 = right.length();
            for (i = 0; i < len1; ++i) {
                initializeItemNode.execute(inliningTarget, dest, i, getItemLeftNode.execute(inliningTarget, left, i));
            }
            for (i = 0; i < len2; ++i) {
                initializeItemNode.execute(inliningTarget, dest, i + len1, getItemRightNode.execute(inliningTarget, right, i));
            }
            setLenNode.execute(inliningTarget, dest, len1 + len2);
            return dest;
        }

        private static void concat(Object dest, Object arr1, int len1, Object arr2, int len2) {
            PythonUtils.arraycopy(arr1, 0, dest, 0, len1);
            PythonUtils.arraycopy(arr2, 0, dest, len1, len2);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ToByteArrayNode
    extends Node {
        public abstract byte[] execute(Node var1, SequenceStorage var2);

        public static byte[] executeUncached(SequenceStorage s) {
            return SequenceStorageNodesFactory.ToByteArrayNodeGen.getUncached().execute(null, s);
        }

        @Specialization
        static byte[] doByteSequenceStorage(Node inliningTarget, ByteSequenceStorage s, @Cached InlinedConditionProfile profile) {
            byte[] bytes = GetInternalByteArrayNode.doByteSequenceStorage(s);
            int storageLength = s.length();
            if (profile.profile(inliningTarget, storageLength != bytes.length)) {
                return ToByteArrayNode.exactCopy(bytes, storageLength);
            }
            return bytes;
        }

        @Specialization(guards={"!isByteSequenceStorage(s)"})
        static byte[] doOther(Node inliningTarget, SequenceStorage s, @Cached GetInternalByteArrayNode getInternalByteArrayNode) {
            return getInternalByteArrayNode.execute(inliningTarget, s);
        }

        private static byte[] exactCopy(byte[] barr, int len) {
            return PythonUtils.arrayCopyOf(barr, len);
        }

        static boolean isByteSequenceStorage(SequenceStorage s) {
            return s instanceof ByteSequenceStorage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class GetInternalByteArrayNode
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, SequenceStorage var2);

        @Specialization
        static byte[] doByteSequenceStorage(ByteSequenceStorage s) {
            return s.getInternalByteArray();
        }

        @Specialization
        static byte[] doNativeByte(Node inliningTarget, NativeByteSequenceStorage s, @Cached.Shared(value="getItemNode") @Cached GetItemScalarNode getItemNode) {
            byte[] barr = new byte[s.length()];
            for (int i = 0; i < barr.length; ++i) {
                int elem = getItemNode.executeKnownInt(inliningTarget, s, i);
                assert (elem >= 0 && elem < 256);
                barr[i] = (byte)elem;
            }
            return barr;
        }

        @Specialization(guards={"s.length() == cachedLen", "cachedLen <= 32"}, limit="1")
        @ExplodeLoop
        static byte[] doGenericLenCached(Node inliningTarget, SequenceStorage s, @Cached.Shared(value="getItemNode") @Cached GetItemScalarNode getItemNode, @Cached.Shared @Cached CastToJavaByteNode castToByteNode, @Cached(value="s.length()") int cachedLen) {
            byte[] barr = new byte[cachedLen];
            for (int i = 0; i < cachedLen; ++i) {
                barr[i] = castToByteNode.execute(inliningTarget, getItemNode.execute(inliningTarget, s, i));
            }
            return barr;
        }

        @Specialization(replaces={"doGenericLenCached"})
        @HostCompilerDirectives.InliningCutoff
        static byte[] doGeneric(Node inliningTarget, SequenceStorage s, @Cached.Shared(value="getItemNode") @Cached GetItemScalarNode getItemNode, @Cached.Shared @Cached CastToJavaByteNode castToByteNode) {
            byte[] barr = new byte[s.length()];
            for (int i = 0; i < barr.length; ++i) {
                barr[i] = castToByteNode.execute(inliningTarget, getItemNode.execute(inliningTarget, s, i));
            }
            return barr;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetInternalBytesNode
    extends PNodeWithContext {
        public final byte[] execute(Node inliningTarget, PBytesLike bytes) {
            return this.execute(null, inliningTarget, bytes);
        }

        public abstract byte[] execute(VirtualFrame var1, Node var2, Object var3);

        protected static boolean isByteSequenceStorage(PBytesLike bytes) {
            return bytes.getSequenceStorage() instanceof ByteSequenceStorage;
        }

        protected static boolean isSimple(Object bytes) {
            return bytes instanceof PBytesLike && GetInternalBytesNode.isByteSequenceStorage((PBytesLike)bytes);
        }

        @Specialization(guards={"isByteSequenceStorage(bytes)"})
        static byte[] doBytes(PBytesLike bytes) {
            return ((ByteSequenceStorage)bytes.getSequenceStorage()).getInternalByteArray();
        }

        @Specialization(guards={"!isSimple(bytes)"})
        static byte[] doGeneric(VirtualFrame frame, Object bytes, @Cached(inline=false) BytesNodes.ToBytesNode toBytesNode) {
            return toBytesNode.execute(frame, bytes);
        }
    }

    public static abstract class CmpNode
    extends SequenceStorageBaseNode {
        @Node.Child
        private BinaryComparisonNode cmpOp;
        @Node.Child
        private CoerceToBooleanNode castToBooleanNode;

        protected CmpNode(BinaryComparisonNode cmpOp) {
            this.cmpOp = cmpOp;
        }

        public abstract boolean execute(VirtualFrame var1, SequenceStorage var2, SequenceStorage var3);

        private boolean testingEqualsWithDifferingLengths(int llen, int rlen) {
            CompilerAsserts.compilationConstant(this.cmpOp.getClass());
            return this.cmpOp instanceof BinaryComparisonNode.EqNode && llen != rlen;
        }

        @Specialization(guards={"isEmpty(left)", "isEmpty(right)"})
        boolean doEmpty(SequenceStorage left, SequenceStorage right) {
            return this.cmpOp.cmp(0, 0);
        }

        @Specialization
        boolean doBoolStorage(BoolSequenceStorage left, BoolSequenceStorage right) {
            int rlen;
            int llen = left.length();
            if (this.testingEqualsWithDifferingLengths(llen, rlen = right.length())) {
                return false;
            }
            for (int i = 0; i < Math.min(llen, rlen); ++i) {
                int ritem;
                int litem = PInt.intValue(left.getBoolItemNormalized(i));
                if (litem == (ritem = PInt.intValue(right.getBoolItemNormalized(i)))) continue;
                return this.cmpOp.cmp(litem, ritem);
            }
            return this.cmpOp.cmp(llen, rlen);
        }

        @Specialization
        boolean doByteStorage(ByteSequenceStorage left, ByteSequenceStorage right) {
            int rlen;
            int llen = left.length();
            if (this.testingEqualsWithDifferingLengths(llen, rlen = right.length())) {
                return false;
            }
            for (int i = 0; i < Math.min(llen, rlen); ++i) {
                byte ritem;
                byte litem = left.getByteItemNormalized(i);
                if (litem == (ritem = right.getByteItemNormalized(i))) continue;
                return this.cmpOp.cmp(litem, ritem);
            }
            return this.cmpOp.cmp(llen, rlen);
        }

        @Specialization
        boolean doIntStorage(IntSequenceStorage left, IntSequenceStorage right) {
            int rlen;
            int llen = left.length();
            if (this.testingEqualsWithDifferingLengths(llen, rlen = right.length())) {
                return false;
            }
            for (int i = 0; i < Math.min(llen, rlen); ++i) {
                int ritem;
                int litem = left.getIntItemNormalized(i);
                if (litem == (ritem = right.getIntItemNormalized(i))) continue;
                return this.cmpOp.cmp(litem, ritem);
            }
            return this.cmpOp.cmp(llen, rlen);
        }

        @Specialization
        boolean doLongStorage(LongSequenceStorage left, LongSequenceStorage right) {
            int rlen;
            int llen = left.length();
            if (this.testingEqualsWithDifferingLengths(llen, rlen = right.length())) {
                return false;
            }
            for (int i = 0; i < Math.min(llen, rlen); ++i) {
                long ritem;
                long litem = left.getLongItemNormalized(i);
                if (litem == (ritem = right.getLongItemNormalized(i))) continue;
                return this.cmpOp.cmp(litem, ritem);
            }
            return this.cmpOp.cmp(llen, rlen);
        }

        @Specialization
        boolean doDoubleStorage(DoubleSequenceStorage left, DoubleSequenceStorage right) {
            int rlen;
            int llen = left.length();
            if (this.testingEqualsWithDifferingLengths(llen, rlen = right.length())) {
                return false;
            }
            for (int i = 0; i < Math.min(llen, rlen); ++i) {
                double ritem;
                double litem = left.getDoubleItemNormalized(i);
                if (Double.compare(litem, ritem = right.getDoubleItemNormalized(i)) == 0) continue;
                return this.cmpOp.cmp(litem, ritem);
            }
            return this.cmpOp.cmp(llen, rlen);
        }

        @Specialization
        boolean doGeneric(VirtualFrame frame, SequenceStorage left, SequenceStorage right, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached GetItemScalarNode getLeftItemNode, @Cached GetItemScalarNode getRightItemNode) {
            int rlen;
            int llen = left.length();
            if (this.testingEqualsWithDifferingLengths(llen, rlen = right.length())) {
                return false;
            }
            for (int i = 0; i < Math.min(llen, rlen); ++i) {
                Object rightItem;
                Object leftItem = getLeftItemNode.execute(inliningTarget, left, i);
                if (eqNode.compare((Frame)frame, inliningTarget, leftItem, rightItem = getRightItemNode.execute(inliningTarget, right, i))) continue;
                return this.cmpGeneric(frame, leftItem, rightItem);
            }
            return this.cmpOp.cmp(llen, rlen);
        }

        private boolean cmpGeneric(VirtualFrame frame, Object left, Object right) {
            return this.castToBoolean(frame, this.cmpOp.executeObject(frame, left, right));
        }

        private boolean castToBoolean(VirtualFrame frame, Object value) {
            if (this.castToBooleanNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.castToBooleanNode = (CoerceToBooleanNode)this.insert(CoerceToBooleanNode.createIfTrueNode());
            }
            return this.castToBooleanNode.executeBooleanCached(frame, value);
        }

        @NeverDefault
        public static CmpNode createLe() {
            return SequenceStorageNodesFactory.CmpNodeGen.create(BinaryComparisonNode.LeNode.create());
        }

        @NeverDefault
        public static CmpNode createLt() {
            return SequenceStorageNodesFactory.CmpNodeGen.create(BinaryComparisonNode.LtNode.create());
        }

        @NeverDefault
        public static CmpNode createGe() {
            return SequenceStorageNodesFactory.CmpNodeGen.create(BinaryComparisonNode.GeNode.create());
        }

        @NeverDefault
        public static CmpNode createGt() {
            return SequenceStorageNodesFactory.CmpNodeGen.create(BinaryComparisonNode.GtNode.create());
        }

        @NeverDefault
        public static CmpNode createEq() {
            return SequenceStorageNodesFactory.CmpNodeGen.create(BinaryComparisonNode.EqNode.create());
        }

        @NeverDefault
        public static CmpNode createNe() {
            return SequenceStorageNodesFactory.CmpNodeGen.create(BinaryComparisonNode.NeNode.create());
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class StorageToNativeNode
    extends Node {
        public abstract NativeByteSequenceStorage executeBytes(Node var1, byte[] var2, int var3, boolean var4);

        public abstract NativeSequenceStorage execute(Node var1, Object var2, int var3, boolean var4);

        public final NativeByteSequenceStorage executeBytes(Node inliningTarget, byte[] obj, int length) {
            return this.executeBytes(inliningTarget, obj, length, true);
        }

        public static NativeSequenceStorage executeUncached(Object obj, int length) {
            return SequenceStorageNodesFactory.StorageToNativeNodeGen.getUncached().execute(null, obj, length);
        }

        public final NativeSequenceStorage execute(Node inliningTarget, Object obj, int length) {
            return this.execute(inliningTarget, obj, length, true);
        }

        @Specialization
        static NativeByteSequenceStorage doByte(byte[] arr, int length, boolean createRef, @Cached.Shared @Cached(inline=false) CStructAccess.AllocateNode alloc, @Cached(inline=false) CStructAccess.WriteByteNode write) {
            Object mem = alloc.calloc((long)(arr.length + 1), 1L);
            write.writeByteArray(mem, arr);
            return NativeByteSequenceStorage.create(mem, length, arr.length, createRef);
        }

        @Specialization
        static NativeSequenceStorage doObject(Object[] arr, int length, boolean createRef, @Cached.Shared @Cached(inline=false) CStructAccess.AllocateNode alloc, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode write) {
            Object mem = alloc.calloc((long)(arr.length + 1), 8L);
            write.writeArray(mem, arr, length, 0, 0L);
            return NativeObjectSequenceStorage.create(mem, length, arr.length, createRef);
        }
    }

    @GenerateUncached
    @ImportStatic(value={SequenceStorageBaseNode.class})
    static abstract class SetStorageSliceNode
    extends Node {
        SetStorageSliceNode() {
        }

        public abstract void execute(SequenceStorage var1, PSlice.SliceInfo var2, SequenceStorage var3, boolean var4);

        @Specialization(limit="MAX_BASIC_STORAGES", guards={"self.getClass() == cachedClass", "self.getClass() == sequence.getClass()", "replacesWholeSequence(cachedClass, self, info)"})
        static void doWholeSequence(ArrayBasedSequenceStorage self, PSlice.SliceInfo info, ArrayBasedSequenceStorage sequence, boolean canGeneralize, @Cached(value="self.getClass()") Class<? extends ArrayBasedSequenceStorage> cachedClass) {
            ArrayBasedSequenceStorage selfProfiled = cachedClass.cast(self);
            ArrayBasedSequenceStorage otherProfiled = cachedClass.cast(sequence);
            selfProfiled.setInternalArrayObject(otherProfiled.getCopyOfInternalArrayObject());
            selfProfiled.setNewLength(otherProfiled.length());
            selfProfiled.minimizeCapacity();
        }

        @Specialization(guards={"!canGeneralize || isDataTypeCompatibleNode.execute(inliningTarget, self, values)", "sinfo.step == 1"}, limit="1")
        static void singleStep(SequenceStorage self, PSlice.SliceInfo sinfo, SequenceStorage values, boolean canGeneralize, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached IsDataTypeCompatibleNode isDataTypeCompatibleNode, @Cached.Exclusive @Cached SetLenNode setLenNode, @Cached.Exclusive @Cached EnsureCapacityNode ensureCapacityNode, @Cached.Exclusive @Cached MemMoveNode memove, @Cached.Exclusive @Cached MemCopyNode memcpy, @Cached.Exclusive @Cached CopyNode copyNode, @Cached.Exclusive @Cached InlinedConditionProfile memoryError, @Cached.Exclusive @Cached InlinedConditionProfile negGrowth, @Cached.Exclusive @Cached InlinedConditionProfile posGrowth, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int start = sinfo.start;
            int stop = sinfo.stop;
            int step = sinfo.step;
            SequenceStorage data = values == self ? copyNode.execute(inliningTarget, values) : values;
            int needed = data.length();
            if (step < 0 && start < stop || step > 0 && start > stop) {
                stop = start;
            }
            SetStorageSliceNode.singleStep(self, start, stop, data, needed, inliningTarget, setLenNode, ensureCapacityNode, memove, memcpy, memoryError, negGrowth, posGrowth, raiseNode);
        }

        @Specialization(guards={"!canGeneralize || isDataTypeCompatibleNode.execute(inliningTarget, self, values)", "sinfo.step != 1"}, limit="1")
        static void multiStep(SequenceStorage self, PSlice.SliceInfo sinfo, SequenceStorage values, boolean canGeneralize, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached IsDataTypeCompatibleNode isDataTypeCompatibleNode, @Cached.Exclusive @Cached InlinedConditionProfile wrongLength, @Cached.Exclusive @Cached InlinedConditionProfile deleteSlice, @Cached.Exclusive @Cached SetLenNode setLenNode, @Cached.Exclusive @Cached EnsureCapacityNode ensureCapacityNode, @Cached.Exclusive @Cached MemMoveNode memove, @Cached SetItemScalarNode setLeftItemNode, @Cached GetItemScalarNode getRightItemNode, @Cached.Shared @Cached PRaiseNode raiseNode, @Cached.Exclusive @Cached CopyNode copyNode) {
            int start = sinfo.start;
            int step = sinfo.step;
            int slicelen = sinfo.sliceLength;
            assert (slicelen != -1) : "slice info has not been adjusted";
            SequenceStorage data = values == self ? copyNode.execute(inliningTarget, values) : values;
            int needed = data.length();
            if (deleteSlice.profile(inliningTarget, needed == 0)) {
                DeleteSliceNode.multipleSteps(self, sinfo, inliningTarget, setLenNode, ensureCapacityNode, memove);
            } else {
                if (wrongLength.profile(inliningTarget, needed != slicelen)) {
                    raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.ATTEMPT_TO_ASSIGN_SEQ_OF_SIZE_TO_SLICE_OF_SIZE, needed, slicelen);
                }
                int cur = start;
                for (int i = 0; i < slicelen; ++i) {
                    setLeftItemNode.execute(inliningTarget, self, cur, getRightItemNode.execute(inliningTarget, data, i));
                    cur += step;
                }
            }
        }

        @Specialization(guards={"canGeneralize", "!isAssignCompatibleNode.execute(inliningTarget, self, sequence)"}, limit="1")
        static void doError(SequenceStorage self, PSlice.SliceInfo info, SequenceStorage sequence, boolean canGeneralize, @Bind(value="this") Node inliningTarget, @Cached IsAssignCompatibleNode isAssignCompatibleNode) {
            throw new SequenceStoreException(sequence.getIndicativeValue());
        }

        static void singleStep(SequenceStorage self, int lo, int hi, SequenceStorage data, int needed, Node inliningTarget, SetLenNode setLenNode, EnsureCapacityNode ensureCapacityNode, MemMoveNode memove, MemCopyNode memcpy, InlinedConditionProfile memoryError, InlinedConditionProfile negGrowth, InlinedConditionProfile posGrowth, PRaiseNode raiseNode) {
            int avail = hi - lo;
            int growth = needed - avail;
            assert (avail >= 0) : "sliceInfo.start and sliceInfo.stop have not been adjusted.";
            int len = self.length();
            if (negGrowth.profile(inliningTarget, growth < 0)) {
                ensureCapacityNode.execute(inliningTarget, self, len + growth);
                memove.execute(inliningTarget, self, lo + needed, hi, len - hi);
                setLenNode.execute(inliningTarget, self, len + growth);
            } else if (posGrowth.profile(inliningTarget, growth > 0)) {
                ensureCapacityNode.execute(inliningTarget, self, len + growth);
                if (memoryError.profile(inliningTarget, len > Integer.MAX_VALUE - growth)) {
                    throw raiseNode.raise(PythonErrorType.MemoryError);
                }
                setLenNode.execute(inliningTarget, self, len += growth);
                memove.execute(inliningTarget, self, lo + needed, hi, len - lo - needed);
            }
            if (needed > 0) {
                memcpy.execute(inliningTarget, self, lo, data, 0, needed);
            }
        }

        protected static boolean replacesWholeSequence(Class<? extends ArrayBasedSequenceStorage> cachedClass, ArrayBasedSequenceStorage s, PSlice.SliceInfo info) {
            return info.start == 0 && info.step == 1 && info.stop == cachedClass.cast(s).length();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class ReverseNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, SequenceStorage var2);

        @Specialization
        static void doEmpty(EmptySequenceStorage storage) {
        }

        @Specialization
        static void doIntStorage(IntSequenceStorage storage) {
            storage.reverse();
        }

        @Specialization
        static void doDoubleStorage(DoubleSequenceStorage storage) {
            storage.reverse();
        }

        @Specialization
        static void doLongStorage(LongSequenceStorage storage) {
            storage.reverse();
        }

        @Specialization
        static void doByteStorage(ByteSequenceStorage storage) {
            storage.reverse();
        }

        @Specialization
        static void doObjectStorage(ObjectSequenceStorage storage) {
            storage.reverse();
        }

        @Specialization
        static void doNativePrimitive(Node inliningTarget, NativePrimitiveSequenceStorage storage) {
            int length = storage.length();
            Unsafe unsafe = PythonContext.get(inliningTarget).getUnsafe();
            long itemSize = storage.getItemSize();
            long startAddress = storage.getValueBufferAddr();
            byte[] tempBuffer = new byte[(int)itemSize];
            for (long endAddress = startAddress + (long)(length - 1) * itemSize; startAddress < endAddress; startAddress += itemSize, endAddress -= itemSize) {
                unsafe.copyMemory(null, startAddress, tempBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, itemSize);
                unsafe.copyMemory(endAddress, startAddress, itemSize);
                unsafe.copyMemory(tempBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, null, endAddress, itemSize);
            }
        }

        @Specialization
        static void doBoolStorage(BoolSequenceStorage storage) {
            storage.reverse();
        }

        @Specialization
        static void doMroStorage(MroSequenceStorage storage) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void doNative(NativeSequenceStorage storage, @Cached(inline=false) ReverseNativeNode reverseNativeNode) {
            reverseNativeNode.execute(storage);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void doForeign(Node inliningTarget, ForeignSequenceStorage storage, @Cached ForeignSequenceStorage.ReadNoConversionNode readNode, @Cached ForeignSequenceStorage.WriteNode writeNode) {
            int length = storage.length();
            if (length > 0) {
                int head = 0;
                int tail = length - 1;
                int middle = (length - 1) / 2;
                while (head <= middle) {
                    Object temp = readNode.execute(inliningTarget, storage, head);
                    writeNode.execute(inliningTarget, storage, head, readNode.execute(inliningTarget, storage, tail));
                    writeNode.execute(inliningTarget, storage, tail, temp);
                    ++head;
                    --tail;
                }
            }
        }

        @GenerateUncached
        @GenerateInline(value=false)
        static abstract class ReverseNativeNode
        extends Node {
            ReverseNativeNode() {
            }

            abstract void execute(NativeSequenceStorage var1);

            @Specialization
            static void doNativeByte(NativeByteSequenceStorage storage, @Cached CStructAccess.ReadByteNode readByteNode, @Cached CStructAccess.WriteByteNode writeByteNode) {
                int length = storage.length();
                if (length > 0) {
                    int head = 0;
                    int tail = length - 1;
                    int middle = (length - 1) / 2;
                    Object ptr = storage.getPtr();
                    while (head <= middle) {
                        byte temp = readByteNode.readArrayElement(ptr, head);
                        writeByteNode.writeArrayElement(ptr, head, readByteNode.readArrayElement(ptr, tail));
                        writeByteNode.writeArrayElement(ptr, tail, temp);
                        ++head;
                        --tail;
                    }
                }
            }

            @Specialization
            static void doNativeObject(NativeObjectSequenceStorage storage, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.WritePointerNode writePointerNode) {
                int length = storage.length();
                if (length > 0) {
                    int head = 0;
                    int tail = length - 1;
                    int middle = (length - 1) / 2;
                    Object ptr = storage.getPtr();
                    while (head <= middle) {
                        Object temp = readPointerNode.readArrayElement(ptr, head);
                        writePointerNode.writeArrayElement(ptr, head, readPointerNode.readArrayElement(ptr, tail));
                        writePointerNode.writeArrayElement(ptr, tail, temp);
                        ++head;
                        --tail;
                    }
                }
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class MemCopyNode
    extends Node {
        public abstract void execute(Node var1, SequenceStorage var2, int var3, SequenceStorage var4, int var5, int var6);

        @Specialization(guards={"length <= 0"})
        protected static void nothing(SequenceStorage dist, int distPos, SequenceStorage src, int srcPos, int length) {
        }

        @Specialization(limit="MAX_BASIC_STORAGES", guards={"length > 0", "dist.getClass() == cachedClass", "src.getClass() == dist.getClass()"})
        protected static void doArrayBasedCopy(ArrayBasedSequenceStorage dist, int distPos, ArrayBasedSequenceStorage src, int srcPos, int length, @Cached(value="dist.getClass()") Class<? extends ArrayBasedSequenceStorage> cachedClass) {
            Object distArray = cachedClass.cast(dist).getInternalArrayObject();
            Object srcArray = cachedClass.cast(src).getInternalArrayObject();
            PythonUtils.arraycopy(srcArray, srcPos, distArray, distPos, length);
        }

        @Specialization(guards={"length > 0", "!isArrayBasedSequenceStorage(dist) || dist.getClass() != src.getClass()"})
        protected static void doOther(Node inliningTarget, SequenceStorage dist, int distPos, SequenceStorage src, int srcPos, int length, @Cached SetItemScalarNode setLeftItemNode, @Cached GetItemScalarNode getRightItemNode) {
            int cur = distPos;
            int j = srcPos;
            for (int i = 0; i < length; ++i) {
                setLeftItemNode.execute(inliningTarget, dist, cur, getRightItemNode.execute(inliningTarget, src, j));
                ++cur;
                ++j;
            }
        }

        protected static boolean isArrayBasedSequenceStorage(Object o) {
            return o instanceof ArrayBasedSequenceStorage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class MemMoveNode
    extends Node {
        public abstract void execute(Node var1, SequenceStorage var2, int var3, int var4, int var5);

        public static void executeUncached(SequenceStorage s, int distPos, int srcPos, int length) {
            SequenceStorageNodesFactory.MemMoveNodeGen.getUncached().execute(null, s, distPos, srcPos, length);
        }

        @Specialization(guards={"length <= 0"})
        protected static void nothing(SequenceStorage storage, int distPos, int srcPos, int length) {
        }

        @Specialization(limit="MAX_BASIC_STORAGES", guards={"length > 0", "storage.getClass() == cachedClass"})
        protected static void doArrayBasedMove(ArrayBasedSequenceStorage storage, int distPos, int srcPos, int length, @Cached(value="storage.getClass()") Class<? extends ArrayBasedSequenceStorage> cachedClass) {
            Object array = cachedClass.cast(storage).getInternalArrayObject();
            PythonUtils.arraycopy(array, srcPos, array, distPos, length);
        }

        @Specialization(guards={"length > 0", "!isArrayBasedSequenceStorage(storage)"})
        protected static void doOther(Node inliningTarget, SequenceStorage storage, int distPos, int srcPos, int length, @Cached SetItemScalarNode setLeftItemNode, @Cached GetItemScalarNode getRightItemNode) {
            if (srcPos < distPos && srcPos + length > distPos) {
                MemMoveNode.copyBackward(inliningTarget, storage, getRightItemNode, setLeftItemNode, distPos, srcPos, length);
            } else {
                MemMoveNode.copyForward(inliningTarget, storage, getRightItemNode, setLeftItemNode, distPos, srcPos, length);
            }
        }

        private static void copyForward(Node inliningTarget, SequenceStorage storage, GetItemScalarNode getRightItemNode, SetItemScalarNode setLeftItemNode, int destPos, int srcPos, int length) {
            while (length > 0) {
                Object value = getRightItemNode.execute(inliningTarget, storage, srcPos);
                setLeftItemNode.execute(inliningTarget, storage, destPos, value);
                ++destPos;
                ++srcPos;
                --length;
            }
        }

        private static void copyBackward(Node inliningTarget, SequenceStorage storage, GetItemScalarNode getRightItemNode, SetItemScalarNode setLeftItemNode, int destPos, int srcPos, int length) {
            destPos += length;
            srcPos += length;
            while (length > 0) {
                --length;
                Object value = getRightItemNode.execute(inliningTarget, storage, --srcPos);
                setLeftItemNode.execute(inliningTarget, storage, --destPos, value);
            }
        }

        protected static boolean isArrayBasedSequenceStorage(Object o) {
            return o instanceof ArrayBasedSequenceStorage;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorage.StorageType.class, SequenceStorageBaseNode.class})
    public static abstract class SetItemSliceNode
    extends Node {
        public abstract void execute(Frame var1, Node var2, SequenceStorage var3, PSlice.SliceInfo var4, Object var5, boolean var6);

        public final void execute(Frame frame, Node inliningTarget, SequenceStorage s, PSlice.SliceInfo info, Object iterable) {
            this.execute(frame, inliningTarget, s, info, iterable, true);
        }

        @Specialization(guards={"hasStorage(seq)"})
        static void doStorage(Node inliningTarget, SequenceStorage s, PSlice.SliceInfo info, PSequence seq, boolean canGeneralize, @Cached.Shared(value="setStorageSliceNode") @Cached(inline=false) SetStorageSliceNode setStorageSliceNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode) {
            setStorageSliceNode.execute(s, info, getSequenceStorageNode.execute(inliningTarget, seq), canGeneralize);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void doGeneric(VirtualFrame frame, SequenceStorage s, PSlice.SliceInfo info, Object iterable, boolean canGeneralize, @Cached.Shared(value="setStorageSliceNode") @Cached(inline=false) SetStorageSliceNode setStorageSliceNode, @Cached(inline=false) ListNodes.ConstructListNode constructListNode) {
            PList list = constructListNode.execute((Frame)frame, iterable);
            setStorageSliceNode.execute(s, info, list.getSequenceStorage(), canGeneralize);
        }
    }

    @GenerateUncached
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class InitializeNativeItemScalarNode
    extends Node {
        public abstract void execute(NativeSequenceStorage var1, int var2, Object var3);

        @Specialization
        protected static void doNativeByte(NativeByteSequenceStorage storage, int idx, Object value, @Cached CStructAccess.WriteByteNode writeNode, @Cached CastToByteNode castToByteNode) {
            writeNode.writeArrayElement(storage.getPtr(), idx, castToByteNode.execute(null, value));
        }

        @Specialization
        protected static void doNativeObject(NativeObjectSequenceStorage storage, int idx, Object value, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CApiTransitions.PythonToNativeNewRefNode toNative) {
            writePointerNode.writeArrayElement(storage.getPtr(), idx, toNative.execute(value));
        }
    }

    @GenerateUncached
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class SetNativeItemScalarNode
    extends Node {
        public abstract void execute(NativeSequenceStorage var1, int var2, Object var3);

        @Specialization
        protected static void doNativeByte(NativeByteSequenceStorage storage, int idx, Object value, @Cached CStructAccess.WriteByteNode writeNode, @Cached CastToByteNode castToByteNode) {
            writeNode.writeArrayElement(storage.getPtr(), idx, castToByteNode.execute(null, value));
        }

        @Specialization
        protected static void doNativeObject(NativeObjectSequenceStorage storage, int idx, Object value, @Bind(value="this") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNewRefNode toNative, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CExtNodes.XDecRefPointerNode decRefPointerNode) {
            Object old = readPointerNode.readArrayElement(storage.getPtr(), idx);
            writePointerNode.writeArrayElement(storage.getPtr(), idx, toNative.execute(value));
            decRefPointerNode.execute(inliningTarget, old);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class InitializeItemScalarNode
    extends AbstractSetItemScalarNode {
        @HostCompilerDirectives.InliningCutoff
        @Specialization
        protected static void doNative(NativeSequenceStorage storage, int idx, Object value, @Cached(inline=false) InitializeNativeItemScalarNode initializeItem) {
            initializeItem.execute(storage, idx, value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetItemScalarGeneralizingNode
    extends Node {
        public abstract SequenceStorage execute(Node var1, SequenceStorage var2, int var3, Object var4, GenNodeSupplier var5);

        @Specialization
        static SequenceStorage set(Node inliningTarget, SequenceStorage storage, int idx, Object value, GenNodeSupplier genNodeSupplier, @Cached InlinedBranchProfile generalizeProfile, @Cached SetItemScalarNode setItemScalarNode, @Cached DoGeneralizationNode doGeneralizationNode) {
            try {
                setItemScalarNode.execute(inliningTarget, storage, idx, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = doGeneralizationNode.execute(inliningTarget, genNodeSupplier, storage, e.getIndicationValue());
                try {
                    setItemScalarNode.execute(inliningTarget, generalized, idx, value);
                }
                catch (SequenceStoreException e1) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException();
                }
                return generalized;
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetItemScalarNode
    extends AbstractSetItemScalarNode {
        @HostCompilerDirectives.InliningCutoff
        @Specialization
        protected static void doNative(NativeSequenceStorage storage, int idx, Object value, @Cached(inline=false) SetNativeItemScalarNode setItem) {
            setItem.execute(storage, idx, value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SequenceStorageBaseNode.class, PGuards.class})
    public static abstract class AbstractSetItemScalarNode
    extends PNodeWithContext {
        public abstract void execute(Node var1, SequenceStorage var2, int var3, Object var4);

        @Specialization
        protected static void doBoolean(Node inliningTarget, BoolSequenceStorage storage, int idx, boolean value) {
            storage.setBoolItemNormalized(idx, value);
        }

        @Specialization
        protected static void doByteSimple(Node inliningTarget, ByteSequenceStorage storage, int idx, byte value) {
            storage.setByteItemNormalized(idx, value);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(replaces={"doByteSimple"})
        protected static void doByte(Node inliningTarget, ByteSequenceStorage storage, int idx, Object value, @Cached(inline=false) CastToByteNode castToByteNode) {
            storage.setByteItemNormalized(idx, castToByteNode.execute(null, value));
        }

        @Specialization
        protected static void doInt(Node inliningTarget, IntSequenceStorage storage, int idx, int value) {
            storage.setIntItemNormalized(idx, value);
        }

        @Specialization
        protected static void doNativeInt(Node inliningTarget, NativeIntSequenceStorage storage, int idx, int value) {
            storage.setIntItemNormalized(idx, value);
        }

        @Specialization(rewriteOn={OverflowException.class})
        protected static void doIntL(Node inliningTarget, IntSequenceStorage storage, int idx, long value) throws OverflowException {
            storage.setIntItemNormalized(idx, PInt.intValueExact(value));
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(replaces={"doIntL"})
        protected static void doIntLOvf(Node inliningTarget, IntSequenceStorage storage, int idx, long value) {
            try {
                storage.setIntItemNormalized(idx, PInt.intValueExact(value));
            }
            catch (OverflowException e) {
                throw new SequenceStoreException(value);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isNativeWrapper(value)"})
        protected static void doInt(Node inliningTarget, IntSequenceStorage storage, int idx, PInt value) {
            try {
                storage.setIntItemNormalized(idx, value.intValueExact());
            }
            catch (OverflowException e) {
                throw new SequenceStoreException(value);
            }
        }

        @Specialization
        protected static void doLong(Node inliningTarget, LongSequenceStorage storage, int idx, long value) {
            storage.setLongItemNormalized(idx, value);
        }

        @Specialization
        protected static void doLong(Node inliningTarget, LongSequenceStorage storage, int idx, int value) {
            storage.setLongItemNormalized(idx, value);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isNativeWrapper(value)"})
        protected static void doLong(Node inliningTarget, LongSequenceStorage storage, int idx, PInt value) {
            try {
                storage.setLongItemNormalized(idx, value.longValueExact());
            }
            catch (OverflowException e) {
                throw new SequenceStoreException(value);
            }
        }

        @Specialization
        protected static void doDouble(Node inliningTarget, DoubleSequenceStorage storage, int idx, double value) {
            storage.setDoubleItemNormalized(idx, value);
        }

        @Specialization
        protected static void doObject(Node inliningTarget, ObjectSequenceStorage storage, int idx, Object value) {
            storage.setObjectItemNormalized(idx, value);
        }

        @Specialization
        protected static void doForeign(Node inliningTarget, ForeignSequenceStorage storage, int idx, Object value, @Cached ForeignSequenceStorage.WriteNode writeNode) {
            writeNode.execute(inliningTarget, storage, idx, value);
        }

        @Fallback
        static void doError(Node inliningTarget, SequenceStorage s, int idx, Object item) {
            throw new SequenceStoreException(item);
        }
    }

    public static abstract class SetItemNode
    extends NormalizingNode {
        @Node.Child
        private GeneralizationNode generalizationNode;
        private final Supplier<GeneralizationNode> generalizationNodeProvider;

        public SetItemNode(IndexNodes.NormalizeIndexNode normalizeIndexNode, Supplier<GeneralizationNode> generalizationNodeProvider) {
            super(normalizeIndexNode);
            this.generalizationNodeProvider = generalizationNodeProvider;
        }

        public abstract SequenceStorage execute(VirtualFrame var1, SequenceStorage var2, Object var3, Object var4);

        protected abstract SequenceStorage execute(VirtualFrame var1, SequenceStorage var2, int var3, Object var4);

        public final SequenceStorage execute(SequenceStorage s, int key, Object value) {
            return this.execute((VirtualFrame)null, s, key, value);
        }

        protected abstract SequenceStorage execute(VirtualFrame var1, SequenceStorage var2, int var3, int var4);

        public final SequenceStorage execute(SequenceStorage s, int key, int value) {
            return this.execute((VirtualFrame)null, s, key, value);
        }

        protected abstract SequenceStorage execute(VirtualFrame var1, SequenceStorage var2, int var3, double var4);

        public final SequenceStorage execute(SequenceStorage s, int key, double value) {
            return this.execute((VirtualFrame)null, s, key, value);
        }

        @Specialization
        protected SequenceStorage doScalarInt(IntSequenceStorage storage, int idx, int value) {
            int normalized = this.normalizeIndex(idx, storage);
            storage.setIntItemNormalized(normalized, value);
            return storage;
        }

        @Specialization
        protected SequenceStorage doScalarInt(DoubleSequenceStorage storage, int idx, double value) {
            int normalized = this.normalizeIndex(idx, storage);
            storage.setDoubleItemNormalized(normalized, value);
            return storage;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        protected SequenceStorage doScalarInt(SequenceStorage storage, int idx, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared(value="setItemScalarNode") @Cached SetItemScalarNode setItemScalarNode) {
            int normalized = this.normalizeIndex(idx, storage);
            try {
                setItemScalarNode.execute(inliningTarget, storage, normalized, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = this.generalizeStore(storage, e.getIndicationValue());
                try {
                    setItemScalarNode.execute(inliningTarget, generalized, normalized, value);
                }
                catch (SequenceStoreException e1) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException();
                }
                return generalized;
            }
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        protected SequenceStorage doScalarLong(VirtualFrame frame, SequenceStorage storage, long idx, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared(value="setItemScalarNode") @Cached SetItemScalarNode setItemScalarNode) {
            int normalized = this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage);
            try {
                setItemScalarNode.execute(inliningTarget, storage, normalized, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = this.generalizeStore(storage, e.getIndicationValue());
                setItemScalarNode.execute(inliningTarget, generalized, normalized, value);
                return generalized;
            }
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        protected SequenceStorage doScalarPInt(VirtualFrame frame, SequenceStorage storage, PInt idx, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared(value="setItemScalarNode") @Cached SetItemScalarNode setItemScalarNode) {
            int normalized = this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage);
            try {
                setItemScalarNode.execute(inliningTarget, storage, normalized, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = this.generalizeStore(storage, e.getIndicationValue());
                setItemScalarNode.execute(inliningTarget, generalized, normalized, value);
                return generalized;
            }
        }

        @Specialization(guards={"!isPSlice(idx)"})
        @HostCompilerDirectives.InliningCutoff
        protected SequenceStorage doScalarGeneric(VirtualFrame frame, SequenceStorage storage, Object idx, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared(value="setItemScalarNode") @Cached SetItemScalarNode setItemScalarNode) {
            int normalized = this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage);
            try {
                setItemScalarNode.execute(inliningTarget, storage, normalized, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = this.generalizeStore(storage, e.getIndicationValue());
                setItemScalarNode.execute(inliningTarget, generalized, normalized, value);
                return generalized;
            }
        }

        @Specialization
        protected SequenceStorage doSliceSequence(VirtualFrame frame, SequenceStorage storage, PSlice slice, PSequence sequence, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared @Cached SetItemSliceNode setItemSliceNode, @Cached.Shared @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached.Shared @Cached SliceNodes.SliceUnpack unpack, @Cached.Shared @Cached SliceNodes.AdjustIndices adjustIndices) {
            PSlice.SliceInfo unadjusted = unpack.execute(inliningTarget, sliceCast.execute(inliningTarget, slice));
            int len = storage.length();
            PSlice.SliceInfo info = adjustIndices.execute(inliningTarget, len, unadjusted);
            try {
                setItemSliceNode.execute((Frame)frame, inliningTarget, storage, info, sequence, true);
                return storage;
            }
            catch (SequenceStoreException e) {
                return this.generalize(frame, storage, sequence, inliningTarget, generalizeProfile, setItemSliceNode, info, e);
            }
        }

        @Specialization(replaces={"doSliceSequence"})
        @HostCompilerDirectives.InliningCutoff
        protected SequenceStorage doSliceGeneric(VirtualFrame frame, SequenceStorage storage, PSlice slice, Object iterable, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared @Cached SetItemSliceNode setItemSliceNode, @Cached ListNodes.ConstructListNode constructListNode, @Cached.Shared @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached.Shared @Cached SliceNodes.SliceUnpack unpack, @Cached.Shared @Cached SliceNodes.AdjustIndices adjustIndices) {
            PSlice.SliceInfo unadjusted = unpack.execute(inliningTarget, sliceCast.execute(inliningTarget, slice));
            int len = storage.length();
            PSlice.SliceInfo info = adjustIndices.execute(inliningTarget, len, unadjusted);
            PList values = constructListNode.execute((Frame)frame, iterable);
            try {
                setItemSliceNode.execute((Frame)frame, inliningTarget, storage, info, values, true);
                return storage;
            }
            catch (SequenceStoreException e) {
                return this.generalize(frame, storage, values, inliningTarget, generalizeProfile, setItemSliceNode, info, e);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private SequenceStorage generalize(VirtualFrame frame, SequenceStorage storage, PSequence sequence, Node inliningTarget, InlinedBranchProfile generalizeProfile, SetItemSliceNode setItemSliceNode, PSlice.SliceInfo info, SequenceStoreException e) {
            generalizeProfile.enter(inliningTarget);
            SequenceStorage generalized = this.generalizeStore(storage, e.getIndicationValue());
            setItemSliceNode.execute((Frame)frame, inliningTarget, generalized, info, sequence, false);
            return generalized;
        }

        private SequenceStorage generalizeStore(SequenceStorage storage, Object value) {
            if (this.generalizationNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.generalizationNode = (GeneralizationNode)this.insert((GeneralizationNode)((Object)this.generalizationNodeProvider.get()));
            }
            return this.generalizationNode.executeCached(storage, value);
        }

        @NeverDefault
        public static SetItemNode create(IndexNodes.NormalizeIndexNode normalizeIndexNode, Supplier<GeneralizationNode> generalizationNodeProvider) {
            return SequenceStorageNodesFactory.SetItemNodeGen.create(normalizeIndexNode, generalizationNodeProvider);
        }

        @NeverDefault
        public static SetItemNode create(IndexNodes.NormalizeIndexNode normalizeIndexNode, TruffleString invalidItemErrorMessage) {
            return SequenceStorageNodesFactory.SetItemNodeGen.create(normalizeIndexNode, () -> NoGeneralizationCustomMessageNode.create(invalidItemErrorMessage));
        }

        @NeverDefault
        public static SetItemNode create(TruffleString invalidItemErrorMessage) {
            return SequenceStorageNodesFactory.SetItemNodeGen.create(IndexNodes.NormalizeIndexNode.create(), () -> NoGeneralizationCustomMessageNode.create(invalidItemErrorMessage));
        }

        @NeverDefault
        public static SetItemNode createForList() {
            return SetItemNode.create(IndexNodes.NormalizeIndexNode.forListAssign(), ListGeneralizationNode::create);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class DoGeneralizationNode
    extends Node {
        DoGeneralizationNode() {
        }

        public abstract SequenceStorage execute(Node var1, GenNodeSupplier var2, SequenceStorage var3, Object var4);

        @Specialization(guards={"supplier == cachedSupplier"}, limit="1")
        static SequenceStorage doCached(GenNodeSupplier supplier, SequenceStorage storage, Object value, @Cached(value="supplier") GenNodeSupplier cachedSupplier, @Cached(value="supplier.create()", uncached="supplier.getUncached()", inline=false) GeneralizationNode genNode) {
            return genNode.executeCached(storage, value);
        }

        @Specialization(replaces={"doCached"})
        static SequenceStorage doUncached(GenNodeSupplier supplier, SequenceStorage storage, Object value) {
            return supplier.getUncached().executeCached(storage, value);
        }
    }

    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class SetItemDynamicNode
    extends Node {
        public abstract SequenceStorage execute(Frame var1, GenNodeSupplier var2, SequenceStorage var3, Object var4, Object var5);

        @Specialization
        protected static SequenceStorage doScalarInt(GenNodeSupplier generalizationNodeProvider, SequenceStorage storage, int idx, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared(value="setItemScalarNode") @Cached SetItemScalarNode setItemScalarNode, @Cached.Shared(value="doGenNode") @Cached DoGeneralizationNode doGenNode, @Cached.Shared(value="normalizeNode") @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeNode) {
            int normalized = normalizeNode.execute(idx, storage.length(), ErrorMessages.INDEX_OUT_OF_RANGE);
            try {
                setItemScalarNode.execute(inliningTarget, storage, normalized, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = doGenNode.execute(inliningTarget, generalizationNodeProvider, storage, e.getIndicationValue());
                try {
                    setItemScalarNode.execute(inliningTarget, generalized, normalized, value);
                }
                catch (SequenceStoreException e1) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException();
                }
                return generalized;
            }
        }

        @Specialization
        protected static SequenceStorage doScalarLong(GenNodeSupplier generalizationNodeProvider, SequenceStorage storage, long idx, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared(value="setItemScalarNode") @Cached SetItemScalarNode setItemScalarNode, @Cached.Shared(value="doGenNode") @Cached DoGeneralizationNode doGenNode, @Cached.Shared(value="normalizeNode") @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeNode) {
            int normalized = normalizeNode.execute(idx, storage.length(), ErrorMessages.INDEX_OUT_OF_RANGE);
            try {
                setItemScalarNode.execute(inliningTarget, storage, normalized, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = doGenNode.execute(inliningTarget, generalizationNodeProvider, storage, e.getIndicationValue());
                setItemScalarNode.execute(inliningTarget, generalized, normalized, value);
                return generalized;
            }
        }

        @Specialization
        protected static SequenceStorage doScalarPInt(GenNodeSupplier generalizationNodeProvider, SequenceStorage storage, PInt idx, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared(value="setItemScalarNode") @Cached SetItemScalarNode setItemScalarNode, @Cached.Shared(value="doGenNode") @Cached DoGeneralizationNode doGenNode, @Cached.Shared(value="normalizeNode") @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeNode) {
            int normalized = normalizeNode.execute(idx, storage.length(), ErrorMessages.INDEX_OUT_OF_RANGE);
            try {
                setItemScalarNode.execute(inliningTarget, storage, normalized, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = doGenNode.execute(inliningTarget, generalizationNodeProvider, storage, e.getIndicationValue());
                setItemScalarNode.execute(inliningTarget, generalized, normalized, value);
                return generalized;
            }
        }

        @Specialization(guards={"!isPSlice(idx)"})
        protected static SequenceStorage doScalarGeneric(GenNodeSupplier generalizationNodeProvider, SequenceStorage storage, Object idx, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="generalizeProfile") @Cached InlinedBranchProfile generalizeProfile, @Cached.Shared(value="setItemScalarNode") @Cached SetItemScalarNode setItemScalarNode, @Cached.Shared(value="doGenNode") @Cached DoGeneralizationNode doGenNode, @Cached.Shared(value="normalizeNode") @Cached IndexNodes.NormalizeIndexCustomMessageNode normalizeNode) {
            int normalized = normalizeNode.execute(idx, storage.length(), ErrorMessages.INDEX_OUT_OF_RANGE);
            try {
                setItemScalarNode.execute(inliningTarget, storage, normalized, value);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = doGenNode.execute(inliningTarget, generalizationNodeProvider, storage, e.getIndicationValue());
                setItemScalarNode.execute(inliningTarget, generalized, normalized, value);
                return generalized;
            }
        }

        @Specialization
        protected static SequenceStorage doSlice(VirtualFrame frame, GenNodeSupplier generalizationNodeProvider, SequenceStorage storage, PSlice slice, Object iterable, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedBranchProfile generalizeProfile, @Cached SetItemSliceNode setItemSliceNode, @Cached.Exclusive @Cached DoGeneralizationNode doGenNode, @Cached ListNodes.ConstructListNode constructListNode, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute) {
            PSlice.SliceInfo info = compute.execute((Frame)frame, sliceCast.execute(inliningTarget, slice), storage.length());
            PList values = constructListNode.execute((Frame)frame, iterable);
            try {
                setItemSliceNode.execute((Frame)frame, inliningTarget, storage, info, values);
                return storage;
            }
            catch (SequenceStoreException e) {
                generalizeProfile.enter(inliningTarget);
                SequenceStorage generalized = doGenNode.execute(inliningTarget, generalizationNodeProvider, storage, e.getIndicationValue());
                setItemSliceNode.execute((Frame)frame, inliningTarget, generalized, info, values);
                return generalized;
            }
        }

        public static SetItemDynamicNode getUncached() {
            return SequenceStorageNodesFactory.SetItemDynamicNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @ImportStatic(value={SequenceStorage.StorageType.class, SequenceStorageBaseNode.class})
    public static abstract class GetItemSliceNode
    extends PNodeWithContext {
        public abstract SequenceStorage execute(SequenceStorage var1, int var2, int var3, int var4, int var5);

        @Specialization
        protected static EmptySequenceStorage doEmpty(EmptySequenceStorage storage, int start, int stop, int step, int length) {
            return EmptySequenceStorage.INSTANCE;
        }

        @Specialization
        protected static SequenceStorage doIntSequenceStorage(IntSequenceStorage storage, int start, int stop, int step, int length) {
            int[] newArray = new int[length];
            int[] values = storage.getInternalIntArray();
            if (step == 1) {
                PythonUtils.arraycopy(values, start, newArray, 0, length);
                return new IntSequenceStorage(newArray);
            }
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = values[i];
                i += step;
            }
            return new IntSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doLongSequenceStorage(LongSequenceStorage storage, int start, int stop, int step, int length) {
            long[] newArray = new long[length];
            long[] values = storage.getInternalLongArray();
            if (step == 1) {
                PythonUtils.arraycopy(values, start, newArray, 0, length);
                return new LongSequenceStorage(newArray);
            }
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = values[i];
                i += step;
            }
            return new LongSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doDoubleSequenceStorage(DoubleSequenceStorage storage, int start, int stop, int step, int length) {
            double[] newArray = new double[length];
            double[] values = storage.getInternalDoubleArray();
            if (step == 1) {
                PythonUtils.arraycopy(values, start, newArray, 0, length);
                return new DoubleSequenceStorage(newArray);
            }
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = values[i];
                i += step;
            }
            return new DoubleSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doBoolSequenceStorage(BoolSequenceStorage storage, int start, int stop, int step, int length) {
            boolean[] newArray = new boolean[length];
            boolean[] values = storage.getInternalBoolArray();
            if (step == 1) {
                PythonUtils.arraycopy(values, start, newArray, 0, length);
                return new BoolSequenceStorage(newArray);
            }
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = values[i];
                i += step;
            }
            return new BoolSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doByteSequenceStorage(ByteSequenceStorage storage, int start, int stop, int step, int length) {
            byte[] newArray = new byte[length];
            byte[] values = storage.getInternalByteArray();
            if (step == 1) {
                PythonUtils.arraycopy(values, start, newArray, 0, length);
                return new ByteSequenceStorage(newArray);
            }
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = values[i];
                i += step;
            }
            return new ByteSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doObjectSequenceStorage(ObjectSequenceStorage storage, int start, int stop, int step, int length) {
            Object[] newArray = new Object[length];
            Object[] values = storage.getInternalObjectArray();
            if (step == 1) {
                PythonUtils.arraycopy(values, start, newArray, 0, length);
                return new ObjectSequenceStorage(newArray);
            }
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = values[i];
                i += step;
            }
            return new ObjectSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doMroSequenceStorage(MroSequenceStorage storage, int start, int stop, int step, int length) {
            Object[] newArray = new PythonAbstractClass[length];
            PythonAbstractClass[] values = storage.getInternalClassArray();
            if (step == 1) {
                PythonUtils.arraycopy(values, start, newArray, 0, length);
                return new MroSequenceStorage(storage.getClassName(), (PythonAbstractClass[])newArray);
            }
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = values[i];
                i += step;
            }
            return new ObjectSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doNativeInt(NativeIntSequenceStorage storage, int start, int stop, int step, int length, @Bind(value="this") Node node) {
            NativeBuffer sliceValueBuffer = GetItemSliceNode.doNativePrimitiveSliceInBound(PythonContext.get(node), start, step, length, storage);
            return PythonContext.get((Node)node).nativeBufferContext.createNativeIntStorage(sliceValueBuffer, length);
        }

        @Specialization
        protected static SequenceStorage doNativeByte(NativeByteSequenceStorage storage, int start, int stop, int step, int length, @Cached CStructAccess.ReadByteNode readNode) {
            byte[] newArray = new byte[length];
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = readNode.readArrayElement(storage.getPtr(), i);
                i += step;
            }
            return new ByteSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doNativeObject(NativeObjectSequenceStorage storage, int start, int stop, int step, int length, @Cached CStructAccess.ReadPointerNode readNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode) {
            Object[] newArray = new Object[length];
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = toJavaNode.execute(readNode.readArrayElement(storage.getPtr(), i));
                i += step;
            }
            return new ObjectSequenceStorage(newArray);
        }

        @Specialization
        protected static SequenceStorage doForeign(ForeignSequenceStorage storage, int start, int stop, int step, int length, @Bind(value="this") Node inliningTarget, @Cached ForeignSequenceStorage.ReadNode readNode) {
            Object[] newArray = new Object[length];
            int i = start;
            for (int j = 0; j < length; ++j) {
                newArray[j] = readNode.execute(inliningTarget, storage, i);
                i += step;
            }
            return new ObjectSequenceStorage(newArray);
        }

        private static NativeBuffer doNativePrimitiveSliceInBound(PythonContext pythonCtx, int start, int step, int sliceLength, NativePrimitiveSequenceStorage storage) {
            Unsafe unsafe = pythonCtx.getUnsafe();
            long itemSize = storage.getItemSize();
            long sizeInBytes = (long)sliceLength * itemSize;
            NativeBuffer sliceBuffer = NativeBuffer.allocateNew(sizeInBytes);
            if (step == 1) {
                long startAddress = storage.getValueBufferAddr() + (long)start * itemSize;
                unsafe.copyMemory(startAddress, sliceBuffer.getMemoryAddress(), sizeInBytes);
                return sliceBuffer;
            }
            long stepInBytes = (long)step * itemSize;
            long srcAddr = storage.getValueBufferAddr() + (long)start * itemSize;
            long destAddr = sliceBuffer.getMemoryAddress();
            for (long j = 0L; j < (long)sliceLength; ++j) {
                unsafe.copyMemory(srcAddr, destAddr, itemSize);
                srcAddr += stepInBytes;
                destAddr += itemSize;
            }
            return sliceBuffer;
        }

        @NeverDefault
        public static GetItemSliceNode create() {
            return SequenceStorageNodesFactory.GetItemSliceNodeGen.create();
        }

        public static GetItemSliceNode getUncached() {
            return SequenceStorageNodesFactory.GetItemSliceNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @ImportStatic(value={SequenceStorageBaseNode.class})
    protected static abstract class GetNativeItemScalarNode
    extends Node {
        protected GetNativeItemScalarNode() {
        }

        public abstract Object execute(NativeSequenceStorage var1, int var2);

        @Specialization
        protected static Object doNativeObject(NativeObjectSequenceStorage storage, int idx, @Cached CStructAccess.ReadPointerNode readNode, @Cached CApiTransitions.NativeToPythonNode toJavaNode) {
            return toJavaNode.execute(readNode.readArrayElement(storage.getPtr(), idx));
        }

        @Specialization
        protected static int doNativeByte(NativeByteSequenceStorage storage, int idx, @Cached CStructAccess.ReadByteNode readNode) {
            return readNode.readArrayElement(storage.getPtr(), idx) & 0xFF;
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @ImportStatic(value={SequenceStorageBaseNode.class})
    public static abstract class GetItemScalarNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, SequenceStorage var2, int var3);

        public final Object executeCached(SequenceStorage s, int idx) {
            return this.execute(null, s, idx);
        }

        public static Object executeUncached(SequenceStorage s, int idx) {
            return SequenceStorageNodesFactory.GetItemScalarNodeGen.getUncached().execute(null, s, idx);
        }

        public abstract int executeInt(Node var1, SequenceStorage var2, int var3) throws UnexpectedResultException;

        public final int executeIntCached(SequenceStorage s, int idx) throws UnexpectedResultException {
            return this.executeInt(null, s, idx);
        }

        public final int executeKnownInt(Node inliningTarget, SequenceStorage s, int idx) {
            try {
                return this.executeInt(inliningTarget, s, idx);
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        public final int executeKnownIntCached(SequenceStorage s, int idx) {
            return this.executeKnownInt(null, s, idx);
        }

        public abstract double executeDouble(Node var1, SequenceStorage var2, int var3) throws UnexpectedResultException;

        public final double executeDoubleCached(SequenceStorage s, int idx) throws UnexpectedResultException {
            return this.executeDouble(null, s, idx);
        }

        @Specialization
        protected static boolean doBoolean(BoolSequenceStorage storage, int idx) {
            return storage.getBoolItemNormalized(idx);
        }

        @Specialization
        protected static int doByte(ByteSequenceStorage storage, int idx) {
            return storage.getIntItemNormalized(idx);
        }

        @Specialization
        protected static int doInt(IntSequenceStorage storage, int idx) {
            return storage.getIntItemNormalized(idx);
        }

        @Specialization
        protected static long doLong(LongSequenceStorage storage, int idx) {
            return storage.getLongItemNormalized(idx);
        }

        @Specialization
        protected static double doDouble(DoubleSequenceStorage storage, int idx) {
            return storage.getDoubleItemNormalized(idx);
        }

        @Specialization
        protected static Object doObject(ObjectSequenceStorage storage, int idx) {
            return storage.getObjectItemNormalized(idx);
        }

        @Specialization
        protected static int doNativeInt(NativeIntSequenceStorage storage, int idx) {
            return storage.getIntItemNormalized(idx);
        }

        @Specialization
        protected static Object doMro(MroSequenceStorage storage, int idx) {
            return storage.getPythonClassItemNormalized(idx);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        protected static Object doNative(NativeSequenceStorage storage, int idx, @Cached(inline=false) GetNativeItemScalarNode getItem) {
            return getItem.execute(storage, idx);
        }

        @Specialization
        protected static Object doForeign(Node inliningTarget, ForeignSequenceStorage storage, int idx, @Cached ForeignSequenceStorage.ReadNode readNode) {
            return readNode.execute(inliningTarget, storage, idx);
        }

        @NeverDefault
        public static GetItemScalarNode create() {
            return SequenceStorageNodesFactory.GetItemScalarNodeGen.create();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class GetItemDynamicNode
    extends Node {
        public abstract Object execute(Node var1, SequenceStorage var2, int var3);

        public static Object executeUncached(SequenceStorage s, int key) {
            return SequenceStorageNodesFactory.GetItemDynamicNodeGen.getUncached().execute(null, s, key);
        }

        @Specialization
        protected static Object doScalarInt(Node inliningTarget, SequenceStorage storage, int idx, @Cached GetItemScalarNode getItemScalarNode, @Cached(inline=false) IndexNodes.NormalizeIndexCustomMessageNode normalizeIndexNode) {
            return getItemScalarNode.execute(inliningTarget, storage, normalizeIndexNode.execute(idx, storage.length(), ErrorMessages.INDEX_OUT_OF_RANGE));
        }
    }

    public static abstract class GetItemNode
    extends NormalizingNode {
        @Node.Child
        private GetItemScalarNode getItemScalarNode;
        @Node.Child
        private GetItemSliceNode getItemSliceNode;
        private final BiFunction<SequenceStorage, PythonObjectFactory, Object> factoryMethod;

        public GetItemNode(IndexNodes.NormalizeIndexNode normalizeIndexNode, BiFunction<SequenceStorage, PythonObjectFactory, Object> factoryMethod) {
            super(normalizeIndexNode);
            this.factoryMethod = factoryMethod;
        }

        public abstract Object execute(VirtualFrame var1, SequenceStorage var2, Object var3);

        public final Object execute(SequenceStorage s, int key) {
            return this.doScalarInt(s, key);
        }

        public final int executeInt(SequenceStorage s, int key) throws UnexpectedResultException {
            return this.getGetItemScalarNode().executeIntCached(s, this.normalizeIndex(key, s));
        }

        public final int executeKnownInt(SequenceStorage s, int key) {
            return this.getGetItemScalarNode().executeKnownIntCached(s, this.normalizeIndex(key, s));
        }

        public final double executeDouble(SequenceStorage s, int key) throws UnexpectedResultException {
            return this.getGetItemScalarNode().executeDoubleCached(s, this.normalizeIndex(key, s));
        }

        @Specialization
        protected Object doScalarInt(SequenceStorage storage, int idx) {
            return this.getGetItemScalarNode().executeCached(storage, this.normalizeIndex(idx, storage));
        }

        @Specialization
        protected Object doScalarLong(VirtualFrame frame, SequenceStorage storage, long idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            return this.getGetItemScalarNode().executeCached(storage, this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage));
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        protected Object doScalarPInt(VirtualFrame frame, SequenceStorage storage, PInt idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            return this.getGetItemScalarNode().executeCached(storage, this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage));
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isPSlice(idx)"})
        protected Object doScalarGeneric(VirtualFrame frame, SequenceStorage storage, Object idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            return this.getGetItemScalarNode().executeCached(storage, this.normalizeIndex(frame, inliningTarget, asSizeNode, idx, storage));
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        protected Object doSlice(VirtualFrame frame, SequenceStorage storage, PSlice slice, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached SliceNodes.ComputeIndices compute, @Cached RangeNodes.LenOfRangeNode sliceLen) {
            PSlice.SliceInfo info = compute.execute((Frame)frame, sliceCast.execute(inliningTarget, slice), storage.length());
            if (this.factoryMethod != null) {
                return this.factoryMethod.apply(this.getGetItemSliceNode().execute(storage, info.start, info.stop, info.step, sliceLen.len(inliningTarget, info)), factory);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException();
        }

        private GetItemScalarNode getGetItemScalarNode() {
            if (this.getItemScalarNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getItemScalarNode = (GetItemScalarNode)this.insert(GetItemScalarNode.create());
            }
            return this.getItemScalarNode;
        }

        private GetItemSliceNode getGetItemSliceNode() {
            if (this.getItemSliceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getItemSliceNode = (GetItemSliceNode)this.insert(GetItemSliceNode.create());
            }
            return this.getItemSliceNode;
        }

        @NeverDefault
        public static GetItemNode createNotNormalized() {
            return SequenceStorageNodesFactory.GetItemNodeGen.create(null, null);
        }

        @NeverDefault
        public static GetItemNode create(IndexNodes.NormalizeIndexNode normalizeIndexNode) {
            return SequenceStorageNodesFactory.GetItemNodeGen.create(normalizeIndexNode, null);
        }

        @NeverDefault
        public static GetItemNode create() {
            return SequenceStorageNodesFactory.GetItemNodeGen.create(IndexNodes.NormalizeIndexNode.create(), null);
        }

        @NeverDefault
        public static GetItemNode create(IndexNodes.NormalizeIndexNode normalizeIndexNode, BiFunction<SequenceStorage, PythonObjectFactory, Object> factoryMethod) {
            return SequenceStorageNodesFactory.GetItemNodeGen.create(normalizeIndexNode, factoryMethod);
        }

        @NeverDefault
        public static GetItemNode createForList() {
            return GetItemNode.create(IndexNodes.NormalizeIndexNode.forList(), (s, f) -> f.createList((SequenceStorage)s));
        }

        @NeverDefault
        public static GetItemNode createForTuple() {
            return GetItemNode.create(IndexNodes.NormalizeIndexNode.forTuple(), (s, f) -> f.createTuple((SequenceStorage)s));
        }
    }

    static abstract class NormalizingNode
    extends PNodeWithContext {
        @Node.Child
        private IndexNodes.NormalizeIndexNode normalizeIndexNode;

        protected NormalizingNode(IndexNodes.NormalizeIndexNode normalizeIndexNode) {
            this.normalizeIndexNode = normalizeIndexNode;
        }

        protected final int normalizeIndex(VirtualFrame frame, Node inliningTarget, PyNumberAsSizeNode asSizeNode, Object idx, SequenceStorage store) {
            int intIdx = asSizeNode.executeExact((Frame)frame, inliningTarget, idx, PythonErrorType.IndexError);
            if (this.normalizeIndexNode != null) {
                return this.normalizeIndexNode.execute(intIdx, store.length());
            }
            return intIdx;
        }

        protected final int normalizeIndex(int idx, SequenceStorage store) {
            if (this.normalizeIndexNode != null) {
                return this.normalizeIndexNode.execute(idx, store.length());
            }
            return idx;
        }

        protected final int normalizeIndex(VirtualFrame frame, Node inliningTarget, PyNumberAsSizeNode asSizeNode, long idx, SequenceStorage store) {
            int intIdx = asSizeNode.executeExact((Frame)frame, inliningTarget, idx, PythonErrorType.IndexError);
            if (this.normalizeIndexNode != null) {
                return this.normalizeIndexNode.execute(intIdx, store.length());
            }
            return intIdx;
        }

        protected static boolean isPSlice(Object obj) {
            return obj instanceof PSlice;
        }
    }

    @ImportStatic(value={PythonOptions.class})
    static abstract class SequenceStorageBaseNode
    extends PNodeWithContext {
        protected static final int MAX_BASIC_STORAGES = 7;

        SequenceStorageBaseNode() {
        }

        protected static boolean isNative(SequenceStorage store) {
            return store instanceof NativeSequenceStorage;
        }

        protected static boolean isEmpty(SequenceStorage left) {
            return left.length() == 0;
        }

        protected static boolean isBoolean(SequenceStorage.StorageType et) {
            return et == SequenceStorage.StorageType.Boolean;
        }

        protected static boolean isByte(SequenceStorage.StorageType et) {
            return et == SequenceStorage.StorageType.Byte;
        }

        protected static boolean isByteLike(SequenceStorage.StorageType et) {
            return SequenceStorageBaseNode.isByte(et) || SequenceStorageBaseNode.isInt(et) || SequenceStorageBaseNode.isLong(et);
        }

        protected static boolean isInt(SequenceStorage.StorageType et) {
            return et == SequenceStorage.StorageType.Int;
        }

        protected static boolean isLong(SequenceStorage.StorageType et) {
            return et == SequenceStorage.StorageType.Long;
        }

        protected static boolean isDouble(SequenceStorage.StorageType et) {
            return et == SequenceStorage.StorageType.Double;
        }

        protected static boolean isObject(SequenceStorage.StorageType et) {
            return et == SequenceStorage.StorageType.Generic;
        }

        protected static boolean hasStorage(Object source) {
            return source instanceof PSequence && !(source instanceof PString);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class IsDataTypeCompatibleNode
    extends Node {
        IsDataTypeCompatibleNode() {
        }

        protected abstract boolean execute(Node var1, SequenceStorage var2, SequenceStorage var3);

        @Specialization
        static boolean compatibleAssign(Node inliningTarget, SequenceStorage lhs, SequenceStorage rhs, @Cached GetElementType getElementTypeNode) {
            SequenceStorage.StorageType rhsType = getElementTypeNode.execute(inliningTarget, rhs);
            switch (getElementTypeNode.execute(inliningTarget, lhs)) {
                case Boolean: 
                case Byte: 
                case Int: 
                case Long: {
                    return rhsType == SequenceStorage.StorageType.Boolean || rhsType == SequenceStorage.StorageType.Byte || rhsType == SequenceStorage.StorageType.Int || rhsType == SequenceStorage.StorageType.Long || rhsType == SequenceStorage.StorageType.Uninitialized || rhsType == SequenceStorage.StorageType.Empty;
                }
                case Double: {
                    return rhsType == SequenceStorage.StorageType.Double || rhsType == SequenceStorage.StorageType.Uninitialized || rhsType == SequenceStorage.StorageType.Empty;
                }
                case Generic: {
                    return true;
                }
                case Empty: 
                case Uninitialized: {
                    return false;
                }
            }
            assert (false) : "should not reach";
            return false;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IsAssignCompatibleNode
    extends Node {
        protected abstract boolean execute(Node var1, SequenceStorage var2, SequenceStorage var3);

        @Specialization
        static boolean compatibleAssign(Node inliningTarget, SequenceStorage lhs, SequenceStorage rhs, @Cached GetElementType getElementTypeNode) {
            SequenceStorage.StorageType rhsType = getElementTypeNode.execute(inliningTarget, rhs);
            switch (getElementTypeNode.execute(inliningTarget, lhs)) {
                case Boolean: {
                    return rhsType == SequenceStorage.StorageType.Boolean || rhsType == SequenceStorage.StorageType.Uninitialized || rhsType == SequenceStorage.StorageType.Empty;
                }
                case Byte: {
                    return rhsType == SequenceStorage.StorageType.Byte || rhsType == SequenceStorage.StorageType.Uninitialized || rhsType == SequenceStorage.StorageType.Empty;
                }
                case Int: {
                    return rhsType == SequenceStorage.StorageType.Byte || rhsType == SequenceStorage.StorageType.Int || rhsType == SequenceStorage.StorageType.Uninitialized || rhsType == SequenceStorage.StorageType.Empty;
                }
                case Long: {
                    return rhsType == SequenceStorage.StorageType.Byte || rhsType == SequenceStorage.StorageType.Int || rhsType == SequenceStorage.StorageType.Long || rhsType == SequenceStorage.StorageType.Uninitialized || rhsType == SequenceStorage.StorageType.Empty;
                }
                case Double: {
                    return rhsType == SequenceStorage.StorageType.Double || rhsType == SequenceStorage.StorageType.Uninitialized || rhsType == SequenceStorage.StorageType.Empty;
                }
                case Generic: {
                    return true;
                }
                case Empty: 
                case Uninitialized: {
                    return false;
                }
            }
            assert (false) : "should not reach";
            return false;
        }
    }

    public static interface GenNodeSupplier {
        public GeneralizationNode create();

        public GeneralizationNode getUncached();
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SequenceStorageMpSubscriptNode
    extends PNodeWithContext {
        public static boolean isValidIndex(Node inliningTarget, Object index, PyIndexCheckNode indexCheckNode) {
            return PGuards.isPSlice(index) || indexCheckNode.execute(inliningTarget, index);
        }

        public final Object execute(VirtualFrame frame, Node inliningTarget, SequenceStorage storage, Object index, TruffleString indexBoundsErrorMessage, StorageWrapperFactory factory) {
            assert (SequenceStorageMpSubscriptNode.isValidIndex(null, index, PyIndexCheckNode.getUncached()));
            return this.executeImpl(frame, inliningTarget, storage, index, indexBoundsErrorMessage, factory);
        }

        abstract Object executeImpl(VirtualFrame var1, Node var2, SequenceStorage var3, Object var4, TruffleString var5, StorageWrapperFactory var6);

        @Specialization(guards={"!isPSlice(idx)"})
        static Object doNonSlice(VirtualFrame frame, Node inliningTarget, SequenceStorage storage, Object idx, TruffleString indexBoundsErrorMessage, StorageWrapperFactory wrapperFactory, @Cached PyNumberAsSizeNode numberAsSizeNode, @Cached InlinedConditionProfile negativeIndexProfile, @Cached PRaiseNode.Lazy raiseNode, @Cached GetItemScalarNode getItemNode) {
            int index = numberAsSizeNode.executeExact((Frame)frame, inliningTarget, idx, PythonBuiltinClassType.IndexError);
            if (negativeIndexProfile.profile(inliningTarget, index < 0)) {
                index += storage.length();
            }
            return SequenceStorageSqItemNode.getItem(inliningTarget, storage, index, indexBoundsErrorMessage, raiseNode, getItemNode);
        }

        @Specialization
        static Object doSlice(VirtualFrame frame, Node inliningTarget, SequenceStorage storage, PSlice slice, TruffleString indexBoundsErrorMessage, StorageWrapperFactory wrapperFactory, @Cached(inline=false) PythonObjectFactory factory, @Cached SliceNodes.CoerceToIntSlice sliceCast, @Cached(inline=false) SliceNodes.ComputeIndices compute, @Cached(inline=false) GetItemSliceNode getItemSliceNode, @Cached RangeNodes.LenOfRangeNode sliceLen) {
            PSlice.SliceInfo info = compute.execute((Frame)frame, sliceCast.execute(inliningTarget, slice), storage.length());
            SequenceStorage newStorage = getItemSliceNode.execute(storage, info.start, info.stop, info.step, sliceLen.len(inliningTarget, info));
            return wrapperFactory.create(factory, newStorage);
        }
    }

    @FunctionalInterface
    public static interface StorageWrapperFactory {
        public Object create(PythonObjectFactory var1, SequenceStorage var2);
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class SequenceStorageSqItemNode
    extends Node {
        public abstract Object execute(Node var1, SequenceStorage var2, int var3, TruffleString var4);

        @Specialization
        static Object doIt(Node inliningTarget, SequenceStorage self, int index, TruffleString errorMessage, @Cached PRaiseNode.Lazy raiseNode, @Cached GetItemScalarNode getItemNode) {
            return SequenceStorageSqItemNode.getItem(inliningTarget, self, index, errorMessage, raiseNode, getItemNode);
        }

        private static Object getItem(Node inliningTarget, SequenceStorage storage, int index, TruffleString errorMessage, PRaiseNode.Lazy raiseNode, GetItemScalarNode getItemNode) {
            IndexNodes.checkBounds(inliningTarget, raiseNode, errorMessage, index, storage.length());
            return getItemNode.execute(inliningTarget, storage, index);
        }
    }
}

