/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ints;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.ints.IntNodesFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.NumericSupport;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.math.BigInteger;

public final class IntNodes {
    private IntNodes() {
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateUncached
    public static abstract class PyLongFromByteArray
    extends Node {
        public abstract Object execute(Node var1, byte[] var2, boolean var3, boolean var4);

        public final Object executeCached(byte[] data, boolean littleEndian, boolean signed) {
            return this.execute(this, data, littleEndian, signed);
        }

        public static Object executeUncached(byte[] data, boolean littleEndian, boolean signed) {
            return IntNodesFactory.PyLongFromByteArrayNodeGen.getUncached().execute(null, data, littleEndian, signed);
        }

        @Specialization
        static Object doOther(Node inliningTarget, byte[] data, boolean littleEndian, boolean signed, @Cached InlinedBranchProfile fastPath1, @Cached InlinedBranchProfile fastPath2, @Cached InlinedBranchProfile fastPath4, @Cached InlinedBranchProfile fastPath8, @Cached InlinedBranchProfile generic, @Cached(inline=false) PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            NumericSupport support;
            NumericSupport numericSupport = support = littleEndian ? NumericSupport.littleEndian() : NumericSupport.bigEndian();
            if (signed) {
                switch (data.length) {
                    case 1: {
                        fastPath1.enter(inliningTarget);
                        return (int)support.getByte(data, 0);
                    }
                    case 2: {
                        fastPath2.enter(inliningTarget);
                        return (int)support.getShort(data, 0);
                    }
                    case 4: {
                        fastPath4.enter(inliningTarget);
                        return support.getInt(data, 0);
                    }
                    case 8: {
                        fastPath8.enter(inliningTarget);
                        return support.getLong(data, 0);
                    }
                }
            }
            generic.enter(inliningTarget);
            try {
                BigInteger integer = support.getBigInteger(data, signed);
                if (PInt.bigIntegerFitsInLong(integer)) {
                    long longValue = PInt.longValue(integer);
                    return PInt.isIntRange(longValue) ? (long)((int)longValue) : longValue;
                }
                return factory.createInt(integer);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.BYTE_ARRAY_TOO_LONG_TO_CONVERT_TO_INT);
            }
        }
    }

    @GenerateInline(inlineByDefault=true)
    public static abstract class PyLongAsByteArray
    extends Node {
        public abstract byte[] execute(Node var1, Object var2, int var3, boolean var4);

        public final byte[] executeCached(Object value, int size, boolean bigEndian) {
            return this.execute(this, value, size, bigEndian);
        }

        protected static int asWellSizedData(int len) {
            switch (len) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return len;
                }
            }
            return -1;
        }

        @Specialization(guards={"size == cachedDataLen"}, limit="4")
        static byte[] doPrimitive(long value, int size, boolean bigEndian, @Cached(value="asWellSizedData(size)") int cachedDataLen) {
            byte[] bytes = new byte[size];
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            support.putLong(bytes, 0, value, cachedDataLen);
            return bytes;
        }

        @Specialization
        static byte[] doArbitraryBytesLong(Node inliningTarget, long value, int size, boolean bigEndian, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            byte[] bytes = new byte[size];
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            try {
                support.putBigInteger(bytes, 0, PInt.longToBigInteger(value), size);
            }
            catch (OverflowException oe) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.TOO_LARGE_TO_CONVERT, "int");
            }
            return bytes;
        }

        @Specialization
        static byte[] doPInt(Node inliningTarget, PInt value, int size, boolean bigEndian, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            byte[] bytes = new byte[size];
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            try {
                support.putBigInteger(bytes, 0, value.getValue(), size);
            }
            catch (OverflowException oe) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.TOO_LARGE_TO_CONVERT, "int");
            }
            return bytes;
        }
    }

    @GenerateInline(value=false)
    public static abstract class PyLongNumBits
    extends Node {
        public abstract int execute(Object var1);

        @Specialization
        static int doInt(int value) {
            return 32 - Integer.numberOfLeadingZeros(Math.abs(value));
        }

        @Specialization
        static int doLong(long value) {
            return 64 - Long.numberOfLeadingZeros(Math.abs(value));
        }

        @Specialization
        static int doPInt(PInt value) {
            return value.bitLength();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PyLongSign
    extends Node {
        public abstract int execute(Object var1);

        @Specialization
        static int doInt(int value) {
            return Integer.compare(value, 0);
        }

        @Specialization
        static int doLong(long value) {
            return Long.compare(value, 0L);
        }

        @Specialization
        static int doPInt(PInt value) {
            return value.compareTo(0L);
        }
    }
}

