/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ordereddict;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDict;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDictIterator;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectDelItem;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetStateNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.POrderedDict})
public class OrderedDictBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = OrderedDictBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return OrderedDictBuiltinsFactory.getFactories();
    }

    @Builtin(name="__sizeof__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SizeOfNode
    extends PythonUnaryBuiltinNode {
        SizeOfNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int sizeof(POrderedDict self) {
            return 300 + self.nodes.size() * 32;
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class DictNode
    extends PythonBinaryBuiltinNode {
        DictNode() {
        }

        @Specialization
        static PNone dict(Object self, PDict mapping, @Bind(value="this") Node inliningTarget, @Cached SetDictNode setDict) {
            setDict.execute(inliningTarget, self, mapping);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(mapping)"})
        static Object dict(Object self, PNone mapping, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }

        @Specialization(guards={"!isNoValue(mapping)", "!isDict(mapping)"})
        static PNone dict(Object self, Object mapping, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, mapping);
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        NeNode() {
        }

        @Specialization
        static boolean cmp(VirtualFrame frame, POrderedDict self, PDict other, @Bind(value="this") Node inliningTarget, @Cached EqHelperNode eqHelperNode) {
            return !eqHelperNode.execute(frame, inliningTarget, self, other);
        }

        @Fallback
        static Object cmp(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        @Specialization
        static boolean cmp(VirtualFrame frame, POrderedDict self, PDict other, @Bind(value="this") Node inliningTarget, @Cached EqHelperNode eqHelperNode) {
            return eqHelperNode.execute(frame, inliningTarget, self, other);
        }

        @Fallback
        static Object cmp(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class EqHelperNode
    extends Node {
        EqHelperNode() {
        }

        abstract boolean execute(VirtualFrame var1, Node var2, POrderedDict var3, PDict var4);

        @Specialization
        static boolean cmp(VirtualFrame frame, Node inliningTarget, POrderedDict self, POrderedDict other, @Cached HashingStorageNodes.HashingStorageGetItemWithHash getItem, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            POrderedDict.ODictNode lnode = self.first;
            POrderedDict.ODictNode rnode = other.first;
            while (lnode != null || rnode != null) {
                Object rvalue;
                if (lnode == null || rnode == null) {
                    return false;
                }
                if (!eqNode.compare((Frame)frame, inliningTarget, lnode.key, rnode.key)) {
                    return false;
                }
                Object lvalue = getItem.execute((Frame)frame, inliningTarget, self.getDictStorage(), lnode.key, lnode.hash);
                if (!eqNode.compare((Frame)frame, inliningTarget, lvalue, rvalue = getItem.execute((Frame)frame, inliningTarget, other.getDictStorage(), rnode.key, rnode.hash))) {
                    return false;
                }
                lnode = lnode.next;
                rnode = rnode.next;
            }
            return true;
        }

        @Fallback
        static boolean cmp(VirtualFrame frame, Node inliningTarget, POrderedDict self, PDict other, @Cached HashingStorageNodes.HashingStorageEq eqNode) {
            return eqNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), other.getDictStorage());
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object repr(VirtualFrame frame, POrderedDict self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached ListNodes.ConstructListNode constructListNode, @Cached PyObjectReprAsTruffleStringNode repr) {
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self));
            if (self.first == null) {
                TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(builder, (AbstractTruffleString)typeName);
                appendStringNode.execute(builder, (AbstractTruffleString)StringLiterals.T_EMPTY_PARENS);
                return toStringNode.execute(builder);
            }
            PythonContext context = PythonContext.get(inliningTarget);
            if (!context.reprEnter(self)) {
                return StringLiterals.T_ELLIPSIS;
            }
            try {
                TruffleStringBuilder builder = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(builder, (AbstractTruffleString)typeName);
                Object items = callMethod.execute((Frame)frame, inliningTarget, self, SpecialMethodNames.T_ITEMS, new Object[0]);
                TruffleString itemsRepr = repr.execute((Frame)frame, inliningTarget, constructListNode.execute((Frame)frame, items));
                appendStringNode.execute(builder, (AbstractTruffleString)StringLiterals.T_LPAREN);
                appendStringNode.execute(builder, (AbstractTruffleString)itemsRepr);
                appendStringNode.execute(builder, (AbstractTruffleString)StringLiterals.T_RPAREN);
                TruffleString truffleString = toStringNode.execute(builder);
                return truffleString;
            }
            finally {
                context.reprLeave(self);
            }
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        ReversedNode() {
        }

        @Specialization
        static Object iter(POrderedDict self, @Cached PythonObjectFactory factory) {
            return factory.createOrderedDictIterator(self, POrderedDictIterator.IteratorType.KEYS, true);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static Object iter(POrderedDict self, @Cached PythonObjectFactory factory) {
            return factory.createOrderedDictIterator(self, POrderedDictIterator.IteratorType.KEYS, false);
        }
    }

    @Builtin(name="items", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ItemsNode
    extends PythonUnaryBuiltinNode {
        ItemsNode() {
        }

        @Specialization
        static Object items(POrderedDict self, @Cached PythonObjectFactory factory) {
            return factory.createOrderedDictItems(self);
        }
    }

    @Builtin(name="values", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ValuesNode
    extends PythonUnaryBuiltinNode {
        ValuesNode() {
        }

        @Specialization
        static Object values(POrderedDict self, @Cached PythonObjectFactory factory) {
            return factory.createOrderedDictValues(self);
        }
    }

    @Builtin(name="keys", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class KeysNode
    extends PythonUnaryBuiltinNode {
        KeysNode() {
        }

        @Specialization
        static Object keys(POrderedDict self, @Cached PythonObjectFactory factory) {
            return factory.createOrderedDictKeys(self);
        }
    }

    @Builtin(name="move_to_end", minNumOfPositionalArgs=2, parameterNames={"$self", "key", "last"})
    @ArgumentClinic(name="last", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")
    @GenerateNodeFactory
    static abstract class MoveToEndNode
    extends PythonTernaryClinicBuiltinNode {
        MoveToEndNode() {
        }

        @Specialization
        static PNone move(VirtualFrame frame, POrderedDict self, Object key, boolean last, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode, @Cached ObjectHashMap.GetNode getNode, @Cached PRaiseNode raiseNode) {
            if (self.first == null) {
                throw raiseNode.raise(PythonBuiltinClassType.KeyError, new Object[]{key});
            }
            if ((last ? self.last : self.first).key != key) {
                long hash = hashNode.execute((Frame)frame, inliningTarget, key);
                POrderedDict.ODictNode node = (POrderedDict.ODictNode)getNode.execute((Frame)frame, inliningTarget, self.nodes, key, hash);
                if (node == null) {
                    throw raiseNode.raise(PythonBuiltinClassType.KeyError, new Object[]{key});
                }
                if (last) {
                    if (self.last != node) {
                        self.remove(node);
                        self.append(node);
                    }
                } else if (self.first != node) {
                    self.remove(node);
                    self.prepend(node);
                }
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return OrderedDictBuiltinsClinicProviders.MoveToEndNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ClearNode
    extends PythonUnaryBuiltinNode {
        ClearNode() {
        }

        @Specialization
        static PNone clear(POrderedDict self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageClear clearNode) {
            HashingStorage storage = clearNode.execute(inliningTarget, self.getDictStorage());
            self.setDictStorage(storage);
            self.nodes.clear();
            self.last = null;
            self.first = null;
            return PNone.NONE;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        CopyNode() {
        }

        @Specialization
        static Object copy(VirtualFrame frame, POrderedDict self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached CallNode callNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            return callNode.execute((Frame)frame, type, self);
        }
    }

    @Builtin(name="popitem", minNumOfPositionalArgs=1, parameterNames={"$self", "last"})
    @ArgumentClinic(name="last", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true")
    @GenerateNodeFactory
    static abstract class PopItemNode
    extends PythonBinaryClinicBuiltinNode {
        PopItemNode() {
        }

        @Specialization
        static Object popitem(VirtualFrame frame, POrderedDict self, boolean last, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageDelItem delItem, @Cached ObjectHashMap.RemoveNode removeNode2, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raise) {
            POrderedDict.ODictNode node;
            POrderedDict.ODictNode oDictNode = node = last ? self.last : self.first;
            if (node == null) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.KeyError, ErrorMessages.IS_EMPTY, "dictionary");
            }
            self.remove(node);
            removeNode2.execute((Frame)frame, inliningTarget, self.nodes, node.key, node.hash);
            Object value = delItem.executePop((Frame)frame, inliningTarget, self.getDictStorage(), node.key, self);
            return factory.createTuple(new Object[]{node.key, value});
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return OrderedDictBuiltinsClinicProviders.PopItemNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=2, parameterNames={"$self", "key", "default"})
    @GenerateNodeFactory
    static abstract class PopNode
    extends PythonTernaryBuiltinNode {
        PopNode() {
        }

        @Specialization
        static Object pop(VirtualFrame frame, POrderedDict self, Object key, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached PySequenceContainsNode containsNode, @Cached PyObjectGetItem getItem, @Cached PyObjectDelItem delItem, @Cached PRaiseNode.Lazy raiseNode) {
            if (containsNode.execute((Frame)frame, inliningTarget, self, key)) {
                Object value = getItem.execute((Frame)frame, inliningTarget, self, key);
                delItem.execute((Frame)frame, inliningTarget, self, key);
                return value;
            }
            if (defaultValue != PNone.NO_VALUE) {
                return defaultValue;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.KeyError, new Object[]{key});
        }
    }

    @Builtin(name="setdefault", minNumOfPositionalArgs=2, parameterNames={"$self", "key", "default"})
    @ArgumentClinic(name="default", defaultValue="PNone.NONE")
    @GenerateNodeFactory
    static abstract class SetDefaultNode
    extends PythonTernaryClinicBuiltinNode {
        SetDefaultNode() {
        }

        @Specialization
        static Object setdefault(VirtualFrame frame, POrderedDict self, Object key, Object defaultValue, @Bind(value="this") Node inliningTarget, @Cached PySequenceContainsNode containsNode, @Cached PyObjectGetItem getItem, @Cached PyObjectSetItem setItem) {
            if (containsNode.execute((Frame)frame, inliningTarget, self, key)) {
                return getItem.execute((Frame)frame, inliningTarget, self, key);
            }
            setItem.execute((Frame)frame, inliningTarget, self, key, defaultValue);
            return defaultValue;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return OrderedDictBuiltinsClinicProviders.SetDefaultNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, POrderedDict self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectGetStateNode getStateNode, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectGetIter getIter, @Cached PythonObjectFactory factory) {
            Object type = getClassNode.execute(inliningTarget, self);
            Object state = getStateNode.execute(frame, inliningTarget, self);
            PTuple args = factory.createEmptyTuple();
            Object items = callMethod.execute((Frame)frame, inliningTarget, self, SpecialMethodNames.T_ITEMS, new Object[0]);
            Object itemsIter = getIter.execute((Frame)frame, inliningTarget, items);
            return factory.createTuple(new Object[]{type, args, state, PNone.NONE, itemsIter});
        }
    }

    @Builtin(name="__ior__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IOrNode
    extends PythonBinaryBuiltinNode {
        IOrNode() {
        }

        @Specialization
        static Object or(VirtualFrame frame, POrderedDict self, Object other, @Bind(value="this") Node inliningTarget, @Cached UpdateFromArgsNode update) {
            update.execute(frame, inliningTarget, self, other);
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization
        static Object or(VirtualFrame frame, POrderedDict left, PDict right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached CallNode callNode, @Cached.Shared @Cached UpdateFromArgsNode update) {
            Object newDict = callNode.execute((Frame)frame, getClassNode.execute(inliningTarget, left), left);
            update.execute(frame, inliningTarget, newDict, right);
            return newDict;
        }

        @Specialization
        static Object or(VirtualFrame frame, PDict left, POrderedDict right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached CallNode callNode, @Cached.Shared @Cached UpdateFromArgsNode update) {
            Object newDict = callNode.execute((Frame)frame, getClassNode.execute(inliningTarget, right), left);
            update.execute(frame, inliningTarget, newDict, right);
            return newDict;
        }

        @Fallback
        static Object or(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class UpdateFromArgsNode
    extends Node {
        UpdateFromArgsNode() {
        }

        final void execute(VirtualFrame frame, Node inliningTarget, Object self, Object mapping) {
            this.execute(frame, inliningTarget, self, mapping, PKeyword.EMPTY_KEYWORDS);
        }

        abstract void execute(VirtualFrame var1, Node var2, Object var3, Object var4, PKeyword[] var5);

        @Specialization
        static void update(VirtualFrame frame, Node inliningTarget, Object self, Object mapping, PKeyword[] kwargs, @Cached(inline=false) HashingStorage.InitNode initNode, @Cached HashingStorageNodes.HashingStorageForEach forEach, @Cached(inline=false) ForEachNode callbackNode) {
            HashingStorage newStorage = initNode.execute(frame, mapping, kwargs);
            forEach.execute((Frame)frame, inliningTarget, newStorage, callbackNode, self);
        }

        @GenerateInline(value=false)
        static abstract class ForEachNode
        extends HashingStorageNodes.HashingStorageForEachCallback<Object> {
            ForEachNode() {
            }

            @Override
            public abstract Object execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, Object var5);

            @Specialization
            static Object each(Frame frame, Node node, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, Object dict, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached HashingStorageNodes.HashingStorageIteratorValue itValue, @Cached PyObjectSetItem setItem) {
                Object key = itKey.execute(inliningTarget, storage, it);
                Object value = itValue.execute(inliningTarget, storage, it);
                setItem.execute(frame, inliningTarget, dict, key, value);
                return dict;
            }
        }
    }

    @Slot(value=Slot.SlotKind.mp_ass_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class SetItemNode
    extends TpSlotMpAssSubscript.MpAssSubscriptBuiltinNode {
        SetItemNode() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void setitem(VirtualFrame frame, POrderedDict self, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectHashNode hashNode, @Cached HashingStorageNodes.HashingStorageSetItemWithHash setItemWithHash, @Cached InlinedBranchProfile storageUpdated, @Cached ObjectHashMap.GetNode getNode, @Cached ObjectHashMap.PutNode putNode) {
            long hash = hashNode.execute((Frame)frame, inliningTarget, key);
            HashingStorage newStorage = setItemWithHash.execute((Frame)frame, inliningTarget, self.getDictStorage(), key, hash, value);
            if (newStorage != self.getDictStorage()) {
                storageUpdated.enter(inliningTarget);
                self.setDictStorage(newStorage);
            }
            if (getNode.execute((Frame)frame, inliningTarget, self.nodes, key, hash) == null) {
                POrderedDict.ODictNode node = new POrderedDict.ODictNode(key, hash, self.last, null);
                self.append(node);
                putNode.put((Frame)frame, inliningTarget, self.nodes, key, hash, node);
            }
        }

        @Specialization(guards={"isNoValue(value)"})
        static void delitem(VirtualFrame frame, POrderedDict self, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectHashNode hashNode, @Cached HashingStorageNodes.HashingStorageDelItem delItem, @Cached ObjectHashMap.RemoveNode removeNode2, @Cached PRaiseNode raiseNode) {
            long hash = hashNode.execute((Frame)frame, inliningTarget, key);
            POrderedDict.ODictNode node = (POrderedDict.ODictNode)removeNode2.execute((Frame)frame, inliningTarget, self.nodes, key, hash);
            if (node == null) {
                throw raiseNode.raise(PythonBuiltinClassType.KeyError, new Object[]{key});
            }
            self.remove(node);
            delItem.execute((Frame)frame, inliningTarget, self.getDictStorage(), key, self);
        }
    }

    @Builtins(value={@Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true), @Builtin(name="update", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)})
    @GenerateNodeFactory
    static abstract class InitNode
    extends PythonBuiltinNode {
        InitNode() {
        }

        @Specialization
        static PNone update(VirtualFrame frame, PDict self, Object[] args, PKeyword[] kwargs, @Bind(value="this") Node inliningTarget, @Cached UpdateFromArgsNode update, @Cached PRaiseNode.Lazy raiseNode) {
            Object mapping = PNone.NO_VALUE;
            if (args.length == 1) {
                mapping = args[0];
            } else if (args.length > 1) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_AT_MOST_D_ARGS_GOT_D, 1, args.length);
            }
            update.execute(frame, inliningTarget, self, mapping, kwargs);
            return PNone.NONE;
        }
    }
}

