/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.types.GenericAliasIteratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.builtins.objects.types.PGenericAliasIterator;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PGenericAliasIterator})
public final class GenericAliasIteratorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GenericAliasIteratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PGenericAliasIterator self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Cached PythonObjectFactory factory) {
            PythonModule builtins = PythonContext.get(inliningTarget).getBuiltins();
            Object iter = getAttr.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_ITER);
            Object[] args = !self.isExhausted() ? new Object[]{self.getObj()} : new Object[]{factory.createEmptyTuple()};
            return factory.createTuple(new Object[]{iter, factory.createTuple(args)});
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        NextNode() {
        }

        @Specialization
        static Object next(PGenericAliasIterator self, @Cached PRaiseNode raiseNode, @Cached PythonObjectFactory factory) {
            if (self.isExhausted()) {
                throw raiseNode.raise(PythonBuiltinClassType.StopIteration);
            }
            PGenericAlias alias = self.getObj();
            PGenericAlias starredAlias = factory.createGenericAlias(alias.getOrigin(), alias.getArgs(), true);
            self.markExhausted();
            return starredAlias;
        }
    }
}

