/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.types.PGenericAlias;
import com.oracle.graal.python.builtins.objects.types.PUnionType;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectTypeCheck;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class GenericTypeNodes {
    public static final String J___TYPING_SUBST__ = "__typing_subst__";
    public static final TruffleString T___TYPING_SUBST__ = PythonUtils.tsLiteral("__typing_subst__");
    public static final String J___TYPING_UNPACKED_TUPLE_ARGS__ = "__typing_unpacked_tuple_args__";
    public static final TruffleString T___TYPING_UNPACKED_TUPLE_ARGS__ = PythonUtils.tsLiteral("__typing_unpacked_tuple_args__");
    public static final String J___TYPING_IS_UNPACKED_TYPEVARTUPLE__ = "__typing_is_unpacked_typevartuple__";
    public static final TruffleString T___TYPING_IS_UNPACKED_TYPEVARTUPLE__ = PythonUtils.tsLiteral("__typing_is_unpacked_typevartuple__");
    public static final String J___TYPING_PREPARE_SUBST__ = "__typing_prepare_subst__";
    public static final TruffleString T___TYPING_PREPARE_SUBST__ = PythonUtils.tsLiteral("__typing_prepare_subst__");

    @CompilerDirectives.TruffleBoundary
    private static Object getItemUncached(SequenceStorage storage, int i) {
        return SequenceStorageNodes.GetItemScalarNode.executeUncached(storage, i);
    }

    static void reprItem(TruffleStringBuilder sb, Object obj) {
        Object module;
        Object args;
        PyObjectLookupAttr lookup = PyObjectLookupAttr.getUncached();
        PyObjectStrAsTruffleStringNode str = PyObjectStrAsTruffleStringNode.getUncached();
        Object origin = lookup.execute(null, null, obj, SpecialAttributeNames.T___ORIGIN__);
        if (origin != PNone.NO_VALUE && (args = lookup.execute(null, null, obj, SpecialAttributeNames.T___ARGS__)) != PNone.NO_VALUE) {
            sb.appendStringUncached(PyObjectReprAsTruffleStringNode.executeUncached(obj));
            return;
        }
        Object qualname = lookup.execute(null, null, obj, SpecialAttributeNames.T___QUALNAME__);
        if (qualname != PNone.NO_VALUE && !((module = lookup.execute(null, null, obj, SpecialAttributeNames.T___MODULE__)) instanceof PNone)) {
            if (PyUnicodeCheckNode.executeUncached(module) && PyObjectRichCompareBool.EqNode.compareUncached(module, BuiltinNames.T_BUILTINS)) {
                sb.appendStringUncached(str.execute(null, null, qualname));
                return;
            }
            sb.appendStringUncached(str.execute(null, null, module));
            sb.appendCodePointUncached(46);
            sb.appendStringUncached(str.execute(null, null, qualname));
            return;
        }
        sb.appendStringUncached(PyObjectReprAsTruffleStringNode.executeUncached(obj));
    }

    @CompilerDirectives.TruffleBoundary
    static Object[] makeParameters(PTuple args) {
        PyObjectLookupAttr lookup = PyObjectLookupAttr.getUncached();
        SequenceStorage argsStorage = args.getSequenceStorage();
        int nargs = argsStorage.length();
        ArrayList<Object> parameters = new ArrayList<Object>(nargs);
        for (int iarg = 0; iarg < nargs; ++iarg) {
            Object t = GenericTypeNodes.getItemUncached(argsStorage, iarg);
            if (TypeNodes.IsTypeNode.executeUncached(t)) continue;
            Object subst = PyObjectLookupAttr.executeUncached(t, T___TYPING_SUBST__);
            if (subst != PNone.NO_VALUE) {
                GenericTypeNodes.listAdd(parameters, t);
                continue;
            }
            Object subparams = lookup.execute(null, null, t, SpecialAttributeNames.T___PARAMETERS__);
            if (!(subparams instanceof PTuple)) continue;
            PTuple subparamsTuple = (PTuple)subparams;
            SequenceStorage subparamsStorage = subparamsTuple.getSequenceStorage();
            for (int j = 0; j < subparamsStorage.length(); ++j) {
                GenericTypeNodes.listAdd(parameters, GenericTypeNodes.getItemUncached(subparamsStorage, j));
            }
        }
        return parameters.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    private static void listAdd(List<Object> list, Object obj) {
        if (GenericTypeNodes.listIndex(list, obj) < 0) {
            list.add(obj);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static int listIndex(List<Object> list, Object obj) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != obj) continue;
            return i;
        }
        return -1;
    }

    @CompilerDirectives.TruffleBoundary
    private static int tupleIndex(PTuple tuple, Object obj) {
        SequenceStorage storage = tuple.getSequenceStorage();
        for (int i = 0; i < storage.length(); ++i) {
            if (GenericTypeNodes.getItemUncached(storage, i) != obj) continue;
            return i;
        }
        return -1;
    }

    @CompilerDirectives.TruffleBoundary
    private static void listExtend(List<Object> list, PTuple tuple) {
        SequenceStorage storage = tuple.getSequenceStorage();
        for (int i = 0; i < storage.length(); ++i) {
            list.add(SequenceStorageNodes.GetItemScalarNode.executeUncached(storage, i));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean isUnpackedTypeVarTuple(Object arg) {
        if (TypeNodes.IsTypeNode.executeUncached(arg)) {
            return false;
        }
        Object result = PyObjectLookupAttr.executeUncached(arg, T___TYPING_IS_UNPACKED_TYPEVARTUPLE__);
        return PyObjectIsTrueNode.executeUncached(result);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object unpackedTupleArgs(Object item) {
        PGenericAlias alias;
        if (item instanceof PGenericAlias && (alias = (PGenericAlias)item).isStarred() && TypeNodes.IsSameTypeNode.executeUncached(alias.getOrigin(), (Object)PythonBuiltinClassType.PTuple)) {
            return alias.getArgs();
        }
        Object result = PyObjectLookupAttr.executeUncached(item, T___TYPING_UNPACKED_TUPLE_ARGS__);
        if (result instanceof PNone) {
            return null;
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] unpackArgs(Object item) {
        ArrayList<Object> newargs = new ArrayList<Object>();
        if (item instanceof PTuple) {
            PTuple tuple = (PTuple)item;
            SequenceStorage storage = tuple.getSequenceStorage();
            for (int i = 0; i < storage.length(); ++i) {
                GenericTypeNodes.unpackArgsInner(newargs, GenericTypeNodes.getItemUncached(storage, i));
            }
        } else {
            GenericTypeNodes.unpackArgsInner(newargs, item);
        }
        return newargs.toArray();
    }

    private static void unpackArgsInner(List<Object> newargs, Object item) {
        PTuple tuple;
        SequenceStorage storage;
        Object subargs;
        if (!TypeNodes.IsTypeNode.executeUncached(item) && (subargs = GenericTypeNodes.unpackedTupleArgs(item)) instanceof PTuple && ((storage = (tuple = (PTuple)subargs).getSequenceStorage()).length() <= 0 || GenericTypeNodes.getItemUncached(storage, storage.length() - 1) != PEllipsis.INSTANCE)) {
            for (int i = 0; i < storage.length(); ++i) {
                newargs.add(GenericTypeNodes.getItemUncached(storage, i));
            }
            return;
        }
        newargs.add(item);
    }

    @CompilerDirectives.TruffleBoundary
    static Object[] subsParameters(Node node, Object self, PTuple args, PTuple parameters, Object item) {
        SequenceStorage paramsStorage = parameters.getSequenceStorage();
        int nparams = paramsStorage.length();
        if (nparams == 0) {
            throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.S_IS_NOT_A_GENERIC_CLASS, PyObjectReprAsTruffleStringNode.executeUncached(self));
        }
        Object[] argitems = GenericTypeNodes.unpackArgs(item);
        for (int i = 0; i < nparams; ++i) {
            Object param = GenericTypeNodes.getItemUncached(paramsStorage, i);
            Object prepare = PyObjectLookupAttr.executeUncached(param, T___TYPING_PREPARE_SUBST__);
            if (prepare instanceof PNone) continue;
            Object itemarg = item instanceof PTuple ? item : PythonContext.get(node).factory().createTuple(new Object[]{item});
            item = CallNode.executeUncached(prepare, self, itemarg);
        }
        if (argitems.length != nparams) {
            throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.TypeError, ErrorMessages.TOO_S_ARGUMENTS_FOR_S_ACTUAL_D_EXPECTED_D, argitems.length > nparams ? "many" : "few", PyObjectReprAsTruffleStringNode.executeUncached(self), argitems.length, nparams);
        }
        SequenceStorage argsStorage = args.getSequenceStorage();
        ArrayList<Object> newargs = new ArrayList<Object>(argsStorage.length());
        for (int iarg = 0; iarg < argsStorage.length(); ++iarg) {
            Object arg = GenericTypeNodes.getItemUncached(argsStorage, iarg);
            if (TypeNodes.IsTypeNode.executeUncached(arg)) {
                newargs.add(arg);
                continue;
            }
            boolean unpack = GenericTypeNodes.isUnpackedTypeVarTuple(arg);
            Object subst = PyObjectLookupAttr.executeUncached(arg, T___TYPING_SUBST__);
            if (subst != PNone.NO_VALUE) {
                int iparam = GenericTypeNodes.tupleIndex(parameters, arg);
                assert (iparam >= 0);
                arg = CallNode.executeUncached(subst, argitems[iparam]);
            } else {
                arg = GenericTypeNodes.subsTvars(node, arg, parameters, argitems);
            }
            if (unpack && arg instanceof PTuple) {
                PTuple tuple = (PTuple)arg;
                GenericTypeNodes.listExtend(newargs, tuple);
                continue;
            }
            newargs.add(arg);
        }
        return newargs.toArray();
    }

    @CompilerDirectives.TruffleBoundary
    private static Object subsTvars(Node node, Object obj, PTuple parameters, Object[] argitems) {
        PTuple tuple;
        Object subparams = PyObjectLookupAttr.executeUncached(obj, SpecialAttributeNames.T___PARAMETERS__);
        if (subparams instanceof PTuple && (tuple = (PTuple)subparams).getSequenceStorage().length() > 0) {
            SequenceStorage subparamsStorage = tuple.getSequenceStorage();
            ArrayList<Object> subargs = new ArrayList<Object>(subparamsStorage.length());
            for (int i = 0; i < subparamsStorage.length(); ++i) {
                Object arg = GenericTypeNodes.getItemUncached(subparamsStorage, i);
                int foundIndex = GenericTypeNodes.tupleIndex(parameters, arg);
                if (foundIndex >= 0) {
                    Object param = arg;
                    arg = argitems[foundIndex];
                    if (arg instanceof PTuple) {
                        PTuple tuple1 = (PTuple)arg;
                        Object paramType = GetClassNode.executeUncached(param);
                        if (LookupCallableSlotInMRONode.getUncached(SpecialMethodSlot.Iter).execute(paramType) != PNone.NO_VALUE) {
                            GenericTypeNodes.listExtend(subargs, tuple1);
                        }
                    }
                }
                subargs.add(arg);
            }
            PTuple subargsTuple = PythonContext.get(node).factory().createTuple(subargs.toArray());
            obj = PyObjectGetItem.executeUncached(obj, subargsTuple);
        }
        return obj;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] dedupAndFlattenArgs(Object[] args) {
        args = GenericTypeNodes.flattenArgs(args);
        PyObjectRichCompareBool.EqNode eq = PyObjectRichCompareBool.EqNode.getUncached();
        Object[] newArgs = new Object[args.length];
        int addedItems = 0;
        for (int i = 0; i < args.length; ++i) {
            boolean isDuplicate = false;
            Object iElement = args[i];
            for (int j = 0; j < addedItems; ++j) {
                Object jElement = newArgs[j];
                boolean isGA = iElement instanceof PGenericAlias && jElement instanceof PGenericAlias;
                boolean bl = isDuplicate = isGA ? eq.compare(null, null, iElement, jElement) : IsNode.getUncached().execute(iElement, jElement);
                if (isDuplicate) break;
            }
            if (isDuplicate) continue;
            newArgs[addedItems++] = iElement;
        }
        if (addedItems != args.length) {
            newArgs = Arrays.copyOf(newArgs, addedItems);
        }
        return newArgs;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] flattenArgs(Object[] args) {
        int totalArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof PUnionType) {
                totalArgs += ((PUnionType)args[i]).getArgs().getSequenceStorage().length();
                continue;
            }
            ++totalArgs;
        }
        Object[] flattenedArgs = new Object[totalArgs];
        int pos = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof PUnionType) {
                SequenceStorage storage = ((PUnionType)args[i]).getArgs().getSequenceStorage();
                for (int j = 0; j < storage.length(); ++j) {
                    flattenedArgs[pos++] = GenericTypeNodes.getItemUncached(storage, j);
                }
                continue;
            }
            flattenedArgs[pos++] = args[i] == PNone.NONE ? PythonBuiltinClassType.PNone : args[i];
        }
        assert (pos == totalArgs);
        return flattenedArgs;
    }

    public static abstract class UnionTypeOrNode
    extends PNodeWithContext {
        public abstract Object execute(Object var1, Object var2);

        @Specialization(guards={"isUnionable(inliningTarget, typeCheck, self)", "isUnionable(inliningTarget, typeCheck, other)"}, limit="1")
        static Object union(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyObjectTypeCheck typeCheck, @Cached PythonObjectFactory factory) {
            Object[] args = GenericTypeNodes.dedupAndFlattenArgs(new Object[]{self, other});
            if (args.length == 1) {
                return args[0];
            }
            assert (args.length > 1);
            return factory.createUnionType(args);
        }

        @Fallback
        static Object notImplemented(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        protected static boolean isUnionable(Node inliningTarget, PyObjectTypeCheck typeCheck, Object obj) {
            return obj == PNone.NONE || typeCheck.execute(inliningTarget, obj, (Object)PythonBuiltinClassType.PythonClass) || typeCheck.execute(inliningTarget, obj, (Object)PythonBuiltinClassType.PGenericAlias) || typeCheck.execute(inliningTarget, obj, (Object)PythonBuiltinClassType.PUnionType);
        }
    }
}

