/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.iterator.PBigRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.lib.PyIterNextNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
public abstract class PyIterNextNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Object var2);

    @Specialization
    Object doIntRange(PIntRangeIterator iterator) {
        if (iterator.hasNextInt()) {
            return iterator.nextInt();
        }
        iterator.setExhausted();
        return null;
    }

    @Specialization
    Object doBigIntRange(PBigRangeIterator iterator, @Cached PythonObjectFactory factory) {
        if (iterator.hasNextBigInt()) {
            return factory.createInt(iterator.nextBigInt());
        }
        iterator.setExhausted();
        return null;
    }

    @Specialization
    static Object doGeneric(VirtualFrame frame, Object iterator, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(parameters={"Next"}) LookupSpecialMethodSlotNode lookupNext, @Cached CallUnaryMethodNode callNext, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached PRaiseNode.Lazy raiseNode) {
        Object nextMethod = lookupNext.execute((Frame)frame, getClassNode.execute(inliningTarget, iterator), iterator);
        if (nextMethod == PNone.NO_VALUE) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, iterator);
        }
        try {
            return callNext.executeObject((Frame)frame, nextMethod, iterator);
        }
        catch (PException e) {
            e.expectStopIteration(inliningTarget, stopIterationProfile);
            return null;
        }
    }

    public static PyIterNextNode create() {
        return PyIterNextNodeGen.create();
    }

    public static PyIterNextNode getUncached() {
        return PyIterNextNodeGen.getUncached();
    }
}

