/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;

@GenerateUncached
@ImportStatic(value={SpecialMethodSlot.class})
@GenerateInline(inlineByDefault=true)
public abstract class PySequenceIterSearchNode
extends PNodeWithContext {
    public static final int PY_ITERSEARCH_COUNT = 1;
    public static final int PY_ITERSEARCH_INDEX = 2;
    public static final int PY_ITERSEARCH_CONTAINS = 3;

    public final int executeCached(Frame frame, Object container, Object key, int operation) {
        return this.execute(frame, this, container, key, operation);
    }

    public final int execute(Node inliningTarget, Object container, Object key, int operation) {
        return this.execute(null, inliningTarget, container, key, operation);
    }

    public abstract int execute(Frame var1, Node var2, Object var3, Object var4, int var5);

    @Specialization
    static int search(Frame frame, Node inliningTarget, Object container, Object key, int operation, @Cached PyObjectGetIter getIter, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile noIterProfile, @Cached PRaiseNode.Lazy raiseNode, @Cached GetClassNode getIterClass, @Cached(parameters={"Next"}, inline=false) LookupSpecialMethodSlotNode lookupIternext, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile noNextProfile, @Cached(inline=false) CallUnaryMethodNode callNext, @Cached(inline=false) PyObjectRichCompareBool.EqNode eqNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached InlinedIntValueProfile opProfile) {
        Object iterator;
        try {
            iterator = getIter.execute(frame, inliningTarget, container);
        }
        catch (PException e) {
            e.expectTypeError(inliningTarget, noIterProfile);
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_CONTAINER, container);
        }
        Object next = PNone.NO_VALUE;
        try {
            next = lookupIternext.execute(frame, getIterClass.execute(inliningTarget, iterator), iterator);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, noNextProfile);
        }
        if (next instanceof PNone) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, iterator);
        }
        int i = 0;
        int n = 0;
        boolean wrapped = false;
        while (true) {
            try {
                if (eqNode.compare(frame, inliningTarget, callNext.executeObject(frame, next, iterator), key)) {
                    switch (opProfile.profile(inliningTarget, operation)) {
                        case 1: {
                            ++n;
                            break;
                        }
                        case 2: {
                            if (CompilerDirectives.hasNextTier()) {
                                LoopNode.reportLoopCount((Node)inliningTarget, (int)(wrapped ? Integer.MAX_VALUE : i + 1));
                            }
                            if (wrapped) {
                                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.INDEX_EXCEEDS_INT);
                            }
                            return i;
                        }
                        case 3: {
                            if (CompilerDirectives.hasNextTier()) {
                                LoopNode.reportLoopCount((Node)inliningTarget, (int)(wrapped ? Integer.MAX_VALUE : i + 1));
                            }
                            return 1;
                        }
                    }
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, stopIterationProfile);
                if (CompilerDirectives.hasNextTier()) {
                    LoopNode.reportLoopCount((Node)inliningTarget, (int)(wrapped ? Integer.MAX_VALUE : i + 1));
                }
                if (opProfile.profile(inliningTarget, operation) == 2) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.X_NOT_IN_SEQUENCE);
                }
                return n;
            }
            if (opProfile.profile(inliningTarget, operation) == 2 && i == Integer.MAX_VALUE) {
                wrapped = true;
            }
            ++i;
        }
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class LazyPySequenceIterSeachNode
    extends Node {
        public final PySequenceIterSearchNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        protected abstract PySequenceIterSearchNode execute(Node var1);

        @Specialization
        static PySequenceIterSearchNode doIt(@Cached(inline=false) PySequenceIterSearchNode node) {
            return node;
        }
    }
}

