/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNodeGen;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromPythonObjectNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PGuards.class, PythonOptions.class})
@ReportPolymorphism
@GenerateInline(value=false)
public abstract class ReadAttributeFromObjectNode
extends PNodeWithContext {
    @NeverDefault
    public static ReadAttributeFromObjectNode create() {
        return ReadAttributeFromObjectNodeGen.ReadAttributeFromObjectNotTypeNodeGen.create();
    }

    @NeverDefault
    public static ReadAttributeFromObjectNode createForceType() {
        return ReadAttributeFromObjectNodeGen.ReadAttributeFromObjectTpDictNodeGen.create();
    }

    public static ReadAttributeFromObjectNode getUncached() {
        return ReadAttributeFromObjectNodeGen.ReadAttributeFromObjectNotTypeNodeGen.getUncached();
    }

    public static ReadAttributeFromObjectNode getUncachedForceType() {
        return ReadAttributeFromObjectNodeGen.ReadAttributeFromObjectTpDictNodeGen.getUncached();
    }

    public abstract Object execute(Object var1, TruffleString var2);

    public abstract Object execute(PythonModule var1, TruffleString var2);

    protected static HashingStorage getStorage(Object module, PHashingCollection cachedGlobals) {
        return cachedGlobals.getDictStorage();
    }

    protected static PDict getDict(Object object) {
        return GetDictIfExistsNode.getUncached().execute(object);
    }

    @Specialization(guards={"isSingleContext()", "cachedObject == object", "getStorage(object, cachedDict) == cachedStorage"}, limit="1")
    protected static Object readFromBuiltinModuleDict(PythonModule object, TruffleString key, @Bind(value="this") Node inliningTarget, @Cached(value="object", weak=true) PythonModule cachedObject, @Cached(value="getDict(object)", weak=true) PHashingCollection cachedDict, @Cached(value="getStorage(object, getDict(object))", weak=true) HashingStorage cachedStorage, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
        Object value = getItem.execute(inliningTarget, cachedStorage, key);
        if (value == null) {
            return PNone.NO_VALUE;
        }
        return value;
    }

    @Specialization
    protected static Object readObjectAttribute(PythonObject object, TruffleString key, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile profileHasDict, @Cached.Exclusive @Cached GetDictIfExistsNode getDict, @Cached ReadAttributeFromPythonObjectNode readAttributeFromPythonObjectNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
        PDict dict = getDict.execute(object);
        if (profileHasDict.profile(inliningTarget, dict == null)) {
            return readAttributeFromPythonObjectNode.execute(object, key);
        }
        Object value = getItem.execute(null, inliningTarget, dict.getDictStorage(), key);
        if (value == null) {
            return PNone.NO_VALUE;
        }
        return value;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"!isPythonObject(object)", "!isNativeObject(object)"})
    protected static Object readForeignOrPrimitive(Object object, TruffleString key) {
        return PNone.NO_VALUE;
    }

    private static Object readNative(Node inliningTarget, TruffleString key, Object dict, HashingStorageNodes.HashingStorageGetItem getItem) {
        Object result;
        if (dict instanceof PHashingCollection && (result = getItem.execute(null, inliningTarget, ((PHashingCollection)dict).getDictStorage(), key)) != null) {
            return result;
        }
        return PNone.NO_VALUE;
    }

    @GenerateUncached
    @GenerateInline(value=false)
    protected static abstract class ReadAttributeFromObjectNotTypeNode
    extends ReadAttributeFromObjectNode {
        protected ReadAttributeFromObjectNotTypeNode() {
        }

        @Specialization(insertBefore="readForeignOrPrimitive")
        protected static Object readNativeObject(PythonAbstractNativeObject object, TruffleString key, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetDictIfExistsNode getDict, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            return ReadAttributeFromObjectNode.readNative(inliningTarget, key, getDict.execute(object), getItem);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    protected static abstract class ReadAttributeFromObjectTpDictNode
    extends ReadAttributeFromObjectNode {
        protected ReadAttributeFromObjectTpDictNode() {
        }

        @Specialization(insertBefore="readForeignOrPrimitive")
        protected static Object readNativeClass(PythonAbstractNativeObject object, TruffleString key, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.ReadObjectNode getNativeDict, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            return ReadAttributeFromObjectNode.readNative(inliningTarget, key, getNativeDict.readFromObj(object, CFields.PyTypeObject__tp_dict), getItem);
        }
    }
}

