/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupInheritedAttributeNode;
import com.oracle.graal.python.nodes.bytecode.GetAIterNodeGen;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateUncached
@ImportStatic(value={SpecialMethodSlot.class})
@GenerateInline(value=false)
public abstract class GetAIterNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Object var2);

    public static GetAIterNode getUncached() {
        return GetAIterNodeGen.getUncached();
    }

    public static GetAIterNode create() {
        return GetAIterNodeGen.create();
    }

    @Specialization
    Object doGeneric(Frame frame, Object receiver, @Bind(value="this") Node inliningTarget, @Cached(parameters={"AIter"}) LookupSpecialMethodSlotNode getAIter, @Cached GetClassNode getAsyncIterType, @Cached PRaiseNode.Lazy raiseNoAIter, @Cached TypeNodes.GetNameNode getName, @Cached InlinedBranchProfile errorProfile, @Cached CallUnaryMethodNode callAIter, @Cached LookupInheritedAttributeNode.Dynamic lookupANext) {
        Object type = getAsyncIterType.execute(inliningTarget, receiver);
        Object getter = getAIter.execute(frame, type, receiver);
        if (getter == PNone.NO_VALUE) {
            errorProfile.enter((Node)this);
            throw raiseNoAIter.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ASYNC_FOR_NO_AITER, getName.execute(inliningTarget, type));
        }
        Object asyncIterator = callAIter.executeObject(frame, getter, receiver);
        Object anext = lookupANext.execute(inliningTarget, asyncIterator, SpecialMethodNames.T___ANEXT__);
        if (anext == PNone.NO_VALUE) {
            errorProfile.enter((Node)this);
            throw raiseNoAIter.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ASYNC_FOR_NO_ANEXT_INITIAL, getName.execute(inliningTarget, type));
        }
        return asyncIterator;
    }
}

