/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.classes;

import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupInheritedAttributeNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.AbstractObjectGetBasesNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@ImportStatic(value={SpecialMethodNames.class})
public abstract class AbstractObjectGetBasesNode
extends PNodeWithContext {
    @NeverDefault
    public static AbstractObjectGetBasesNode create() {
        return AbstractObjectGetBasesNodeGen.create();
    }

    protected abstract PTuple executeInternal(Frame var1, Object var2);

    public final PTuple execute(VirtualFrame frame, Object cls) {
        return this.executeInternal((Frame)frame, cls);
    }

    @Specialization(guards={"!isUncachedNode()"})
    static PTuple getBasesCached(VirtualFrame frame, Object cls, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttributeNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exceptionMaskProfile) {
        try {
            Object bases = getAttributeNode.execute((Frame)frame, inliningTarget, cls, SpecialAttributeNames.T___BASES__);
            if (bases instanceof PTuple) {
                return (PTuple)bases;
            }
        }
        catch (PException pe) {
            pe.expectAttributeError(inliningTarget, exceptionMaskProfile);
        }
        return null;
    }

    @Specialization(replaces={"getBasesCached"})
    static PTuple getBasesUncached(VirtualFrame frame, Object cls, @Bind(value="this") Node inliningTarget, @Cached LookupInheritedAttributeNode.Dynamic lookupGetattributeNode, @Cached CallNode callGetattributeNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exceptionMaskProfile) {
        Object getattr = lookupGetattributeNode.execute(inliningTarget, cls, SpecialMethodNames.T___GETATTRIBUTE__);
        try {
            Object bases = callGetattributeNode.execute((Frame)frame, getattr, cls, SpecialAttributeNames.T___BASES__);
            if (bases instanceof PTuple) {
                return (PTuple)bases;
            }
        }
        catch (PException pe) {
            pe.expectAttributeError(inliningTarget, exceptionMaskProfile);
        }
        return null;
    }
}

