/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNodeFactory;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@TypeSystemReference(value=PythonArithmeticTypes.class)
public abstract class BinaryComparisonNode
extends BinaryOpNode {
    public abstract boolean cmp(int var1, int var2);

    public abstract boolean cmp(long var1, long var3);

    public abstract boolean cmp(char var1, char var2);

    public abstract boolean cmp(byte var1, byte var2);

    public abstract boolean cmp(double var1, double var3);

    public abstract boolean executeBool(VirtualFrame var1, Object var2, Object var3) throws UnexpectedResultException;

    public static abstract class NeNode
    extends FallbackNode {
        @Override
        @Specialization
        public final boolean cmp(int l, int r) {
            return l != r;
        }

        @Override
        @Specialization
        public final boolean cmp(long l, long r) {
            return l != r;
        }

        @Override
        @Specialization
        public final boolean cmp(char l, char r) {
            return l != r;
        }

        @Override
        @Specialization
        public final boolean cmp(byte l, byte r) {
            return l != r;
        }

        @Override
        @Specialization
        public final boolean cmp(double l, double r) {
            return l != r;
        }

        @Override
        @Specialization
        public final boolean cmp(TruffleString l, TruffleString r, @Cached TruffleString.EqualNode equalNode) {
            return !equalNode.execute((AbstractTruffleString)l, (AbstractTruffleString)r, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static boolean cmp(int l, double r) {
            return (double)l != r;
        }

        @Specialization
        static boolean cmp(double l, int r) {
            return l != (double)r;
        }

        @Specialization
        protected final Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode) {
            Object result = callNode.executeObject(frame, left, right);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                return !this.ensureIsNode().execute(left, right);
            }
            return result;
        }

        @NeverDefault
        protected static LookupAndCallBinaryNode createCallNode() {
            return LookupAndCallBinaryNode.create(SpecialMethodSlot.Ne, SpecialMethodSlot.Ne, true, true);
        }

        @NeverDefault
        public static NeNode create() {
            return BinaryComparisonNodeFactory.NeNodeGen.create();
        }
    }

    public static abstract class EqNode
    extends FallbackNode {
        @Override
        @Specialization
        public final boolean cmp(int l, int r) {
            return l == r;
        }

        @Override
        @Specialization
        public final boolean cmp(long l, long r) {
            return l == r;
        }

        @Override
        @Specialization
        public final boolean cmp(char l, char r) {
            return l == r;
        }

        @Override
        @Specialization
        public final boolean cmp(byte l, byte r) {
            return l == r;
        }

        @Override
        @Specialization
        public final boolean cmp(double l, double r) {
            return l == r;
        }

        @Override
        @Specialization
        public final boolean cmp(TruffleString l, TruffleString r, @Cached TruffleString.EqualNode equalNode) {
            return equalNode.execute((AbstractTruffleString)l, (AbstractTruffleString)r, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static boolean cmp(int l, double r) {
            return (double)l == r;
        }

        @Specialization
        static boolean cmp(double l, int r) {
            return l == (double)r;
        }

        @Specialization
        protected final Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode) {
            Object result = callNode.executeObject(frame, left, right);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                return this.ensureIsNode().execute(left, right);
            }
            return result;
        }

        @NeverDefault
        protected static LookupAndCallBinaryNode createCallNode() {
            return LookupAndCallBinaryNode.create(SpecialMethodSlot.Eq, SpecialMethodSlot.Eq, true, true);
        }

        @NeverDefault
        public static EqNode create() {
            return BinaryComparisonNodeFactory.EqNodeGen.create();
        }
    }

    public static abstract class GtNode
    extends ErrorNode {
        @Override
        @Specialization
        public final boolean cmp(int l, int r) {
            return l > r;
        }

        @Override
        @Specialization
        public final boolean cmp(long l, long r) {
            return l > r;
        }

        @Override
        @Specialization
        public final boolean cmp(char l, char r) {
            return l > r;
        }

        @Override
        @Specialization
        public final boolean cmp(byte l, byte r) {
            return l > r;
        }

        @Override
        @Specialization
        public final boolean cmp(double l, double r) {
            return l > r;
        }

        @Override
        @Specialization
        public final boolean cmp(TruffleString l, TruffleString r, @Cached TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return StringUtils.compareStrings(l, r, compareIntsUTF32Node) > 0;
        }

        @Specialization
        static boolean cmp(int l, double r) {
            return (double)l > r;
        }

        @Specialization
        static boolean cmp(double l, int r) {
            return l > (double)r;
        }

        @Specialization
        protected final Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode) {
            Object result = callNode.executeObject(frame, left, right);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                throw this.noSupported(left, right);
            }
            return result;
        }

        @NeverDefault
        protected static LookupAndCallBinaryNode createCallNode() {
            return LookupAndCallBinaryNode.create(SpecialMethodSlot.Gt, SpecialMethodSlot.Lt, true, true);
        }

        @Override
        protected String operator() {
            return ">";
        }

        @NeverDefault
        public static GtNode create() {
            return BinaryComparisonNodeFactory.GtNodeGen.create();
        }
    }

    public static abstract class GeNode
    extends ErrorNode {
        @Override
        @Specialization
        public final boolean cmp(int l, int r) {
            return l >= r;
        }

        @Override
        @Specialization
        public final boolean cmp(long l, long r) {
            return l >= r;
        }

        @Override
        @Specialization
        public final boolean cmp(char l, char r) {
            return l >= r;
        }

        @Override
        @Specialization
        public final boolean cmp(byte l, byte r) {
            return l >= r;
        }

        @Override
        @Specialization
        public final boolean cmp(double l, double r) {
            return l >= r;
        }

        @Override
        @Specialization
        public final boolean cmp(TruffleString l, TruffleString r, @Cached TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return StringUtils.compareStrings(l, r, compareIntsUTF32Node) >= 0;
        }

        @Specialization
        static boolean cmp(int l, double r) {
            return (double)l >= r;
        }

        @Specialization
        static boolean cmp(double l, int r) {
            return l >= (double)r;
        }

        @Specialization
        protected final Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode) {
            Object result = callNode.executeObject(frame, left, right);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                throw this.noSupported(left, right);
            }
            return result;
        }

        @NeverDefault
        protected static LookupAndCallBinaryNode createCallNode() {
            return LookupAndCallBinaryNode.create(SpecialMethodSlot.Ge, SpecialMethodSlot.Le, true, true);
        }

        @Override
        protected String operator() {
            return ">=";
        }

        @NeverDefault
        public static GeNode create() {
            return BinaryComparisonNodeFactory.GeNodeGen.create();
        }
    }

    public static abstract class LtNode
    extends ErrorNode {
        @Override
        @Specialization
        public final boolean cmp(int l, int r) {
            return l < r;
        }

        @Override
        @Specialization
        public final boolean cmp(long l, long r) {
            return l < r;
        }

        @Override
        @Specialization
        public final boolean cmp(char l, char r) {
            return l < r;
        }

        @Override
        @Specialization
        public final boolean cmp(byte l, byte r) {
            return l < r;
        }

        @Override
        @Specialization
        public final boolean cmp(double l, double r) {
            return l < r;
        }

        @Override
        @Specialization
        public final boolean cmp(TruffleString l, TruffleString r, @Cached TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return StringUtils.compareStrings(l, r, compareIntsUTF32Node) < 0;
        }

        @Specialization
        static boolean cmp(int l, double r) {
            return (double)l < r;
        }

        @Specialization
        static boolean cmp(double l, int r) {
            return l < (double)r;
        }

        @Specialization
        protected final Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode) {
            Object result = callNode.executeObject(frame, left, right);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                throw this.noSupported(left, right);
            }
            return result;
        }

        @NeverDefault
        protected static LookupAndCallBinaryNode createCallNode() {
            return LookupAndCallBinaryNode.create(SpecialMethodSlot.Lt, SpecialMethodSlot.Gt, true, true);
        }

        @Override
        protected String operator() {
            return "<";
        }

        @NeverDefault
        public static LtNode create() {
            return BinaryComparisonNodeFactory.LtNodeGen.create();
        }
    }

    public static abstract class LeNode
    extends ErrorNode {
        @Override
        @Specialization
        public final boolean cmp(int l, int r) {
            return l <= r;
        }

        @Override
        @Specialization
        public final boolean cmp(long l, long r) {
            return l <= r;
        }

        @Override
        @Specialization
        public final boolean cmp(char l, char r) {
            return l <= r;
        }

        @Override
        @Specialization
        public final boolean cmp(byte l, byte r) {
            return l <= r;
        }

        @Override
        @Specialization
        public final boolean cmp(double l, double r) {
            return l <= r;
        }

        @Override
        @Specialization
        public final boolean cmp(TruffleString l, TruffleString r, @Cached TruffleString.CompareIntsUTF32Node compareIntsUTF32Node) {
            return StringUtils.compareStrings(l, r, compareIntsUTF32Node) <= 0;
        }

        @Specialization
        static boolean cmp(int l, double r) {
            return (double)l <= r;
        }

        @Specialization
        static boolean cmp(double l, int r) {
            return l <= (double)r;
        }

        @Specialization
        protected final Object doGeneric(VirtualFrame frame, Object left, Object right, @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode) {
            Object result = callNode.executeObject(frame, left, right);
            if (result == PNotImplemented.NOT_IMPLEMENTED) {
                throw this.noSupported(left, right);
            }
            return result;
        }

        @NeverDefault
        protected static LookupAndCallBinaryNode createCallNode() {
            return LookupAndCallBinaryNode.create(SpecialMethodSlot.Le, SpecialMethodSlot.Ge, true, true);
        }

        @Override
        protected final String operator() {
            return "<=";
        }

        @NeverDefault
        public static LeNode create() {
            return BinaryComparisonNodeFactory.LeNodeGen.create();
        }
    }

    private static abstract class FallbackNode
    extends BinaryComparisonNode {
        @Node.Child
        private IsNode isNode;

        private FallbackNode() {
        }

        protected final IsNode ensureIsNode() {
            if (this.isNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isNode = (IsNode)this.insert(IsNode.create());
            }
            return this.isNode;
        }

        public abstract boolean cmp(TruffleString var1, TruffleString var2, TruffleString.EqualNode var3);
    }

    private static abstract class ErrorNode
    extends BinaryComparisonNode {
        @Node.Child
        private PRaiseNode raiseNode;

        private ErrorNode() {
        }

        protected final RuntimeException noSupported(Object left, Object right) {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.NOT_SUPPORTED_BETWEEN_INSTANCES, this.operator(), left, right);
        }

        protected abstract String operator();

        public abstract boolean cmp(TruffleString var1, TruffleString var2, TruffleString.CompareIntsUTF32Node var3);
    }
}

