/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class PythonVarargsBuiltinNode
extends PythonBuiltinBaseNode {
    @Node.Child
    private PythonObjectFactory objectFactory;
    @Node.Child
    private PRaiseNode raiseNode;

    protected final PythonObjectFactory factory() {
        if (this.objectFactory == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.objectFactory = this.isAdoptable() ? (PythonObjectFactory)this.insert(PythonObjectFactory.create()) : this.getContext().factory();
        }
        return this.objectFactory;
    }

    protected final PRaiseNode getRaiseNode() {
        if (this.raiseNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.raiseNode = this.isAdoptable() ? (PRaiseNode)this.insert(PRaiseNode.create()) : PRaiseNode.getUncached();
        }
        return this.raiseNode;
    }

    public PException raise(PythonBuiltinClassType type, TruffleString string) {
        return this.getRaiseNode().raise(type, string);
    }

    public final PException raise(PythonBuiltinClassType type, TruffleString format, Object ... arguments) {
        return this.getRaiseNode().raise(type, format, arguments);
    }

    public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws VarargsBuiltinDirectInvocationNotSupported {
        throw VarargsBuiltinDirectInvocationNotSupported.INSTANCE;
    }

    public abstract Object execute(VirtualFrame var1, Object var2, Object[] var3, PKeyword[] var4);

    public static final class VarargsBuiltinDirectInvocationNotSupported
    extends ControlFlowException {
        public static final VarargsBuiltinDirectInvocationNotSupported INSTANCE = new VarargsBuiltinDirectInvocationNotSupported();
        private static final long serialVersionUID = 1L;

        private VarargsBuiltinDirectInvocationNotSupported() {
        }
    }
}

