/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.BuiltinCallNode;
import com.oracle.graal.python.nodes.function.builtins.SlotWrapper;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;
import org.graalvm.collections.Pair;

public final class WrapTpNew
extends SlotWrapper {
    @Node.Child
    private TypeNodes.IsTypeNode isType;
    @Node.Child
    private IsSubtypeNode isSubtype;
    @Node.Child
    private PRaiseNode raiseNode;
    @Node.Child
    private LookupAttributeInMRONode lookupNewNode;
    @CompilerDirectives.CompilationFinal
    private ValueProfile builtinProfile;
    @CompilerDirectives.CompilationFinal
    private byte state = 0;
    private final PythonBuiltinClassType owner;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Pair<?, ?>[] cachedFactoriesNodeClasses = new Pair[2];
    private static final byte NOT_SUBTP_STATE = 4;
    private static final byte NOT_CLASS_STATE = 2;
    private static final byte IS_UNSAFE_STATE = 1;

    public WrapTpNew(BuiltinCallNode func, PythonBuiltinClassType owner) {
        super(func);
        this.owner = owner;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object cls;
        try {
            cls = PArguments.getArgument((Frame)frame, 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException(String.valueOf(this.owner.getName()) + ".__new__ called without arguments");
        }
        if (cls != this.owner) {
            Object newMethod;
            if (this.isType == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.isType = (TypeNodes.IsTypeNode)this.insert(TypeNodes.IsTypeNode.create());
            }
            if (!this.isType.executeCached(cls)) {
                if ((this.state & 2) == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.reportPolymorphicSpecialize();
                    this.state = (byte)(this.state | 2);
                }
                throw this.getRaiseNode().raise(PythonBuiltinClassType.TypeError, ErrorMessages.NEW_X_ISNT_TYPE_OBJ, this.owner.getName(), cls);
            }
            if (this.isSubtype == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.isSubtype = (IsSubtypeNode)this.insert(IsSubtypeNode.create());
            }
            if (!this.isSubtype.execute(cls, (Object)this.owner)) {
                if ((this.state & 4) == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.reportPolymorphicSpecialize();
                    this.state = (byte)(this.state | 4);
                }
                throw this.getRaiseNode().raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_SUBTYPE_OF, this.owner.getName(), cls, cls, this.owner.getName());
            }
            if (this.lookupNewNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                this.lookupNewNode = (LookupAttributeInMRONode)this.insert(LookupAttributeInMRONode.createForLookupOfUnmanagedClasses(SpecialMethodNames.T___NEW__));
            }
            if ((newMethod = this.lookupNewNode.execute(cls)) instanceof PBuiltinMethod) {
                NodeFactory<? extends PythonBuiltinBaseNode> factory;
                if (this.builtinProfile == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.builtinProfile = PythonUtils.createValueIdentityProfile();
                }
                if ((factory = ((PBuiltinMethod)this.builtinProfile.profile(newMethod)).getBuiltinFunction().getBuiltinNodeFactory()) != null && !this.getFactoryNodeClass(factory).isInstance((Object)this.getNode())) {
                    if ((this.state & 1) == 0) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.reportPolymorphicSpecialize();
                        this.state = (byte)(this.state | 1);
                    }
                    throw this.getRaiseNode().raise(PythonBuiltinClassType.TypeError, ErrorMessages.NEW_IS_NOT_SAFE_USE_ELSE, this.owner.getName(), cls, cls);
                }
            }
        }
        return super.execute(frame);
    }

    @ExplodeLoop
    private final Class<? extends PythonBuiltinBaseNode> getFactoryNodeClass(NodeFactory<? extends PythonBuiltinBaseNode> factory) {
        for (int i = 0; i < this.cachedFactoriesNodeClasses.length; ++i) {
            Pair<?, ?> pair = this.cachedFactoriesNodeClasses[i];
            if (pair == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.reportPolymorphicSpecialize();
                Class nodeclass = factory.getNodeClass();
                this.cachedFactoriesNodeClasses[i] = Pair.create(factory, (Object)nodeclass);
                return nodeclass;
            }
            if (pair.getLeft() != factory) continue;
            return (Class)pair.getRight();
        }
        return WrapTpNew.getFactoryNodeClassUncached(factory);
    }

    @CompilerDirectives.TruffleBoundary
    private static final Class<? extends PythonBuiltinBaseNode> getFactoryNodeClassUncached(NodeFactory<? extends PythonBuiltinBaseNode> factory) {
        return factory.getNodeClass();
    }

    private PRaiseNode getRaiseNode() {
        if (this.raiseNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
        }
        return this.raiseNode;
    }
}

