/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.IntConversionBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.SliceIndexConversionNodeGen;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class SliceIndexConversionNode
extends IntConversionBaseNode {
    protected SliceIndexConversionNode(int defaultValue, boolean useDefaultForNone) {
        super(defaultValue, useDefaultForNone);
    }

    @Specialization(guards={"!isHandledPNone(value)"})
    static int doOthers(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached PRaiseNode.Lazy raiseNode) {
        if (indexCheckNode.execute(inliningTarget, value)) {
            return asSizeNode.executeLossy((Frame)frame, inliningTarget, value);
        }
        throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SLICE_INDICES_TYPE_ERROR);
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int})
    @NeverDefault
    public static SliceIndexConversionNode create(@ClinicConverterFactory.DefaultValue int defaultValue, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        return SliceIndexConversionNodeGen.create(defaultValue, useDefaultForNone);
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Int})
    @NeverDefault
    public static SliceIndexConversionNode create(@ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        assert (!useDefaultForNone) : "defaultValue must be provided if useDefaultForNone is true";
        return SliceIndexConversionNodeGen.create(0, false);
    }
}

