/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNodeGen;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={PGuards.class})
public abstract class GetOrCreateDictNode
extends PNodeWithContext {
    public abstract PDict execute(Node var1, Object var2);

    public final PDict executeCached(Object object) {
        return this.execute(this, object);
    }

    public static PDict executeUncached(Object object) {
        return GetOrCreateDictNodeGen.getUncached().execute(null, object);
    }

    @Specialization
    static PDict doPythonObject(Node inliningTarget, PythonObject object, @Cached.Shared(value="getDict") @Cached(inline=false) GetDictIfExistsNode getDictIfExistsNode, @Cached SetDictNode setDictNode, @Cached InlinedBranchProfile createDict, @Cached(inline=false) PythonObjectFactory factory) {
        PDict dict = getDictIfExistsNode.execute(object);
        if (dict == null) {
            createDict.enter(inliningTarget);
            dict = factory.createDictFixedStorage(object);
            setDictNode.execute(inliningTarget, object, dict);
        }
        return dict;
    }

    @Specialization(guards={"!isPythonObject(object)"})
    static PDict doOther(Node inliningTarget, Object object, @Cached.Shared(value="getDict") @Cached(inline=false) GetDictIfExistsNode getDict) {
        PDict dict = getDict.execute(object);
        if (dict == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.UNABLE_SET_DICT_OF_OBJ, object);
        }
        return dict;
    }

    @NeverDefault
    public static GetOrCreateDictNode create() {
        return GetOrCreateDictNodeGen.create();
    }
}

