/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline
@GenerateCached(value=false)
@TypeSystemReference(value=PythonArithmeticTypes.class)
@ImportStatic(value={PGuards.class})
public abstract class CoerceToComplexNode
extends PNodeWithContext {
    public abstract PComplex execute(VirtualFrame var1, Node var2, Object var3);

    @Specialization
    static PComplex doLong(long x, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
        return factory.createComplex(x, 0.0);
    }

    @Specialization
    static PComplex doDouble(double x, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory) {
        return factory.createComplex(x, 0.0);
    }

    @Specialization
    static PComplex doComplex(PComplex x) {
        return x;
    }

    @Specialization(guards={"!isPComplex(x)"})
    static PComplex toComplex(VirtualFrame frame, Node inliningTarget, Object x, @Cached(value="create(T___COMPLEX__)", inline=false) LookupAndCallUnaryNode callComplexFunc, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared @Cached(inline=false) PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
        Object result = callComplexFunc.executeObject(frame, x);
        if (result != PNone.NO_VALUE) {
            if (result instanceof PComplex) {
                return (PComplex)result;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_RETURN, "__complex__", "complex object");
        }
        return factory.createComplex(asDoubleNode.execute(frame, inliningTarget, x), 0.0);
    }
}

