/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ErrorMessageFormatter {
    private static final Object REMOVED_MARKER = new Object();
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @CompilerDirectives.TruffleBoundary
    public static String format(TruffleString format, Object ... args) {
        return ErrorMessageFormatter.format(format.toJavaStringUncached(), args);
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(String format, Object ... args) {
        CompilerAsserts.neverPartOfCompilation();
        Matcher m = fsPattern.matcher(format);
        StringBuilder sb = new StringBuilder(format);
        int removedCnt = 0;
        int matchIdx = 0;
        int idx = 0;
        int offset = 0;
        while (m.find(idx)) {
            String group = m.group();
            if ("%p".equals(group)) {
                name = ErrorMessageFormatter.getClassName(args[matchIdx]);
                sb.replace(m.start() + offset, m.end() + offset, (String)name);
                offset += ((String)name).length() - (m.end() - m.start());
                args[matchIdx] = REMOVED_MARKER;
                ++removedCnt;
            } else if ("%P".equals(group)) {
                name = "<class '" + ErrorMessageFormatter.getClassName(args[matchIdx]) + "'>";
                sb.replace(m.start() + offset, m.end() + offset, (String)name);
                offset += ((String)name).length() - (m.end() - m.start());
                args[matchIdx] = REMOVED_MARKER;
                ++removedCnt;
            } else if ("%N".equals(group)) {
                name = ErrorMessageFormatter.getClassNameOfClass(args[matchIdx]);
                sb.replace(m.start() + offset, m.end() + offset, (String)name);
                offset += ((String)name).length() - (m.end() - m.start());
                args[matchIdx] = REMOVED_MARKER;
                ++removedCnt;
            } else if ("%m".equals(group) && args[matchIdx] instanceof Throwable) {
                String exceptionMessage = ErrorMessageFormatter.getMessage((Throwable)args[matchIdx]);
                sb.replace(m.start() + offset, m.end() + offset, exceptionMessage);
                offset += exceptionMessage.length() - (m.end() - m.start());
                args[matchIdx] = REMOVED_MARKER;
                ++removedCnt;
            }
            idx = m.end();
            if ("%%".equals(group)) continue;
            ++matchIdx;
        }
        return PythonUtils.formatJString(sb.toString(), ErrorMessageFormatter.compact(args, removedCnt));
    }

    @CompilerDirectives.TruffleBoundary
    private static String getMessage(Throwable exception) {
        String message = exception.getClass().getSimpleName() + ": " + exception.getMessage();
        if (PythonOptions.shouldPrintJavaStacktrace(PythonLanguage.get(null), exception)) {
            StringWriter writer = new StringWriter();
            try (PrintWriter pw = new PrintWriter(writer);){
                exception.printStackTrace(pw);
            }
            message = message + "\n\nJava stack trace:\n" + String.valueOf(writer);
        }
        return message;
    }

    private static String getClassName(Object obj) {
        return ErrorMessageFormatter.getClassNameOfClass(GetClassNode.executeUncached(obj));
    }

    private static String getClassNameOfClass(Object type) {
        return TypeNodes.GetNameNode.doSlowPath(type).toJavaStringUncached();
    }

    public static boolean containsCustomSpecifier(String format) {
        int pidx = -1;
        while ((pidx = format.indexOf(37, pidx + 1)) != -1 && pidx + 1 < format.length()) {
            char c = format.charAt(pidx + 1);
            if (c != 'p' && c != 'P' && c != 'm' && c != 'N') continue;
            return true;
        }
        return false;
    }

    private static Object[] compact(Object[] args, int removedCnt) {
        Object[] compacted = new Object[args.length - removedCnt];
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == REMOVED_MARKER) continue;
            compacted[j++] = args[i];
        }
        return compacted;
    }
}

