/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSPolyglotHostServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotHostServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import org.graalvm.jniutils.HSObject;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.ProcessHandler;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class HSPolyglotHostServicesGen {
    HSPolyglotHostServicesGen() {
    }

    static HSPolyglotHostServices createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSPolyglotHostServices {
        private static final BinaryMarshaller<Object> objectWithContextReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public void attachPolyglotThread(long l2, long l3, long l4, boolean bl, long l5) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)6, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                jValue.addressOf(2).setLong(l3);
                jValue.addressOf(3).setLong(l4);
                jValue.addressOf(4).setBoolean(bl);
                jValue.addressOf(5).setLong(l5);
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.attachPolyglotThreadMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void detachPolyglotThread(long l2, long l3, long l4, boolean bl) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)5, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                jValue.addressOf(2).setLong(l3);
                jValue.addressOf(3).setLong(l4);
                jValue.addressOf(4).setBoolean(bl);
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.detachPolyglotThreadMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isDefaultProcessHandler(ProcessHandler processHandler) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(processHandler != null ? ((HSObject)processHandler).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isDefaultProcessHandlerMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isInCurrentEngineHostCallback(long l2, long l3) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                jValue.addressOf(2).setLong(l3);
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isInCurrentEngineHostCallbackMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isInternalFileSystem(FileSystem fileSystem) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(fileSystem != null ? ((HSObject)fileSystem).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isInternalFileSystemMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyPolyglotThreadStart(Object object, long l2) {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = objectWithContextReceiverMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithContextReceiverMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setLong(l2);
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.notifyPolyglotThreadStartMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public long retrieveHostStackOverflowLimit() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.retrieveHostStackOverflowLimitMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithContextReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.ContextReceiver.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod attachPolyglotThreadMethod;
            final JNICalls.JNIMethod detachPolyglotThreadMethod;
            final JNICalls.JNIMethod isDefaultProcessHandlerMethod;
            final JNICalls.JNIMethod isInCurrentEngineHostCallbackMethod;
            final JNICalls.JNIMethod isInternalFileSystemMethod;
            final JNICalls.JNIMethod notifyPolyglotThreadStartMethod;
            final JNICalls.JNIMethod retrieveHostStackOverflowLimitMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.attachPolyglotThreadMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"attachPolyglotThread", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;JJJZJ)V");
                this.detachPolyglotThreadMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"detachPolyglotThread", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;JJJZ)V");
                this.isDefaultProcessHandlerMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isDefaultProcessHandler", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;Lorg/graalvm/polyglot/io/ProcessHandler;)Z");
                this.isInCurrentEngineHostCallbackMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isInCurrentEngineHostCallback", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;JJ)Z");
                this.isInternalFileSystemMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isInternalFileSystem", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;Lorg/graalvm/polyglot/io/FileSystem;)Z");
                this.notifyPolyglotThreadStartMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"notifyPolyglotThreadStart", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;J[B)V");
                this.retrieveHostStackOverflowLimitMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"retrieveHostStackOverflowLimit", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;)J");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Object> objectWithContextReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void attachPolyglotThread(PolyglotHostServices polyglotHostServices, long l2, long l3, long l4, boolean bl, long l5) {
            try {
                polyglotHostServices.attachPolyglotThread(l2, l3, l4, bl, l5);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void detachPolyglotThread(PolyglotHostServices polyglotHostServices, long l2, long l3, long l4, boolean bl) {
            try {
                polyglotHostServices.detachPolyglotThread(l2, l3, l4, bl);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isDefaultProcessHandler(PolyglotHostServices polyglotHostServices, ProcessHandler processHandler) {
            try {
                boolean bl = polyglotHostServices.isDefaultProcessHandler(processHandler);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isInCurrentEngineHostCallback(PolyglotHostServices polyglotHostServices, long l2, long l3) {
            try {
                boolean bl = polyglotHostServices.isInCurrentEngineHostCallback(l2, l3);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isInternalFileSystem(PolyglotHostServices polyglotHostServices, FileSystem fileSystem) {
            try {
                boolean bl = polyglotHostServices.isInternalFileSystem(fileSystem);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void notifyPolyglotThreadStart(PolyglotHostServices polyglotHostServices, long l2, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithContextReceiverMarshaller.read(binaryInput);
                polyglotHostServices.notifyPolyglotThreadStart(object, l2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long retrieveHostStackOverflowLimit(PolyglotHostServices polyglotHostServices) {
            try {
                long l2 = polyglotHostServices.retrieveHostStackOverflowLimit();
                return l2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithContextReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.ContextReceiver.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

