/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeExecutionEventDispatch;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.List;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativebridge.TypeLiteral;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.word.WordFactory;

final class NativeExecutionEventDispatchGen {
    NativeExecutionEventDispatchGen() {
    }

    static NativeExecutionEventDispatch createHSToNative(AbstractPolyglotImpl abstractPolyglotImpl) {
        return new StartPoint(abstractPolyglotImpl);
    }

    static NativeExecutionEventDispatch createNativeToNative(AbstractPolyglotImpl abstractPolyglotImpl) {
        return new StartPoint(abstractPolyglotImpl);
    }

    static NativeExecutionEventDispatch create(AbstractPolyglotImpl abstractPolyglotImpl) {
        if (ImageInfo.inImageCode()) {
            return NativeExecutionEventDispatchGen.createNativeToNative(abstractPolyglotImpl);
        }
        return NativeExecutionEventDispatchGen.createHSToNative(abstractPolyglotImpl);
    }

    private static final class StartPoint
    extends NativeExecutionEventDispatch {
        private static final BinaryMarshaller<List<Object>> listOfObjectWithValuesListMarshaller;
        private static final BinaryMarshaller<Object> objectWithSourceSectionReceiverMarshaller;
        private static final BinaryMarshaller<Object> objectWithValueReceiverMarshaller;
        private static final BinaryMarshaller<RuntimeException> runtimeExceptionWithPolyglotExceptionReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(AbstractPolyglotImpl abstractPolyglotImpl) {
            super(abstractPolyglotImpl);
        }

        @Override
        public RuntimeException getExecutionEventException(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.getExecutionEventException0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                RuntimeException runtimeException = (RuntimeException)runtimeExceptionWithPolyglotExceptionReceiverMarshaller.read(binaryInput);
                return runtimeException;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public List<Object> getExecutionEventInputValues(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.getExecutionEventInputValues0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                List list = (List)listOfObjectWithValuesListMarshaller.read(binaryInput);
                return list;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Object getExecutionEventLocation(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.getExecutionEventLocation0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object2 = objectWithSourceSectionReceiverMarshaller.read(binaryInput);
                return object2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public Object getExecutionEventReturnValue(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.getExecutionEventReturnValue0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object2 = objectWithValueReceiverMarshaller.read(binaryInput);
                return object2;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public String getExecutionEventRootName(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                String string = StartPoint.getExecutionEventRootName0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return string;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public boolean isExecutionEventExpression(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                boolean bl = StartPoint.isExecutionEventExpression0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public boolean isExecutionEventRoot(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                boolean bl = StartPoint.isExecutionEventRoot0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public boolean isExecutionEventStatement(Object object) {
            NativeObject nativeObject = (NativeObject)object;
            NativeIsolateThread nativeIsolateThread = nativeObject.getIsolate().enter();
            try {
                boolean bl = StartPoint.isExecutionEventStatement0(nativeIsolateThread.getIsolateThreadId(), nativeObject.getHandle());
                return bl;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native byte[] getExecutionEventException0(long var0, long var2);

        private static native byte[] getExecutionEventInputValues0(long var0, long var2);

        private static native byte[] getExecutionEventLocation0(long var0, long var2);

        private static native byte[] getExecutionEventReturnValue0(long var0, long var2);

        private static native String getExecutionEventRootName0(long var0, long var2);

        private static native boolean isExecutionEventExpression0(long var0, long var2);

        private static native boolean isExecutionEventRoot0(long var0, long var2);

        private static native boolean isExecutionEventStatement0(long var0, long var2);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            listOfObjectWithValuesListMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<List<Object>>(){}, new Class[]{PolyglotJNIConfig.ValuesList.class});
            objectWithSourceSectionReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.SourceSectionReceiver.class});
            objectWithValueReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.ValueReceiver.class});
            runtimeExceptionWithPolyglotExceptionReceiverMarshaller = jNIConfig.lookupMarshaller(RuntimeException.class, new Class[]{PolyglotJNIConfig.PolyglotExceptionReceiver.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<List<Object>> listOfObjectWithValuesListMarshaller;
        private static final BinaryMarshaller<Object> objectWithSourceSectionReceiverMarshaller;
        private static final BinaryMarshaller<Object> objectWithValueReceiverMarshaller;
        private static final BinaryMarshaller<RuntimeException> runtimeExceptionWithPolyglotExceptionReceiverMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionEventDispatchGen_00024StartPoint_getExecutionEventException0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getExecutionEventException(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeExecutionEventDispatchGen::getExecutionEventException", (JNI.JNIEnv)jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractExecutionEventDispatch abstractExecutionEventDispatch = NativeExecutionEventDispatch.resolveNativeDelegate(object);
                Object object2 = NativeExecutionEventDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                RuntimeException runtimeException = abstractExecutionEventDispatch.getExecutionEventException(object2);
                int n2 = runtimeExceptionWithPolyglotExceptionReceiverMarshaller.inferSize((Object)runtimeException);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    runtimeExceptionWithPolyglotExceptionReceiverMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)runtimeException);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionEventDispatchGen_00024StartPoint_getExecutionEventInputValues0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getExecutionEventInputValues(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeExecutionEventDispatchGen::getExecutionEventInputValues", (JNI.JNIEnv)jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractExecutionEventDispatch abstractExecutionEventDispatch = NativeExecutionEventDispatch.resolveNativeDelegate(object);
                Object object2 = NativeExecutionEventDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                List list = abstractExecutionEventDispatch.getExecutionEventInputValues(object2);
                int n2 = listOfObjectWithValuesListMarshaller.inferSize((Object)list);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    listOfObjectWithValuesListMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)list);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionEventDispatchGen_00024StartPoint_getExecutionEventLocation0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getExecutionEventLocation(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeExecutionEventDispatchGen::getExecutionEventLocation", (JNI.JNIEnv)jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractExecutionEventDispatch abstractExecutionEventDispatch = NativeExecutionEventDispatch.resolveNativeDelegate(object);
                Object object2 = NativeExecutionEventDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                Object object3 = abstractExecutionEventDispatch.getExecutionEventLocation(object2);
                int n2 = objectWithSourceSectionReceiverMarshaller.inferSize(object3);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    objectWithSourceSectionReceiverMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object3);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionEventDispatchGen_00024StartPoint_getExecutionEventReturnValue0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray getExecutionEventReturnValue(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeExecutionEventDispatchGen::getExecutionEventReturnValue", (JNI.JNIEnv)jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractExecutionEventDispatch abstractExecutionEventDispatch = NativeExecutionEventDispatch.resolveNativeDelegate(object);
                Object object2 = NativeExecutionEventDispatch.resolveReceiver(object);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                Object object3 = abstractExecutionEventDispatch.getExecutionEventReturnValue(object2);
                int n2 = objectWithValueReceiverMarshaller.inferSize(object3);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create((int)n2) : BinaryOutput.create((CCharPointer)cCharPointer, (int)256, (boolean)false);){
                    objectWithValueReceiverMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object3);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n3);
                    JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n3, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult((JNI.JObject)jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionEventDispatchGen_00024StartPoint_getExecutionEventRootName0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JString getExecutionEventRootName(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeExecutionEventDispatchGen::getExecutionEventRootName", (JNI.JNIEnv)jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                AbstractPolyglotImpl.AbstractExecutionEventDispatch abstractExecutionEventDispatch = NativeExecutionEventDispatch.resolveNativeDelegate(object);
                Object object2 = NativeExecutionEventDispatch.resolveReceiver(object);
                String string = abstractExecutionEventDispatch.getExecutionEventRootName(object2);
                jNIMethodScope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JString)jNIMethodScope.getObjectResult();
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionEventDispatchGen_00024StartPoint_isExecutionEventExpression0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean isExecutionEventExpression(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            boolean bl;
            block8: {
                JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeExecutionEventDispatchGen::isExecutionEventExpression", (JNI.JNIEnv)jNIEnv);
                try {
                    boolean bl2;
                    Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                    AbstractPolyglotImpl.AbstractExecutionEventDispatch abstractExecutionEventDispatch = NativeExecutionEventDispatch.resolveNativeDelegate(object);
                    Object object2 = NativeExecutionEventDispatch.resolveReceiver(object);
                    bl = bl2 = abstractExecutionEventDispatch.isExecutionEventExpression(object2);
                    if (jNIMethodScope == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (jNIMethodScope != null) {
                            try {
                                jNIMethodScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                        return false;
                    }
                }
                jNIMethodScope.close();
            }
            return bl;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionEventDispatchGen_00024StartPoint_isExecutionEventRoot0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean isExecutionEventRoot(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            boolean bl;
            block8: {
                JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeExecutionEventDispatchGen::isExecutionEventRoot", (JNI.JNIEnv)jNIEnv);
                try {
                    boolean bl2;
                    Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                    AbstractPolyglotImpl.AbstractExecutionEventDispatch abstractExecutionEventDispatch = NativeExecutionEventDispatch.resolveNativeDelegate(object);
                    Object object2 = NativeExecutionEventDispatch.resolveReceiver(object);
                    bl = bl2 = abstractExecutionEventDispatch.isExecutionEventRoot(object2);
                    if (jNIMethodScope == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (jNIMethodScope != null) {
                            try {
                                jNIMethodScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                        return false;
                    }
                }
                jNIMethodScope.close();
            }
            return bl;
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeExecutionEventDispatchGen_00024StartPoint_isExecutionEventStatement0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static boolean isExecutionEventStatement(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            boolean bl;
            block8: {
                JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeExecutionEventDispatchGen::isExecutionEventStatement", (JNI.JNIEnv)jNIEnv);
                try {
                    boolean bl2;
                    Object object = NativeObjectHandles.resolve((long)l3, Object.class);
                    AbstractPolyglotImpl.AbstractExecutionEventDispatch abstractExecutionEventDispatch = NativeExecutionEventDispatch.resolveNativeDelegate(object);
                    Object object2 = NativeExecutionEventDispatch.resolveReceiver(object);
                    bl = bl2 = abstractExecutionEventDispatch.isExecutionEventStatement(object2);
                    if (jNIMethodScope == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (jNIMethodScope != null) {
                            try {
                                jNIMethodScope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        ForeignException.forThrowable((Throwable)throwable3, throwableMarshaller).throwUsingJNI(jNIEnv);
                        return false;
                    }
                }
                jNIMethodScope.close();
            }
            return bl;
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            listOfObjectWithValuesListMarshaller = jNIConfig.lookupMarshaller((TypeLiteral)new TypeLiteral<List<Object>>(){}, new Class[]{PolyglotJNIConfig.ValuesList.class});
            objectWithSourceSectionReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.SourceSectionReceiver.class});
            objectWithValueReceiverMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.ValueReceiver.class});
            runtimeExceptionWithPolyglotExceptionReceiverMarshaller = jNIConfig.lookupMarshaller(RuntimeException.class, new Class[]{PolyglotJNIConfig.PolyglotExceptionReceiver.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

