/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeOutputStream;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.io.OutputStream;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class NativeOutputStreamGen {
    NativeOutputStreamGen() {
    }

    static NativeOutputStream createHSToNative(NativeObject nativeObject) {
        return new StartPoint(nativeObject);
    }

    static NativeOutputStream createNativeToNative(NativeObject nativeObject) {
        return new StartPoint(nativeObject);
    }

    static NativeOutputStream create(NativeObject nativeObject) {
        if (ImageInfo.inImageCode()) {
            return NativeOutputStreamGen.createNativeToNative(nativeObject);
        }
        return NativeOutputStreamGen.createHSToNative(nativeObject);
    }

    private static final class StartPoint
    extends NativeOutputStream {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeObject nativeObject) {
            super(nativeObject);
        }

        @Override
        public void close() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateOutputStream.getIsolate().enter();
            try {
                StartPoint.close0(nativeIsolateThread.getIsolateThreadId(), this.isolateOutputStream.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void flush() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateOutputStream.getIsolate().enter();
            try {
                StartPoint.flush0(nativeIsolateThread.getIsolateThreadId(), this.isolateOutputStream.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void write(int n2) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateOutputStream.getIsolate().enter();
            try {
                StartPoint.write0(nativeIsolateThread.getIsolateThreadId(), this.isolateOutputStream.getHandle(), n2);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.isolateOutputStream.getIsolate().enter();
            try {
                StartPoint.write0(nativeIsolateThread.getIsolateThreadId(), this.isolateOutputStream.getHandle(), byArray, n2, n3);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void close0(long var0, long var2) throws IOException;

        private static native void flush0(long var0, long var2) throws IOException;

        private static native void write0(long var0, long var2, int var4) throws IOException;

        private static native void write0(long var0, long var2, byte[] var4, int var5, int var6) throws IOException;

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOutputStreamGen_00024StartPoint_close0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void close(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeOutputStreamGen::close", (JNI.JNIEnv)jNIEnv);){
                OutputStream outputStream = (OutputStream)NativeObjectHandles.resolve((long)l3, OutputStream.class);
                outputStream.close();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOutputStreamGen_00024StartPoint_flush0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void flush(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeOutputStreamGen::flush", (JNI.JNIEnv)jNIEnv);){
                OutputStream outputStream = (OutputStream)NativeObjectHandles.resolve((long)l3, OutputStream.class);
                outputStream.flush();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOutputStreamGen_00024StartPoint_write0__JJI", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void write(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, int n2) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeOutputStreamGen::write", (JNI.JNIEnv)jNIEnv);){
                OutputStream outputStream = (OutputStream)NativeObjectHandles.resolve((long)l3, OutputStream.class);
                outputStream.write(n2);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOutputStreamGen_00024StartPoint_write0__JJ_3BII", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void write(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray, int n2, int n3) {
            try (JNIMethodScope jNIMethodScope = ForeignException.openJNIMethodScope((String)"NativeOutputStreamGen::write", (JNI.JNIEnv)jNIEnv);){
                OutputStream outputStream = (OutputStream)NativeObjectHandles.resolve((long)l3, OutputStream.class);
                byte[] byArray = new byte[n3];
                JNIUtil.arrayCopy((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)n2, (byte[])byArray, (int)0, (int)n3);
                outputStream.write(byArray, 0, n3);
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

